/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractEnterpriseMojo;
import io.gatling.mojo.MojoConstants;
import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.util.SelectorUtils;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.FileUtilsV2_2;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
@Mojo(name="enterprisePackage", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.TEST)
public class EnterprisePackageMojo
extends AbstractEnterpriseMojo {
    private static final List<char[]> ALWAYS_EXCLUDES = EnterprisePackageMojo.toChars(new String[]{"module-info.class", "LICENSE", "META-INF/LICENSE", "META-INF/MANIFEST.MF", "META-INF/versions/**", "META-INF/maven/**", "*.SF", "*.DSA", "*.RSA"});
    private static final Set<String> EXCLUDED_NETTY_ARTIFACTS;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(property="gatling.excludes")
    private String[] excludes;

    private Set<Artifact> nonGatlingDependencies(List<Artifact> artifacts) {
        return artifacts.stream().flatMap(artifact -> this.resolveTransitively((Artifact)artifact).stream().filter(art -> !MojoConstants.GATLING_GROUP_IDS.contains(art.getGroupId()))).collect(Collectors.toSet());
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        FileWriter fw;
        File workingDir;
        this.checkPluginPreConditions();
        Set allDeps = this.mavenProject.getArtifacts();
        List<Artifact> depsWithFrontLineGroupId = MojoUtils.findByGroupId(allDeps, "io.gatling.frontline");
        if (!depsWithFrontLineGroupId.isEmpty()) {
            throw new MojoExecutionException("Found a dependency with group id io.gatling.frontline in projects dependencies");
        }
        List<Artifact> depsWithGatlingGroupId = MojoUtils.findByGroupId(allDeps, "io.gatling");
        List<Artifact> depsWithGatlingHighchartsGroupId = MojoUtils.findByGroupId(allDeps, "io.gatling.highcharts");
        if (depsWithGatlingGroupId.isEmpty()) {
            throw new MojoExecutionException("Couldn't find any dependencies with group id io.gatling in project dependencies");
        }
        HashSet<Artifact> gatlingDependencies = new HashSet<Artifact>();
        gatlingDependencies.addAll(this.nonGatlingDependencies(depsWithGatlingGroupId));
        gatlingDependencies.addAll(this.nonGatlingDependencies(depsWithGatlingHighchartsGroupId));
        Set filteredDeps = allDeps.stream().filter(artifact -> !artifact.getType().equals("pom") && !MojoConstants.GATLING_GROUP_IDS.contains(artifact.getGroupId()) && (!artifact.getGroupId().equals("io.netty") || !EXCLUDED_NETTY_ARTIFACTS.contains(artifact.getArtifactId())) && MojoUtils.artifactNotIn(artifact, gatlingDependencies)).collect(Collectors.toSet());
        try {
            workingDir = Files.createTempDirectory("gatling-maven", new FileAttribute[0]).toFile();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to create temp dir", (Exception)e);
        }
        List<char[]> compiledExcludes = this.compileExcludes();
        for (Artifact artifact2 : filteredDeps) {
            ZipUtil.unpack((File)artifact2.getFile(), (File)workingDir, name -> this.exclude(name, compiledExcludes) ? null : name);
        }
        File outputDirectory = new File(this.mavenProject.getBuild().getOutputDirectory());
        Path outputDirectoryPath = outputDirectory.toPath();
        File testOutputDirectory = new File(this.mavenProject.getBuild().getTestOutputDirectory());
        Path testOutputDirectoryPath = testOutputDirectory.toPath();
        try {
            if (outputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)outputDirectory, (File)workingDir, pathname -> !this.exclude(outputDirectoryPath.relativize(pathname.toPath()).toString(), compiledExcludes), (boolean)false);
            }
            if (testOutputDirectory.exists()) {
                FileUtilsV2_2.copyDirectory((File)testOutputDirectory, (File)workingDir, pathname -> !this.exclude(testOutputDirectoryPath.relativize(pathname.toPath()).toString(), compiledExcludes), (boolean)false);
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy compiled classes", (Exception)e);
        }
        File metaInfDir = new File(workingDir, "META-INF");
        metaInfDir.mkdirs();
        File mavenDir = new File(new File(new File(metaInfDir, "maven"), this.mavenProject.getGroupId()), this.mavenProject.getArtifactId());
        mavenDir.mkdirs();
        try {
            fw = new FileWriter(new File(mavenDir, "pom.properties"));
            try {
                fw.write("groupId=" + this.mavenProject.getGroupId() + "\n");
                fw.write("artifactId=" + this.mavenProject.getArtifactId() + "\n");
                fw.write("version=" + this.mavenProject.getVersion() + "\n");
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        try {
            fw = new FileWriter(new File(mavenDir, "pom.xml"));
            try {
                fw.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                fw.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                fw.write("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
                fw.write("    <modelVersion>4.0.0</modelVersion>\n");
                fw.write("    <groupId>" + this.mavenProject.getGroupId() + "</groupId>\n");
                fw.write("    <artifactId>" + this.mavenProject.getArtifactId() + "</artifactId>\n");
                fw.write("    <version>" + this.mavenProject.getVersion() + "</version>\n");
                fw.write("</project>");
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate pom.properties", (Exception)e);
        }
        File manifest = new File(metaInfDir, "MANIFEST.MF");
        String gatlingVersion = MojoUtils.findByGroupIdAndArtifactId(allDeps, "io.gatling", "gatling-app").getVersion();
        try (FileWriter fw2 = new FileWriter(manifest);){
            fw2.write("Manifest-Version: 1.0\n");
            fw2.write("Implementation-Title: " + this.mavenProject.getArtifactId() + "\n");
            fw2.write("Implementation-Version: " + this.mavenProject.getVersion() + "\n");
            fw2.write("Implementation-Vendor: " + this.mavenProject.getGroupId() + "\n");
            fw2.write("Specification-Vendor: GatlingCorp\n");
            fw2.write("Gatling-Version: " + gatlingVersion + "\n");
            fw2.write("Gatling-Packager: maven\n");
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate manifest", (Exception)e);
        }
        File shaded = this.shadedArtifactFile();
        this.getLog().info((CharSequence)("Generating Gatling Enterprise package " + String.valueOf(shaded)));
        ZipUtil.pack((File)workingDir, (File)shaded);
        this.projectHelper.attachArtifact(this.mavenProject, "jar", this.shadedClassifier, shaded);
        try {
            FileUtilsV2_2.deleteDirectory((File)workingDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to delete working directory " + String.valueOf(workingDir), (Exception)e);
        }
    }

    private static List<char[]> toChars(String[] patterns) {
        return Arrays.stream(patterns).map(String::toCharArray).collect(Collectors.toList());
    }

    private List<char[]> compileExcludes() {
        if (this.excludes == null) {
            return ALWAYS_EXCLUDES;
        }
        List<char[]> compiledUserExcludes = EnterprisePackageMojo.toChars(this.excludes);
        compiledUserExcludes.addAll(ALWAYS_EXCLUDES);
        return compiledUserExcludes;
    }

    private boolean exclude(String name, List<char[]> excludes) {
        for (char[] pattern : excludes) {
            if (!SelectorUtils.match((char[])pattern, (char[])name.toCharArray(), (boolean)false)) continue;
            this.getLog().info((CharSequence)("Excluding file " + name));
            return true;
        }
        return false;
    }

    private Set<Artifact> resolveTransitively(Artifact artifact) {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(artifact).setResolveRoot(true).setResolveTransitively(true).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies()).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.session.getCurrentProject().getRemoteArtifactRepositories());
        return this.repository.resolve(request).getArtifacts();
    }

    static {
        HashSet<String> excludedNettyArtifacts = new HashSet<String>();
        excludedNettyArtifacts.add("netty-all");
        excludedNettyArtifacts.add("netty-resolver-dns-classes-macos");
        excludedNettyArtifacts.add("netty-resolver-dns-native-macos");
        EXCLUDED_NETTY_ARTIFACTS = Collections.unmodifiableSet(excludedNettyArtifacts);
    }
}

