/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.io.File;
import java.io.FileInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

final class AssertionsSummary {
    private final int errors;
    private final int failures;

    AssertionsSummary(int errors, int failures) {
        this.errors = errors;
        this.failures = failures;
    }

    static AssertionsSummary fromAssertionsFile(File assertionsFile) throws Exception {
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        try (FileInputStream is = new FileInputStream(assertionsFile);){
            Node testsuite = (Node)xpath.evaluate("/testsuite", new InputSource(is), XPathConstants.NODE);
            String errors = xpath.evaluate("@errors", testsuite);
            String failures = xpath.evaluate("@failures", testsuite);
            AssertionsSummary assertionsSummary = new AssertionsSummary(Integer.parseInt(errors), Integer.parseInt(failures));
            return assertionsSummary;
        }
    }

    int getErrors() {
        return this.errors;
    }

    int getFailures() {
        return this.failures;
    }

    boolean hasFailures() {
        return this.errors + this.failures > 0;
    }
}

