/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;

public final class MojoUtils {
    private static final Pattern FILE_URL_PATTERN = Pattern.compile("^.*file:(.*)!.*$");

    private MojoUtils() {
    }

    public static String locateJar(Class<?> c) throws Exception {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        if (location != null) {
            Matcher m = FILE_URL_PATTERN.matcher(location.toString());
            if (m.find()) {
                return URLDecoder.decode(m.group(1), StandardCharsets.UTF_8);
            }
            throw new ClassNotFoundException("Cannot parse location of '" + String.valueOf(location) + "'.  Probably not loaded from a Jar");
        }
        throw new ClassNotFoundException("Cannot find class '" + c.getName() + " using the classloader");
    }

    static boolean artifactNotIn(Artifact target, Collection<Artifact> artifacts) {
        return MojoUtils.findByGroupIdAndArtifactId(artifacts, target.getGroupId(), target.getArtifactId()) == null;
    }

    static Artifact findByGroupIdAndArtifactId(Collection<Artifact> artifacts, String groupId, String artifactId) {
        return artifacts.stream().filter(artifact -> artifact.getGroupId().equals(groupId) && artifact.getArtifactId().equals(artifactId)).findFirst().orElse(null);
    }
}

