/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.MojoUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.SelectorUtils;

public final class SimulationClassUtils {
    private SimulationClassUtils() {
    }

    public static List<String> resolveSimulations(MavenProject mavenProject, File compiledClassesFolder, String[] includes, String[] excludes) {
        try {
            URLClassLoader testClassLoader = new URLClassLoader(SimulationClassUtils.testClassPathUrls(mavenProject));
            Class<?> scalaSimulationClass = testClassLoader.loadClass("io.gatling.core.scenario.Simulation");
            Optional<Class<?>> javaSimulationClass = SimulationClassUtils.loadJavaSimulationClass(testClassLoader);
            List<String> includesList = MojoUtils.arrayAsListEmptyIfNull(includes);
            List<String> excludesList = MojoUtils.arrayAsListEmptyIfNull(excludes);
            ArrayList<String> simulationsClasses = new ArrayList<String>();
            for (String classFile : SimulationClassUtils.compiledClassFiles(compiledClassesFolder)) {
                Class<?> clazz;
                boolean isExcluded;
                String className = SimulationClassUtils.pathToClassName(classFile);
                boolean isIncluded = includesList.isEmpty() || SimulationClassUtils.match(includesList, className);
                boolean bl = isExcluded = !excludesList.isEmpty() && SimulationClassUtils.match(excludesList, className);
                if (!isIncluded || isExcluded || !SimulationClassUtils.isConcreteClass(clazz = testClassLoader.loadClass(className)) || !javaSimulationClass.map(simClass -> simClass.isAssignableFrom(clazz)).orElse(false).booleanValue() && !scalaSimulationClass.isAssignableFrom(clazz)) continue;
                simulationsClasses.add(className);
            }
            return simulationsClasses;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static URL[] testClassPathUrls(MavenProject mavenProject) throws DependencyResolutionRequiredException, MalformedURLException {
        List testClasspathElements = mavenProject.getTestClasspathElements();
        URL[] urls = new URL[testClasspathElements.size()];
        for (int i = 0; i < testClasspathElements.size(); ++i) {
            URL url;
            String testClasspathElement = (String)testClasspathElements.get(i);
            urls[i] = url = Paths.get(testClasspathElement, new String[0]).toUri().toURL();
        }
        return urls;
    }

    private static Optional<Class<?>> loadJavaSimulationClass(ClassLoader testClassLoader) {
        try {
            return Optional.of(testClassLoader.loadClass("io.gatling.javaapi.core.Simulation"));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    private static String[] compiledClassFiles(File compiledClassesFolder) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(compiledClassesFolder.getCanonicalPath());
        scanner.setIncludes(new String[]{"**/*.class"});
        scanner.scan();
        Object[] files = scanner.getIncludedFiles();
        Arrays.sort(files);
        return files;
    }

    private static String pathToClassName(String path) {
        return path.substring(0, path.length() - ".class".length()).replace(File.separatorChar, '.');
    }

    private static boolean match(List<String> patterns, String string) {
        for (String pattern : patterns) {
            if (pattern == null || !SelectorUtils.match((String)pattern, (String)string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConcreteClass(Class<?> clazz) {
        return !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers());
    }
}

