/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import io.gatling.mojo.AbstractGatlingExecutionMojo;
import io.gatling.mojo.GatlingSimulationAssertionsFailedException;
import io.gatling.mojo.MojoUtils;
import io.gatling.plugin.GatlingConstants;
import io.gatling.plugin.SimulationSelector;
import io.gatling.plugin.model.BuildPlugin;
import io.gatling.plugin.model.BuildTool;
import io.gatling.plugin.util.Fork;
import io.gatling.plugin.util.NoFork;
import io.gatling.shared.cli.GatlingCliOptions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.ExceptionUtils;

@Execute(phase=LifecyclePhase.TEST_COMPILE)
@Mojo(name="test", defaultPhase=LifecyclePhase.INTEGRATION_TEST, requiresDependencyResolution=ResolutionScope.TEST)
public final class GatlingMojo
extends AbstractGatlingExecutionMojo {
    @Parameter(property="gatling.simulationClass")
    private String simulationClass;
    @Parameter(property="gatling.runMultipleSimulations", defaultValue="false")
    private boolean runMultipleSimulations;
    @Parameter(property="gatling.includes")
    private List<String> includes;
    @Parameter(property="gatling.excludes")
    private List<String> excludes;
    @Parameter(property="gatling.noReports", defaultValue="false")
    private boolean noReports;
    @Parameter(property="gatling.reportsOnly")
    private String reportsOnly;
    @Parameter(property="gatling.runDescription")
    private String runDescription;
    @Parameter(property="gatling.failOnError", defaultValue="true")
    private boolean failOnError;
    @Parameter(property="gatling.continueOnAssertionFailure", defaultValue="false")
    private boolean continueOnAssertionFailure;
    @Parameter(property="gatling.jvmArgs")
    private List<String> jvmArgs;
    @Parameter(property="gatling.ignoreDefaultGatlingJvmArgs", defaultValue="false")
    private boolean ignoreDefaultGatlingJvmArgs;
    @Parameter(property="gatling.sameProcess", defaultValue="false")
    private boolean sameProcess;
    @Parameter(defaultValue="${plugin.artifacts}", readonly=true)
    private List<Artifact> artifacts;
    @Parameter(property="gatling.workingDirectory")
    private File workingDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block15: {
            if (this.skip) {
                this.getLog().info((CharSequence)"Skipping gatling-maven-plugin");
                return;
            }
            if (!this.resultsFolder.exists() && !this.resultsFolder.mkdirs()) {
                throw new MojoExecutionException("Could not create resultsFolder " + this.resultsFolder.getAbsolutePath());
            }
            Set<File> preExistingRunDirectories = this.runDirectories();
            try {
                List<String> testClasspath = this.buildTestClasspath();
                Toolchain toolchain = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
                List<String> jvmArgs = this.gatlingJvmArgs();
                if (this.reportsOnly != null) {
                    this.executeGatling(jvmArgs, this.gatlingArgs(null), testClasspath, toolchain);
                } else {
                    List<String> simulations = this.simulations();
                    this.iterateBySimulations(toolchain, jvmArgs, testClasspath, simulations);
                }
                if (this.failOnError) break block15;
                try {
                    this.saveSimulationResultToFile(preExistingRunDirectories, null);
                }
                catch (IOException e) {
                    throw new SaveSimulationResultToFileException(e);
                }
            }
            catch (SaveSimulationResultToFileException e) {
                throw new MojoExecutionException("Could not record simulation results.", e.getCause());
            }
            catch (Exception e) {
                if (this.failOnError) {
                    if (e instanceof GatlingSimulationAssertionsFailedException) {
                        throw new MojoFailureException(e.getMessage(), (Throwable)e);
                    }
                    if (e instanceof MojoFailureException) {
                        throw (MojoFailureException)e;
                    }
                    if (e instanceof MojoExecutionException) {
                        throw (MojoExecutionException)e;
                    }
                    throw new MojoExecutionException("Gatling failed.", e);
                }
                this.getLog().warn((CharSequence)"There were some errors while running your simulation, but failOnError was set to false won't fail your build.");
                try {
                    this.saveSimulationResultToFile(preExistingRunDirectories, e);
                }
                catch (IOException newE) {
                    throw new MojoExecutionException("Could not record simulation results.", (Exception)newE);
                }
            }
        }
    }

    private Set<File> runDirectories() {
        File[] directories = this.resultsFolder.listFiles(File::isDirectory);
        return directories == null ? Set.of() : Set.of(directories);
    }

    private void iterateBySimulations(Toolchain toolchain, List<String> jvmArgs, List<String> testClasspath, List<String> simulations) throws Exception {
        GatlingSimulationAssertionsFailedException exc = null;
        int simulationsCount = simulations.size();
        for (int i = 0; i < simulationsCount; ++i) {
            try {
                String selectedSimulation = simulations.get(i);
                List<String> gatlingArgs = this.gatlingArgs(selectedSimulation);
                this.getLog().info((CharSequence)("Running simulation " + selectedSimulation + "."));
                this.executeGatling(jvmArgs, gatlingArgs, testClasspath, toolchain);
                continue;
            }
            catch (GatlingSimulationAssertionsFailedException e) {
                if (exc == null && i == simulationsCount - 1) {
                    throw e;
                }
                if (this.continueOnAssertionFailure) {
                    if (exc != null) continue;
                    exc = e;
                    continue;
                }
                throw e;
            }
        }
        if (exc != null) {
            this.getLog().warn((CharSequence)"There were some errors while running your simulation, but continueOnAssertionFailure was set to true, so your simulations continue to perform.");
            throw exc;
        }
    }

    private void executeGatling(List<String> gatlingJvmArgs, List<String> gatlingArgs, List<String> testClasspath, Toolchain toolchain) throws Exception {
        if (this.sameProcess) {
            new NoFork("io.gatling.app.Gatling", gatlingArgs, testClasspath.stream().map(File::new).collect(Collectors.toList())).run();
        } else {
            Fork forkedGatling = this.newFork("io.gatling.app.Gatling", testClasspath, gatlingJvmArgs, gatlingArgs, toolchain, this.workingDirectory);
            try {
                forkedGatling.run();
            }
            catch (Fork.ForkException e) {
                if (e.exitValue == 2) {
                    throw new GatlingSimulationAssertionsFailedException(e);
                }
                throw e;
            }
        }
    }

    private void saveSimulationResultToFile(Set<File> preExistingRunDirectories, Exception exception) throws IOException {
        Path resultsFile = this.resultsFolder.toPath().resolve("lastRun.txt");
        try (BufferedWriter writer = Files.newBufferedWriter(resultsFile, new OpenOption[0]);){
            for (File directory : this.runDirectories()) {
                if (preExistingRunDirectories.contains(directory)) continue;
                writer.write(directory.getName() + System.lineSeparator());
            }
            if (exception != null) {
                String error = exception instanceof GatlingSimulationAssertionsFailedException ? "Gatling simulation assertions failed!" : GatlingMojo.getRecursiveCauses(exception);
                writer.write("ExecutionError: " + error + System.lineSeparator());
            }
        }
    }

    private static String getRecursiveCauses(Throwable e) {
        return Arrays.stream(ExceptionUtils.getThrowables((Throwable)e)).map(ex -> {
            String exceptionClassName = ex.getClass().getName();
            String exceptionMessage = ex.getMessage();
            return exceptionMessage != null ? exceptionClassName + ": " + exceptionMessage : exceptionClassName;
        }).collect(Collectors.joining(" | "));
    }

    private List<String> gatlingJvmArgs() {
        if (this.ignoreDefaultGatlingJvmArgs) {
            return Collections.unmodifiableList(this.jvmArgs);
        }
        ArrayList<String> merged = new ArrayList<String>(GatlingConstants.DEFAULT_JVM_OPTIONS_GATLING);
        merged.addAll(this.jvmArgs);
        return merged;
    }

    private List<String> simulations() throws MojoFailureException {
        List testClasspath;
        try {
            testClasspath = this.mavenProject.getTestClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoFailureException("Failed to build test classpath", (Throwable)e);
        }
        SimulationSelector.Result result = SimulationSelector.simulations((String)this.simulationClass, (List)testClasspath, this.includes, this.excludes, (boolean)this.runMultipleSimulations, (boolean)BuildPlugin.getInstance((BuildTool)this.buildTool, (String)this.pluginVersion(), (Boolean)this.requireBatchMode()).interactive);
        SimulationSelector.Result.Error error = result.error;
        if (error != null) {
            String errorMessage;
            switch (error) {
                case NoSimulations: {
                    errorMessage = "No simulations to run";
                    break;
                }
                case MoreThanOneSimulationInNonInteractiveMode: {
                    errorMessage = "Running in non-interactive mode, yet more than 1 simulation is available. Either specify one with -Dgatling.simulationClass=<className> or run them all sequentially with -Dgatling.runMultipleSimulations=true.";
                    break;
                }
                case TooManyInteractiveAttempts: {
                    errorMessage = "Max attempts of reading simulation number reached. Aborting.";
                    break;
                }
                default: {
                    throw new MojoFailureException("Unknown error: " + String.valueOf(error));
                }
            }
            this.getLog().error((CharSequence)errorMessage);
            throw new MojoFailureException(errorMessage);
        }
        return result.simulations;
    }

    private List<String> gatlingArgs(String simulationClass) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (simulationClass != null) {
            args.addAll(List.of(GatlingCliOptions.Simulation.shortOption(), simulationClass));
        }
        args.addAll(List.of(GatlingCliOptions.ResultsFolder.shortOption(), this.resultsFolder.getCanonicalPath()));
        if (this.reportsOnly != null) {
            args.addAll(List.of(GatlingCliOptions.ReportsOnly.shortOption(), this.reportsOnly));
        }
        if (this.runDescription != null) {
            String encodedRunDescription = Base64.getEncoder().encodeToString(this.runDescription.getBytes(StandardCharsets.UTF_8));
            args.addAll(List.of(GatlingCliOptions.RunDescription.shortOption(), encodedRunDescription));
        }
        if (this.noReports) {
            args.add(GatlingCliOptions.NoReports.shortOption());
        }
        String[] gatlingVersion = MojoUtils.findByGroupIdAndArtifactId(this.mavenProject.getArtifacts(), "io.gatling", "gatling-app").getVersion().split("\\.");
        int gatlingMajorVersion = Integer.parseInt(gatlingVersion[0]);
        int gatlingMinorVersion = Integer.parseInt(gatlingVersion[1]);
        if (gatlingMajorVersion == 3 && gatlingMinorVersion >= 8 || gatlingMajorVersion > 4) {
            args.addAll(List.of(GatlingCliOptions.Launcher.shortOption(), "maven"));
            args.addAll(List.of(GatlingCliOptions.BuildToolVersion.shortOption(), MavenProject.class.getPackage().getImplementationVersion()));
        }
        return args;
    }

    private static final class SaveSimulationResultToFileException
    extends Exception {
        public SaveSimulationResultToFileException(IOException cause) {
            super(cause);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

