/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.mojo;

import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;

public class MojoUtils {
    private MojoUtils() {
        throw new AssertionError();
    }

    public static String toMultiPath(List<String> paths) {
        return StringUtils.join(paths.iterator(), (String)File.pathSeparator);
    }

    public static String locateJar(Class<?> c) throws Exception {
        String classLocation = c.getName().replace('.', '/') + ".class";
        ClassLoader loader = c.getClassLoader();
        URL location = loader == null ? ClassLoader.getSystemResource(classLocation) : loader.getResource(classLocation);
        if (location != null) {
            Pattern p = Pattern.compile("^.*file:(.*)!.*$");
            Matcher m = p.matcher(location.toString());
            if (m.find()) {
                return URLDecoder.decode(m.group(1), "UTF-8");
            }
            throw new ClassNotFoundException("Cannot parse location of '" + location + "'.  Probably not loaded from a Jar");
        }
        throw new ClassNotFoundException("Cannot find class '" + c.getName() + " using the classloader");
    }

    public static <T> List<T> arrayAsListEmptyIfNull(T[] array) {
        return array == null ? Collections.emptyList() : Arrays.asList(array);
    }
}

