/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.check;

import com.fasterxml.jackson.databind.JsonNode;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.check.Check;
import io.gatling.core.check.CheckMaterializer;
import io.gatling.core.check.bytes.BodyBytesCheckType;
import io.gatling.core.check.jmespath.JmesPathCheckType;
import io.gatling.core.check.jsonpath.JsonPathCheckType;
import io.gatling.core.check.string.BodyStringCheckType;
import io.gatling.core.check.substring.SubstringCheckType;
import io.gatling.core.check.xpath.XPathCheckType;
import io.gatling.core.check.xpath.XmlParsers$;
import io.gatling.core.json.JsonParsers;
import io.gatling.jms.check.JmsCheckMaterializer;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.TextMessage;
import net.sf.saxon.s9api.XdmNode;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JmsCheckMaterializer$ {
    public static final JmsCheckMaterializer$ MODULE$ = new JmsCheckMaterializer$();
    private static final Function1<String, String> JsonPreparerErrorMapper = (Function1 & Serializable)x$1 -> new StringBuilder(38).append("Could not parse response into a JSON: ").append((String)x$1).toString();
    private static final CheckMaterializer<XPathCheckType, Check<Message>, Message, Option<XdmNode>> Xpath;

    static {
        Function1 & Serializable errorMapper = (Function1 & Serializable)x$2 -> new StringBuilder(46).append("Could not parse response into a DOM Document: ").append((String)x$2).toString();
        Function1 & Serializable preparer = (Function1 & Serializable)message -> package$.MODULE$.safely(errorMapper, (Function0 & Serializable)() -> {
            Failure failure;
            Message message = message;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)new Some((Object)XmlParsers$.MODULE$.parse(textMessage.getText()))));
            } else {
                failure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Unsupported message type"));
            }
            return failure;
        });
        Xpath = new JmsCheckMaterializer<XPathCheckType, Option<XdmNode>>(preparer);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] toBytes(BytesMessage bytesMessage) {
        void var2_2;
        byte[] buffer = (byte[])Array$.MODULE$.ofDim((int)bytesMessage.getBodyLength(), (ClassTag)ClassTag$.MODULE$.Byte());
        bytesMessage.readBytes(buffer);
        return var2_2;
    }

    private String getBodyAsString(BytesMessage bytesMessage, Charset charset) {
        Charset charset2 = charset;
        Charset charset3 = StandardCharsets.UTF_8;
        return !(charset2 != null ? !((Object)charset2).equals(charset3) : charset3 != null) ? bytesMessage.readUTF() : new String(this.toBytes(bytesMessage), charset);
    }

    private Function1<Message, Validation<byte[]>> bodyBytesPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Failure failure;
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)textMessage.getText().getBytes(charset)));
            } else if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)MODULE$.toBytes(bytesMessage)));
            } else {
                failure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Unsupported message type"));
            }
            return failure;
        };
    }

    private Function1<Message, Validation<Object>> bodyLengthPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Failure failure;
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)textMessage.getText().getBytes(charset).length)));
            } else if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                failure = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)BoxesRunTime.boxToInteger((int)((int)bytesMessage.getBodyLength()))));
            } else {
                failure = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Unsupported message type"));
            }
            return failure;
        };
    }

    private Function1<String, String> JsonPreparerErrorMapper() {
        return JsonPreparerErrorMapper;
    }

    private Function1<Message, Validation<JsonNode>> jsonPreparer(JsonParsers jsonParsers, Charset charset) {
        return (Function1 & Serializable)replyMessage -> package$.MODULE$.safely(MODULE$.JsonPreparerErrorMapper(), (Function0 & Serializable)() -> {
            Validation validation;
            Message message = replyMessage;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                validation = jsonParsers.safeParse(textMessage.getText());
            } else if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                validation = jsonParsers.safeParse(MODULE$.getBodyAsString(bytesMessage, charset));
            } else {
                validation = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Unsupported message type"));
            }
            return validation;
        });
    }

    private Function1<Message, Validation<String>> stringBodyPreparer(Charset charset) {
        return (Function1 & Serializable)x0$1 -> {
            Validation validation;
            Message message = x0$1;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)textMessage.getText()));
            } else if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)MODULE$.getBodyAsString(bytesMessage, charset)));
            } else {
                validation = package.FailureWrapper$.MODULE$.failure$extension(package$.MODULE$.FailureWrapper("Unsupported message type"));
            }
            return validation;
        };
    }

    public CheckMaterializer<BodyStringCheckType, Check<Message>, Message, String> bodyString(Charset charset) {
        return new JmsCheckMaterializer<BodyStringCheckType, String>(this.stringBodyPreparer(charset));
    }

    public CheckMaterializer<BodyBytesCheckType, Check<Message>, Message, byte[]> bodyBytes(Charset charset) {
        return new JmsCheckMaterializer<BodyBytesCheckType, byte[]>(this.bodyBytesPreparer(charset));
    }

    public CheckMaterializer<BodyBytesCheckType, Check<Message>, Message, Object> bodyLength(Charset charset) {
        return new JmsCheckMaterializer<BodyBytesCheckType, Object>(this.bodyLengthPreparer(charset));
    }

    public CheckMaterializer<SubstringCheckType, Check<Message>, Message, String> substring(Charset charset) {
        return new JmsCheckMaterializer<SubstringCheckType, String>(this.stringBodyPreparer(charset));
    }

    public CheckMaterializer<JmesPathCheckType, Check<Message>, Message, JsonNode> jmesPath(JsonParsers jsonParsers, Charset charset) {
        return new JmsCheckMaterializer<JmesPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers, charset));
    }

    public CheckMaterializer<JsonPathCheckType, Check<Message>, Message, JsonNode> jsonPath(JsonParsers jsonParsers, Charset charset) {
        return new JmsCheckMaterializer<JsonPathCheckType, JsonNode>(this.jsonPreparer(jsonParsers, charset));
    }

    public CheckMaterializer<XPathCheckType, Check<Message>, Message, Option<XdmNode>> Xpath() {
        return Xpath;
    }

    private JmsCheckMaterializer$() {
    }
}

