/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.jms.client.CachedProducerKey;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsSessionPool;
import jakarta.jms.Destination;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003 \u0001\u0011\u0005\u0001\u0005C\u0004$\u0001\t\u0007I\u0011\u0002\u0013\t\r\u0001\u0003\u0001\u0015!\u0003&\u0011\u001d\t\u0005A1A\u0005\n\tCaa\u0014\u0001!\u0002\u0013\u0019\u0005\"\u0002)\u0001\t\u0003\t\u0006\"\u0002/\u0001\t\u0003i&a\u0004&ngB\u0013x\u000eZ;dKJ\u0004vn\u001c7\u000b\u0005-a\u0011AB2mS\u0016tGO\u0003\u0002\u000e\u001d\u0005\u0019!.\\:\u000b\u0005=\u0001\u0012aB4bi2Lgn\u001a\u0006\u0002#\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001A\u0003\u0005\u0002\u001615\taCC\u0001\u0018\u0003\u0015\u00198-\u00197b\u0013\tIbC\u0001\u0004B]f\u0014VMZ\u0001\fg\u0016\u001c8/[8o!>|G\u000e\u0005\u0002\u001d;5\t!\"\u0003\u0002\u001f\u0015\tq!*\\:TKN\u001c\u0018n\u001c8Q_>d\u0017A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011A\u0004\u0001\u0005\u00065\t\u0001\raG\u0001\u0014e\u0016<\u0017n\u001d;fe\u0016$\u0007K]8ek\u000e,'o]\u000b\u0002KA!a\u0005M\u001a;\u001d\t9c&D\u0001)\u0015\tI#&\u0001\u0006d_:\u001cWO\u001d:f]RT!a\u000b\u0017\u0002\tU$\u0018\u000e\u001c\u0006\u0002[\u0005!!.\u0019<b\u0013\ty\u0003&A\tD_:\u001cWO\u001d:f]RD\u0015m\u001d5NCBL!!\r\u001a\u0003\u0015-+\u0017pU3u-&,wO\u0003\u00020QA\u0011A\u0007O\u0007\u0002k)\u0011QB\u000e\u0006\u0002o\u00059!.Y6beR\f\u0017BA\u001d6\u0005=iUm]:bO\u0016\u0004&o\u001c3vG\u0016\u0014\bCA\u001e?\u001b\u0005a$BA\u001f-\u0003\u0011a\u0017M\\4\n\u0005}b$a\u0002\"p_2,\u0017M\\\u0001\u0015e\u0016<\u0017n\u001d;fe\u0016$\u0007K]8ek\u000e,'o\u001d\u0011\u0002\u0013A\u0014x\u000eZ;dKJ\u001cX#A\"\u0011\t\u001d\"e)S\u0005\u0003\u000b\"\u0012\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q!\tar)\u0003\u0002I\u0015\t\t2)Y2iK\u0012\u0004&o\u001c3vG\u0016\u00148*Z=\u0011\u0007mRE*\u0003\u0002Ly\tYA\u000b\u001b:fC\u0012dunY1m!\taR*\u0003\u0002O\u0015\tY!*\\:Qe>$WoY3s\u0003)\u0001(o\u001c3vG\u0016\u00148\u000fI\u0001\taJ|G-^2feR\u0019AJU,\t\u000bM;\u0001\u0019\u0001+\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\t\u0003iUK!AV\u001b\u0003\u0017\u0011+7\u000f^5oCRLwN\u001c\u0005\u00061\u001e\u0001\r!W\u0001\rI\u0016d\u0017N^3ss6{G-\u001a\t\u0003+iK!a\u0017\f\u0003\u0007%sG/A\u0003dY>\u001cX\rF\u0001_!\t)r,\u0003\u0002a-\t!QK\\5u\u0001")
public final class JmsProducerPool {
    private final JmsSessionPool sessionPool;
    private final ConcurrentHashMap.KeySetView<MessageProducer, Boolean> registeredProducers;
    private final ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers;

    private ConcurrentHashMap.KeySetView<MessageProducer, Boolean> registeredProducers() {
        return this.registeredProducers;
    }

    private ConcurrentHashMap<CachedProducerKey, ThreadLocal<JmsProducer>> producers() {
        return this.producers;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return (JmsProducer)this.producers().computeIfAbsent(new CachedProducerKey(destination, deliveryMode), key -> ThreadLocal.withInitial(() -> {
            Session jmsSession = $this.sessionPool.jmsSession();
            MessageProducer producer = jmsSession.createProducer(key.destination());
            producer.setDeliveryMode(key.deliveryMode());
            this.registeredProducers().add(producer);
            return new JmsProducer(jmsSession, producer);
        })).get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredProducers()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsProducerPool(JmsSessionPool sessionPool) {
        this.sessionPool = sessionPool;
        this.registeredProducers = ConcurrentHashMap.newKeySet();
        this.producers = new ConcurrentHashMap();
    }
}

