/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import javax.jms.BytesMessage;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001}4AAC\u0006\u0001)!A1\u0004\u0001B\u0001B\u0003%A\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011\u00159\u0003\u0001\"\u0001)\u0011\u0015i\u0003\u0001\"\u0001/\u0011\u0015Q\u0006\u0001\"\u0001\\\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u00151\b\u0001\"\u0003x\u0011\u0015Y\b\u0001\"\u0003}\u0005-QUn\u001d)s_\u0012,8-\u001a:\u000b\u00051i\u0011AB2mS\u0016tGO\u0003\u0002\u000f\u001f\u0005\u0019!.\\:\u000b\u0005A\t\u0012aB4bi2Lgn\u001a\u0006\u0002%\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u001735\tqCC\u0001\u0019\u0003\u0015\u00198-\u00197b\u0013\tQrC\u0001\u0004B]f\u0014VMZ\u0001\u000bU6\u001c8+Z:tS>t\u0007CA\u000f\"\u001b\u0005q\"B\u0001\b \u0015\u0005\u0001\u0013!\u00026bm\u0006D\u0018B\u0001\u0012\u001f\u0005\u001d\u0019Vm]:j_:\f\u0001\u0002\u001d:pIV\u001cWM\u001d\t\u0003;\u0015J!A\n\u0010\u0003\u001f5+7o]1hKB\u0013x\u000eZ;dKJ\fa\u0001P5oSRtDcA\u0015,YA\u0011!\u0006A\u0007\u0002\u0017!)1d\u0001a\u00019!)1e\u0001a\u0001I\u0005\u00012/\u001a8e\u0005f$Xm]'fgN\fw-\u001a\u000b\u0006_IRTJ\u0015\t\u0003-AJ!!M\f\u0003\tUs\u0017\u000e\u001e\u0005\u0006g\u0011\u0001\r\u0001N\u0001\u0006Ef$Xm\u001d\t\u0004-U:\u0014B\u0001\u001c\u0018\u0005\u0015\t%O]1z!\t1\u0002(\u0003\u0002:/\t!!)\u001f;f\u0011\u0015YD\u00011\u0001=\u0003\u0015\u0001(o\u001c9t!\u0011iDi\u0012&\u000f\u0005y\u0012\u0005CA \u0018\u001b\u0005\u0001%BA!\u0014\u0003\u0019a$o\\8u}%\u00111iF\u0001\u0007!J,G-\u001a4\n\u0005\u00153%aA'ba*\u00111i\u0006\t\u0003{!K!!\u0013$\u0003\rM#(/\u001b8h!\t12*\u0003\u0002M/\t\u0019\u0011I\\=\t\u000b9#\u0001\u0019A(\u0002\u000f)l7\u000fV=qKB\u0019a\u0003U$\n\u0005E;\"AB(qi&|g\u000eC\u0003T\t\u0001\u0007A+\u0001\u0006cK\u001a|'/Z*f]\u0012\u0004BAF+X_%\u0011ak\u0006\u0002\n\rVt7\r^5p]F\u0002\"!\b-\n\u0005es\"aB'fgN\fw-Z\u0001\u000fg\u0016tG-T1q\u001b\u0016\u001c8/Y4f)\u0015yCLX0a\u0011\u0015iV\u00011\u0001=\u0003\ri\u0017\r\u001d\u0005\u0006w\u0015\u0001\r\u0001\u0010\u0005\u0006\u001d\u0016\u0001\ra\u0014\u0005\u0006'\u0016\u0001\r\u0001V\u0001\u0012g\u0016tGm\u00142kK\u000e$X*Z:tC\u001e,G#B\u0018dY6t\u0007\"\u00023\u0007\u0001\u0004)\u0017!A8\u0011\u0005\u0019TW\"A4\u000b\u0005IA'\"A5\u0002\t)\fg/Y\u0005\u0003W\u001e\u0014AbU3sS\u0006d\u0017N_1cY\u0016DQa\u000f\u0004A\u0002qBQA\u0014\u0004A\u0002=CQa\u0015\u0004A\u0002Q\u000bqb]3oIR+\u0007\u0010^'fgN\fw-\u001a\u000b\u0006_E\u001cH/\u001e\u0005\u0006e\u001e\u0001\raR\u0001\f[\u0016\u001c8/Y4f)\u0016DH\u000fC\u0003<\u000f\u0001\u0007A\bC\u0003O\u000f\u0001\u0007q\nC\u0003T\u000f\u0001\u0007A+A\u0006tK:$W*Z:tC\u001e,GcA\u0018yu\")\u0011\u0010\u0003a\u0001/\u00069Q.Z:tC\u001e,\u0007\"B*\t\u0001\u0004!\u0016aE<sSR,\u0007K]8qgR{W*Z:tC\u001e,GcA\u0018~}\")1(\u0003a\u0001y!)\u00110\u0003a\u0001/\u0002")
public class JmsProducer {
    private final Session jmsSession;
    private final MessageProducer producer;

    public void sendBytesMessage(byte[] bytes, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        BytesMessage message = this.jmsSession.createBytesMessage();
        message.writeBytes(bytes);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendMapMessage(Map<String, Object> map, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        MapMessage message = this.jmsSession.createMapMessage();
        map.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            JmsProducer.$anonfun$sendMapMessage$1(message, x0$1);
            return BoxedUnit.UNIT;
        });
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendObjectMessage(java.io.Serializable o, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        ObjectMessage message = this.jmsSession.createObjectMessage(o);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    public void sendTextMessage(String messageText, Map<String, Object> props, Option<String> jmsType, Function1<Message, BoxedUnit> beforeSend) {
        TextMessage message = this.jmsSession.createTextMessage(messageText);
        this.writePropsToMessage(props, (Message)message);
        jmsType.foreach((Function1 & java.io.Serializable & Serializable)x$1 -> {
            message.setJMSType(x$1);
            return BoxedUnit.UNIT;
        });
        this.sendMessage((Message)message, beforeSend);
    }

    private void sendMessage(Message message, Function1<Message, BoxedUnit> beforeSend) {
        beforeSend.apply((Object)message);
        this.producer.send(message);
    }

    private void writePropsToMessage(Map<String, Object> props, Message message) {
        props.foreach((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            JmsProducer.$anonfun$writePropsToMessage$1(message, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$sendMapMessage$1(MapMessage message$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$2.setObject(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$writePropsToMessage$1(Message message$5, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        Object value = tuple2._2();
        message$5.setObjectProperty(key, value);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public JmsProducer(Session jmsSession, MessageProducer producer) {
        this.jmsSession = jmsSession;
        this.producer = producer;
    }
}

