/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.StatsEngine;
import io.gatling.core.util.NameGen;
import io.gatling.jms.action.JmsLogging;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool$;
import io.gatling.jms.client.MessageReceived;
import io.gatling.jms.client.Tracker$;
import io.gatling.jms.protocol.JmsMessageMatcher;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001ds!B\u0001\u0003\u0011\u0003Y\u0011A\u0004&ngR\u0013\u0018mY6feB{w\u000e\u001c\u0006\u0003\u0007\u0011\taa\u00197jK:$(BA\u0003\u0007\u0003\rQWn\u001d\u0006\u0003\u000f!\tqaZ1uY&twMC\u0001\n\u0003\tIwn\u0001\u0001\u0011\u00051iQ\"\u0001\u0002\u0007\u000b9\u0011\u0001\u0012A\b\u0003\u001d)k7\u000f\u0016:bG.,'\u000fU8pYN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001b\u0002\u000e\u000e\u0005\u0004%IaG\u0001\u0019\u00156\u001c8i\u001c8tk6,'\u000f\u00165sK\u0006$g)Y2u_JLX#\u0001\u000f\u0011\u0005u!S\"\u0001\u0010\u000b\u0005}\u0001\u0013AC2p]\u000e,(O]3oi*\u0011\u0011EI\u0001\u0005kRLGN\u0003\u0002$\u0011\u0005)a.\u001a;us&\u0011QE\b\u0002\u0015\t\u00164\u0017-\u001e7u)\"\u0014X-\u00193GC\u000e$xN]=\t\r\u001dj\u0001\u0015!\u0003\u001d\u0003eQUn]\"p]N,X.\u001a:UQJ,\u0017\r\u001a$bGR|'/\u001f\u0011\u0007\t9\u0011\u0001!K\n\u0005QAQ\u0003\u0007\u0005\u0002,]5\tAF\u0003\u0002.\t\u00051\u0011m\u0019;j_:L!a\f\u0017\u0003\u0015)k7\u000fT8hO&tw\r\u0005\u00022k5\t!G\u0003\u0002\"g)\u0011AGB\u0001\u0005G>\u0014X-\u0003\u00027e\t9a*Y7f\u000f\u0016t\u0007\u0002\u0003\u001d)\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u0017M,7o]5p]B{w\u000e\u001c\t\u0003\u0019iJ!a\u000f\u0002\u0003\u001d)k7oU3tg&|g\u000eU8pY\"AQ\b\u000bB\u0001B\u0003%a(\u0001\u0004tsN$X-\u001c\t\u0003\u007f\u0011k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000bQ!Y2u_JT\u0011aQ\u0001\u0005C.\\\u0017-\u0003\u0002F\u0001\nY\u0011i\u0019;peNK8\u000f^3n\u0011!9\u0005F!A!\u0002\u0013A\u0015aC:uCR\u001cXI\\4j]\u0016\u0004\"!\u0013'\u000e\u0003)S!aS\u001a\u0002\u000bM$\u0018\r^:\n\u00055S%aC*uCR\u001cXI\\4j]\u0016D\u0001b\u0014\u0015\u0003\u0002\u0003\u0006I\u0001U\u0001\u0006G2|7m\u001b\t\u0003#Vk\u0011A\u0015\u0006\u0003CMS!\u0001\u0016\u0004\u0002\u000f\r|W.\\8og&\u0011aK\u0015\u0002\u0006\u00072|7m\u001b\u0005\t1\"\u0012\t\u0011)A\u00053\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"AW/\u000e\u0003mS!\u0001X\u001a\u0002\r\r|gNZ5h\u0013\tq6L\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\u001c\u0005\u0006/!\"\t\u0001\u0019\u000b\u0007C\n\u001cG-\u001a4\u0011\u00051A\u0003\"\u0002\u001d`\u0001\u0004I\u0004\"B\u001f`\u0001\u0004q\u0004\"B$`\u0001\u0004A\u0005\"B(`\u0001\u0004\u0001\u0006\"\u0002-`\u0001\u0004I\u0006b\u00025)\u0005\u0004%I![\u0001\tiJ\f7m[3sgV\t!\u000eE\u0003laJ\f)\"D\u0001m\u0015\tyRN\u0003\u0002\"]*\tq.\u0001\u0003kCZ\f\u0017BA9m\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005#M,H0\u0003\u0002u%\t1A+\u001e9mKJ\u0002\"A\u001e>\u000e\u0003]T!!\u0002=\u000b\u0003e\fQA[1wCbL!a_<\u0003\u0017\u0011+7\u000f^5oCRLwN\u001c\t\u0004#u|\u0018B\u0001@\u0013\u0005\u0019y\u0005\u000f^5p]B!\u0011\u0011AA\b\u001d\u0011\t\u0019!a\u0003\u0011\u0007\u0005\u0015!#\u0004\u0002\u0002\b)\u0019\u0011\u0011\u0002\u0006\u0002\rq\u0012xn\u001c;?\u0013\r\tiAE\u0001\u0007!J,G-\u001a4\n\t\u0005E\u00111\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u00055!\u0003E\u0002\r\u0003/I1!!\u0007\u0003\u0005)QUn\u001d+sC\u000e\\WM\u001d\u0005\b\u0003;A\u0003\u0015!\u0003k\u0003%!(/Y2lKJ\u001c\b\u0005C\u0004\u0002\"!\"\t!a\t\u0002\u000fQ\u0014\u0018mY6feRQ\u0011QCA\u0013\u0003S\ti#a\u000e\t\u000f\u0005\u001d\u0012q\u0004a\u0001k\u0006YA-Z:uS:\fG/[8o\u0011\u001d\tY#a\bA\u0002q\f\u0001b]3mK\u000e$xN\u001d\u0005\t\u0003_\ty\u00021\u0001\u00022\u0005\u0019B.[:uK:,'\u000f\u00165sK\u0006$7i\\;oiB\u0019\u0011#a\r\n\u0007\u0005U\"CA\u0002J]RD\u0001\"!\u000f\u0002 \u0001\u0007\u00111H\u0001\u000f[\u0016\u001c8/Y4f\u001b\u0006$8\r[3s!\u0011\ti$a\u0011\u000e\u0005\u0005}\"bAA!\t\u0005A\u0001O]8u_\u000e|G.\u0003\u0003\u0002F\u0005}\"!\u0005&ng6+7o]1hK6\u000bGo\u00195fe\u0002")
public class JmsTrackerPool
implements JmsLogging,
NameGen {
    private final JmsSessionPool sessionPool;
    private final ActorSystem system;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final ConcurrentHashMap<Tuple2<Destination, Option<String>>, JmsTracker> trackers;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, Message msg) {
        JmsLogging.logMessage$(this, text, msg);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private ConcurrentHashMap<Tuple2<Destination, Option<String>>, JmsTracker> trackers() {
        return this.trackers;
    }

    public JmsTracker tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackers().computeIfAbsent((Tuple2<Destination, Option<String>>)new Tuple2((Object)destination, selector), x$1 -> {
            ActorRef actor = $this.system.actorOf(Tracker$.MODULE$.props($this.statsEngine, $this.clock, $this.configuration), this.genName("jmsTrackerActor"));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), listenerThreadCount).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
                Thread thread = JmsTrackerPool$.MODULE$.io$gatling$jms$client$JmsTrackerPool$$JmsConsumerThreadFactory().newThread(() -> {
                    MessageConsumer consumer = $this.sessionPool.jmsSession().createConsumer(destination, (String)selector.orNull(Predef$.MODULE$.$conforms()));
                    consumer.setMessageListener(message -> {
                        String matchId = messageMatcher.responseMatchId(message);
                        this.logMessage((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Message received JMSMessageID=").append(message.getJMSMessageID()).append(" matchId=").append(matchId).toString(), message);
                        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(actor);
                        MessageReceived x$2 = new MessageReceived(matchId, $this.clock.nowMillis(), message);
                        ActorRef x$3 = qual$1.$bang$default$2((Object)x$2);
                        qual$1.$bang((Object)x$2, x$3);
                    });
                });
                thread.start();
            });
            return new JmsTracker(actor);
        });
    }

    public JmsTrackerPool(JmsSessionPool sessionPool, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.sessionPool = sessionPool;
        this.system = system;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.configuration = configuration;
        StrictLogging.$init$((StrictLogging)this);
        JmsLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.trackers = new ConcurrentHashMap();
    }
}

