/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import akka.actor.ActorSystem;
import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsProducerPool;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool;
import io.gatling.jms.protocol.JmsMessageMatcher;
import io.gatling.jms.request.JmsDestination;
import io.gatling.jms.request.JmsQueue;
import io.gatling.jms.request.JmsTemporaryQueue$;
import io.gatling.jms.request.JmsTemporaryTopic$;
import io.gatling.jms.request.JmsTopic;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u0001-\u0011QBS7t\u0007>tg.Z2uS>t'BA\u0002\u0005\u0003\u0019\u0019G.[3oi*\u0011QAB\u0001\u0004U6\u001c(BA\u0004\t\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011!C\u0001\u0003S>\u001c\u0001a\u0005\u0002\u0001\u0019A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001aD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\u000bG>tg.Z2uS>t\u0007CA\u000b\u001a\u001b\u00051\"BA\u0003\u0018\u0015\u0005A\u0012!\u00026bm\u0006D\u0018B\u0001\u000e\u0017\u0005)\u0019uN\u001c8fGRLwN\u001c\u0005\t9\u0001\u0011)\u0019!C\u0001;\u0005Y1M]3eK:$\u0018.\u00197t+\u0005q\u0002cA\u0007 C%\u0011\u0001E\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\t:S\"A\u0012\u000b\u0005\u0011*\u0013!B7pI\u0016d'B\u0001\u0014\u0007\u0003\u001d\u0019w.\\7p]NL!\u0001K\u0012\u0003\u0017\r\u0013X\rZ3oi&\fGn\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005=\u0005a1M]3eK:$\u0018.\u00197tA!AA\u0006\u0001B\u0001B\u0003%Q&\u0001\u0004tsN$X-\u001c\t\u0003]Mj\u0011a\f\u0006\u0003aE\nQ!Y2u_JT\u0011AM\u0001\u0005C.\\\u0017-\u0003\u00025_\tY\u0011i\u0019;peNK8\u000f^3n\u0011!1\u0004A!A!\u0002\u00139\u0014aC:uCR\u001cXI\\4j]\u0016\u0004\"\u0001O\u001f\u000e\u0003eR!AO\u001e\u0002\u000bM$\u0018\r^:\u000b\u0005q2\u0011\u0001B2pe\u0016L!AP\u001d\u0003\u0017M#\u0018\r^:F]\u001eLg.\u001a\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006)1\r\\8dWB\u0011!)R\u0007\u0002\u0007*\u0011A)J\u0001\u0005kRLG.\u0003\u0002G\u0007\n)1\t\\8dW\"A\u0001\n\u0001B\u0001B\u0003%\u0011*A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003\u00156k\u0011a\u0013\u0006\u0003\u0019n\naaY8oM&<\u0017B\u0001(L\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\")\u0001\u000b\u0001C\u0001#\u00061A(\u001b8jiz\"rA\u0015+V-^C\u0016\f\u0005\u0002T\u00015\t!\u0001C\u0003\u0014\u001f\u0002\u0007A\u0003C\u0003\u001d\u001f\u0002\u0007a\u0004C\u0003-\u001f\u0002\u0007Q\u0006C\u00037\u001f\u0002\u0007q\u0007C\u0003A\u001f\u0002\u0007\u0011\tC\u0003I\u001f\u0002\u0007\u0011\nC\u0004\\\u0001\t\u0007I\u0011\u0002/\u0002\u0017M,7o]5p]B{w\u000e\\\u000b\u0002;B\u00111KX\u0005\u0003?\n\u0011aBS7t'\u0016\u001c8/[8o!>|G\u000e\u0003\u0004b\u0001\u0001\u0006I!X\u0001\rg\u0016\u001c8/[8o!>|G\u000e\t\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u00031\u0019H/\u0019;jGF+X-^3t+\u0005)\u0007\u0003\u00024m]fl\u0011a\u001a\u0006\u0003Q&\f!bY8oGV\u0014(/\u001a8u\u0015\t!%NC\u0001l\u0003\u0011Q\u0017M^1\n\u00055<'!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011qN\u001e\b\u0003aR\u0004\"!\u001d\b\u000e\u0003IT!a\u001d\u0006\u0002\rq\u0012xn\u001c;?\u0013\t)h\"\u0001\u0004Qe\u0016$WMZ\u0005\u0003ob\u0014aa\u0015;sS:<'BA;\u000f!\t)\"0\u0003\u0002|-\tYA)Z:uS:\fG/[8o\u0011\u0019i\b\u0001)A\u0005K\u0006i1\u000f^1uS\u000e\fV/Z;fg\u0002Bqa \u0001C\u0002\u0013%A-\u0001\u0007ti\u0006$\u0018n\u0019+pa&\u001c7\u000fC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B3\u0002\u001bM$\u0018\r^5d)>\u0004\u0018nY:!\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t1\u0002Z3ti&t\u0017\r^5p]R!\u00111BA\u0017!\u0015\ti!a\nz\u001d\u0011\ty!!\t\u000f\t\u0005E\u0011Q\u0004\b\u0005\u0003'\tYB\u0004\u0003\u0002\u0016\u0005eabA9\u0002\u0018%\t\u0011\"\u0003\u0002\b\u0011%\u0011AHB\u0005\u0004\u0003?Y\u0014aB:fgNLwN\\\u0005\u0005\u0003G\t)#A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\u0005}1(\u0003\u0003\u0002*\u0005-\"AC#yaJ,7o]5p]*!\u00111EA\u0013\u0011!\ty#!\u0002A\u0002\u0005E\u0012A\u00046ng\u0012+7\u000f^5oCRLwN\u001c\t\u0005\u0003g\tI$\u0004\u0002\u00026)\u0019\u0011q\u0007\u0003\u0002\u000fI,\u0017/^3ti&!\u00111HA\u001b\u00059QUn\u001d#fgRLg.\u0019;j_:D\u0011\"a\u0010\u0001\u0005\u0004%I!!\u0011\u0002\u0019A\u0014x\u000eZ;dKJ\u0004vn\u001c7\u0016\u0005\u0005\r\u0003cA*\u0002F%\u0019\u0011q\t\u0002\u0003\u001f)k7\u000f\u0015:pIV\u001cWM\u001d)p_2D\u0001\"a\u0013\u0001A\u0003%\u00111I\u0001\u000eaJ|G-^2feB{w\u000e\u001c\u0011\t\u000f\u0005=\u0003\u0001\"\u0001\u0002R\u0005A\u0001O]8ek\u000e,'\u000f\u0006\u0004\u0002T\u0005e\u00131\f\t\u0004'\u0006U\u0013bAA,\u0005\tY!*\\:Qe>$WoY3s\u0011\u001d\t9!!\u0014A\u0002eD\u0001\"!\u0018\u0002N\u0001\u0007\u0011qL\u0001\rI\u0016d\u0017N^3ss6{G-\u001a\t\u0004\u001b\u0005\u0005\u0014bAA2\u001d\t\u0019\u0011J\u001c;\t\u0013\u0005\u001d\u0004A1A\u0005\n\u0005%\u0014a\u0003;sC\u000e\\WM\u001d)p_2,\"!a\u001b\u0011\u0007M\u000bi'C\u0002\u0002p\t\u0011aBS7t)J\f7m[3s!>|G\u000e\u0003\u0005\u0002t\u0001\u0001\u000b\u0011BA6\u00031!(/Y2lKJ\u0004vn\u001c7!\u0011\u001d\t9\b\u0001C\u0001\u0003s\nq\u0001\u001e:bG.,'\u000f\u0006\u0006\u0002|\u0005\u0005\u00151QAE\u0003\u001b\u00032aUA?\u0013\r\tyH\u0001\u0002\u000b\u00156\u001cHK]1dW\u0016\u0014\bbBA\u0004\u0003k\u0002\r!\u001f\u0005\t\u0003\u000b\u000b)\b1\u0001\u0002\b\u0006A1/\u001a7fGR|'\u000fE\u0002\u000e?9D\u0001\"a#\u0002v\u0001\u0007\u0011qL\u0001\u0014Y&\u001cH/\u001a8feRC'/Z1e\u0007>,h\u000e\u001e\u0005\t\u0003\u001f\u000b)\b1\u0001\u0002\u0012\u0006qQ.Z:tC\u001e,W*\u0019;dQ\u0016\u0014\b\u0003BAJ\u00033k!!!&\u000b\u0007\u0005]E!\u0001\u0005qe>$xnY8m\u0013\u0011\tY*!&\u0003#)k7/T3tg\u0006<W-T1uG\",'\u000fC\u0004\u0002 \u0002!\t!!)\u0002\u000b\rdwn]3\u0015\u0005\u0005\r\u0006cA\u0007\u0002&&\u0019\u0011q\u0015\b\u0003\tUs\u0017\u000e\u001e")
public class JmsConnection {
    private final Connection connection;
    private final Option<Credentials> credentials;
    private final JmsSessionPool sessionPool;
    private final ConcurrentHashMap<String, Destination> staticQueues;
    private final ConcurrentHashMap<String, Destination> staticTopics;
    private final JmsProducerPool producerPool;
    private final JmsTrackerPool trackerPool;

    public Option<Credentials> credentials() {
        return this.credentials;
    }

    private JmsSessionPool sessionPool() {
        return this.sessionPool;
    }

    private ConcurrentHashMap<String, Destination> staticQueues() {
        return this.staticQueues;
    }

    private ConcurrentHashMap<String, Destination> staticTopics() {
        return this.staticTopics;
    }

    public Function1<io.gatling.core.session.Session, Validation<Destination>> destination(JmsDestination jmsDestination) {
        Function1 function1;
        Session jmsSession = this.sessionPool().jmsSession();
        JmsDestination jmsDestination2 = jmsDestination;
        if (JmsTemporaryQueue$.MODULE$.equals(jmsDestination2)) {
            function1 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryQueue()));
        } else if (JmsTemporaryTopic$.MODULE$.equals(jmsDestination2)) {
            function1 = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryTopic()));
        } else if (jmsDestination2 instanceof JmsQueue) {
            JmsQueue jmsQueue = (JmsQueue)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = jmsQueue.name();
            function1 = package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable & scala.Serializable)n -> (Destination)this.staticQueues().computeIfAbsent((String)n, x$1 -> jmsSession.createQueue(x$1)));
        } else if (jmsDestination2 instanceof JmsTopic) {
            JmsTopic jmsTopic = (JmsTopic)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = jmsTopic.name();
            function1 = package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable & scala.Serializable)n -> (Destination)this.staticTopics().computeIfAbsent((String)n, x$1 -> jmsSession.createTopic(x$1)));
        } else {
            throw new MatchError((Object)jmsDestination2);
        }
        return function1;
    }

    private JmsProducerPool producerPool() {
        return this.producerPool;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return this.producerPool().producer(destination, deliveryMode);
    }

    private JmsTrackerPool trackerPool() {
        return this.trackerPool;
    }

    public JmsTracker tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackerPool().tracker(destination, selector, listenerThreadCount, messageMatcher);
    }

    public void close() {
        this.producerPool().close();
        this.sessionPool().close();
        this.connection.close();
    }

    public JmsConnection(Connection connection, Option<Credentials> credentials, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.connection = connection;
        this.credentials = credentials;
        this.sessionPool = new JmsSessionPool(connection);
        this.staticQueues = new ConcurrentHashMap();
        this.staticTopics = new ConcurrentHashMap();
        this.producerPool = new JmsProducerPool(this.sessionPool());
        this.trackerPool = new JmsTrackerPool(this.sessionPool(), system, statsEngine, clock, configuration);
    }
}

