/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.action;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.core.action.Action;
import io.gatling.core.action.ChainableAction;
import io.gatling.core.action.ExitableAction;
import io.gatling.core.action.RequestAction;
import io.gatling.core.session.Session;
import io.gatling.core.session.package$;
import io.gatling.core.util.NameGen;
import io.gatling.jms.action.JmsLogging;
import io.gatling.jms.client.JmsConnection;
import io.gatling.jms.client.JmsConnectionPool;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.protocol.JmsProtocol;
import io.gatling.jms.request.BytesJmsMessage;
import io.gatling.jms.request.JmsAttributes;
import io.gatling.jms.request.JmsMessage;
import io.gatling.jms.request.MapJmsMessage;
import io.gatling.jms.request.ObjectJmsMessage;
import io.gatling.jms.request.TextJmsMessage;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.Message;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00055c!B\u0001\u0003\u0003\u0003Y!!\u0003&ng\u0006\u001bG/[8o\u0015\t\u0019A!\u0001\u0004bGRLwN\u001c\u0006\u0003\u000b\u0019\t1A[7t\u0015\t9\u0001\"A\u0004hCRd\u0017N\\4\u000b\u0003%\t!![8\u0004\u0001M)\u0001\u0001\u0004\n\u001a;A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"aE\f\u000e\u0003QQ!aA\u000b\u000b\u0005Y1\u0011\u0001B2pe\u0016L!\u0001\u0007\u000b\u0003\u001bI+\u0017/^3ti\u0006\u001bG/[8o!\tQ2$D\u0001\u0003\u0013\ta\"A\u0001\u0006K[NdunZ4j]\u001e\u0004\"AH\u0011\u000e\u0003}Q!\u0001I\u000b\u0002\tU$\u0018\u000e\\\u0005\u0003E}\u0011qAT1nK\u001e+g\u000e\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003&\u0003)\tG\u000f\u001e:jEV$Xm\u001d\t\u0003M%j\u0011a\n\u0006\u0003Q\u0011\tqA]3rk\u0016\u001cH/\u0003\u0002+O\ti!*\\:BiR\u0014\u0018NY;uKND\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!L\u0001\taJ|Go\\2pYB\u0011a\u0006M\u0007\u0002_)\u0011A\u0006B\u0005\u0003c=\u00121BS7t!J|Go\\2pY\"A1\u0007\u0001B\u0001B\u0003%A'\u0001\u0003q_>d\u0007CA\u001b9\u001b\u00051$BA\u001c\u0005\u0003\u0019\u0019G.[3oi&\u0011\u0011H\u000e\u0002\u0012\u00156\u001c8i\u001c8oK\u000e$\u0018n\u001c8Q_>d\u0007\"B\u001e\u0001\t\u0003a\u0014A\u0002\u001fj]&$h\b\u0006\u0003>}}\u0002\u0005C\u0001\u000e\u0001\u0011\u0015!#\b1\u0001&\u0011\u0015a#\b1\u0001.\u0011\u0015\u0019$\b1\u00015\u0011\u001d\u0011\u0005A1A\u0005B\r\u000b1B]3rk\u0016\u001cHOT1nKV\tA\tE\u0002F+bs!A\u0012*\u000f\u0005\u001d\u0003fB\u0001%P\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002M\u0015\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!A\u0006\u0004\n\u0005E+\u0012aB:fgNLwN\\\u0005\u0003'R\u000bq\u0001]1dW\u0006<WM\u0003\u0002R+%\u0011ak\u0016\u0002\u000b\u000bb\u0004(/Z:tS>t'BA*U!\tIVL\u0004\u0002[7B\u0011!JD\u0005\u00039:\ta\u0001\u0015:fI\u00164\u0017B\u00010`\u0005\u0019\u0019FO]5oO*\u0011AL\u0004\u0005\u0007C\u0002\u0001\u000b\u0011\u0002#\u0002\u0019I,\u0017/^3ti:\u000bW.\u001a\u0011\t\u000f\r\u0004!\u0019!C\tI\u0006i!.\\:D_:tWm\u0019;j_:,\u0012!\u001a\t\u0003k\u0019L!a\u001a\u001c\u0003\u001b)k7oQ8o]\u0016\u001cG/[8o\u0011\u0019I\u0007\u0001)A\u0005K\u0006q!.\\:D_:tWm\u0019;j_:\u0004\u0003bB6\u0001\u0005\u0004%I\u0001\\\u0001\u000fU6\u001cH)Z:uS:\fG/[8o+\u0005i\u0007cA#V]B\u0011qn]\u0007\u0002a*\u0011Q!\u001d\u0006\u0002e\u0006)!.\u0019<bq&\u0011A\u000f\u001d\u0002\f\t\u0016\u001cH/\u001b8bi&|g\u000e\u0003\u0004w\u0001\u0001\u0006I!\\\u0001\u0010U6\u001cH)Z:uS:\fG/[8oA!)\u0001\u0010\u0001C!s\u0006Y1/\u001a8e%\u0016\fX/Z:u)\u0015Q\u00181BA\u0007!\u0015Y\u0018\u0011AA\u0003\u001b\u0005a(BA?\u007f\u0003)1\u0018\r\\5eCRLwN\u001c\u0006\u0003\u007f\u001a\tqaY8n[>t7/C\u0002\u0002\u0004q\u0014!BV1mS\u0012\fG/[8o!\ri\u0011qA\u0005\u0004\u0003\u0013q!\u0001B+oSRDQAQ<A\u0002aCa!U<A\u0002\u0005=\u0001\u0003BA\t\u0003'i\u0011\u0001V\u0005\u0004\u0003+!&aB*fgNLwN\u001c\u0005\b\u00033\u0001A\u0011BA\u000e\u0003E\u0011Xm]8mm\u0016\u0004&o\u001c9feRLWm\u001d\u000b\u0007\u0003;\tY#a\r\u0011\u000bm\f\t!a\b\u0011\re\u000b\t\u0003WA\u0013\u0013\r\t\u0019c\u0018\u0002\u0004\u001b\u0006\u0004\bcA\u0007\u0002(%\u0019\u0011\u0011\u0006\b\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0002.\u0005]\u0001\u0019AA\u0018\u0003)\u0001(o\u001c9feRLWm\u001d\t\u00073\u0006\u0005B)!\r\u0011\t\u0015+\u0016Q\u0005\u0005\b#\u0006]\u0001\u0019AA\b\u0011\u001d\t9\u0004\u0001D\t\u0003s\t!BY3g_J,7+\u001a8e)\u0019\tY$!\u0013\u0002LA)10!\u0001\u0002>A9Q\"a\u0010\u0002D\u0005\u0015\u0011bAA!\u001d\tIa)\u001e8di&|g.\r\t\u0004_\u0006\u0015\u0013bAA$a\n9Q*Z:tC\u001e,\u0007B\u0002\"\u00026\u0001\u0007\u0001\fC\u0004R\u0003k\u0001\r!a\u0004")
public abstract class JmsAction
implements RequestAction,
JmsLogging,
NameGen {
    private final JmsAttributes attributes;
    private final JmsProtocol protocol;
    private final Function1<Session, Validation<String>> requestName;
    private final JmsConnection jmsConnection;
    private final Function1<Session, Validation<Destination>> jmsDestination;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    @Override
    public void logMessage(Function0<String> text, Message msg) {
        JmsLogging.logMessage$(this, text, msg);
    }

    public void execute(Session session) {
        RequestAction.execute$((RequestAction)this, (Session)session);
    }

    public /* synthetic */ void io$gatling$core$action$ExitableAction$$super$$bang(Session session) {
        ChainableAction.$bang$((ChainableAction)this, (Session)session);
    }

    public void $bang(Session session) {
        ExitableAction.$bang$((ExitableAction)this, (Session)session);
    }

    public /* synthetic */ void io$gatling$core$action$ChainableAction$$super$$bang(Session session) {
        Action.$bang$((Action)this, (Session)session);
    }

    public void recover(Session session, Validation<?> v) {
        ChainableAction.recover$((ChainableAction)this, (Session)session, v);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Function1<Session, Validation<String>> requestName() {
        return this.requestName;
    }

    public JmsConnection jmsConnection() {
        return this.jmsConnection;
    }

    private Function1<Session, Validation<Destination>> jmsDestination() {
        return this.jmsDestination;
    }

    public Validation<BoxedUnit> sendRequest(String requestName, Session session) {
        return package$.MODULE$.resolveOptionalExpression(this.attributes.jmsType(), session).flatMap((Function1 & Serializable & scala.Serializable)jmsType -> this.resolveProperties($this.attributes.messageProperties(), session).flatMap((Function1 & Serializable & scala.Serializable)props -> ((Validation)this.jmsDestination().apply((Object)session)).flatMap((Function1 & Serializable & scala.Serializable)resolvedJmsDestination -> this.beforeSend(requestName, session).map((Function1 & Serializable & scala.Serializable)beforeSend0 -> {
            JmsAction.$anonfun$sendRequest$4(this, session, jmsType, props, resolvedJmsDestination, beforeSend0);
            return BoxedUnit.UNIT;
        }))));
    }

    private Validation<Map<String, Object>> resolveProperties(Map<Function1<Session, Validation<String>>, Function1<Session, Validation<Object>>> properties, Session session) {
        return (Validation)properties.foldLeft((Object)package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)Predef$.MODULE$.Map().empty())), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            Validation resolvedProperties;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    resolvedProperties = (Validation)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            Function1 key2 = (Function1)tuple2._1();
            Function1 value = (Function1)tuple2._2();
            Validation validation = ((Validation)key2.apply((Object)session)).flatMap((Function1 & Serializable & scala.Serializable)key -> ((Validation)value.apply((Object)session)).flatMap((Function1 & Serializable & scala.Serializable)value -> resolvedProperties.map((Function1 & Serializable & scala.Serializable)resolvedProperties -> resolvedProperties.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), value)))));
            return validation;
        });
    }

    public abstract Validation<Function1<Message, BoxedUnit>> beforeSend(String var1, Session var2);

    public static final /* synthetic */ void $anonfun$sendRequest$4(JmsAction $this, Session session$1, Option jmsType$1, Map props$1, Destination resolvedJmsDestination$1, Function1 beforeSend0) {
        JmsProducer producer = $this.jmsConnection().producer(resolvedJmsDestination$1, $this.protocol.deliveryMode());
        JmsMessage jmsMessage = $this.attributes.message();
        if (jmsMessage instanceof BytesJmsMessage) {
            BytesJmsMessage bytesJmsMessage = (BytesJmsMessage)jmsMessage;
            Function1<Session, Validation<byte[]>> bytes2 = bytesJmsMessage.bytes();
            ((Validation)bytes2.apply((Object)session$1)).map((Function1 & Serializable & scala.Serializable)bytes -> {
                producer.sendBytesMessage(bytes, (Map<String, Object>)props$1, (Option<String>)jmsType$1, (Function1<Message, BoxedUnit>)beforeSend0);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsMessage instanceof MapJmsMessage) {
            MapJmsMessage mapJmsMessage = (MapJmsMessage)jmsMessage;
            Function1<Session, Validation<Map<String, Object>>> map2 = mapJmsMessage.map();
            ((Validation)map2.apply((Object)session$1)).map((Function1 & Serializable & scala.Serializable)map -> {
                producer.sendMapMessage((Map<String, Object>)map, (Map<String, Object>)props$1, (Option<String>)jmsType$1, (Function1<Message, BoxedUnit>)beforeSend0);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsMessage instanceof ObjectJmsMessage) {
            ObjectJmsMessage objectJmsMessage = (ObjectJmsMessage)jmsMessage;
            Function1<Session, Validation<Serializable>> o2 = objectJmsMessage.o();
            ((Validation)o2.apply((Object)session$1)).map((Function1 & Serializable & scala.Serializable)o -> {
                producer.sendObjectMessage(o, (Map<String, Object>)props$1, (Option<String>)jmsType$1, (Function1<Message, BoxedUnit>)beforeSend0);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (jmsMessage instanceof TextJmsMessage) {
            TextJmsMessage textJmsMessage = (TextJmsMessage)jmsMessage;
            Function1<Session, Validation<String>> txt2 = textJmsMessage.text();
            ((Validation)txt2.apply((Object)session$1)).map((Function1 & Serializable & scala.Serializable)txt -> {
                producer.sendTextMessage(txt, (Map<String, Object>)props$1, (Option<String>)jmsType$1, (Function1<Message, BoxedUnit>)beforeSend0);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)jmsMessage);
        }
    }

    public JmsAction(JmsAttributes attributes, JmsProtocol protocol, JmsConnectionPool pool) {
        this.attributes = attributes;
        this.protocol = protocol;
        StrictLogging.$init$((StrictLogging)this);
        Action.$init$((Action)this);
        ChainableAction.$init$((ChainableAction)this);
        ExitableAction.$init$((ExitableAction)this);
        RequestAction.$init$((RequestAction)this);
        JmsLogging.$init$(this);
        NameGen.$init$((NameGen)this);
        this.requestName = attributes.requestName();
        this.jmsConnection = pool.jmsConnection(protocol.connectionFactory(), protocol.credentials());
        this.jmsDestination = this.jmsConnection().destination(attributes.destination());
    }
}

