/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.core.config.SslConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dsA\u0002\f\u0018\u0011\u0003IrD\u0002\u0004\"/!\u0005\u0011D\t\u0005\u0006S\u0005!\ta\u000b\u0005\bY\u0005\u0011\r\u0011\"\u0003.\u0011\u00191\u0014\u0001)A\u0005]!9q'\u0001b\u0001\n\u0013A\u0004BB\"\u0002A\u0003%\u0011HB\u0003\"/\u0001YB\t\u0003\u0005P\u000f\t\u0005\t\u0015!\u0003Q\u0011\u0015Is\u0001\"\u0001Y\u0011\u001dYvA1A\u0005\nqCa\u0001Y\u0004!\u0002\u0013i\u0006bB1\b\u0005\u0004%IA\u0019\u0005\u0007c\u001e\u0001\u000b\u0011B2\t\u000fI<!\u0019!C\u0005g\"1\u0011p\u0002Q\u0001\nQDqA_\u0004C\u0002\u0013%1\u0010\u0003\u0004\u0000\u000f\u0001\u0006I\u0001 \u0005\t\u0003\u00039!\u0019!C\u0005w\"9\u00111A\u0004!\u0002\u0013a\bbBA\u0003\u000f\u0011\u0005\u0011q\u0001\u0005\b\u0003_9A\u0011BA\u0019\u0003I\u00196\u000f\\\"p]R,\u0007\u0010^:GC\u000e$xN]=\u000b\u0005aI\u0012\u0001B;uS2T!AG\u000e\u0002\t!$H\u000f\u001d\u0006\u00039u\tqaZ1uY&twMC\u0001\u001f\u0003\tIw\u000e\u0005\u0002!\u00035\tqC\u0001\nTg2\u001cuN\u001c;fqR\u001ch)Y2u_JL8CA\u0001$!\t!s%D\u0001&\u0015\u00051\u0013!B:dC2\f\u0017B\u0001\u0015&\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\u001a\u0001\u0001F\u0001 \u0003Y!UMZ1vYR\u001c6\u000f\\*fGV\u0014XMU1oI>lW#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001C:fGV\u0014\u0018\u000e^=\u000b\u0003M\nAA[1wC&\u0011Q\u0007\r\u0002\r'\u0016\u001cWO]3SC:$w.\\\u0001\u0018\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[\u0002\n1!\u00119o+\u0005I\u0004C\u0001\u001eB\u001b\u0005Y$B\u0001\u001f>\u0003\r\u00198\u000f\u001c\u0006\u0003}}\nq\u0001[1oI2,'O\u0003\u0002A;\u0005)a.\u001a;us&\u0011!i\u000f\u0002\u001a\u0003B\u0004H.[2bi&|g\u000e\u0015:pi>\u001cw\u000e\\\"p]\u001aLw-\u0001\u0003Ba:\u00043cA\u0004$\u000bB\u0011a)T\u0007\u0002\u000f*\u0011\u0001*S\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003\u0015.\u000b\u0001\u0002^=qKN\fg-\u001a\u0006\u0002\u0019\u0006\u00191m\\7\n\u00059;%!D*ue&\u001cG\u000fT8hO&tw-A\u0005tg2\u001cuN\u001c4jOB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u0007G>tg-[4\u000b\u0005U[\u0012\u0001B2pe\u0016L!a\u0016*\u0003!M\u001bHnQ8oM&<WO]1uS>tGCA-[!\t\u0001s\u0001C\u0003P\u0013\u0001\u0007\u0001+\u0001\rtg2\u001cVm]:j_:$\u0016.\\3pkR\u001cVmY8oIN,\u0012!\u0018\t\u0003IyK!aX\u0013\u0003\t1{gnZ\u0001\u001agNd7+Z:tS>tG+[7f_V$8+Z2p]\u0012\u001c\b%\u0001\tf]\u0006\u0014G.\u001a3Qe>$xnY8mgV\t1\rE\u0002%I\u001aL!!Z\u0013\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u001dtgB\u00015m!\tIW%D\u0001k\u0015\tY'&\u0001\u0004=e>|GOP\u0005\u0003[\u0016\na\u0001\u0015:fI\u00164\u0017BA8q\u0005\u0019\u0019FO]5oO*\u0011Q.J\u0001\u0012K:\f'\r\\3e!J|Go\\2pYN\u0004\u0013aE3oC\ndW\rZ\"ja\",'oU;ji\u0016\u001cX#\u0001;\u0011\u0007U<h-D\u0001w\u0015\tA\"'\u0003\u0002ym\n!A*[:u\u0003Q)g.\u00192mK\u0012\u001c\u0015\u000e\u001d5feN+\u0018\u000e^3tA\u0005QQo]3Pa\u0016t7k\u001d7\u0016\u0003q\u0004\"\u0001J?\n\u0005y,#a\u0002\"p_2,\u0017M\\\u0001\fkN,w\n]3o'Nd\u0007%\u0001\u000bvg\u0016|\u0005/\u001a8Tg24\u0015N\\1mSj,'o]\u0001\u0016kN,w\n]3o'Ndg)\u001b8bY&TXM]:!\u00039qWm^*tY\u000e{g\u000e^3yiN$b!!\u0003\u0002\u0010\u0005M\u0001c\u0001\u0011\u0002\f%\u0019\u0011QB\f\u0003\u0017M\u001bHnQ8oi\u0016DHo\u001d\u0005\u0007\u0003#!\u0002\u0019\u0001?\u0002\u0019!$H\u000f\u001d\u001aF]\u0006\u0014G.\u001a3\t\u000f\u0005UA\u00031\u0001\u0002\u0018\u0005A\u0002/\u001a:Vg\u0016\u00148*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0011\u000b\u0011\nI\"!\b\n\u0007\u0005mQE\u0001\u0004PaRLwN\u001c\t\u0005\u0003?\tY#\u0004\u0002\u0002\")\u0019A(a\t\u000b\t\u0005\u0015\u0012qE\u0001\u0004]\u0016$(BAA\u0015\u0003\u0015Q\u0017M^1y\u0013\u0011\ti#!\t\u0003#-+\u00170T1oC\u001e,'OR1di>\u0014\u00180\u0001\toK^TEm[*tY\u000e{g\u000e^3yiR1\u00111GA\u001d\u0003\u0007\u00022AOA\u001b\u0013\r\t9d\u000f\u0002\u000b'Nd7i\u001c8uKb$\bbBA\u001e+\u0001\u0007\u0011QH\u0001\u000eU\u0012\\7k\u001d7D_:$X\r\u001f;\u0011\t\u0005}\u0011qH\u0005\u0005\u0003\u0003\n\tC\u0001\u0006T'2\u001buN\u001c;fqRDa!!\u0012\u0016\u0001\u0004I\u0014aA1q]\u0002")
public class SslContextsFactory
implements StrictLogging {
    private final SslConfiguration sslConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] enabledProtocols;
    private final List<String> enabledCipherSuites;
    private final boolean useOpenSsl;
    private final boolean useOpenSslFinalizers;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    private String[] enabledProtocols() {
        return this.enabledProtocols;
    }

    private List<String> enabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    private boolean useOpenSsl() {
        return this.useOpenSsl;
    }

    private boolean useOpenSslFinalizers() {
        return this.useOpenSslFinalizers;
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        SslContexts sslContexts;
        Option kmf = perUserKeyManagerFactory.orElse((Function0 & Serializable & scala.Serializable)() -> $this.sslConfig.keyManagerFactory());
        Option tmf = this.sslConfig.trustManagerFactory().orElse((Function0 & Serializable & scala.Serializable)() -> $this.sslConfig.useInsecureTrustManager() ? new Some((Object)InsecureTrustManagerFactory.INSTANCE) : None$.MODULE$);
        if (this.useOpenSsl()) {
            SslProvider provider = this.useOpenSslFinalizers() ? SslProvider.OPENSSL : SslProvider.OPENSSL_REFCNT;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(provider);
            Object object = this.sslConfig.sessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.sslConfig.sessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.sslConfig.sessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? sslContextBuilder.protocols(this.enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.sslConfig.enabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            kmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            tmf.foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.trustManager(x$1));
            SslContext sslContext = sslContextBuilder.build();
            None$ alpnSslContext = http2Enabled ? new Some((Object)sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build()) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])kmf.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), (TrustManager[])tmf.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getTrustManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newJdkSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newJdkSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newJdkSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new JdkSslContext(jdkSslContext, true, this.enabledCipherSuites().isEmpty() ? null : this.enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn, ClientAuth.NONE, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.enabledProtocols())).nonEmpty() ? this.enabledProtocols() : null, false);
    }

    /*
     * WARNING - void declaration
     */
    public SslContextsFactory(SslConfiguration sslConfig) {
        boolean bl;
        this.sslConfig = sslConfig;
        StrictLogging.$init$((StrictLogging)this);
        this.sslSessionTimeoutSeconds = sslConfig.sessionTimeout().toSeconds();
        this.enabledProtocols = (String[])sslConfig.enabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)sslConfig.enabledCipherSuites()).asJava();
        if (sslConfig.useOpenSsl()) {
            void var2_2;
            BoxedUnit boxedUnit;
            boolean available = OpenSsl.isAvailable();
            if (!available) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("OpenSSL is enabled in the Gatling configuration but it's not available on your architecture.");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            bl = var2_2;
        } else {
            bl = false;
        }
        this.useOpenSsl = bl;
        this.useOpenSslFinalizers = sslConfig.useOpenSslFinalizers();
    }
}

