/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.resolver;

import io.gatling.http.client.HttpListener;
import io.gatling.http.client.resolver.InetAddressNameResolver;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001-4Aa\u0002\u0005\u0001#!A\u0011\u0005\u0001B\u0001B\u0003%!\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0011\u0015y\u0006\u0001\"\u0003a\u0011\u0015I\u0007\u0001\"\u0011k\u0005}IeN\u001a7jO\"$\u0018J\\3u\u0003\u0012$'/Z:t\u001d\u0006lWMU3t_24XM\u001d\u0006\u0003\u0013)\t\u0001B]3t_24XM\u001d\u0006\u0003\u00171\tA\u0001\u001b;ua*\u0011QBD\u0001\bO\u0006$H.\u001b8h\u0015\u0005y\u0011AA5p\u0007\u0001\u00192\u0001\u0001\n\u001b!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0003mC:<'\"A\f\u0002\t)\fg/Y\u0005\u00033Q\u0011aa\u00142kK\u000e$\bCA\u000e \u001b\u0005a\"BA\u0005\u001e\u0015\tq\"\"\u0001\u0004dY&,g\u000e^\u0005\u0003Aq\u0011q#\u00138fi\u0006#GM]3tg:\u000bW.\u001a*fg>dg/\u001a:\u0002\u000f]\u0014\u0018\r\u001d9fI\u0006)\u0012N\u001c)s_\u001e\u0014Xm]:SKN|G.\u001e;j_:\u001c\b\u0003\u0002\u0013*Waj\u0011!\n\u0006\u0003M\u001d\n!bY8oGV\u0014(/\u001a8u\u0015\tAc#\u0001\u0003vi&d\u0017B\u0001\u0016&\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003YUr!!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005A\u0002\u0012A\u0002\u001fs_>$hHC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b2!\rId\bQ\u0007\u0002u)\u0011ae\u000f\u0006\u0003QqR!!\u0010\b\u0002\u000b9,G\u000f^=\n\u0005}R$a\u0002)s_6L7/\u001a\t\u0004\u0003\n#U\"A\u0014\n\u0005\r;#\u0001\u0002'jgR\u0004\"!\u0012%\u000e\u0003\u0019S!a\u0012\f\u0002\u00079,G/\u0003\u0002J\r\nY\u0011J\\3u\u0003\u0012$'/Z:t\u0003\u0019a\u0014N\\5u}Q\u0019AJT(\u0011\u00055\u0003Q\"\u0001\u0005\t\u000b\u0005\u001a\u0001\u0019\u0001\u000e\t\u000b\t\u001a\u0001\u0019A\u0012\u0002\u0015I,7o\u001c7wK\u0006cG\u000e\u0006\u0003S+^K\u0006cA\u001dT\u0001&\u0011AK\u000f\u0002\u0007\rV$XO]3\t\u000bY#\u0001\u0019A\u0016\u0002\u0011%tW\r\u001e%pgRDQ\u0001\u0017\u0003A\u0002a\nq\u0001\u001d:p[&\u001cX\rC\u0003[\t\u0001\u00071,\u0001\u0005mSN$XM\\3s!\taV,D\u0001\u001e\u0013\tqVD\u0001\u0007IiR\u0004H*[:uK:,'/\u0001\bue\u0006t7OZ3s%\u0016\u001cX\u000f\u001c;\u0015\u0007\u0005,w\r\u0005\u0002cG6\t\u0011'\u0003\u0002ec\t!QK\\5u\u0011\u00151W\u00011\u0001S\u0003\r\u0019(o\u0019\u0005\u0006Q\u0016\u0001\r\u0001O\u0001\u0004IN$\u0018!B2m_N,G#A1")
public class InflightInetAddressNameResolver
implements InetAddressNameResolver {
    private final InetAddressNameResolver wrapped;
    private final ConcurrentHashMap<String, Promise<List<InetAddress>>> inProgressResolutions;

    public Future<List<InetAddress>> resolveAll(String inetHost, Promise<List<InetAddress>> promise, HttpListener listener) {
        Future future;
        Promise<List<InetAddress>> earlyPromise = this.inProgressResolutions.putIfAbsent(inetHost, promise);
        if (earlyPromise != null) {
            if (earlyPromise.isDone()) {
                this.transferResult((Future<List<InetAddress>>)earlyPromise, promise);
                future = BoxedUnit.UNIT;
            } else {
                future = earlyPromise.addListener(x$2 -> this.transferResult((Future<List<InetAddress>>)x$2, promise));
            }
        } else {
            try {
                future = this.wrapped.resolveAll(inetHost, promise, listener);
            }
            finally {
                if (promise.isDone()) {
                    this.inProgressResolutions.remove(inetHost);
                } else {
                    promise.addListener(x$3 -> $this.inProgressResolutions.remove(inetHost));
                }
            }
        }
        return promise;
    }

    private void transferResult(Future<List<InetAddress>> src, Promise<List<InetAddress>> dst) {
        if (src.isSuccess()) {
            dst.trySuccess(src.getNow());
        } else {
            dst.tryFailure(src.cause());
        }
    }

    public void close() {
    }

    public InflightInetAddressNameResolver(InetAddressNameResolver wrapped, ConcurrentHashMap<String, Promise<List<InetAddress>>> inProgressResolutions) {
        this.wrapped = wrapped;
        this.inProgressResolutions = inProgressResolutions;
    }
}

