/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.SseClosingState;
import io.gatling.http.action.sse.fsm.SseCrashedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SsePerformingCheckState;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.check.sse.SseMessageCheck;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import java.io.Serializable;
import scala.Function0;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015a\u0001\u0002\u0006\f\u0001aA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!)!\u0007\u0001C\u0001g!)q\u0007\u0001C!q!)Q\r\u0001C!M\")q\u000e\u0001C!a\")!\u000f\u0001C!g\")Q\u000f\u0001C!m\")Q\u0010\u0001C!}\na1k]3JI2,7\u000b^1uK*\u0011A\"D\u0001\u0004MNl'B\u0001\b\u0010\u0003\r\u00198/\u001a\u0006\u0003!E\ta!Y2uS>t'B\u0001\n\u0014\u0003\u0011AG\u000f\u001e9\u000b\u0005Q)\u0012aB4bi2Lgn\u001a\u0006\u0002-\u0005\u0011\u0011n\\\u0002\u0001'\r\u0001\u0011$\b\t\u00035mi\u0011aC\u0005\u00039-\u0011\u0001bU:f'R\fG/\u001a\t\u0003=\u0015j\u0011a\b\u0006\u0003A\u0005\nAb]2bY\u0006dwnZ4j]\u001eT!AI\u0012\u0002\u0011QL\b/Z:bM\u0016T\u0011\u0001J\u0001\u0004G>l\u0017B\u0001\u0014 \u00055\u0019FO]5di2{wmZ5oOB\u0011!\u0004K\u0005\u0003S-\u0011aaU:f\rNl\u0017aB:fgNLwN\u001c\t\u0003YAj\u0011!\f\u0006\u0003U9R!aL\n\u0002\t\r|'/Z\u0005\u0003c5\u0012qaU3tg&|g.\u0001\u0004=S:LGO\u0010\u000b\u0004iU2\u0004C\u0001\u000e\u0001\u0011\u0015a1\u00011\u0001(\u0011\u0015Q3\u00011\u0001,\u0003)ygnU3u\u0007\",7m\u001b\u000b\u0006sqZUL\u0018\t\u00035iJ!aO\u0006\u0003\u00199+\u0007\u0010^*tKN#\u0018\r^3\t\u000bu\"\u0001\u0019\u0001 \u0002\u0015\u0005\u001cG/[8o\u001d\u0006lW\r\u0005\u0002@\u0011:\u0011\u0001I\u0012\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007^\ta\u0001\u0010:p_Rt$\"A#\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u001d#\u0015A\u0002)sK\u0012,g-\u0003\u0002J\u0015\n11\u000b\u001e:j]\u001eT!a\u0012#\t\u000b1#\u0001\u0019A'\u0002\u001d\rDWmY6TKF,XM\\2fgB\u0019aj\u0015,\u000f\u0005=\u000bfBA!Q\u0013\u0005)\u0015B\u0001*E\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\t1K7\u000f\u001e\u0006\u0003%\u0012\u0003\"aV.\u000e\u0003aS!AD-\u000b\u0005i\u000b\u0012!B2iK\u000e\\\u0017B\u0001/Y\u0005]\u00196/Z'fgN\fw-Z\"iK\u000e\\7+Z9vK:\u001cW\rC\u0003+\t\u0001\u00071\u0006C\u0003`\t\u0001\u0007\u0001-\u0001\u0003oKb$\bCA1d\u001b\u0005\u0011'B\u0001\t/\u0013\t!'M\u0001\u0004BGRLwN\\\u0001\u000e_:\u001c6/\u001a*fG\u0016Lg/\u001a3\u0015\u0007e:\u0017\u000eC\u0003i\u000b\u0001\u0007a(A\u0004nKN\u001c\u0018mZ3\t\u000b),\u0001\u0019A6\u0002\u0013QLW.Z:uC6\u0004\bC\u00017n\u001b\u0005!\u0015B\u00018E\u0005\u0011auN\\4\u0002)=t7k]3TiJ,\u0017-\\\"p]:,7\r^3e)\tI\u0014\u000fC\u0003k\r\u0001\u00071.\u0001\tp]N\u001bX-\u00128e\u001f\u001a\u001cFO]3b[R\u0011\u0011\b\u001e\u0005\u0006U\u001e\u0001\ra[\u0001\u0013_:\u001c6/Z*ue\u0016\fWn\u0011:bg\",G\rF\u0002:orDQ\u0001\u001f\u0005A\u0002e\f\u0011\u0001\u001e\t\u0003\u001djL!a_+\u0003\u0013QC'o\\<bE2,\u0007\"\u00026\t\u0001\u0004Y\u0017\u0001F8o\u00072LWM\u001c;DY>\u001cXMU3rk\u0016\u001cH\u000f\u0006\u0004:\u007f\u0006\u0005\u00111\u0001\u0005\u0006{%\u0001\rA\u0010\u0005\u0006U%\u0001\ra\u000b\u0005\u0006?&\u0001\r\u0001\u0019")
public class SseIdleState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final Session session;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextSseState onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Set check {}", new Object[]{actionName});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long timestamp = this.fsm.clock().nowMillis();
        List<SseMessageCheckSequence> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        SseMessageCheckSequence sseMessageCheckSequence = (SseMessageCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.tl$access$1();
        if (sseMessageCheckSequence == null) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        FiniteDuration timeout = sseMessageCheckSequence.timeout();
        List<SseMessageCheck> list2 = sseMessageCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        SseMessageCheck currentCheck = (SseMessageCheck)colon3.head();
        List remainingChecks = colon3.tl$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextSseState(new SsePerformingCheckState(this.fsm, currentCheck, (List<SseMessageCheck>)remainingChecks, timestamp, (List<SseMessageCheckSequence>)remainingCheckSequences, session, next), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseReceived(String message, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received unmatched message={}", new Object[]{message});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logUnmatchedServerMessage(this.session);
        return new NextSseState(this, NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamConnected(long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("SSE Stream reconnected while in Idle state");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(this, NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseEndOfStream(long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Server notified of end of stream while in Idle state");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm.statsEngine(), "End of stream"), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamCrashed(Throwable t, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("SSE stream crashed while in Idle state", t);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm.statsEngine(), Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t))), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onClientCloseRequest(String actionName, Session session, Action next) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Client requested SSE stream close");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseClosingState(this.fsm, actionName, session, next, this.fsm.clock().nowMillis()), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.fsm.stream().requestingCloseByClient());
    }

    public SseIdleState(SseFsm fsm, Session session) {
        this.fsm = fsm;
        this.session = session;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

