/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import io.gatling.commons.util.Maps;
import io.gatling.commons.util.Maps$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBody;
import io.gatling.http.response.ResponseBody$;
import io.gatling.http.response.ResponseBuilder$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\t%r!\u0002\u00180\u0011\u0003Ad!\u0002\u001e0\u0011\u0003Y\u0004\"\u0002\"\u0002\t\u0003\u0019\u0005\"\u0002#\u0002\t\u0003)e\u0001\u0002\u001e0\u0001}C\u0001B\u0015\u0003\u0003\u0002\u0003\u0006I\u0001\u0019\u0005\tM\u0012\u0011\t\u0011)A\u0005O\"AQ\u0010\u0002B\u0001B\u0003%a\u0010C\u0005\u0002\u0004\u0011\u0011\t\u0011)A\u0005}\"Q\u0011Q\u0001\u0003\u0003\u0002\u0003\u0006I!a\u0002\t\r\t#A\u0011AA\f\u0011-\t)\u0003\u0002a\u0001\u0002\u0004%\t!a\n\t\u0017\u0005%B\u00011AA\u0002\u0013\u0005\u00111\u0006\u0005\u000b\u0003o!\u0001\u0019!A!B\u0013q\bbCA\u001d\t\u0001\u0007\t\u0019!C\u0001\u0003wA1\"a\u0011\u0005\u0001\u0004\u0005\r\u0011\"\u0001\u0002F!Y\u0011\u0011\n\u0003A\u0002\u0003\u0005\u000b\u0015BA\u001f\u0011-\tY\u0005\u0002a\u0001\u0002\u0004%\t!a\u000f\t\u0017\u00055C\u00011AA\u0002\u0013\u0005\u0011q\n\u0005\f\u0003'\"\u0001\u0019!A!B\u0013\ti\u0004C\u0006\u0002V\u0011\u0001\r\u00111A\u0005\n\u0005\u001d\u0002bCA,\t\u0001\u0007\t\u0019!C\u0005\u00033B!\"!\u0018\u0005\u0001\u0004\u0005\t\u0015)\u0003\u007f\u0011%\ty\u0006\u0002a\u0001\n\u0013\t\t\u0007C\u0005\u0002\u0000\u0011\u0001\r\u0011\"\u0003\u0002\u0002\"A\u0011Q\u0011\u0003!B\u0013\t\u0019\u0007C\u0005\u0002\b\u0012\u0001\r\u0011\"\u0003\u0002\n\"I\u0011\u0011\u0013\u0003A\u0002\u0013%\u00111\u0013\u0005\t\u0003/#\u0001\u0015)\u0003\u0002\f\"I\u0011\u0011\u0014\u0003A\u0002\u0013%\u0011\u0011\u0012\u0005\n\u00037#\u0001\u0019!C\u0005\u0003;C\u0001\"!)\u0005A\u0003&\u00111\u0012\u0005\n\u0003G#\u0001\u0019!C\u0005\u0003KC\u0011\"a1\u0005\u0001\u0004%I!!2\t\u0011\u0005%G\u0001)Q\u0005\u0003OCq!a3\u0005\t\u0003\ti\rC\u0004\u0002T\u0012!\t!!6\t\u000f\u0005eG\u0001\"\u0001\u0002\\\"9\u0011\u0011\u001c\u0003\u0005\u0002\u0005\u0015\bbBAw\t\u0011\u0005\u0011q\u001e\u0005\b\u0003g$A\u0011BA{\u0011\u001d\t9\u0010\u0002C\u0005\u0003sDqA!\u0001\u0005\t\u0003\u0011\u0019\u0001C\u0004\u0003\f\u0011!\tA!\u0004\t\u000f\t-A\u0001\"\u0003\u0003 !9!Q\u0005\u0003\u0005\u0002\t\u001d\u0012a\u0004*fgB|gn]3Ck&dG-\u001a:\u000b\u0005A\n\u0014\u0001\u0003:fgB|gn]3\u000b\u0005I\u001a\u0014\u0001\u00025uiBT!\u0001N\u001b\u0002\u000f\u001d\fG\u000f\\5oO*\ta'\u0001\u0002j_\u000e\u0001\u0001CA\u001d\u0002\u001b\u0005y#a\u0004*fgB|gn]3Ck&dG-\u001a:\u0014\u0005\u0005a\u0004CA\u001fA\u001b\u0005q$\"A \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005s$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002q\u0005Ib.Z<SKN\u0004xN\\:f\u0005VLG\u000eZ3s\r\u0006\u001cGo\u001c:z)\r1U*\u0016\t\u0003\u000f*s!!\u000f%\n\u0005%{\u0013a\u00029bG.\fw-Z\u0005\u0003\u00172\u0013aCU3ta>t7/\u001a\"vS2$WM\u001d$bGR|'/\u001f\u0006\u0003\u0013>BQAT\u0002A\u0002=\u000bQB]3rk\u0016\u001cHoQ8oM&<\u0007C\u0001)T\u001b\u0005\t&B\u0001*2\u0003\u001d\u0011X-];fgRL!\u0001V)\u0003#!#H\u000f\u001d*fcV,7\u000f^\"p]\u001aLw\rC\u0003W\u0007\u0001\u0007q+A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u00031vk\u0011!\u0017\u0006\u00035n\u000baaY8oM&<'B\u0001/4\u0003\u0011\u0019wN]3\n\u0005yK&\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|gn\u0005\u0002\u0005yA\u0011\u0011\rZ\u0007\u0002E*\u00111-M\u0001\u0007G2LWM\u001c;\n\u0005\u0015\u0014'a\u0002*fcV,7\u000f^\u0001\bI&<Wm\u001d;t!\u0011AwN];\u000f\u0005%l\u0007C\u00016?\u001b\u0005Y'B\u000178\u0003\u0019a$o\\8u}%\u0011aNP\u0001\u0007!J,G-\u001a4\n\u0005A\f(aA'ba*\u0011aN\u0010\t\u0003QNL!\u0001^9\u0003\rM#(/\u001b8h!\t180D\u0001x\u0015\tA\u00180\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\u001b5+7o]1hK\u0012Kw-Z:u\u00039\u0019Ho\u001c:f\u0005>$\u0017\u0010U1siN\u0004\"!P@\n\u0007\u0005\u0005aHA\u0004C_>dW-\u00198\u0002%%tg-\u001a:Ii6d'+Z:pkJ\u001cWm]\u0001\u000fI\u00164\u0017-\u001e7u\u0007\"\f'o]3u!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\tqa\u00195beN,GOC\u0002\u0002\u0012e\f1A\\5p\u0013\u0011\t)\"a\u0003\u0003\u000f\rC\u0017M]:fiRa\u0011\u0011DA\u000e\u0003;\ty\"!\t\u0002$A\u0011\u0011\b\u0002\u0005\u0006%*\u0001\r\u0001\u0019\u0005\u0006M*\u0001\ra\u001a\u0005\u0006{*\u0001\rA \u0005\u0007\u0003\u0007Q\u0001\u0019\u0001@\t\u000f\u0005\u0015!\u00021\u0001\u0002\b\u0005q1\u000f^8sK\"#X\u000e\\(s\u0007N\u001cX#\u0001@\u0002%M$xN]3Ii6dwJ]\"tg~#S-\u001d\u000b\u0005\u0003[\t\u0019\u0004E\u0002>\u0003_I1!!\r?\u0005\u0011)f.\u001b;\t\u0011\u0005UB\"!AA\u0002y\f1\u0001\u001f\u00132\u0003=\u0019Ho\u001c:f\u0011RlGn\u0014:DgN\u0004\u0013AD:uCJ$H+[7fgR\fW\u000e]\u000b\u0003\u0003{\u00012!PA \u0013\r\t\tE\u0010\u0002\u0005\u0019>tw-\u0001\nti\u0006\u0014H\u000fV5nKN$\u0018-\u001c9`I\u0015\fH\u0003BA\u0017\u0003\u000fB\u0011\"!\u000e\u0010\u0003\u0003\u0005\r!!\u0010\u0002\u001fM$\u0018M\u001d;US6,7\u000f^1na\u0002\nA\"\u001a8e)&lWm\u001d;b[B\f\u0001#\u001a8e)&lWm\u001d;b[B|F%Z9\u0015\t\u00055\u0012\u0011\u000b\u0005\n\u0003k\u0011\u0012\u0011!a\u0001\u0003{\tQ\"\u001a8e)&lWm\u001d;b[B\u0004\u0013aB5t\u0011R$\bOM\u0001\fSNDE\u000f\u001e93?\u0012*\u0017\u000f\u0006\u0003\u0002.\u0005m\u0003\u0002CA\u001b+\u0005\u0005\t\u0019\u0001@\u0002\u0011%\u001c\b\n\u001e;qe\u0001\naa\u001d;biV\u001cXCAA2!\u0015i\u0014QMA5\u0013\r\t9G\u0010\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005-\u00141P\u0007\u0003\u0003[R1AMA8\u0015\u0011\t\t(a\u001d\u0002\u000b\r|G-Z2\u000b\t\u0005U\u0014qO\u0001\bQ\u0006tG\r\\3s\u0015\r\tI(N\u0001\u0006]\u0016$H/_\u0005\u0005\u0003{\niG\u0001\nIiR\u0004(+Z:q_:\u001cXm\u0015;biV\u001c\u0018AC:uCR,8o\u0018\u0013fcR!\u0011QFAB\u0011%\t)\u0004GA\u0001\u0002\u0004\t\u0019'A\u0004ti\u0006$Xo\u001d\u0011\u0002%]L'/\u001a*fcV,7\u000f\u001e%fC\u0012,'o]\u000b\u0003\u0003\u0017\u0003B!a\u001b\u0002\u000e&!\u0011qRA7\u0005-AE\u000f\u001e9IK\u0006$WM]:\u0002-]L'/\u001a*fcV,7\u000f\u001e%fC\u0012,'o]0%KF$B!!\f\u0002\u0016\"I\u0011QG\u000e\u0002\u0002\u0003\u0007\u00111R\u0001\u0014o&\u0014XMU3rk\u0016\u001cH\u000fS3bI\u0016\u00148\u000fI\u0001\bQ\u0016\fG-\u001a:t\u0003-AW-\u00193feN|F%Z9\u0015\t\u00055\u0012q\u0014\u0005\n\u0003kq\u0012\u0011!a\u0001\u0003\u0017\u000b\u0001\u0002[3bI\u0016\u00148\u000fI\u0001\u0007G\",hn[:\u0016\u0005\u0005\u001d\u0006CBAU\u0003c\u000b9L\u0004\u0003\u0002,\u0006=fb\u00016\u0002.&\tq(\u0003\u0002J}%!\u00111WA[\u0005\u0011a\u0015n\u001d;\u000b\u0005%s\u0004\u0003BA]\u0003\u007fk!!a/\u000b\t\u0005u\u0016qO\u0001\u0007EV4g-\u001a:\n\t\u0005\u0005\u00171\u0018\u0002\b\u0005f$XMQ;g\u0003)\u0019\u0007.\u001e8lg~#S-\u001d\u000b\u0005\u0003[\t9\rC\u0005\u00026\u0005\n\t\u00111\u0001\u0002(\u000691\r[;oWN\u0004\u0013aC;qI\u0006$Xm\u0015;beR$b!!\f\u0002P\u0006E\u0007bBA\u001dG\u0001\u0007\u0011Q\b\u0005\b\u0003\u000f\u001b\u0003\u0019AAF\u0003I)\b\u000fZ1uK\u0016sG\rV5nKN$\u0018-\u001c9\u0015\t\u00055\u0012q\u001b\u0005\b\u0003\u0017\"\u0003\u0019AA\u001f\u0003)\t7mY;nk2\fG/\u001a\u000b\t\u0003[\ti.a8\u0002b\"9\u0011qL\u0013A\u0002\u0005%\u0004bBAMK\u0001\u0007\u00111\u0012\u0005\b\u0003G,\u0003\u0019AA\u001f\u0003%!\u0018.\\3ti\u0006l\u0007\u000f\u0006\u0004\u0002.\u0005\u001d\u00181\u001e\u0005\b\u0003S4\u0003\u0019AA\\\u0003\u001d\u0011\u0017\u0010^3Ck\u001aDq!a9'\u0001\u0004\ti$\u0001\u0005tKRDE\u000f\u001e93)\u0011\ti#!=\t\r\u0005Us\u00051\u0001\u007f\u00039\u0011Xm]8mm\u0016\u001c\u0005.\u0019:tKR,\"!a\u0002\u0002)\r|W\u000e];uK\u000e{g\u000e^3oi2+gn\u001a;i+\t\tY\u0010E\u0002>\u0003{L1!a@?\u0005\rIe\u000e^\u0001\u000eEVLG\u000e\u001a*fgB|gn]3\u0016\u0005\t\u0015\u0001cA\u001d\u0003\b%\u0019!\u0011B\u0018\u0003\u0015!#H\u000f\u001d*fgVdG/\u0001\u0007ck&dGMR1jYV\u0014X\r\u0006\u0003\u0003\u0010\tU\u0001cA\u001d\u0003\u0012%\u0019!1C\u0018\u0003\u0017!#H\u000f\u001d$bS2,(/\u001a\u0005\b\u0005/Y\u0003\u0019\u0001B\r\u0003\u0005!\b\u0003BAU\u00057IAA!\b\u00026\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u000b\u0005\u0005\u001f\u0011\t\u0003\u0003\u0004\u0003$1\u0002\rA]\u0001\rKJ\u0014xN]'fgN\fw-Z\u0001\u000ee\u0016dW-Y:f\u0007\",hn[:\u0015\u0005\u00055\u0002")
public class ResponseBuilder {
    private final Request request;
    private final Map<String, MessageDigest> digests;
    private final boolean storeBodyParts;
    private final boolean inferHtmlResources;
    private final Charset defaultCharset;
    private boolean storeHtmlOrCss;
    private long startTimestamp;
    private long endTimestamp;
    private boolean isHttp2;
    private Option<HttpResponseStatus> status;
    private HttpHeaders wireRequestHeaders;
    private HttpHeaders headers;
    private List<ByteBuf> chunks;

    public static Function1<Request, ResponseBuilder> newResponseBuilderFactory(HttpRequestConfig httpRequestConfig, GatlingConfiguration gatlingConfiguration) {
        return ResponseBuilder$.MODULE$.newResponseBuilderFactory(httpRequestConfig, gatlingConfiguration);
    }

    public boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    public void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp_$eq(long x$1) {
        this.startTimestamp = x$1;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public void endTimestamp_$eq(long x$1) {
        this.endTimestamp = x$1;
    }

    private boolean isHttp2() {
        return this.isHttp2;
    }

    private void isHttp2_$eq(boolean x$1) {
        this.isHttp2 = x$1;
    }

    private Option<HttpResponseStatus> status() {
        return this.status;
    }

    private void status_$eq(Option<HttpResponseStatus> x$1) {
        this.status = x$1;
    }

    private HttpHeaders wireRequestHeaders() {
        return this.wireRequestHeaders;
    }

    private void wireRequestHeaders_$eq(HttpHeaders x$1) {
        this.wireRequestHeaders = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    public void updateStart(long startTimestamp, HttpHeaders wireRequestHeaders) {
        this.startTimestamp_$eq(startTimestamp);
        this.wireRequestHeaders_$eq(wireRequestHeaders);
    }

    public void updateEndTimestamp(long endTimestamp) {
        this.endTimestamp_$eq(endTimestamp);
    }

    public void accumulate(HttpResponseStatus status, HttpHeaders headers, long timestamp) {
        this.updateEndTimestamp(timestamp);
        this.status_$eq((Option<HttpResponseStatus>)new Some((Object)status));
        if (this.headers() == EmptyHttpHeaders.INSTANCE) {
            this.headers_$eq(headers);
            this.storeHtmlOrCss_$eq(this.inferHtmlResources && (HttpHelper$.MODULE$.isHtml(headers) || HttpHelper$.MODULE$.isCss(headers)));
        } else {
            this.headers().add(headers);
        }
    }

    public void accumulate(ByteBuf byteBuf, long timestamp) {
        block2: {
            this.updateEndTimestamp(timestamp);
            if (!byteBuf.isReadable()) break block2;
            if (this.storeBodyParts || this.storeHtmlOrCss()) {
                ByteBuf byteBuf2 = byteBuf.retain();
                this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf2));
            }
            if (this.digests.nonEmpty()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])byteBuf.nioBuffers())).foreach((Function1 & Serializable & scala.Serializable)nioBuffer -> {
                    ResponseBuilder.$anonfun$accumulate$1(this, nioBuffer);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public void setHttp2(boolean isHttp2) {
        this.isHttp2_$eq(isHttp2);
    }

    private Charset resolveCharset() {
        String contentTypeHeader = this.headers().get(HeaderNames$.MODULE$.ContentType());
        return contentTypeHeader == null ? this.defaultCharset : (Charset)HttpHelper$.MODULE$.extractCharsetFromContentType(contentTypeHeader).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
    }

    private int computeContentLength() {
        IntRef l = IntRef.create((int)0);
        this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            ResponseBuilder.$anonfun$computeContentLength$1(l, x$4);
            return BoxedUnit.UNIT;
        });
        return l.elem;
    }

    public HttpResult buildResponse() {
        HttpFailure httpFailure;
        Option<HttpResponseStatus> option = this.status();
        if (option instanceof Some) {
            Product product;
            Some some = (Some)option;
            HttpResponseStatus s = (HttpResponseStatus)some.value();
            try {
                this.endTimestamp_$eq(package$.MODULE$.max(this.endTimestamp(), this.startTimestamp()));
                Map checksums = Maps.PimpedMap$.MODULE$.forceMapValues$extension(Maps$.MODULE$.PimpedMap(this.digests), (Function1 & Serializable & scala.Serializable)md -> StringHelper$.MODULE$.bytes2Hex(md.digest()));
                Charset resolvedCharset = this.resolveCharset();
                List chunksOrderedByArrival = this.chunks().reverse();
                ResponseBody body = ResponseBody$.MODULE$.apply((Seq<ByteBuf>)chunksOrderedByArrival, resolvedCharset);
                product = new Response(this.request, this.wireRequestHeaders(), this.startTimestamp(), this.endTimestamp(), s, this.headers(), body, (Map<String, String>)checksums, this.computeContentLength(), resolvedCharset, this.isHttp2());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                if (option2.isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option2.get();
                HttpFailure httpFailure2 = this.buildFailure(t);
                product = httpFailure2;
            }
            httpFailure = product;
        } else {
            httpFailure = this.buildFailure("How come we're trying to build a response with no status?!");
        }
        return httpFailure;
    }

    public HttpFailure buildFailure(Throwable t) {
        return this.buildFailure(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
    }

    private HttpFailure buildFailure(String errorMessage) {
        return new HttpFailure(this.request, this.wireRequestHeaders(), this.startTimestamp(), this.endTimestamp(), errorMessage);
    }

    public void releaseChunks() {
        this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$accumulate$1(ResponseBuilder $this, ByteBuffer nioBuffer) {
        $this.digests.values().foreach((Function1 & Serializable & scala.Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$computeContentLength$1(IntRef l$1, ByteBuf x$4) {
        l$1.elem += x$4.readableBytes();
    }

    public ResponseBuilder(Request request, Map<String, MessageDigest> digests, boolean storeBodyParts, boolean inferHtmlResources, Charset defaultCharset) {
        this.request = request;
        this.digests = digests;
        this.storeBodyParts = storeBodyParts;
        this.inferHtmlResources = inferHtmlResources;
        this.defaultCharset = defaultCharset;
        this.status = None$.MODULE$;
        this.wireRequestHeaders = EmptyHttpHeaders.INSTANCE;
        this.headers = EmptyHttpHeaders.INSTANCE;
        this.chunks = Nil$.MODULE$;
    }
}

