/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.request.builder;

import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.Validation$;
import io.gatling.commons.validation.package;
import io.gatling.core.body.Body;
import io.gatling.core.body.ByteArrayBody;
import io.gatling.core.body.ElBody;
import io.gatling.core.body.InputStreamBody;
import io.gatling.core.body.PebbleBody;
import io.gatling.core.body.RawFileBody;
import io.gatling.core.body.ResourceAndCachedBytes;
import io.gatling.core.body.StringBody;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.util.Resource;
import io.gatling.http.HeaderNames$;
import io.gatling.http.cache.ContentCacheEntry;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.gatling.http.client.body.file.FileRequestBodyBuilder;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBodyBuilder;
import io.gatling.http.client.body.is.InputStreamRequestBodyBuilder;
import io.gatling.http.client.body.multipart.MultipartFormDataRequestBodyBuilder;
import io.gatling.http.client.body.multipart.StringPart;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.gatling.http.client.body.stringchunks.StringChunksRequestBodyBuilder;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.protocol.Remote$;
import io.gatling.http.request.BodyPart;
import io.gatling.http.request.builder.CommonAttributes;
import io.gatling.http.request.builder.HttpAttributes;
import io.gatling.http.request.builder.RequestExpressionBuilder;
import io.gatling.http.request.builder.RequestExpressionBuilder$;
import io.gatling.http.request.builder.package$;
import io.gatling.http.request.builder.package$HttpParams$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ec\u0001\u0002\t\u0012\u0001qA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\tK\u0001\u0011\t\u0011)A\u0005M!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0011!9\u0004A!A!\u0002\u0013A\u0004\"\u0002!\u0001\t\u0003\t\u0005\"\u0002%\u0001\t\u0013I\u0005\"B;\u0001\t\u00131\b\"CA\u0001\u0001\t\u0007I\u0011BA\u0002\u0011!\t\u0019\u0002\u0001Q\u0001\n\u0005\u0015\u0001\"CA\u000b\u0001\t\u0007I\u0011BA\u0002\u0011!\t9\u0002\u0001Q\u0001\n\u0005\u0015\u0001bBA\r\u0001\u0011E\u00131\u0004\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\t\t\u0004\u0001C!\u0003g\u0011A\u0004\u0013;uaJ+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'O\u0003\u0002\u0013'\u00059!-^5mI\u0016\u0014(B\u0001\u000b\u0016\u0003\u001d\u0011X-];fgRT!AF\f\u0002\t!$H\u000f\u001d\u0006\u00031e\tqaZ1uY&twMC\u0001\u001b\u0003\tIwn\u0001\u0001\u0014\u0005\u0001i\u0002C\u0001\u0010 \u001b\u0005\t\u0012B\u0001\u0011\u0012\u0005a\u0011V-];fgR,\u0005\u0010\u001d:fgNLwN\u001c\"vS2$WM]\u0001\u0011G>lWn\u001c8BiR\u0014\u0018NY;uKN\u0004\"AH\u0012\n\u0005\u0011\n\"\u0001E\"p[6|g.\u0011;ue&\u0014W\u000f^3t\u00039AG\u000f\u001e9BiR\u0014\u0018NY;uKN\u0004\"AH\u0014\n\u0005!\n\"A\u0004%uiB\fE\u000f\u001e:jEV$Xm]\u0001\u000bQR$\boQ1dQ\u0016\u001c\bCA\u0016/\u001b\u0005a#BA\u0017\u0016\u0003\u0015\u0019\u0017m\u00195f\u0013\tyCF\u0001\u0006IiR\u00048)Y2iKN\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\"AM\u001b\u000e\u0003MR!\u0001N\u000b\u0002\u0011A\u0014x\u000e^8d_2L!AN\u001a\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tId(D\u0001;\u0015\tYD(\u0001\u0004d_:4\u0017n\u001a\u0006\u0003{]\tAaY8sK&\u0011qH\u000f\u0002\u0015\u000f\u0006$H.\u001b8h\u0007>tg-[4ve\u0006$\u0018n\u001c8\u0002\rqJg.\u001b;?)\u0019\u00115\tR#G\u000fB\u0011a\u0004\u0001\u0005\u0006C\u0019\u0001\rA\t\u0005\u0006K\u0019\u0001\rA\n\u0005\u0006S\u0019\u0001\rA\u000b\u0005\u0006a\u0019\u0001\r!\r\u0005\u0006o\u0019\u0001\r\u0001O\u0001\u0013G>tg-[4ve\u0016\u0014u\u000eZ=QCJ$8\u000f\u0006\u0003K1~\u000b\u0007cA&Q%6\tAJ\u0003\u0002N\u001d\u0006Qa/\u00197jI\u0006$\u0018n\u001c8\u000b\u0005=;\u0012aB2p[6|gn]\u0005\u0003#2\u0013!BV1mS\u0012\fG/[8o!\t\u0019f+D\u0001U\u0015\t)V#\u0001\u0004dY&,g\u000e^\u0005\u0003/R\u0013aBU3rk\u0016\u001cHOQ;jY\u0012,'\u000fC\u0003Z\u000f\u0001\u0007!,A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005mkV\"\u0001/\u000b\u0005ec\u0014B\u00010]\u0005\u001d\u0019Vm]:j_:DQ\u0001Y\u0004A\u0002I\u000baB]3rk\u0016\u001cHOQ;jY\u0012,'\u000fC\u0003c\u000f\u0001\u00071-A\u0005c_\u0012L\b+\u0019:ugB\u0019AM\\9\u000f\u0005\u0015\\gB\u00014j\u001b\u00059'B\u00015\u001c\u0003\u0019a$o\\8u}%\t!.A\u0003tG\u0006d\u0017-\u0003\u0002m[\u00069\u0001/Y2lC\u001e,'\"\u00016\n\u0005=\u0004(\u0001\u0002'jgRT!\u0001\\7\u0011\u0005I\u001cX\"A\n\n\u0005Q\u001c\"\u0001\u0003\"pIf\u0004\u0016M\u001d;\u0002\u000fM,GOQ8esR!!j\u001e=z\u0011\u0015I\u0006\u00021\u0001[\u0011\u0015\u0001\u0007\u00021\u0001S\u0011\u0015Q\b\u00021\u0001|\u0003\u0011\u0011w\u000eZ=\u0011\u0005qtX\"A?\u000b\u0005id\u0014BA@~\u0005\u0011\u0011u\u000eZ=\u0002\u001b\r|gNZ5hkJ,'i\u001c3z+\t\t)\u0001\u0005\u0003\u0002\b\u00055ab\u0001\u0010\u0002\n%\u0019\u00111B\t\u00021I+\u0017/^3ti\u0016C\bO]3tg&|gNQ;jY\u0012,'/\u0003\u0003\u0002\u0010\u0005E!a\u0006*fcV,7\u000f\u001e\"vS2$WM]\"p]\u001aLw-\u001e:f\u0015\r\tY!E\u0001\u000fG>tg-[4ve\u0016\u0014u\u000eZ=!\u0003]\u0019wN\u001c4jOV\u0014X\r\u0015:j_J\\en\\<mK\u0012<W-\u0001\rd_:4\u0017nZ;sKB\u0013\u0018n\u001c:L]><H.\u001a3hK\u0002\nqcY8oM&<WO]3SKF,Xm\u001d;Ck&dG-\u001a:\u0015\u000b)\u000bi\"a\b\t\u000bek\u0001\u0019\u0001.\t\u000b\u0001l\u0001\u0019\u0001*\u0002/\r|gNZ5hkJ,7)Y2iS:<\u0007*Z1eKJ\u001cH\u0003BA\u0013\u0003_!B!a\n\u0002.A\u00191+!\u000b\n\u0007\u0005-BKA\u0004SKF,Xm\u001d;\t\rQq\u0001\u0019AA\u0014\u0011\u0015If\u00021\u0001[\u0003\u0015\u0011W/\u001b7e+\t\t)\u0004\u0005\u0004\u00028\u0005-\u0013q\u0005\b\u0005\u0003s\tIE\u0004\u0003\u0002<\u0005\u001dc\u0002BA\u001f\u0003\u000brA!a\u0010\u0002D9\u0019a-!\u0011\n\u0003iI!\u0001G\r\n\u0005u:\u0012BA-=\u0013\taG,\u0003\u0003\u0002N\u0005=#AC#yaJ,7o]5p]*\u0011A\u000e\u0018")
public class HttpRequestExpressionBuilder
extends RequestExpressionBuilder {
    private final HttpAttributes httpAttributes;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody;
    private final Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge;

    private Validation<RequestBuilder> configureBodyParts(Session session, RequestBuilder requestBuilder, List<BodyPart> bodyParts) {
        return package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams(this.httpAttributes.formParams()), this.httpAttributes.form(), session).map((Function1 & Serializable & scala.Serializable)params -> {
            Buffer stringParts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(params).asScala()).map((Function1 & Serializable & scala.Serializable)param -> new StringPart(param.getName(), param.getValue(), this.charset(), null, null, null, null, null), Buffer$.MODULE$.canBuildFrom());
            return new Tuple2(params, (Object)stringParts);
        }).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Buffer stringParts = (Buffer)tuple2._2();
            Validation validation = Validation$.MODULE$.sequence((Seq)bodyParts.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toMultiPart(session), List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)parts -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new MultipartFormDataRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)stringParts.$plus$plus((GenTraversableOnce)parts, Buffer$.MODULE$.canBuildFrom())).asJava())));
            return validation;
        });
    }

    private Validation<RequestBuilder> setBody(Session session, RequestBuilder requestBuilder, Body body) {
        Validation validation;
        Body body2 = body;
        if (body2 instanceof StringBody) {
            StringBody stringBody = (StringBody)body2;
            Function1 string = stringBody.string();
            validation = ((Validation)string.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else if (body2 instanceof RawFileBody) {
            RawFileBody rawFileBody = (RawFileBody)body2;
            Function1 resourceWithCachedBytes = rawFileBody.resourceAndCachedBytes();
            validation = ((Validation)resourceWithCachedBytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                FileRequestBodyBuilder fileRequestBodyBuilder;
                ResourceAndCachedBytes resourceAndCachedBytes = x0$1;
                if (resourceAndCachedBytes != null) {
                    Resource resource = resourceAndCachedBytes.resource();
                    Option cachedBytes = resourceAndCachedBytes.cachedBytes();
                    Option option = cachedBytes;
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        byte[] bytes = (byte[])some.value();
                        fileRequestBodyBuilder = new ByteArrayRequestBodyBuilder(bytes);
                    } else {
                        fileRequestBodyBuilder = new FileRequestBodyBuilder(resource.file());
                    }
                } else {
                    throw new MatchError((Object)resourceAndCachedBytes);
                }
                FileRequestBodyBuilder requestBodyBuilder = fileRequestBodyBuilder;
                RequestBuilder requestBuilder = requestBuilder.setBodyBuilder((RequestBodyBuilder)requestBodyBuilder);
                return requestBuilder;
            });
        } else if (body2 instanceof ByteArrayBody) {
            ByteArrayBody byteArrayBody = (ByteArrayBody)body2;
            Function1 bytes = byteArrayBody.bytes();
            validation = ((Validation)bytes.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)b -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new ByteArrayRequestBodyBuilder(b)));
        } else if (body2 instanceof ElBody) {
            ElBody elBody = (ElBody)body2;
            validation = ((Validation)elBody.asStringWithCachedBytes().apply((Object)session)).map((Function1 & Serializable & scala.Serializable)chunks -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringChunksRequestBodyBuilder((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(chunks).asJava())));
        } else if (body2 instanceof InputStreamBody) {
            InputStreamBody inputStreamBody = (InputStreamBody)body2;
            Function1 is2 = inputStreamBody.is();
            validation = ((Validation)is2.apply((Object)session)).map((Function1 & Serializable & scala.Serializable)is -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new InputStreamRequestBodyBuilder(is)));
        } else if (body2 instanceof PebbleBody) {
            PebbleBody pebbleBody = (PebbleBody)body2;
            validation = pebbleBody.apply(session).map((Function1 & Serializable & scala.Serializable)s -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new StringRequestBodyBuilder(s)));
        } else {
            throw new MatchError((Object)body2);
        }
        return validation;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configureBody() {
        return this.configureBody;
    }

    private Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> configurePriorKnowledge() {
        return this.configurePriorKnowledge;
    }

    @Override
    public Validation<RequestBuilder> configureRequestBuilder(Session session, RequestBuilder requestBuilder) {
        return super.configureRequestBuilder(session, requestBuilder).flatMap((Function1)this.configureBody().apply((Object)session)).flatMap((Function1)this.configurePriorKnowledge().apply((Object)session));
    }

    private Request configureCachingHeaders(Session session, Request request) {
        this.httpCaches.contentCacheEntry(session, request).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HttpRequestExpressionBuilder.$anonfun$configureCachingHeaders$1(request, x0$1);
            return BoxedUnit.UNIT;
        });
        return request;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Function1<Session, Validation<Request>> build() {
        void var1_1;
        Function1<Session, Validation<Request>> exp = super.build();
        return this.httpProtocol.requestPart().cache() ? session -> ((Validation)exp.apply(session)).map((Function1 & Serializable & scala.Serializable)request -> this.configureCachingHeaders((Session)session, (Request)request)) : var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$configurePriorKnowledge$3(boolean x$3) {
        return x$3;
    }

    public static final /* synthetic */ void $anonfun$configureCachingHeaders$1(Request request$1, ContentCacheEntry x0$1) {
        ContentCacheEntry contentCacheEntry = x0$1;
        if (contentCacheEntry == null) {
            throw new MatchError((Object)contentCacheEntry);
        }
        Option<String> etag = contentCacheEntry.etag();
        Option<String> lastModified = contentCacheEntry.lastModified();
        etag.foreach((Function1 & Serializable & scala.Serializable)x$4 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfNoneMatch(), x$4));
        lastModified.foreach((Function1 & Serializable & scala.Serializable)x$5 -> request$1.getHeaders().set(HeaderNames$.MODULE$.IfModifiedSince(), x$5));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public HttpRequestExpressionBuilder(CommonAttributes commonAttributes, HttpAttributes httpAttributes, HttpCaches httpCaches, HttpProtocol httpProtocol, GatlingConfiguration configuration) {
        Function1<Session, Function1<RequestBuilder, Validation<RequestBuilder>>> function1;
        this.httpAttributes = httpAttributes;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        super(commonAttributes, httpCaches, httpProtocol, configuration);
        Predef$.MODULE$.require(httpAttributes.body().isEmpty() || httpAttributes.bodyParts().isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Can't have both a body and body parts!");
        Option<Body> option = httpAttributes.body();
        if (option instanceof Some) {
            Some some = (Some)option;
            Body body = (Body)some.value();
            function1 = session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.setBody((Session)session, (RequestBuilder)requestBuilder, body);
        } else {
            function1 = httpAttributes.bodyParts().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> this.configureBodyParts((Session)session, (RequestBuilder)requestBuilder, $this.httpAttributes.bodyParts()) : (httpAttributes.formParams().nonEmpty() || httpAttributes.form().nonEmpty() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> package$HttpParams$.MODULE$.mergeWithFormIntoParamJList$extension(package$.MODULE$.HttpParams($this.httpAttributes.formParams()), $this.httpAttributes.form(), (Session)session).map((Function1 & Serializable & scala.Serializable)resolvedFormParams -> requestBuilder.setBodyBuilder((RequestBodyBuilder)new FormUrlEncodedRequestBodyBuilder(resolvedFormParams))) : RequestExpressionBuilder$.MODULE$.ConfigureIdentity());
        }
        this.configureBody = function1;
        this.configurePriorKnowledge = httpProtocol.enginePart().enableHttp2() ? session -> (Function1 & Serializable & scala.Serializable)requestBuilder -> {
            Option<Object> http2PriorKnowledge = $this.httpCaches.isHttp2PriorKnowledge((Session)session, Remote$.MODULE$.apply(requestBuilder.getUri()));
            return package.SuccessWrapper$.MODULE$.success$extension(io.gatling.commons.validation.package$.MODULE$.SuccessWrapper((Object)requestBuilder.setHttp2Enabled(true).setAlpnRequired(http2PriorKnowledge.forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)HttpRequestExpressionBuilder.$anonfun$configurePriorKnowledge$3(BoxesRunTime.unboxToBoolean((Object)x$3))))).setHttp2PriorKnowledge(http2PriorKnowledge.contains((Object)BoxesRunTime.boxToBoolean((boolean)true)))));
        } : RequestExpressionBuilder$.MODULE$.ConfigureIdentity();
    }
}

