/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.Session;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.Request;
import io.gatling.http.client.resolver.InetAddressNameResolverWrapper;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.http.engine.HttpEngine$;
import io.gatling.http.protocol.HttpComponents;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.request.builder.Http;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.request.builder.RequestBuilder;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.ssl.SslContext;
import io.netty.resolver.NameResolver;
import io.netty.resolver.dns.DnsNameResolverBuilder;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.resolver.dns.SequentialDnsServerAddressStreamProvider;
import java.io.Serializable;
import java.net.InetSocketAddress;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.Iterable;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005uw!\u0002\n\u0014\u0011\u0003ab!\u0002\u0010\u0014\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003\"\u0002\u0015\u0002\t\u0003Ic\u0001\u0002\u0010\u0014\u0001-B\u0001\"\u0013\u0003\u0003\u0002\u0003\u0006IA\u0013\u0005\t\u001f\u0012\u0011\t\u0011)A\u0005!\"Aa\u000b\u0002B\u0001B\u0003%q\u000b\u0003\u0005`\t\t\u0005\t\u0015!\u0003a\u0011\u00151C\u0001\"\u0001g\u0011\u0019YG\u0001)Q\u0005Y\")q\u000e\u0002C\u0001a\")A\u0010\u0002C\u0001{\"9\u0011\u0011\t\u0003\u0005\u0002\u0005\r\u0003bBA;\t\u0011\u0005\u0011q\u000f\u0005\b\u0003;#A\u0011AAP\u0011\u001d\t)\r\u0002C\u0001\u0003\u000fDq!!4\u0005\t\u0003\ny-\u0001\u0006IiR\u0004XI\\4j]\u0016T!\u0001F\u000b\u0002\r\u0015tw-\u001b8f\u0015\t1r#\u0001\u0003iiR\u0004(B\u0001\r\u001a\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AG\u0001\u0003S>\u001c\u0001\u0001\u0005\u0002\u001e\u00035\t1C\u0001\u0006IiR\u0004XI\\4j]\u0016\u001c\"!\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\tA$A\u0003baBd\u0017\u0010F\u0002+\u0003#\u0004\"!\b\u0003\u0014\u000b\u0011aCgN \u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001\u00027b]\u001eT\u0011!M\u0001\u0005U\u00064\u0018-\u0003\u00024]\t1qJ\u00196fGR\u0004\"!L\u001b\n\u0005Yr#!D!vi>\u001cEn\\:fC\ndW\r\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!Q\u000f^5m\u0015\tat#\u0001\u0003d_J,\u0017B\u0001 :\u0005\u001dq\u0015-\\3HK:\u0004\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u0011+\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0019\u000b1aY8n\u0013\tA\u0015IA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0013gNd7i\u001c8uKb$8OR1di>\u0014\u0018\u0010\u0005\u0002L\u001b6\tAJ\u0003\u0002;+%\u0011a\n\u0014\u0002\u0013'Nd7i\u001c8uKb$8OR1di>\u0014\u00180\u0001\u0006iiR\u00048\t\\5f]R\u0004\"!\u0015+\u000e\u0003IS!aU\u000b\u0002\r\rd\u0017.\u001a8u\u0013\t)&K\u0001\u0006IiR\u00048\t\\5f]R\fa\"\u001a<f]Rdun\u001c9He>,\b\u000f\u0005\u0002Y;6\t\u0011L\u0003\u0002[7\u000691\r[1o]\u0016d'B\u0001/\u001a\u0003\u0015qW\r\u001e;z\u0013\tq\u0016L\u0001\bFm\u0016tG\u000fT8pa\u001e\u0013x.\u001e9\u0002\u001b\r|gNZ5hkJ\fG/[8o!\t\tG-D\u0001c\u0015\t\u00197(\u0001\u0004d_:4\u0017nZ\u0005\u0003K\n\u0014AcR1uY&twmQ8oM&<WO]1uS>tG#\u0002\u0016hQ&T\u0007\"B%\n\u0001\u0004Q\u0005\"B(\n\u0001\u0004\u0001\u0006\"\u0002,\n\u0001\u00049\u0006\"B0\n\u0001\u0004\u0001\u0017\u0001C<be6,G-\u00169\u0011\u0005\u0005j\u0017B\u00018#\u0005\u001d\u0011un\u001c7fC:\faa^1s[V\u0003HCA9u!\t\t#/\u0003\u0002tE\t!QK\\5u\u0011\u0015)8\u00021\u0001w\u00039AG\u000f\u001e9D_6\u0004xN\\3oiN\u0004\"a\u001e>\u000e\u0003aT!!_\u000b\u0002\u0011A\u0014x\u000e^8d_2L!a\u001f=\u0003\u001d!#H\u000f]\"p[B|g.\u001a8ug\u0006qQ\r_3dkR,'+Z9vKN$HCD9\u007f\u0003\u000f\t\t\"!\u0006\u0002 \u0005%\u0012Q\b\u0005\u0007\u007f2\u0001\r!!\u0001\u0002\u001b\rd\u0017.\u001a8u%\u0016\fX/Z:u!\r\t\u00161A\u0005\u0004\u0003\u000b\u0011&a\u0002*fcV,7\u000f\u001e\u0005\b\u0003\u0013a\u0001\u0019AA\u0006\u0003!\u0019G.[3oi&#\u0007cA\u0011\u0002\u000e%\u0019\u0011q\u0002\u0012\u0003\t1{gn\u001a\u0005\u0007\u0003'a\u0001\u0019\u00017\u0002\rMD\u0017M]3e\u0011\u001d\t9\u0002\u0004a\u0001\u00033\t\u0011\"\u001a<f]Rdun\u001c9\u0011\u0007a\u000bY\"C\u0002\u0002\u001ee\u0013\u0011\"\u0012<f]Rdun\u001c9\t\u000f\u0005\u0005B\u00021\u0001\u0002$\u0005AA.[:uK:,'\u000fE\u0002R\u0003KI1!a\nS\u00051AE\u000f\u001e9MSN$XM\\3s\u0011\u001d\tY\u0003\u0004a\u0001\u0003[\t!b]:m\u0007>tG/\u001a=u!\u0011\ty#!\u000f\u000e\u0005\u0005E\"\u0002BA\u001a\u0003k\t1a]:m\u0015\r\t9dW\u0001\bQ\u0006tG\r\\3s\u0013\u0011\tY$!\r\u0003\u0015M\u001bHnQ8oi\u0016DH\u000fC\u0004\u0002@1\u0001\r!!\f\u0002\u001d\u0005d\u0007O\\*tY\u000e{g\u000e^3yi\u0006!R\r_3dkR,\u0007\n\u001e;qeI+\u0017/^3tiN$R\"]A#\u0003W\ni'a\u001c\u0002r\u0005M\u0004bBA$\u001b\u0001\u0007\u0011\u0011J\u0001\u0015e\u0016\fX/Z:ug\u0006sG\rT5ti\u0016tWM]:\u0011\r\u0005-\u00131LA1\u001d\u0011\ti%a\u0016\u000f\t\u0005=\u0013QK\u0007\u0003\u0003#R1!a\u0015\u001c\u0003\u0019a$o\\8u}%\t1%C\u0002\u0002Z\t\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002^\u0005}#\u0001C%uKJ\f'\r\\3\u000b\u0007\u0005e#\u0005\u0005\u0005\u0002d\u0005\u001d\u0014\u0011AA\u0012\u001b\t\t)G\u0003\u0002;%&!\u0011\u0011NA3\u0005\u0011\u0001\u0016-\u001b:\t\u000f\u0005%Q\u00021\u0001\u0002\f!1\u00111C\u0007A\u00021Dq!a\u0006\u000e\u0001\u0004\tI\u0002C\u0004\u0002,5\u0001\r!!\f\t\u000f\u0005}R\u00021\u0001\u0002.\u00059b.Z<Bgft7\r\u00128t\u001d\u0006lWMU3t_24XM\u001d\u000b\u0007\u0003s\n))a\"\u0011\t\u0005m\u0014\u0011Q\u0007\u0003\u0003{R1!a S\u0003!\u0011Xm]8mm\u0016\u0014\u0018\u0002BAB\u0003{\u0012a$\u00138fi\u0006#GM]3tg:\u000bW.\u001a*fg>dg/\u001a:Xe\u0006\u0004\b/\u001a:\t\u000f\u0005]a\u00021\u0001\u0002\u001a!9\u0011\u0011\u0012\bA\u0002\u0005-\u0015A\u00033ogN+'O^3sgB)\u0011%!$\u0002\u0012&\u0019\u0011q\u0012\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&1\u0003\rqW\r^\u0005\u0005\u00037\u000b)JA\tJ]\u0016$8k\\2lKR\fE\r\u001a:fgN\faB\\3x'Nd7i\u001c8uKb$8\u000f\u0006\u0004\u0002\"\u0006\u001d\u00161\u0016\t\u0004\u0017\u0006\r\u0016bAAS\u0019\nY1k\u001d7D_:$X\r\u001f;t\u0011\u0019\tIk\u0004a\u0001Y\u0006a\u0001\u000e\u001e;qe\u0015s\u0017M\u00197fI\"9\u0011QV\bA\u0002\u0005=\u0016\u0001\u00079feV\u001bXM]&fs6\u000bg.Y4fe\u001a\u000b7\r^8ssB)\u0011%!-\u00026&\u0019\u00111\u0017\u0012\u0003\r=\u0003H/[8o!\u0011\t9,!1\u000e\u0005\u0005e&\u0002BA\u001a\u0003wSA!a&\u0002>*\u0011\u0011qX\u0001\u0006U\u00064\u0018\r_\u0005\u0005\u0003\u0007\fILA\tLKfl\u0015M\\1hKJ4\u0015m\u0019;pef\fQC\u001a7vg\"\u001cE.[3oi&#7\t[1o]\u0016d7\u000fF\u0003r\u0003\u0013\fY\rC\u0004\u0002\nA\u0001\r!a\u0003\t\u000f\u0005]\u0001\u00031\u0001\u0002\u001a\u0005)1\r\\8tKR\t\u0011\u000fC\u0004\u0002T\u000e\u0001\r!!6\u0002\u001d\r|'/Z\"p[B|g.\u001a8ugB!\u0011q[Am\u001b\u0005Y\u0014bAAnw\tq1i\u001c:f\u0007>l\u0007o\u001c8f]R\u001c\b")
public class HttpEngine
implements AutoCloseable,
NameGen,
StrictLogging {
    private final SslContextsFactory sslContextsFactory;
    private final HttpClient httpClient;
    private final EventLoopGroup eventLoopGroup;
    private final GatlingConfiguration configuration;
    private boolean warmedUp;
    private final Logger logger;

    public static HttpEngine apply(CoreComponents coreComponents) {
        return HttpEngine$.MODULE$.apply(coreComponents);
    }

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void warmUp(HttpComponents httpComponents) {
        block21: {
            BoxedUnit boxedUnit;
            HttpRequestDef httpRequestDef;
            BoxedUnit boxedUnit2;
            if (this.warmedUp) break block21;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Start warm up");
                boxedUnit2 = BoxedUnit.UNIT;
            } else {
                boxedUnit2 = BoxedUnit.UNIT;
            }
            this.warmedUp = true;
            Option<String> option = httpComponents.httpProtocol().warmUpUrl();
            if (option instanceof Some) {
                BoxedUnit boxedUnit3;
                block20: {
                    Some some = (Some)option;
                    String url = (String)some.value();
                    io.gatling.http.client.RequestBuilder requestBuilder = new io.gatling.http.client.RequestBuilder(HttpMethod.GET, Uri.create((String)url)).setHeaders(new DefaultHttpHeaders().add(HeaderNames$.MODULE$.Accept(), (Object)"text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8").add(HeaderNames$.MODULE$.AcceptLanguage(), (Object)"en-US,en;q=0.5").add(HeaderNames$.MODULE$.AcceptEncoding(), (Object)"gzip").add(HeaderNames$.MODULE$.Connection(), (Object)HeaderValues$.MODULE$.Close()).add(HeaderNames$.MODULE$.UserAgent(), (Object)"Mozilla/5.0 (Macintosh; Intel Mac OS X 10.8; rv:16.0) Gecko/20100101 Firefox/16.0")).setRequestTimeout(1000L).setDefaultCharset(this.configuration.core().charset());
                    httpComponents.httpProtocol().proxyPart().proxy().foreach((Function1 & Serializable & scala.Serializable)x$1 -> requestBuilder.setProxyServer(x$1));
                    EventLoop eventLoop = this.eventLoopGroup.next();
                    try {
                        try {
                            Promise p = Promise$.MODULE$.apply();
                            this.httpClient.sendRequest(requestBuilder.build(), 0L, eventLoop, new HttpListener(null, p){
                                private final Promise p$1;

                                public void onSend(HttpHeaders x$1) {
                                    super.onSend(x$1);
                                }

                                public void onProtocolAwareness(boolean x$1) {
                                    super.onProtocolAwareness(x$1);
                                }

                                public void onWrite(Channel x$1) {
                                    super.onWrite(x$1);
                                }

                                public void onHttpResponse(HttpResponseStatus httpResponseStatus, HttpHeaders httpHeaders) {
                                }

                                public void onThrowable(Throwable throwable) {
                                    this.p$1.failure(throwable);
                                }

                                public void onHttpResponseBodyChunk(ByteBuf byteBuf, boolean last) {
                                    block0: {
                                        if (!last) break block0;
                                        this.p$1.success((Object)BoxedUnit.UNIT);
                                    }
                                }
                                {
                                    this.p$1 = p$1;
                                }
                            }, null, null);
                            Await$.MODULE$.result((Awaitable)p.future(), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(2)).seconds());
                            if (this.logger().underlying().isDebugEnabled()) {
                                this.logger().underlying().debug("Warm up request {} successful", new Object[]{url});
                                boxedUnit3 = BoxedUnit.UNIT;
                                break block20;
                            }
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        catch (Throwable throwable) {
                            BoxedUnit boxedUnit4;
                            Throwable throwable2 = throwable;
                            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                            if (!option2.isEmpty()) {
                                Throwable e = (Throwable)option2.get();
                                if (this.logger().underlying().isDebugEnabled()) {
                                    if (this.logger().underlying().isDebugEnabled()) {
                                        this.logger().underlying().debug(new StringBuilder(33).append("Couldn't execute warm up request ").append(url).toString(), e);
                                        boxedUnit4 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit4 = BoxedUnit.UNIT;
                                    }
                                } else if (this.logger().underlying().isInfoEnabled()) {
                                    this.logger().underlying().info("Couldn't execute warm up request {}: {}", (Object[])new String[]{url, Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(e))});
                                    boxedUnit4 = BoxedUnit.UNIT;
                                } else {
                                    boxedUnit4 = BoxedUnit.UNIT;
                                }
                            } else {
                                throw throwable;
                            }
                            BoxedUnit boxedUnit5 = boxedUnit4;
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                    }
                    finally {
                        this.httpClient.flushClientIdChannels(0L, eventLoop);
                    }
                }
                httpRequestDef = boxedUnit3;
            } else {
                Function1 expression = package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)"foo"));
                ((HttpRequestBuilder)((RequestBuilder)new Http((Function1<Session, Validation<String>>)expression).get((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).queryParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression)).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
                httpRequestDef = ((HttpRequestBuilder)new Http((Function1<Session, Validation<String>>)expression).post((Function1<Session, Validation<String>>)expression).header("bar", (Function1<Session, Validation<String>>)expression)).formParam((Function1<Session, Validation<String>>)expression, (Function1<Session, Validation<Object>>)expression).build(httpComponents.httpCaches(), httpComponents.httpProtocol(), false, this.configuration);
            }
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Warm up done");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public void executeRequest(Request clientRequest, long clientId, boolean shared, EventLoop eventLoop, HttpListener listener, SslContext sslContext, SslContext alpnSslContext) {
        block0: {
            if (this.httpClient.isClosed()) break block0;
            this.httpClient.sendRequest(clientRequest, shared ? -1L : clientId, eventLoop, listener, sslContext, alpnSslContext);
        }
    }

    public void executeHttp2Requests(Iterable<Pair<Request, HttpListener>> requestsAndListeners, long clientId, boolean shared, EventLoop eventLoop, SslContext sslContext, SslContext alpnSslContext) {
        block0: {
            if (this.httpClient.isClosed()) break block0;
            this.httpClient.sendHttp2Requests((Pair[])requestsAndListeners.toArray(ClassTag$.MODULE$.apply(Pair.class)), shared ? -1L : clientId, eventLoop, sslContext, alpnSslContext);
        }
    }

    public InetAddressNameResolverWrapper newAsyncDnsNameResolver(EventLoop eventLoop, InetSocketAddress[] dnsServers) {
        return new InetAddressNameResolverWrapper((NameResolver)new DnsNameResolverBuilder(eventLoop).nameServerProvider((DnsServerAddressStreamProvider)(dnsServers.length == 0 ? DnsServerAddressStreamProviders.platformDefault() : new SequentialDnsServerAddressStreamProvider(dnsServers))).queryTimeoutMillis((long)((int)this.configuration.http().dns().queryTimeout().toMillis())).maxQueriesPerResolve(this.configuration.http().dns().maxQueriesPerResolve()).build());
    }

    public SslContexts newSslContexts(boolean http2Enabled, Option<KeyManagerFactory> perUserKeyManagerFactory) {
        return this.sslContextsFactory.newSslContexts(http2Enabled, perUserKeyManagerFactory);
    }

    public void flushClientIdChannels(long clientId, EventLoop eventLoop) {
        block0: {
            if (this.httpClient.isClosed()) break block0;
            this.httpClient.flushClientIdChannels(clientId, eventLoop);
        }
    }

    @Override
    public void close() {
        this.httpClient.close();
    }

    public HttpEngine(SslContextsFactory sslContextsFactory, HttpClient httpClient, EventLoopGroup eventLoopGroup, GatlingConfiguration configuration) {
        this.sslContextsFactory = sslContextsFactory;
        this.httpClient = httpClient;
        this.eventLoopGroup = eventLoopGroup;
        this.configuration = configuration;
        NameGen.$init$((NameGen)this);
        StrictLogging.$init$((StrictLogging)this);
        this.warmedUp = false;
    }
}

