/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.NextSseState$;
import io.gatling.http.action.sse.fsm.SetCheck;
import io.gatling.http.action.sse.fsm.SseClosingState;
import io.gatling.http.action.sse.fsm.SseCrashedState;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SsePerformingCheckState;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.check.sse.SseMessageCheck;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import java.io.Serializable;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\u0006\f\u0001aA\u0001\u0002\u0004\u0001\u0003\u0002\u0003\u0006Ia\n\u0005\tU\u0001\u0011\t\u0011)A\u0005W!A!\u0007\u0001B\u0001B\u0003%1\u0007C\u00037\u0001\u0011\u0005q\u0007C\u0003=\u0001\u0011\u0005S\bC\u0003k\u0001\u0011\u00053\u000eC\u0003u\u0001\u0011\u0005S\u000fC\u0003x\u0001\u0011\u0005\u0003\u0010\u0003\u0004\u0000\u0001\u0011\u0005\u0013\u0011\u0001\u0002\r'N,\u0017\n\u001a7f'R\fG/\u001a\u0006\u0003\u00195\t1AZ:n\u0015\tqq\"A\u0002tg\u0016T!\u0001E\t\u0002\r\u0005\u001cG/[8o\u0015\t\u00112#\u0001\u0003iiR\u0004(B\u0001\u000b\u0016\u0003\u001d9\u0017\r\u001e7j]\u001eT\u0011AF\u0001\u0003S>\u001c\u0001aE\u0002\u00013u\u0001\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003\u0011M\u001bXm\u0015;bi\u0016\u0004\"AH\u0013\u000e\u0003}Q!\u0001I\u0011\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\t\u001a\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0011\n1aY8n\u0013\t1sDA\u0007TiJL7\r\u001e'pO\u001eLgn\u001a\t\u00035!J!!K\u0006\u0003\rM\u001bXMR:n\u0003\u001d\u0019Xm]:j_:\u0004\"\u0001\f\u0019\u000e\u00035R!A\u000b\u0018\u000b\u0005=\u001a\u0012\u0001B2pe\u0016L!!M\u0017\u0003\u000fM+7o]5p]\u000611\u000f\u001e:fC6\u0004\"A\u0007\u001b\n\u0005UZ!!C*tKN#(/Z1n\u0003\u0019a\u0014N\\5u}Q!\u0001(\u000f\u001e<!\tQ\u0002\u0001C\u0003\r\t\u0001\u0007q\u0005C\u0003+\t\u0001\u00071\u0006C\u00033\t\u0001\u00071'\u0001\u0006p]N+Go\u00115fG.$RAP!QE\u000e\u0004\"AG \n\u0005\u0001[!\u0001\u0004(fqR\u001c6/Z*uCR,\u0007\"\u0002\"\u0006\u0001\u0004\u0019\u0015AC1di&|gNT1nKB\u0011A)\u0014\b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001S\f\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0015!B:dC2\f\u0017B\u0001'J\u0003\u0019\u0001&/\u001a3fM&\u0011aj\u0014\u0002\u0007'R\u0014\u0018N\\4\u000b\u00051K\u0005\"B)\u0006\u0001\u0004\u0011\u0016AD2iK\u000e\\7+Z9vK:\u001cWm\u001d\t\u0004'b[fB\u0001+W\u001d\t1U+C\u0001K\u0013\t9\u0016*A\u0004qC\u000e\\\u0017mZ3\n\u0005eS&\u0001\u0002'jgRT!aV%\u0011\u0005q\u0003W\"A/\u000b\u00059q&BA0\u0012\u0003\u0015\u0019\u0007.Z2l\u0013\t\tWLA\fTg\u0016lUm]:bO\u0016\u001c\u0005.Z2l'\u0016\fX/\u001a8dK\")!&\u0002a\u0001W!)A-\u0002a\u0001K\u0006!a.\u001a=u!\t1\u0007.D\u0001h\u0015\t\u0001b&\u0003\u0002jO\n1\u0011i\u0019;j_:\fQb\u001c8Tg\u0016\u0014VmY3jm\u0016$Gc\u0001 m]\")QN\u0002a\u0001\u0007\u00069Q.Z:tC\u001e,\u0007\"B8\u0007\u0001\u0004\u0001\u0018!\u0003;j[\u0016\u001cH/Y7q!\t\t(/D\u0001J\u0013\t\u0019\u0018J\u0001\u0003M_:<\u0017!E8o'N,7\u000b\u001e:fC6\u001cEn\\:fIR\u0011aH\u001e\u0005\u0006_\u001e\u0001\r\u0001]\u0001\u0013_:\u001c6/Z*ue\u0016\fWn\u0011:bg\",G\rF\u0002?szDQA\u001f\u0005A\u0002m\f\u0011\u0001\u001e\t\u0003'rL!! .\u0003\u0013QC'o\\<bE2,\u0007\"B8\t\u0001\u0004\u0001\u0018\u0001F8o\u00072LWM\u001c;DY>\u001cXMU3rk\u0016\u001cH\u000fF\u0004?\u0003\u0007\t)!a\u0002\t\u000b\tK\u0001\u0019A\"\t\u000b)J\u0001\u0019A\u0016\t\u000b\u0011L\u0001\u0019A3")
public class SseIdleState
extends SseState
implements StrictLogging {
    private final SseFsm fsm;
    private final Session session;
    private final SseStream stream;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public NextSseState onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Sent check {}", new Object[]{actionName});
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        long timestamp = this.fsm.clock().nowMillis();
        List<SseMessageCheckSequence> list = checkSequences;
        if (!(list instanceof .colon.colon)) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon2 = (.colon.colon)list;
        SseMessageCheckSequence sseMessageCheckSequence = (SseMessageCheckSequence)colon2.head();
        List remainingCheckSequences = colon2.tl$access$1();
        if (sseMessageCheckSequence == null) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        FiniteDuration timeout = sseMessageCheckSequence.timeout();
        List<SseMessageCheck> list2 = sseMessageCheckSequence.checks();
        if (!(list2 instanceof .colon.colon)) return new NextSseState(this, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> next.$bang(session));
        .colon.colon colon3 = (.colon.colon)list2;
        SseMessageCheck currentCheck = (SseMessageCheck)colon3.head();
        List remainingChecks = colon3.tl$access$1();
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Trigger check after send message");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.fsm.scheduleTimeout(timeout);
        return new NextSseState(new SsePerformingCheckState(this.fsm, this.stream, currentCheck, (List<SseMessageCheck>)remainingChecks, timestamp, (List<SseMessageCheckSequence>)remainingCheckSequences, session, (Either<Action, SetCheck>)package$.MODULE$.Left().apply((Object)next)), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseReceived(String message, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Received unmatched message={}", new Object[]{message});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.logUnmatchedServerMessage(this.session);
        return new NextSseState(this, NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamClosed(long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("SSE stream was forcefully closed by the server while in Idle state");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm, (Option<String>)None$.MODULE$), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onSseStreamCrashed(Throwable t, long timestamp) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("SSE stream crashed by the server while in Idle state", t);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return new NextSseState(new SseCrashedState(this.fsm, (Option<String>)new Some((Object)Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(t)))), NextSseState$.MODULE$.apply$default$2());
    }

    @Override
    public NextSseState onClientCloseRequest(String actionName, Session session, Action next) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Client requested SSE stream close");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.stream.close();
        return new NextSseState(new SseClosingState(this.fsm, actionName, session, next, this.fsm.clock().nowMillis()), NextSseState$.MODULE$.apply$default$2());
    }

    public SseIdleState(SseFsm fsm, Session session, SseStream stream) {
        this.fsm = fsm;
        this.session = session;
        this.stream = stream;
        super(fsm);
        StrictLogging.$init$((StrictLogging)this);
    }
}

