/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import io.gatling.commons.util.Clock;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.fsm.NextSseState;
import io.gatling.http.action.sse.fsm.SseInitState;
import io.gatling.http.action.sse.fsm.SseState;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.check.sse.SseMessageCheckSequence;
import io.gatling.http.client.Request;
import io.gatling.http.engine.HttpEngine;
import io.gatling.http.protocol.HttpProtocol;
import io.netty.channel.EventLoop;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001\u0002\u0013&\u0001IB\u0011\"\u000f\u0001\u0003\u0006\u0004%\t!\n\u001e\t\u0011\u0019\u0003!\u0011!Q\u0001\nmB\u0011b\u0012\u0001\u0003\u0006\u0004%\t!\n%\t\u0011=\u0003!\u0011!Q\u0001\n%C\u0011\u0002\u0015\u0001\u0003\u0006\u0004%\t!\n\u001e\t\u0011E\u0003!\u0011!Q\u0001\nmB\u0011B\u0015\u0001\u0003\u0006\u0004%\t!J*\t\u0011\u0011\u0004!\u0011!Q\u0001\nQC\u0011\"\u001a\u0001\u0003\u0006\u0004%\t!\n4\t\u0011=\u0004!\u0011!Q\u0001\n\u001dD\u0011\u0002\u001d\u0001\u0003\u0006\u0004%\t!J9\t\u0011a\u0004!\u0011!Q\u0001\nID\u0011\"\u001f\u0001\u0003\u0006\u0004%\t!\n>\t\u0013\u0005\r\u0001A!A!\u0002\u0013Y\bbCA\u0003\u0001\t\u0015\r\u0011\"\u0001&\u0003\u000fA!\"!\u0007\u0001\u0005\u0003\u0005\u000b\u0011BA\u0005\u0011-\tY\u0002\u0001BC\u0002\u0013\u0005Q%!\b\t\u0015\u0005=\u0002A!A!\u0002\u0013\ty\u0002C\u0004\u00022\u0001!\t!a\r\t\u0013\u0005-\u0003\u00011A\u0005\n\u00055\u0003\"CA+\u0001\u0001\u0007I\u0011BA,\u0011!\t\u0019\u0007\u0001Q!\n\u0005=\u0003bCA3\u0001\u0001\u0007\t\u0019!C\u0005\u0003OB1\"a\u001f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002~!Y\u0011\u0011\u0011\u0001A\u0002\u0003\u0005\u000b\u0015BA5\u0011!\t\u0019\t\u0001C\u0001K\u0005\u0015\u0005\u0002CAM\u0001\u0011\u0005Q%a'\t\u000f\u0005u\u0005\u0001\"\u0003\u0002 \"9\u0011\u0011\u0017\u0001\u0005\u0002\u0005M\u0006bBAi\u0001\u0011\u0005\u00111\u001b\u0005\b\u0003S\u0004A\u0011AAv\u0011\u001d\tY\u0010\u0001C\u0001\u0003{DqA!\u0002\u0001\t\u0003\u00119\u0001C\u0004\u0003\f\u0001!\tA!\u0004\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\t11k]3Gg6T!AJ\u0014\u0002\u0007\u0019\u001cXN\u0003\u0002)S\u0005\u00191o]3\u000b\u0005)Z\u0013AB1di&|gN\u0003\u0002-[\u0005!\u0001\u000e\u001e;q\u0015\tqs&A\u0004hCRd\u0017N\\4\u000b\u0003A\n!![8\u0004\u0001M\u0011\u0001a\r\t\u0003i]j\u0011!\u000e\u0006\u0002m\u0005)1oY1mC&\u0011\u0001(\u000e\u0002\u0007\u0003:L(+\u001a4\u0002\r]\u001ch*Y7f+\u0005Y\u0004C\u0001\u001fD\u001d\ti\u0014\t\u0005\u0002?k5\tqH\u0003\u0002Ac\u00051AH]8pizJ!AQ\u001b\u0002\rA\u0013X\rZ3g\u0013\t!UI\u0001\u0004TiJLgn\u001a\u0006\u0003\u0005V\nqa^:OC6,\u0007%\u0001\bd_:tWm\u0019;SKF,Xm\u001d;\u0016\u0003%\u0003\"AS'\u000e\u0003-S!\u0001T\u0016\u0002\r\rd\u0017.\u001a8u\u0013\tq5JA\u0004SKF,Xm\u001d;\u0002\u001f\r|gN\\3diJ+\u0017/^3ti\u0002\n\u0011cY8o]\u0016\u001cG/Q2uS>tg*Y7f\u0003I\u0019wN\u001c8fGR\f5\r^5p]:\u000bW.\u001a\u0011\u0002)\r|gN\\3di\u000eCWmY6TKF,XM\\2f+\u0005!\u0006cA+[;:\u0011a\u000b\u0017\b\u0003}]K\u0011AN\u0005\u00033V\nq\u0001]1dW\u0006<W-\u0003\u0002\\9\n!A*[:u\u0015\tIV\u0007\u0005\u0002_E6\tqL\u0003\u0002)A*\u0011\u0011mK\u0001\u0006G\",7m[\u0005\u0003G~\u0013qcU:f\u001b\u0016\u001c8/Y4f\u0007\",7m[*fcV,gnY3\u0002+\r|gN\\3di\u000eCWmY6TKF,XM\\2fA\u0005Y1\u000f^1ug\u0016sw-\u001b8f+\u00059\u0007C\u00015n\u001b\u0005I'B\u00016l\u0003\u0015\u0019H/\u0019;t\u0015\taW&\u0001\u0003d_J,\u0017B\u00018j\u0005-\u0019F/\u0019;t\u000b:<\u0017N\\3\u0002\u0019M$\u0018\r^:F]\u001eLg.\u001a\u0011\u0002\u0015!$H\u000f]#oO&tW-F\u0001s!\t\u0019h/D\u0001u\u0015\t)8&\u0001\u0004f]\u001eLg.Z\u0005\u0003oR\u0014!\u0002\u0013;ua\u0016sw-\u001b8f\u0003-AG\u000f\u001e9F]\u001eLg.\u001a\u0011\u0002\u0019!$H\u000f\u001d)s_R|7m\u001c7\u0016\u0003m\u0004\"\u0001`@\u000e\u0003uT!A`\u0016\u0002\u0011A\u0014x\u000e^8d_2L1!!\u0001~\u00051AE\u000f\u001e9Qe>$xnY8m\u00035AG\u000f\u001e9Qe>$xnY8mA\u0005IQM^3oi2{w\u000e]\u000b\u0003\u0003\u0013\u0001B!a\u0003\u0002\u00165\u0011\u0011Q\u0002\u0006\u0005\u0003\u001f\t\t\"A\u0004dQ\u0006tg.\u001a7\u000b\u0007\u0005Mq&A\u0003oKR$\u00180\u0003\u0003\u0002\u0018\u00055!!C#wK:$Hj\\8q\u0003))g/\u001a8u\u0019>|\u0007\u000fI\u0001\u0006G2|7m[\u000b\u0003\u0003?\u0001B!!\t\u0002,5\u0011\u00111\u0005\u0006\u0005\u0003K\t9#\u0001\u0003vi&d'bAA\u0015[\u000591m\\7n_:\u001c\u0018\u0002BA\u0017\u0003G\u0011Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u000b\u00026\u0005e\u00121HA\u001f\u0003\u007f\t\t%a\u0011\u0002F\u0005\u001d\u0013\u0011\n\t\u0004\u0003o\u0001Q\"A\u0013\t\u000be\u001a\u0002\u0019A\u001e\t\u000b\u001d\u001b\u0002\u0019A%\t\u000bA\u001b\u0002\u0019A\u001e\t\u000bI\u001b\u0002\u0019\u0001+\t\u000b\u0015\u001c\u0002\u0019A4\t\u000bA\u001c\u0002\u0019\u0001:\t\u000be\u001c\u0002\u0019A>\t\u000f\u0005\u00151\u00031\u0001\u0002\n!9\u00111D\nA\u0002\u0005}\u0011\u0001D2veJ,g\u000e^*uCR,WCAA(!\u0011\t9$!\u0015\n\u0007\u0005MSE\u0001\u0005Tg\u0016\u001cF/\u0019;f\u0003A\u0019WO\u001d:f]R\u001cF/\u0019;f?\u0012*\u0017\u000f\u0006\u0003\u0002Z\u0005}\u0003c\u0001\u001b\u0002\\%\u0019\u0011QL\u001b\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003C*\u0012\u0011!a\u0001\u0003\u001f\n1\u0001\u001f\u00132\u00035\u0019WO\u001d:f]R\u001cF/\u0019;fA\u0005q1-\u001e:sK:$H+[7f_V$XCAA5!\u0019\tY'a\u001e\u0002Z5\u0011\u0011Q\u000e\u0006\u0005\u0003_\n\t(\u0001\u0006d_:\u001cWO\u001d:f]RTA!!\n\u0002t)\u0011\u0011QO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002z\u00055$aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0002%\r,(O]3oiRKW.Z8vi~#S-\u001d\u000b\u0005\u00033\ny\bC\u0005\u0002ba\t\t\u00111\u0001\u0002j\u0005y1-\u001e:sK:$H+[7f_V$\b%A\btG\",G-\u001e7f)&lWm\\;u)\u0011\tI&a\"\t\u000f\u0005%%\u00041\u0001\u0002\f\u0006\u0019A-\u001e:\u0011\t\u00055\u0015QS\u0007\u0003\u0003\u001fSA!!%\u0002\u0014\u0006AA-\u001e:bi&|gNC\u0002\u0002pUJA!a&\u0002\u0010\nqa)\u001b8ji\u0016$UO]1uS>t\u0017!D2b]\u000e,G\u000eV5nK>,H\u000f\u0006\u0002\u0002Z\u00059Q\r_3dkR,G\u0003BA-\u0003CC\u0001\"a)\u001d\t\u0003\u0007\u0011QU\u0001\u0002MB)A'a*\u0002,&\u0019\u0011\u0011V\u001b\u0003\u0011q\u0012\u0017P\\1nKz\u0002B!a\u000e\u0002.&\u0019\u0011qV\u0013\u0003\u00199+\u0007\u0010^*tKN#\u0018\r^3\u0002/=t\u0007+\u001a:g_Jl\u0017J\\5uS\u0006d7i\u001c8oK\u000e$HCBA-\u0003k\u000b\u0019\rC\u0004\u00028v\u0001\r!!/\u0002\u000fM,7o]5p]B!\u00111XA`\u001b\t\tiLC\u0002\u00028.LA!!1\u0002>\n91+Z:tS>t\u0007bBAc;\u0001\u0007\u0011qY\u0001\u0013S:LG/[1m\u0007>tg.Z2u\u001d\u0016DH\u000f\u0005\u0003\u0002J\u00065WBAAf\u0015\tQ3.\u0003\u0003\u0002P\u0006-'AB!di&|g.\u0001\u000bp]N\u001bXm\u0015;sK\u0006l7i\u001c8oK\u000e$X\r\u001a\u000b\u0007\u00033\n).a8\t\u000f\u0005]g\u00041\u0001\u0002Z\u000611\u000f\u001e:fC6\u0004B!a\u000e\u0002\\&\u0019\u0011Q\\\u0013\u0003\u0013M\u001bXm\u0015;sK\u0006l\u0007bBAq=\u0001\u0007\u00111]\u0001\ni&lWm\u001d;b[B\u00042\u0001NAs\u0013\r\t9/\u000e\u0002\u0005\u0019>tw-\u0001\u0006p]N+Go\u00115fG.$\"\"!\u0017\u0002n\u0006E\u0018Q_A|\u0011\u0019\tyo\ba\u0001w\u0005Q\u0011m\u0019;j_:t\u0015-\\3\t\r\u0005Mx\u00041\u0001U\u00039\u0019\u0007.Z2l'\u0016\fX/\u001a8dKNDq!a. \u0001\u0004\tI\fC\u0004\u0002z~\u0001\r!a2\u0002\t9,\u0007\u0010^\u0001\u000e_:\u001c6/\u001a*fG\u0016Lg/\u001a3\u0015\r\u0005e\u0013q B\u0002\u0011\u0019\u0011\t\u0001\ta\u0001w\u00059Q.Z:tC\u001e,\u0007bBAqA\u0001\u0007\u00111]\u0001\u0012_:\u001c6/Z*ue\u0016\fWn\u00117pg\u0016$G\u0003BA-\u0005\u0013Aq!!9\"\u0001\u0004\t\u0019/\u0001\np]N\u001bXm\u0015;sK\u0006l7I]1tQ\u0016$GCBA-\u0005\u001f\u0011I\u0002C\u0004\u0003\u0012\t\u0002\rAa\u0005\u0002\u0003Q\u00042!\u0016B\u000b\u0013\r\u00119\u0002\u0018\u0002\n)\"\u0014xn^1cY\u0016Dq!!9#\u0001\u0004\t\u0019/\u0001\u000bp]\u000ec\u0017.\u001a8u\u00072|7/\u001a*fcV,7\u000f\u001e\u000b\t\u00033\u0012yB!\t\u0003$!1\u0011q^\u0012A\u0002mBq!a.$\u0001\u0004\tI\fC\u0004\u0002z\u000e\u0002\r!a2")
public class SseFsm {
    private final String wsName;
    private final Request connectRequest;
    private final String connectActionName;
    private final List<SseMessageCheckSequence> connectCheckSequence;
    private final StatsEngine statsEngine;
    private final HttpEngine httpEngine;
    private final HttpProtocol httpProtocol;
    private final EventLoop eventLoop;
    private final Clock clock;
    private SseState currentState;
    private ScheduledFuture<BoxedUnit> currentTimeout;

    public String wsName() {
        return this.wsName;
    }

    public Request connectRequest() {
        return this.connectRequest;
    }

    public String connectActionName() {
        return this.connectActionName;
    }

    public List<SseMessageCheckSequence> connectCheckSequence() {
        return this.connectCheckSequence;
    }

    public StatsEngine statsEngine() {
        return this.statsEngine;
    }

    public HttpEngine httpEngine() {
        return this.httpEngine;
    }

    public HttpProtocol httpProtocol() {
        return this.httpProtocol;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    public Clock clock() {
        return this.clock;
    }

    private SseState currentState() {
        return this.currentState;
    }

    private void currentState_$eq(SseState x$1) {
        this.currentState = x$1;
    }

    private ScheduledFuture<BoxedUnit> currentTimeout() {
        return this.currentTimeout;
    }

    private void currentTimeout_$eq(ScheduledFuture<BoxedUnit> x$1) {
        this.currentTimeout = x$1;
    }

    public void scheduleTimeout(FiniteDuration dur) {
        this.eventLoop().schedule(() -> {
            this.currentTimeout_$eq(null);
            return this.currentState().onTimeout();
        }, dur.toMillis(), TimeUnit.MILLISECONDS);
    }

    public void cancelTimeout() {
        block0: {
            if (this.currentTimeout() == null) break block0;
            this.currentTimeout().cancel(true);
            this.currentTimeout_$eq(null);
        }
    }

    private void execute(Function0<NextSseState> f) {
        NextSseState nextSseState = (NextSseState)f.apply();
        if (nextSseState == null) {
            throw new MatchError((Object)nextSseState);
        }
        SseState nextState = nextSseState.state();
        Function0<BoxedUnit> afterStateUpdate = nextSseState.afterStateUpdate();
        Tuple2 tuple2 = new Tuple2((Object)nextState, afterStateUpdate);
        Tuple2 tuple22 = tuple2;
        SseState nextState2 = (SseState)tuple22._1();
        Function0 afterStateUpdate2 = (Function0)tuple22._2();
        this.currentState_$eq(nextState2);
        afterStateUpdate2.apply$mcV$sp();
    }

    public void onPerformInitialConnect(Session session, Action initialConnectNext) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onPerformInitialConnect(session, initialConnectNext));
    }

    public void onSseStreamConnected(SseStream stream, long timestamp) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onSseStreamConnected(stream, timestamp));
    }

    public void onSetCheck(String actionName, List<SseMessageCheckSequence> checkSequences, Session session, Action next) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onSetCheck(actionName, checkSequences, session, next));
    }

    public void onSseReceived(String message, long timestamp) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onSseReceived(message, timestamp));
    }

    public void onSseStreamClosed(long timestamp) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onSseStreamClosed(timestamp));
    }

    public void onSseStreamCrashed(Throwable t, long timestamp) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onSseStreamCrashed(t, timestamp));
    }

    public void onClientCloseRequest(String actionName, Session session, Action next) {
        this.execute((Function0<NextSseState>)(Function0 & Serializable & scala.Serializable)() -> this.currentState().onClientCloseRequest(actionName, session, next));
    }

    public SseFsm(String wsName, Request connectRequest, String connectActionName, List<SseMessageCheckSequence> connectCheckSequence, StatsEngine statsEngine, HttpEngine httpEngine, HttpProtocol httpProtocol, EventLoop eventLoop, Clock clock) {
        this.wsName = wsName;
        this.connectRequest = connectRequest;
        this.connectActionName = connectActionName;
        this.connectCheckSequence = connectCheckSequence;
        this.statsEngine = statsEngine;
        this.httpEngine = httpEngine;
        this.httpProtocol = httpProtocol;
        this.eventLoop = eventLoop;
        this.clock = clock;
        this.currentState = new SseInitState(this);
    }
}

