/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.sse.Closed$;
import io.gatling.http.action.sse.Connected$;
import io.gatling.http.action.sse.Connecting$;
import io.gatling.http.action.sse.SseException;
import io.gatling.http.action.sse.SseState;
import io.gatling.http.action.sse.fsm.EventStreamDispatcher;
import io.gatling.http.action.sse.fsm.ServerSentEvent;
import io.gatling.http.action.sse.fsm.SseFsm;
import io.gatling.http.action.sse.fsm.SseStream;
import io.gatling.http.action.sse.fsm.SseStreamDecoder;
import io.gatling.http.client.HttpListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001B\r\u0001\u0003\u0002\u0003\u0006IA\u0011\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\r\"Aa\n\u0001B\u0001B\u0003%q\nC\u0003X\u0001\u0011\u0005\u0001\fC\u0004_\u0001\u0001\u0007I\u0011B0\t\u000f\r\u0004\u0001\u0019!C\u0005I\"1Q\u000e\u0001Q!\n\u0001DqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004t\u0001\u0001\u0006I\u0001\u001d\u0005\ni\u0002\u0001\r\u00111A\u0005\nUD\u0011\" \u0001A\u0002\u0003\u0007I\u0011\u0002@\t\u0015\u0005\u0005\u0001\u00011A\u0001B\u0003&a\u000fC\u0004\u0002\u0004\u0001!\t%!\u0002\t\u000f\u0005%\u0001\u0001\"\u0011\u0002\f!9\u0011Q\u0006\u0001\u0005B\u0005=\u0002bBA&\u0001\u0011\u0005\u0013Q\n\u0005\b\u0003W\u0002A\u0011AA7\u0011\u001d\t\t\b\u0001C!\u0003gBq!!\u001e\u0001\t\u0003\n9HA\u0006Tg\u0016d\u0015n\u001d;f]\u0016\u0014(B\u0001\f\u0018\u0003\r\u00198/\u001a\u0006\u00031e\ta!Y2uS>t'B\u0001\u000e\u001c\u0003\u0011AG\u000f\u001e9\u000b\u0005qi\u0012aB4bi2Lgn\u001a\u0006\u0002=\u0005\u0011\u0011n\\\u0002\u0001'\u0019\u0001\u0011%K\u00186qA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB(cU\u0016\u001cG\u000f\u0005\u0002+[5\t1F\u0003\u0002-3\u000511\r\\5f]RL!AL\u0016\u0003\u0019!#H\u000f\u001d'jgR,g.\u001a:\u0011\u0005A\u001aT\"A\u0019\u000b\u0005I*\u0012a\u00014t[&\u0011A'\r\u0002\n'N,7\u000b\u001e:fC6\u0004\"\u0001\r\u001c\n\u0005]\n$!F#wK:$8\u000b\u001e:fC6$\u0015n\u001d9bi\u000eDWM\u001d\t\u0003s\u0001k\u0011A\u000f\u0006\u0003wq\nAb]2bY\u0006dwnZ4j]\u001eT!!\u0010 \u0002\u0011QL\b/Z:bM\u0016T\u0011aP\u0001\u0004G>l\u0017BA!;\u00055\u0019FO]5di2{wmZ5oOB\u0011\u0001gQ\u0005\u0003\tF\u0012aaU:f\rNl\u0017aC:uCR\u001cXI\\4j]\u0016\u0004\"a\u0012'\u000e\u0003!S!!\u0013&\u0002\u000bM$\u0018\r^:\u000b\u0005-[\u0012\u0001B2pe\u0016L!!\u0014%\u0003\u0017M#\u0018\r^:F]\u001eLg.Z\u0001\u0006G2|7m\u001b\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000bA!\u001e;jY*\u0011AkG\u0001\bG>lWn\u001c8t\u0013\t1\u0016KA\u0003DY>\u001c7.\u0001\u0004=S:LGO\u0010\u000b\u00053ncV\f\u0005\u0002[\u00015\tQ\u0003C\u00033\t\u0001\u0007!\tC\u0003F\t\u0001\u0007a\tC\u0003O\t\u0001\u0007q*A\u0003ti\u0006$X-F\u0001a!\tQ\u0016-\u0003\u0002c+\tA1k]3Ti\u0006$X-A\u0005ti\u0006$Xm\u0018\u0013fcR\u0011Qm\u001b\t\u0003M&l\u0011a\u001a\u0006\u0002Q\u0006)1oY1mC&\u0011!n\u001a\u0002\u0005+:LG\u000fC\u0004m\r\u0005\u0005\t\u0019\u00011\u0002\u0007a$\u0013'\u0001\u0004ti\u0006$X\rI\u0001\bI\u0016\u001cw\u000eZ3s+\u0005\u0001\bC\u0001\u0019r\u0013\t\u0011\u0018G\u0001\tTg\u0016\u001cFO]3b[\u0012+7m\u001c3fe\u0006AA-Z2pI\u0016\u0014\b%A\u0004dQ\u0006tg.\u001a7\u0016\u0003Y\u0004\"a^>\u000e\u0003aT!\u0001^=\u000b\u0005il\u0012!\u00028fiRL\u0018B\u0001?y\u0005\u001d\u0019\u0005.\u00198oK2\f1b\u00195b]:,Gn\u0018\u0013fcR\u0011Qm \u0005\bY.\t\t\u00111\u0001w\u0003!\u0019\u0007.\u00198oK2\u0004\u0013aB8o/JLG/\u001a\u000b\u0004K\u0006\u001d\u0001\"\u0002;\u000e\u0001\u00041\u0018AD8o\u0011R$\bOU3ta>t7/\u001a\u000b\u0006K\u00065\u00111\u0005\u0005\b\u0003\u001fq\u0001\u0019AA\t\u0003\u0019\u0019H/\u0019;vgB!\u00111CA\u0010\u001b\t\t)BC\u0002\u001b\u0003/QA!!\u0007\u0002\u001c\u0005)1m\u001c3fG*\u0019\u0011QD=\u0002\u000f!\fg\u000e\u001a7fe&!\u0011\u0011EA\u000b\u0005IAE\u000f\u001e9SKN\u0004xN\\:f'R\fG/^:\t\u000f\u0005\u0015b\u00021\u0001\u0002(\u00059\u0001.Z1eKJ\u001c\b\u0003BA\n\u0003SIA!a\u000b\u0002\u0016\tY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0003]yg\u000e\u0013;uaJ+7\u000f]8og\u0016\u0014u\u000eZ=DQVt7\u000eF\u0003f\u0003c\t\t\u0005C\u0004\u00024=\u0001\r!!\u000e\u0002\u000b\rDWO\\6\u0011\t\u0005]\u0012QH\u0007\u0003\u0003sQ1!a\u000fz\u0003\u0019\u0011WO\u001a4fe&!\u0011qHA\u001d\u0005\u001d\u0011\u0015\u0010^3Ck\u001aDq!a\u0011\u0010\u0001\u0004\t)%\u0001\u0003mCN$\bc\u00014\u0002H%\u0019\u0011\u0011J4\u0003\u000f\t{w\u000e\\3b]\u0006YqN\u001c+ie><\u0018M\u00197f)\r)\u0017q\n\u0005\b\u0003#\u0002\u0002\u0019AA*\u0003%!\bN]8xC\ndW\r\u0005\u0003\u0002V\u0005\u0015d\u0002BA,\u0003CrA!!\u0017\u0002`5\u0011\u00111\f\u0006\u0004\u0003;z\u0012A\u0002\u001fs_>$h(C\u0001i\u0013\r\t\u0019gZ\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9'!\u001b\u0003\u0013QC'o\\<bE2,'bAA2O\u0006y1/\u001a8e\u001f:$\u0006N]8xC\ndW\rF\u0002f\u0003_Bq!!\u0015\u0012\u0001\u0004\t\u0019&A\u0003dY>\u001cX\rF\u0001f\u0003M!\u0017n\u001d9bi\u000eDWI^3oiN#(/Z1n)\r)\u0017\u0011\u0010\u0005\u0007-M\u0001\r!a\u001f\u0011\u0007A\ni(C\u0002\u0002\u0000E\u0012qbU3sm\u0016\u00148+\u001a8u\u000bZ,g\u000e\u001e")
public class SseListener
implements HttpListener,
SseStream,
EventStreamDispatcher,
StrictLogging {
    private final SseFsm fsm;
    private final Clock clock;
    private SseState state;
    private final SseStreamDecoder decoder;
    private Channel channel;
    private final Logger logger;

    public void onSend(HttpHeaders x$1) {
        super.onSend(x$1);
    }

    public void onProtocolAwareness(boolean x$1) {
        super.onProtocolAwareness(x$1);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private SseState state() {
        return this.state;
    }

    private void state_$eq(SseState x$1) {
        this.state = x$1;
    }

    private SseStreamDecoder decoder() {
        return this.decoder;
    }

    private Channel channel() {
        return this.channel;
    }

    private void channel_$eq(Channel x$1) {
        this.channel = x$1;
    }

    public void onWrite(Channel channel) {
        this.channel_$eq(channel);
    }

    public void onHttpResponse(HttpResponseStatus status, HttpHeaders headers) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Status {} received for SSE", new Object[]{BoxesRunTime.boxToInteger((int)status.code())});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        if (httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null) {
            SseException ex = new SseException(status.code());
            this.onThrowable(ex);
            throw ex;
        }
        this.state_$eq(Connected$.MODULE$);
        this.fsm.onSseStreamConnected(this, this.clock.nowMillis());
    }

    public void onHttpResponseBodyChunk(ByteBuf chunk, boolean last) {
        block1: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block1;
            Seq<ServerSentEvent> events = this.decoder().decodeStream(chunk);
            events.foreach((Function1 & Serializable & scala.Serializable)sse -> {
                this.dispatchEventStream(sse);
                return BoxedUnit.UNIT;
            });
            if (last) {
                this.close();
            }
        }
    }

    public void onThrowable(Throwable throwable) {
        block0: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block0;
            this.close();
            this.sendOnThrowable(throwable);
        }
    }

    public void sendOnThrowable(Throwable throwable) {
        BoxedUnit boxedUnit;
        String errorMessage = Throwables.PimpedException$.MODULE$.rootMessage$extension(Throwables$.MODULE$.PimpedException(throwable));
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Request failed", throwable);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Request failed: {}", new Object[]{errorMessage});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        SseState sseState = this.state();
        boolean bl = Connecting$.MODULE$.equals(sseState) ? true : Connected$.MODULE$.equals(sseState);
        if (bl) {
            this.fsm.onSseStreamCrashed(throwable, this.clock.nowMillis());
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (Closed$.MODULE$.equals(sseState)) {
            BoxedUnit boxedUnit3;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("unexpected state closed with error message: {}", new Object[]{errorMessage});
                boxedUnit3 = BoxedUnit.UNIT;
            } else {
                boxedUnit3 = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit4 = boxedUnit3;
        } else {
            throw new MatchError((Object)sseState);
        }
    }

    @Override
    public void close() {
        block1: {
            SseState sseState = this.state();
            Closed$ closed$ = Closed$.MODULE$;
            if (!(sseState == null ? closed$ != null : !sseState.equals(closed$))) break block1;
            this.state_$eq(Closed$.MODULE$);
            if (this.channel() != null) {
                this.channel().close();
                this.channel_$eq(null);
            }
            this.fsm.onSseStreamClosed(this.clock.nowMillis());
        }
    }

    @Override
    public void dispatchEventStream(ServerSentEvent sse) {
        this.fsm.onSseReceived(sse.asJsonString(), this.clock.nowMillis());
    }

    public SseListener(SseFsm fsm, StatsEngine statsEngine, Clock clock) {
        this.fsm = fsm;
        this.clock = clock;
        StrictLogging.$init$((StrictLogging)this);
        this.state = Connecting$.MODULE$;
        this.decoder = new SseStreamDecoder();
    }
}

