/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.polling.PollerResponseProcessor;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.client.Request;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.RootSessionProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.ResponseBuilder;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\rh!B\f\u0019\u0001a\u0011\u0003\u0002C\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001b\t\u0011\u0001\u0003!\u0011!Q\u0001\n\u0005C\u0001\"\u0013\u0001\u0003\u0002\u0003\u0006IA\u0013\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005l\u0001\t\u0005\t\u0015!\u0003m\u0011!\u0011\bA!A!\u0002\u0013\u0019\b\u0002C=\u0001\u0005\u0003\u0005\u000b\u0011\u0002>\t\u0015\u0005\u0015\u0001A!A!\u0002\u0013\t9\u0001\u0003\u0006\u0002\u0018\u0001\u0011\t\u0011)A\u0005\u00033Aq!a\u000b\u0001\t\u0003\ti\u0003C\u0006\u0002H\u0001\u0001\r\u00111A\u0005\n\u0005%\u0003bCA+\u0001\u0001\u0007\t\u0019!C\u0005\u0003/B1\"a\u0019\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002L!Y\u0011Q\r\u0001A\u0002\u0003\u0007I\u0011BA4\u0011-\ty\t\u0001a\u0001\u0002\u0004%I!!%\t\u0017\u0005}\u0004\u00011A\u0001B\u0003&\u0011\u0011\u000e\u0005\b\u0003;\u0003A\u0011AAP\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!!/\u0001\t\u0013\tY\fC\u0004\u0002>\u0002!I!a0\t\u000f\u0005=\u0007\u0001\"\u0001\u0002R\n1\u0001k\u001c7mKJT!!\u0007\u000e\u0002\u000fA|G\u000e\\5oO*\u00111\u0004H\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u0005uq\u0012\u0001\u00025uiBT!a\b\u0011\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011%\u0001\u0002j_N\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\tQ\u0013'D\u0001,\u0015\taS&\u0001\u0007tG\u0006d\u0017\r\\8hO&twM\u0003\u0002/_\u0005AA/\u001f9fg\u00064WMC\u00011\u0003\r\u0019w.\\\u0005\u0003e-\u0012Qb\u0015;sS\u000e$Hj\\4hS:<\u0017A\u00039pY2,'OT1nK\u000e\u0001\u0001C\u0001\u001c>\u001d\t94\b\u0005\u00029K5\t\u0011H\u0003\u0002;i\u00051AH]8pizJ!\u0001P\u0013\u0002\rA\u0013X\rZ3g\u0013\tqtH\u0001\u0004TiJLgn\u001a\u0006\u0003y\u0015\na\u0001]3sS>$\u0007C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003!!WO]1uS>t'B\u0001$&\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003\u0011\u000e\u0013aBR5oSR,G)\u001e:bi&|g.\u0001\u0006sKF,Xm\u001d;EK\u001a\u0004\"a\u0013(\u000e\u00031S!!\u0014\u000f\u0002\u000fI,\u0017/^3ti&\u0011q\n\u0014\u0002\u000f\u0011R$\bOU3rk\u0016\u001cH\u000fR3g\u0003Y\u0011Xm\u001d9p]N,')^5mI\u0016\u0014h)Y2u_JL\bC\u0001*`\u001d\t\u0019FL\u0004\u0002U5:\u0011Q+\u0017\b\u0003-bs!\u0001O,\n\u0003\u0005J!a\b\u0011\n\u0005uq\u0012BA.\u001d\u0003!\u0011Xm\u001d9p]N,\u0017BA/_\u0003\u001d\u0001\u0018mY6bO\u0016T!a\u0017\u000f\n\u0005\u0001\f'A\u0006*fgB|gn]3Ck&dG-\u001a:GC\u000e$xN]=\u000b\u0005us\u0016A\u00045uiB$\u00060\u0012=fGV$xN\u001d\t\u0003I&l\u0011!\u001a\u0006\u0003M\u001e\f!\u0001\u001e=\u000b\u0005!d\u0012AB3oO&tW-\u0003\u0002kK\nq\u0001\n\u001e;q)b,\u00050Z2vi>\u0014\u0018A\u00035uiB\u001c\u0015m\u00195fgB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eH\u0001\u0006G\u0006\u001c\u0007.Z\u0005\u0003c:\u0014!\u0002\u0013;ua\u000e\u000b7\r[3t\u00031AG\u000f\u001e9Qe>$xnY8m!\t!x/D\u0001v\u0015\t1H$\u0001\u0005qe>$xnY8m\u0013\tAXO\u0001\u0007IiR\u0004\bK]8u_\u000e|G.A\u0006ti\u0006$8/\u00128hS:,\u0007cA>\u0002\u00025\tAP\u0003\u0002~}\u0006)1\u000f^1ug*\u0011qPH\u0001\u0005G>\u0014X-C\u0002\u0002\u0004q\u00141b\u0015;biN,enZ5oK\u0006)1\r\\8dWB!\u0011\u0011BA\n\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011\u0001B;uS2T1!!\u0005\u001f\u0003\u001d\u0019w.\\7p]NLA!!\u0006\u0002\f\t)1\t\\8dW\u000691\r[1sg\u0016$\b\u0003BA\u000e\u0003Oi!!!\b\u000b\t\u0005]\u0011q\u0004\u0006\u0005\u0003C\t\u0019#A\u0002oS>T!!!\n\u0002\t)\fg/Y\u0005\u0005\u0003S\tiBA\u0004DQ\u0006\u00148/\u001a;\u0002\rqJg.\u001b;?)Y\ty#a\r\u00026\u0005]\u0012\u0011HA\u001e\u0003{\ty$!\u0011\u0002D\u0005\u0015\u0003cAA\u0019\u00015\t\u0001\u0004C\u00034\u0017\u0001\u0007Q\u0007C\u0003A\u0017\u0001\u0007\u0011\tC\u0003J\u0017\u0001\u0007!\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003c\u0017\u0001\u00071\rC\u0003l\u0017\u0001\u0007A\u000eC\u0003s\u0017\u0001\u00071\u000fC\u0003z\u0017\u0001\u0007!\u0010C\u0004\u0002\u0006-\u0001\r!a\u0002\t\u000f\u0005]1\u00021\u0001\u0002\u001a\u000591/Z:tS>tWCAA&!\u0011\ti%!\u0015\u000e\u0005\u0005=#bAA$}&!\u00111KA(\u0005\u001d\u0019Vm]:j_:\f1b]3tg&|gn\u0018\u0013fcR!\u0011\u0011LA0!\r!\u00131L\u0005\u0004\u0003;*#\u0001B+oSRD\u0011\"!\u0019\u000e\u0003\u0003\u0005\r!a\u0013\u0002\u0007a$\u0013'\u0001\u0005tKN\u001c\u0018n\u001c8!\u0003\u0015!\u0018.\\3s+\t\tI\u0007\r\u0003\u0002l\u0005m\u0004CBA7\u0003g\n9(\u0004\u0002\u0002p)\u0019a)!\u001d\u000b\t\u00055\u00111E\u0005\u0005\u0003k\nyGA\bTG\",G-\u001e7fI\u001a+H/\u001e:f!\u0011\tI(a\u001f\r\u0001\u0011Y\u0011QP\t\u0002\u0002\u0003\u0005)\u0011AAA\u0005\ryF%M\u0001\u0007i&lWM\u001d\u0011\u0012\t\u0005\r\u0015\u0011\u0012\t\u0004I\u0005\u0015\u0015bAADK\t9aj\u001c;iS:<\u0007c\u0001\u0013\u0002\f&\u0019\u0011QR\u0013\u0003\u0007\u0005s\u00170A\u0005uS6,'o\u0018\u0013fcR!\u0011\u0011LAJ\u0011%\t\t\u0007EA\u0001\u0002\u0004\t)\n\r\u0003\u0002\u0018\u0006m\u0005CBA7\u0003g\nI\n\u0005\u0003\u0002z\u0005mE\u0001DA?\u0003'\u000b\t\u0011!A\u0003\u0002\u0005\u0005\u0015!B:uCJ$H\u0003BA-\u0003CCq!a\u0012\u0013\u0001\u0004\tY%A\u0006ck&dG\r\u0013;uaRCHCAAT!\u0019\tI+a,\u000246\u0011\u00111\u0016\u0006\u0005\u0003[\u000by!\u0001\u0006wC2LG-\u0019;j_:LA!!-\u0002,\nQa+\u00197jI\u0006$\u0018n\u001c8\u0011\u0007\u0011\f),C\u0002\u00028\u0016\u0014a\u0001\u0013;uaRC\u0018\u0001\u00029pY2$\"!!\u0017\u0002\u001fI,7o\\;sG\u00164U\r^2iK\u0012$b!a\u0013\u0002B\u0006\r\u0007B\u00024\u0016\u0001\u0004\t\u0019\fC\u0004\u0002FV\u0001\r!a2\u0002\rI,7/\u001e7u!\u0011\tI-a3\u000e\u0003yK1!!4_\u0005)AE\u000f\u001e9SKN,H\u000e^\u0001\u0005gR|\u0007\u000f\u0006\u0004\u0002Z\u0005M\u0017\u0011\u001d\u0005\b\u0003+4\u0002\u0019AAl\u0003\u0011qW\r\u001f;\u0011\t\u0005e\u0017Q\\\u0007\u0003\u00037T!a\u0007@\n\t\u0005}\u00171\u001c\u0002\u0007\u0003\u000e$\u0018n\u001c8\t\u000f\u0005\u001dc\u00031\u0001\u0002L\u0001")
public class Poller
implements StrictLogging {
    private final String pollerName;
    private final FiniteDuration period;
    private final HttpRequestDef requestDef;
    private final Function1<Request, ResponseBuilder> responseBuilderFactory;
    private final HttpTxExecutor httpTxExecutor;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final StatsEngine statsEngine;
    private final Clock clock;
    private final Charset charset;
    private Session io$gatling$http$action$polling$Poller$$session;
    private ScheduledFuture<?> timer;
    private final Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Session io$gatling$http$action$polling$Poller$$session() {
        return this.io$gatling$http$action$polling$Poller$$session;
    }

    public void io$gatling$http$action$polling$Poller$$session_$eq(Session x$1) {
        this.io$gatling$http$action$polling$Poller$$session = x$1;
    }

    private ScheduledFuture<?> timer() {
        return this.timer;
    }

    private void timer_$eq(ScheduledFuture<?> x$1) {
        this.timer = x$1;
    }

    public void start(Session session) {
        this.timer_$eq((ScheduledFuture<?>)session.eventLoop().scheduleAtFixedRate(() -> this.poll(), 0L, this.period.toMillis(), TimeUnit.MILLISECONDS));
    }

    private Validation<HttpTx> buildHttpTx() {
        return ((Validation)this.requestDef.requestName().apply((Object)this.io$gatling$http$action$polling$Poller$$session())).mapError((Function1 & Serializable & scala.Serializable)errorMessage -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("'{}' failed to execute: {}", (Object[])new String[]{$this.pollerName, errorMessage});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return errorMessage;
        }).flatMap((Function1 & Serializable & scala.Serializable)requestName -> $this.requestDef.build((String)requestName, this.io$gatling$http$action$polling$Poller$$session()).mapError((Function1 & Serializable & scala.Serializable)errorMessage -> {
            $this.statsEngine.reportUnbuildableRequest(this.io$gatling$http$action$polling$Poller$$session(), $this.pollerName, errorMessage);
            return errorMessage;
        }).map((Function1 & Serializable & scala.Serializable)httpRequest -> new HttpTx(this.io$gatling$http$action$polling$Poller$$session(), (HttpRequest)httpRequest, $this.responseBuilderFactory, null, (Option<ResourceTx>)None$.MODULE$, 0)));
    }

    private void poll() {
        Validation<HttpTx> validation = this.buildHttpTx();
        if (validation instanceof Success) {
            Success success = (Success)validation;
            HttpTx tx2 = (HttpTx)success.value();
            this.httpTxExecutor.execute(tx2, (Function1<HttpTx, ResponseProcessor>)(Function1 & Serializable & scala.Serializable)tx -> new ResponseProcessor(this, (HttpTx)tx){
                private final /* synthetic */ Poller $outer;
                private final HttpTx tx$1;

                public void onComplete(HttpResult result) {
                    this.$outer.io$gatling$http$action$polling$Poller$$session_$eq(this.$outer.io$gatling$http$action$polling$Poller$$resourceFetched(this.tx$1, result));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tx$1 = tx$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.timer().cancel(false);
            this.io$gatling$http$action$polling$Poller$$session_$eq(this.io$gatling$http$action$polling$Poller$$session().markAsFailed());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Session io$gatling$http$action$polling$Poller$$resourceFetched(HttpTx tx, HttpResult result) {
        return new PollerResponseProcessor(tx.copy(this.io$gatling$http$action$polling$Poller$$session(), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5(), tx.copy$default$6()), new RootSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol, this.clock), this.httpTxExecutor.statsProcessor(tx), this.charset).onComplete(result);
    }

    public void stop(Action next, Session session) {
        this.timer().cancel(false);
        next.$bang(session.remove(this.pollerName));
    }

    public Poller(String pollerName, FiniteDuration period, HttpRequestDef requestDef, Function1<Request, ResponseBuilder> responseBuilderFactory, HttpTxExecutor httpTxExecutor, HttpCaches httpCaches, HttpProtocol httpProtocol, StatsEngine statsEngine, Clock clock, Charset charset) {
        this.pollerName = pollerName;
        this.period = period;
        this.requestDef = requestDef;
        this.responseBuilderFactory = responseBuilderFactory;
        this.httpTxExecutor = httpTxExecutor;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.statsEngine = statsEngine;
        this.clock = clock;
        this.charset = charset;
        StrictLogging.$init$((StrictLogging)this);
    }
}

