/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.CssResource;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public final class CssParser$
implements StrictLogging {
    public static CssParser$ MODULE$;
    private final Regex InlineStyleImageUrls;
    private final Regex StyleImportsUrls;
    private final Some<Object> SingleQuoteEscapeChar;
    private final Some<Object> DoubleQuoteEscapeChar;
    private final char[] AtImportChars;
    private final char[] UrlStartChars;
    private final Logger logger;

    static {
        new CssParser$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Regex InlineStyleImageUrls() {
        return this.InlineStyleImageUrls;
    }

    private Regex StyleImportsUrls() {
        return this.StyleImportsUrls;
    }

    public Iterator<String> extractInlineStyleImageUrls(CharSequence string) {
        return this.extractUrls(string, this.InlineStyleImageUrls());
    }

    public Iterator<String> extractStyleImportsUrls(CharSequence string) {
        return this.extractUrls(string, this.StyleImportsUrls());
    }

    private Iterator<String> extractUrls(CharSequence string, Regex regex) {
        return regex.findAllIn(string).matchData().flatMap((Function1 & Serializable & scala.Serializable)m -> {
            String raw = m.group(1);
            return Option$.MODULE$.option2Iterable(MODULE$.extractUrl(raw, 0, raw.length()));
        });
    }

    private Some<Object> SingleQuoteEscapeChar() {
        return this.SingleQuoteEscapeChar;
    }

    private Some<Object> DoubleQuoteEscapeChar() {
        return this.DoubleQuoteEscapeChar;
    }

    private char[] AtImportChars() {
        return this.AtImportChars;
    }

    private char[] UrlStartChars() {
        return this.UrlStartChars;
    }

    public Option<String> extractUrl(String string, int start, int end) {
        Object object;
        if (string.isEmpty()) {
            object = None$.MODULE$;
        } else {
            ObjectRef protectChar = ObjectRef.create((Object)None$.MODULE$);
            BooleanRef broken = BooleanRef.create((boolean)false);
            int trimmedStart = this.trimLeft$1(start, end, string, protectChar, broken);
            int trimmedEnd = this.trimRight$1(end, trimmedStart, string, protectChar, broken);
            if (!broken.elem && trimmedStart != trimmedEnd) {
                object = string.charAt(trimmedStart) == '#' ? None$.MODULE$ : new Some((Object)string.substring(trimmedStart, trimmedEnd));
            } else {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info("css url {} broken", new Object[]{string});
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                object = None$.MODULE$;
            }
        }
        return object;
    }

    public List<ConcurrentResource> extractResources(Uri cssURI, String cssContent) {
        ArrayBuffer resources = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        boolean withinComment = false;
        BooleanRef withinImport = BooleanRef.create((boolean)false);
        BooleanRef withinUrl = BooleanRef.create((boolean)false);
        int urlStart = 0;
        block6: for (int i = 0; i < cssContent.length(); ++i) {
            char c = cssContent.charAt(i);
            switch (c) {
                case '/': {
                    if (i < cssContent.length() - 1 && cssContent.charAt(i + 1) == '*') {
                        withinComment = true;
                        ++i;
                        continue block6;
                    }
                    if (i <= 0 || cssContent.charAt(i - 1) != '*') continue block6;
                    withinComment = false;
                    continue block6;
                }
                case '@': {
                    if (withinComment || !this.charsMatch$1(i, this.AtImportChars(), cssContent)) continue block6;
                    withinImport.elem = true;
                    i += "@import".length();
                    continue block6;
                }
                case 'u': {
                    if (withinComment || !withinImport.elem || !this.charsMatch$1(i, this.UrlStartChars(), cssContent)) continue block6;
                    urlStart = i += this.UrlStartChars().length;
                    withinUrl.elem = true;
                    continue block6;
                }
                case ')': {
                    if (withinComment || !withinUrl.elem) continue block6;
                    this.extractUrl(cssContent, urlStart, i).foreach((Function1 & Serializable & scala.Serializable)url -> {
                        CssParser$.$anonfun$extractResources$1(cssURI, resources, withinUrl, withinImport, url);
                        return BoxedUnit.UNIT;
                    });
                    continue block6;
                }
                default: {
                    continue block6;
                }
            }
        }
        return resources.toList();
    }

    private final int trimLeft$1(int cur, int end$1, String string$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        int n;
        block5: while (true) {
            if (cur == end$1) {
                n = cur;
                break;
            }
            char c = string$1.charAt(cur);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    ++cur;
                    continue block5;
                }
                case '\'': {
                    int n2;
                    Option option = (Option)protectChar$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        protectChar$1.elem = this.SingleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n2 = cur;
                    break block5;
                }
                case '\"': {
                    int n3;
                    Option option = (Option)protectChar$1.elem;
                    if (None$.MODULE$.equals(option)) {
                        protectChar$1.elem = this.DoubleQuoteEscapeChar();
                        ++cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n3 = cur;
                    break block5;
                }
                default: {
                    n = cur;
                    break block5;
                }
            }
            break;
        }
        return n;
    }

    private final int trimRight$1(int cur, int leftLimit, String string$1, ObjectRef protectChar$1, BooleanRef broken$1) {
        int n;
        block5: while (true) {
            if (cur == leftLimit) {
                n = cur;
                break;
            }
            char c = string$1.charAt(cur - 1);
            switch (c) {
                case '\n': 
                case '\r': 
                case ' ': {
                    --cur;
                    continue block5;
                }
                case '\'': {
                    int n2;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.SingleQuoteEscapeChar();
                    Option option2 = option;
                    if (!(some == null ? option2 != null : !some.equals((Object)option2))) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n2 = cur;
                    break block5;
                }
                case '\"': {
                    int n3;
                    Option option = (Option)protectChar$1.elem;
                    Some<Object> some = this.DoubleQuoteEscapeChar();
                    Option option3 = option;
                    if (!(some == null ? option3 != null : !some.equals((Object)option3))) {
                        --cur;
                        continue block5;
                    }
                    broken$1.elem = true;
                    n = n3 = cur;
                    break block5;
                }
                default: {
                    n = cur;
                    break block5;
                }
            }
            break;
        }
        return n;
    }

    private final boolean charsMatchRec$1(int j, char[] chars$1, String cssContent$1, int i$1) {
        boolean bl;
        while (true) {
            if (j == chars$1.length) {
                bl = true;
                break;
            }
            if (cssContent$1.charAt(i$1 + j) != chars$1[j]) {
                bl = false;
                break;
            }
            ++j;
        }
        return bl;
    }

    private final boolean charsMatch$1(int i, char[] chars, String cssContent$1) {
        return i < cssContent$1.length() - chars.length && this.charsMatchRec$1(1, chars, cssContent$1, i);
    }

    public static final /* synthetic */ void $anonfun$extractResources$2(ArrayBuffer resources$1, BooleanRef withinUrl$1, BooleanRef withinImport$1, Uri absoluteUri) {
        resources$1.$plus$eq((Object)new CssResource(absoluteUri));
        withinUrl$1.elem = false;
        withinImport$1.elem = false;
    }

    public static final /* synthetic */ void $anonfun$extractResources$1(Uri cssURI$1, ArrayBuffer resources$1, BooleanRef withinUrl$1, BooleanRef withinImport$1, String url) {
        HttpHelper$.MODULE$.resolveFromUriSilently(cssURI$1, url).foreach((Function1 & Serializable & scala.Serializable)absoluteUri -> {
            CssParser$.$anonfun$extractResources$2(resources$1, withinUrl$1, withinImport$1, absoluteUri);
            return BoxedUnit.UNIT;
        });
    }

    private CssParser$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.InlineStyleImageUrls = new StringOps(Predef$.MODULE$.augmentString("url\\((.*)\\)")).r();
        this.StyleImportsUrls = new StringOps(Predef$.MODULE$.augmentString("@import url\\((.*)\\)")).r();
        this.SingleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\''));
        this.DoubleQuoteEscapeChar = new Some((Object)BoxesRunTime.boxToCharacter((char)'\"'));
        this.AtImportChars = "@import".toCharArray();
        this.UrlStartChars = "url(".toCharArray();
    }
}

