/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.polling;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.stats.StatsEngine;
import io.gatling.http.action.polling.PollerResponseProcessor;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.RootSessionProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.HttpResult;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e!B\n\u0015\u0005Qq\u0002\u0002C\u0018\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006IA\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\u001b\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005]\u0001\t\u0005\t\u0015!\u0003^\u0011!\u0019\u0007A!A!\u0002\u0013!\u0007\"\u00027\u0001\t\u0003i\u0007\"C<\u0001\u0001\u0004\u0005\r\u0011\"\u0003y\u0011%q\b\u00011AA\u0002\u0013%q\u0010\u0003\u0006\u0002\f\u0001\u0001\r\u0011!Q!\neD1\"!\u0004\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u0010!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA \u0011-\ti\u0003\u0001a\u0001\u0002\u0003\u0006K!!\u0005\t\u000f\u0005-\u0003\u0001\"\u0001\u0002N!9\u0011\u0011\u000b\u0001\u0005\n\u0005M\u0003bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003c\u0002A\u0011AA:\u0005\u0019\u0001v\u000e\u001c7fe*\u0011QCF\u0001\ba>dG.\u001b8h\u0015\t9\u0002$\u0001\u0004bGRLwN\u001c\u0006\u00033i\tA\u0001\u001b;ua*\u00111\u0004H\u0001\bO\u0006$H.\u001b8h\u0015\u0005i\u0012AA5p'\r\u0001q$\n\t\u0003A\rj\u0011!\t\u0006\u0002E\u0005)1oY1mC&\u0011A%\t\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0019jS\"A\u0014\u000b\u0005!J\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0016,\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0017\u0002\u0007\r|W.\u0003\u0002/O\ti1\u000b\u001e:jGRdunZ4j]\u001e\f!\u0002]8mY\u0016\u0014h*Y7f\u0007\u0001\u0001\"AM\u001d\u000f\u0005M:\u0004C\u0001\u001b\"\u001b\u0005)$B\u0001\u001c1\u0003\u0019a$o\\8u}%\u0011\u0001(I\u0001\u0007!J,G-\u001a4\n\u0005iZ$AB*ue&twM\u0003\u00029C\u00051\u0001/\u001a:j_\u0012\u0004\"AP\"\u000e\u0003}R!\u0001Q!\u0002\u0011\u0011,(/\u0019;j_:T!AQ\u0011\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002E\u007f\tqa)\u001b8ji\u0016$UO]1uS>t\u0017A\u0003:fcV,7\u000f\u001e#fMB\u0011qIS\u0007\u0002\u0011*\u0011\u0011\nG\u0001\be\u0016\fX/Z:u\u0013\tY\u0005J\u0001\bIiR\u0004(+Z9vKN$H)\u001a4\u0002\u001d!$H\u000f\u001d+y\u000bb,7-\u001e;peB\u0011ajU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0003ibT!A\u0015\r\u0002\r\u0015tw-\u001b8f\u0013\t!vJ\u0001\bIiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u0002\u0015!$H\u000f]\"bG\",7\u000f\u0005\u0002X56\t\u0001L\u0003\u0002Z1\u0005)1-Y2iK&\u00111\f\u0017\u0002\u000b\u0011R$\boQ1dQ\u0016\u001c\u0018\u0001\u00045uiB\u0004&o\u001c;pG>d\u0007C\u00010b\u001b\u0005y&B\u00011\u0019\u0003!\u0001(o\u001c;pG>d\u0017B\u00012`\u00051AE\u000f\u001e9Qe>$xnY8m\u0003-\u0019H/\u0019;t\u000b:<\u0017N\\3\u0011\u0005\u0015TW\"\u00014\u000b\u0005\u001dD\u0017!B:uCR\u001c(BA5\u001b\u0003\u0011\u0019wN]3\n\u0005-4'aC*uCR\u001cXI\\4j]\u0016\fa\u0001P5oSRtD\u0003\u00038qcJ\u001cH/\u001e<\u0011\u0005=\u0004Q\"\u0001\u000b\t\u000b=B\u0001\u0019A\u0019\t\u000bqB\u0001\u0019A\u001f\t\u000b\u0015C\u0001\u0019\u0001$\t\u000b1C\u0001\u0019A'\t\u000bUC\u0001\u0019\u0001,\t\u000bqC\u0001\u0019A/\t\u000b\rD\u0001\u0019\u00013\u0002\u000fM,7o]5p]V\t\u0011\u0010\u0005\u0002{y6\t1P\u0003\u0002xQ&\u0011Qp\u001f\u0002\b'\u0016\u001c8/[8o\u0003-\u0019Xm]:j_:|F%Z9\u0015\t\u0005\u0005\u0011q\u0001\t\u0004A\u0005\r\u0011bAA\u0003C\t!QK\\5u\u0011!\tIACA\u0001\u0002\u0004I\u0018a\u0001=%c\u0005A1/Z:tS>t\u0007%A\u0003uS6,'/\u0006\u0002\u0002\u0012A\"\u00111CA\u0015!\u0019\t)\"!\t\u0002&5\u0011\u0011q\u0003\u0006\u0004\u0005\u0006e!\u0002BA\u000e\u0003;\tA!\u001e;jY*\u0011\u0011qD\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002$\u0005]!aD*dQ\u0016$W\u000f\\3e\rV$XO]3\u0011\t\u0005\u001d\u0012\u0011\u0006\u0007\u0001\t-\tYCDA\u0001\u0002\u0003\u0015\t!a\f\u0003\u0007}#\u0013'\u0001\u0004uS6,'\u000fI\t\u0005\u0003c\t9\u0004E\u0002!\u0003gI1!!\u000e\"\u0005\u001dqu\u000e\u001e5j]\u001e\u00042\u0001IA\u001d\u0013\r\tY$\t\u0002\u0004\u0003:L\u0018!\u0003;j[\u0016\u0014x\fJ3r)\u0011\t\t!!\u0011\t\u0013\u0005%Q\"!AA\u0002\u0005\r\u0003\u0007BA#\u0003\u0013\u0002b!!\u0006\u0002\"\u0005\u001d\u0003\u0003BA\u0014\u0003\u0013\"A\"a\u000b\u0002B\u0005\u0005\t\u0011!B\u0001\u0003_\tQa\u001d;beR$B!!\u0001\u0002P!)qo\u0004a\u0001s\u0006!\u0001o\u001c7m)\t\t\t!A\bsKN|WO]2f\r\u0016$8\r[3e)\u0015I\u0018\u0011LA1\u0011\u0019\u0001\u0016\u00031\u0001\u0002\\A\u0019a*!\u0018\n\u0007\u0005}sJ\u0001\u0004IiR\u0004H\u000b\u001f\u0005\b\u0003G\n\u0002\u0019AA3\u0003\u0019\u0011Xm];miB!\u0011qMA7\u001b\t\tIGC\u0002\u0002la\t\u0001B]3ta>t7/Z\u0005\u0005\u0003_\nIG\u0001\u0006IiR\u0004(+Z:vYR\fAa\u001d;paR1\u0011\u0011AA;\u0003\u0007Cq!a\u001e\u0013\u0001\u0004\tI(\u0001\u0003oKb$\b\u0003BA>\u0003\u007fj!!! \u000b\u0005]A\u0017\u0002BAA\u0003{\u0012a!Q2uS>t\u0007\"B<\u0013\u0001\u0004I\b")
public final class Poller
implements StrictLogging {
    private final String pollerName;
    private final FiniteDuration period;
    private final HttpRequestDef requestDef;
    private final HttpTxExecutor httpTxExecutor;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final StatsEngine statsEngine;
    private Session io$gatling$http$action$polling$Poller$$session;
    private ScheduledFuture<?> timer;
    private Logger logger;

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private Session session() {
        return this.io$gatling$http$action$polling$Poller$$session;
    }

    public void io$gatling$http$action$polling$Poller$$session_$eq(Session x$1) {
        this.io$gatling$http$action$polling$Poller$$session = x$1;
    }

    private ScheduledFuture<?> timer() {
        return this.timer;
    }

    private void timer_$eq(ScheduledFuture<?> x$1) {
        this.timer = x$1;
    }

    public void start(Session session) {
        this.io$gatling$http$action$polling$Poller$$session_$eq(session);
        this.timer_$eq((ScheduledFuture<?>)session.eventLoop().scheduleAtFixedRate(() -> this.poll(), 0L, this.period.toMillis(), TimeUnit.MILLISECONDS));
    }

    private void poll() {
        Validation<HttpRequest> validation = this.requestDef.build(this.session());
        if (validation instanceof Success) {
            Success success = (Success)validation;
            HttpRequest httpRequest = (HttpRequest)success.value();
            this.httpTxExecutor.execute(new HttpTx(this.session(), httpRequest, null, (Option<ResourceTx>)None$.MODULE$, 0), (Function1<HttpTx, ResponseProcessor>)(Function1 & Serializable)tx -> new ResponseProcessor(this, (HttpTx)tx){
                private final /* synthetic */ Poller $outer;
                private final HttpTx tx$1;

                public void onComplete(HttpResult result) {
                    this.$outer.io$gatling$http$action$polling$Poller$$session_$eq(this.$outer.io$gatling$http$action$polling$Poller$$resourceFetched(this.tx$1, result));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.tx$1 = tx$1;
                }
            });
            return;
        }
        if (validation instanceof Failure) {
            BoxedUnit boxedUnit;
            Failure failure = (Failure)validation;
            String requestNameError = failure.message();
            String errorMessage = "Failed to build polling request " + this.pollerName + ": " + requestNameError;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(errorMessage);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.statsEngine.logRequestCrash(this.session().scenario(), this.session().groups(), this.pollerName, errorMessage);
            this.timer().cancel(false);
            this.io$gatling$http$action$polling$Poller$$session_$eq(this.session().markAsFailed());
            return;
        }
        throw new MatchError(validation);
    }

    public Session io$gatling$http$action$polling$Poller$$resourceFetched(HttpTx tx, HttpResult result) {
        return new PollerResponseProcessor(tx.copy(this.session(), tx.copy$default$2(), tx.copy$default$3(), tx.copy$default$4(), tx.copy$default$5()), new RootSessionProcessor(tx.silent(), tx.request().clientRequest(), tx.request().requestConfig().checks(), this.httpCaches, this.httpProtocol), this.httpTxExecutor.statsProcessor(tx), tx.request().requestConfig().defaultCharset()).onComplete(result);
    }

    public void stop(Action next, Session session) {
        this.timer().cancel(false);
        next.$bang(session.remove(this.pollerName));
    }

    public Poller(String pollerName, FiniteDuration period, HttpRequestDef requestDef, HttpTxExecutor httpTxExecutor, HttpCaches httpCaches, HttpProtocol httpProtocol, StatsEngine statsEngine) {
        this.pollerName = pollerName;
        this.period = period;
        this.requestDef = requestDef;
        this.httpTxExecutor = httpTxExecutor;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.statsEngine = statsEngine;
        StrictLogging.$init$((StrictLogging)this);
        Statics.releaseFence();
    }
}

