/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.fetch;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.core.CoreComponents;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.filter.Filters;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.cache.InferredPageResources;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.HttpTxExecutor;
import io.gatling.http.fetch.ConcurrentResource;
import io.gatling.http.fetch.CssParser$;
import io.gatling.http.fetch.DefaultResourceAggregator;
import io.gatling.http.fetch.HtmlParser;
import io.gatling.http.fetch.ResourceAggregator;
import io.gatling.http.fetch.ResourceFetcher$;
import io.gatling.http.fetch.UserAgent$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestDef;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015x!B\t\u0013\u0011\u0003Yb!B\u000f\u0013\u0011\u0003q\u0002\"B\u0018\u0002\t\u0003\u0001\u0004\"B\u0019\u0002\t\u0003\u0011\u0004\"B)\u0002\t\u0003\u0011f\u0001B\u000f\u0013\u0001}D!\"!\u0001\u0006\u0005\u0003\u0005\u000b\u0011BA\u0002\u0011!\u0019WA!A!\u0002\u0013!\u0007\u0002C6\u0006\u0005\u0003\u0005\u000b\u0011\u00027\t\u0015\u0005-QA!A!\u0002\u0013\ti\u0001\u0003\u00040\u000b\u0011\u0005\u0011Q\u0004\u0005\b\u0003S)A\u0011BA\u0016\u0011\u001d\ti%\u0002C\u0001\u0003\u001fBq!a'\u0006\t\u0013\ti\nC\u0004\u0002,\u0016!I!!,\t\u000f\u0005\rW\u0001\"\u0001\u0002F\"9\u0011\u0011Z\u0003\u0005\u0002\u0005-\u0017a\u0004*fg>,(oY3GKR\u001c\u0007.\u001a:\u000b\u0005M!\u0012!\u00024fi\u000eD'BA\u000b\u0017\u0003\u0011AG\u000f\u001e9\u000b\u0005]A\u0012aB4bi2Lgn\u001a\u0006\u00023\u0005\u0011\u0011n\\\u0002\u0001!\ta\u0012!D\u0001\u0013\u0005=\u0011Vm]8ve\u000e,g)\u001a;dQ\u0016\u00148cA\u0001 KA\u0011\u0001eI\u0007\u0002C)\t!%A\u0003tG\u0006d\u0017-\u0003\u0002%C\t1\u0011I\\=SK\u001a\u0004\"AJ\u0017\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005)Z\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u00031\n1aY8n\u0013\tqsEA\u0007TiJL7\r\u001e'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\tA#\u00199qYf\u0014Vm]8ve\u000e,g)\u001b7uKJ\u001cHcA\u001aC\tB\u0019A\u0007P \u000f\u0005URdB\u0001\u001c:\u001b\u00059$B\u0001\u001d\u001b\u0003\u0019a$o\\8u}%\t!%\u0003\u0002<C\u00059\u0001/Y2lC\u001e,\u0017BA\u001f?\u0005\u0011a\u0015n\u001d;\u000b\u0005m\n\u0003C\u0001\u000fA\u0013\t\t%C\u0001\nD_:\u001cWO\u001d:f]R\u0014Vm]8ve\u000e,\u0007\"B\"\u0004\u0001\u0004\u0019\u0014!\u0003:fg>,(oY3t\u0011\u0015)5\u00011\u0001G\u0003\u001d1\u0017\u000e\u001c;feN\u00042\u0001I$J\u0013\tA\u0015E\u0001\u0004PaRLwN\u001c\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000baAZ5mi\u0016\u0014(B\u0001(\u0017\u0003\u0011\u0019wN]3\n\u0005A[%a\u0002$jYR,'o]\u0001\u0014e\u0016\u001cx.\u001e:dKN$vNU3rk\u0016\u001cHo\u001d\u000b\b'j[&M\u001b:x!\r!D\b\u0016\t\u0003+bk\u0011A\u0016\u0006\u0003/R\tqA]3rk\u0016\u001cH/\u0003\u0002Z-\nY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u0015\u0019E\u00011\u00014\u0011\u0015aF\u00011\u0001^\u0003\u001d\u0019Xm]:j_:\u0004\"A\u00181\u000e\u0003}S!\u0001X'\n\u0005\u0005|&aB*fgNLwN\u001c\u0005\u0006G\u0012\u0001\r\u0001Z\u0001\u000bQR$\boQ1dQ\u0016\u001c\bCA3i\u001b\u00051'BA4\u0015\u0003\u0015\u0019\u0017m\u00195f\u0013\tIgM\u0001\u0006IiR\u00048)Y2iKNDQa\u001b\u0003A\u00021\fA\u0002\u001b;uaB\u0013x\u000e^8d_2\u0004\"!\u001c9\u000e\u00039T!a\u001c\u000b\u0002\u0011A\u0014x\u000e^8d_2L!!\u001d8\u0003\u0019!#H\u000f\u001d)s_R|7m\u001c7\t\u000bM$\u0001\u0019\u0001;\u0002\u0013QD'o\u001c;uY\u0016$\u0007C\u0001\u0011v\u0013\t1\u0018EA\u0004C_>dW-\u00198\t\u000ba$\u0001\u0019A=\u0002\u001b\r|gNZ5hkJ\fG/[8o!\tQX0D\u0001|\u0015\taX*\u0001\u0004d_:4\u0017nZ\u0005\u0003}n\u0014AcR1uY&twmQ8oM&<WO]1uS>t7cA\u0003 K\u0005q1m\u001c:f\u0007>l\u0007o\u001c8f]R\u001c\b\u0003BA\u0003\u0003\u000fi\u0011!T\u0005\u0004\u0003\u0013i%AD\"pe\u0016\u001cu.\u001c9p]\u0016tGo]\u0001\u000fQR$\b\u000f\u0016=Fq\u0016\u001cW\u000f^8s!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\t!\u0001\u001e=\u000b\u0007\u0005]A#\u0001\u0004f]\u001eLg.Z\u0005\u0005\u00037\t\tB\u0001\bIiR\u0004H\u000b_#yK\u000e,Ho\u001c:\u0015\u0015\u0005}\u0011\u0011EA\u0012\u0003K\t9\u0003\u0005\u0002\u001d\u000b!9\u0011\u0011\u0001\u0006A\u0002\u0005\r\u0001\"B2\u000b\u0001\u0004!\u0007\"B6\u000b\u0001\u0004a\u0007bBA\u0006\u0015\u0001\u0007\u0011QB\u0001\u0013S:4WM\u001d)bO\u0016\u0014Vm]8ve\u000e,7\u000fF\u0005T\u0003[\tY$!\u0013\u0002L!1qk\u0003a\u0001\u0003_\u0001B!!\r\u000285\u0011\u00111\u0007\u0006\u0004\u0003k!\u0012AB2mS\u0016tG/\u0003\u0003\u0002:\u0005M\"a\u0002*fcV,7\u000f\u001e\u0005\b\u0003{Y\u0001\u0019AA \u0003!\u0011Xm\u001d9p]N,\u0007\u0003BA!\u0003\u000bj!!a\u0011\u000b\u0007\u0005uB#\u0003\u0003\u0002H\u0005\r#\u0001\u0003*fgB|gn]3\t\u000bq[\u0001\u0019A/\t\u000bM\\\u0001\u0019\u0001;\u0002\u0015\r\u001c8OR3uG\",G\rF\u0007T\u0003#\n\u0019'! \u0002\u0014\u0006]\u0015\u0011\u0014\u0005\b\u0003'b\u0001\u0019AA+\u0003\r)(/\u001b\t\u0005\u0003/\ny&\u0004\u0002\u0002Z)!\u00111KA.\u0015\u0011\ti&a\r\u0002\u0007\u0005D7-\u0003\u0003\u0002b\u0005e#aA+sS\"9\u0011Q\r\u0007A\u0002\u0005\u001d\u0014A\u0004:fgB|gn]3Ti\u0006$Xo\u001d\t\u0005\u0003S\nI(\u0004\u0002\u0002l)\u0019Q#!\u001c\u000b\t\u0005=\u0014\u0011O\u0001\u0006G>$Wm\u0019\u0006\u0005\u0003g\n)(A\u0004iC:$G.\u001a:\u000b\u0007\u0005]\u0004$A\u0003oKR$\u00180\u0003\u0003\u0002|\u0005-$A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukNDq!a \r\u0001\u0004\t\t)\u0001\nmCN$Xj\u001c3jM&,Gm\u0014:Fi\u0006<\u0007\u0003\u0002\u0011H\u0003\u0007\u0003B!!\"\u0002\u000e:!\u0011qQAE!\t1\u0014%C\u0002\u0002\f\u0006\na\u0001\u0015:fI\u00164\u0017\u0002BAH\u0003#\u0013aa\u0015;sS:<'bAAFC!9\u0011Q\u0013\u0007A\u0002\u0005\r\u0015aB2p]R,g\u000e\u001e\u0005\u000692\u0001\r!\u0018\u0005\u0006g2\u0001\r\u0001^\u0001\u0017EVLG\u000eZ#ya2L7-\u001b;SKN|WO]2fgR)1+a(\u0002*\"11)\u0004a\u0001\u0003C\u0003B\u0001\u000e\u001f\u0002$B\u0019Q+!*\n\u0007\u0005\u001dfK\u0001\bIiR\u0004(+Z9vKN$H)\u001a4\t\u000bqk\u0001\u0019A/\u0002%I,7o\\;sG\u0016\fum\u001a:fO\u0006$xN\u001d\u000b\u0007\u0003_\u000b9,a0\u0011\t\u0001:\u0015\u0011\u0017\t\u00049\u0005M\u0016bAA[%\t\u0011\"+Z:pkJ\u001cW-Q4he\u0016<\u0017\r^8s\u0011\u001d\t\u0019B\u0004a\u0001\u0003s\u0003B!a\u0004\u0002<&!\u0011QXA\t\u0005\u0019AE\u000f\u001e9Uq\"1\u0011\u0011\u0019\bA\u0002M\u000b\u0011#\u001b8gKJ\u0014X\r\u001a*fg>,(oY3t\u0003\trWm\u001e*fg>,(oY3BO\u001e\u0014XmZ1u_J4uN]\"bG\",G\rU1hKR!\u0011qVAd\u0011\u001d\t\u0019b\u0004a\u0001\u0003s\u000b1E\\3x%\u0016\u001cx.\u001e:dK\u0006;wM]3hCR|'OR8s\r\u0016$8\r[3e!\u0006<W\r\u0006\u0005\u00020\u00065\u0017qZAi\u0011\u001d\ti\u0004\u0005a\u0001\u0003\u007fAq!a\u0005\u0011\u0001\u0004\tI\fC\u0004\u0002TB\u0001\r!!6\u0002\rM$\u0018\r^;t!\u0011\t9.!9\u000e\u0005\u0005e'\u0002BAn\u0003;\fQa\u001d;biNT1!a8\u0017\u0003\u001d\u0019w.\\7p]NLA!a9\u0002Z\n11\u000b^1ukN\u0004")
public class ResourceFetcher
implements StrictLogging {
    private final CoreComponents coreComponents;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final HttpTxExecutor httpTxExecutor;
    private final Logger logger;

    public static List<HttpRequest> resourcesToRequests(List<ConcurrentResource> list, Session session, HttpCaches httpCaches, HttpProtocol httpProtocol, boolean bl, GatlingConfiguration gatlingConfiguration) {
        return ResourceFetcher$.MODULE$.resourcesToRequests(list, session, httpCaches, httpProtocol, bl, gatlingConfiguration);
    }

    public static List<ConcurrentResource> applyResourceFilters(List<ConcurrentResource> list, Option<Filters> option) {
        return ResourceFetcher$.MODULE$.applyResourceFilters(list, option);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<HttpRequest> inferPageResources(Request request, Response response, Session session, boolean throttled) {
        Nil$ nil$;
        Uri htmlDocumentUri = request.getUri();
        HttpResponseStatus httpResponseStatus = response.status();
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = response.lastModifiedOrEtag(this.httpProtocol);
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, htmlDocumentUri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> this.inferredResourcesRequests$1(htmlDocumentUri, response, request, session, throttled));
            } else {
                list = this.inferredResourcesRequests$1(htmlDocumentUri, response, request, session, throttled);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, htmlDocumentUri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{htmlDocumentUri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    public List<HttpRequest> cssFetched(Uri uri, HttpResponseStatus responseStatus, Option<String> lastModifiedOrEtag, String content, Session session, boolean throttled) {
        Nil$ nil$;
        HttpResponseStatus httpResponseStatus = responseStatus;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.OK;
        HttpResponseStatus httpResponseStatus3 = httpResponseStatus;
        if (!(httpResponseStatus2 != null ? !httpResponseStatus2.equals(httpResponseStatus3) : httpResponseStatus3 != null)) {
            List<HttpRequest> list;
            Option<String> option = lastModifiedOrEtag;
            if (option instanceof Some) {
                Some some = (Some)option;
                String newLastModifiedOrEtag = (String)some.value();
                list = this.httpCaches.computeInferredResourcesIfAbsent(this.httpProtocol, uri, newLastModifiedOrEtag, (Function0<List<HttpRequest>>)(Function0 & Serializable & scala.Serializable)() -> {
                    $this.httpCaches.removeCssResources(uri);
                    return this.parseCssResources$1(content, uri, session, throttled);
                });
            } else {
                list = this.parseCssResources$1(content, uri, session, throttled);
            }
            nil$ = list;
        } else {
            HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.NOT_MODIFIED;
            HttpResponseStatus httpResponseStatus5 = httpResponseStatus;
            if (!(httpResponseStatus4 != null ? !httpResponseStatus4.equals(httpResponseStatus5) : httpResponseStatus5 != null)) {
                Nil$ nil$2;
                InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(this.httpProtocol, uri);
                if (inferredPageResources == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isWarnEnabled()) {
                        this.logger().underlying().warn("Got a 304 for {} but could find cache entry?!", new Object[]{uri});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    nil$2 = Nil$.MODULE$;
                } else {
                    nil$2 = inferredPageResources.requests();
                }
                nil$ = nil$2;
            } else {
                nil$ = Nil$.MODULE$;
            }
        }
        return nil$;
    }

    private List<HttpRequest> buildExplicitResources(List<HttpRequestDef> resources, Session session) {
        return (List)resources.flatMap((Function1 & Serializable & scala.Serializable)resource -> {
            Iterable iterable;
            Validation validation = (Validation)resource.requestName().apply((Object)session);
            if (validation instanceof Success) {
                Iterable iterable2;
                Success success = (Success)validation;
                String requestName = (String)success.value();
                Validation<HttpRequest> validation2 = resource.build(requestName, session);
                if (validation2 instanceof Success) {
                    Success success2 = (Success)validation2;
                    HttpRequest httpRequest = (HttpRequest)success2.value();
                    iterable2 = Option$.MODULE$.option2Iterable((Option)new Some((Object)httpRequest));
                } else if (validation2 instanceof Failure) {
                    Failure failure = (Failure)validation2;
                    String m = failure.message();
                    $this.coreComponents.statsEngine().reportUnbuildableRequest(session, requestName, m);
                    iterable2 = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                } else {
                    throw new MatchError(validation2);
                }
                iterable = iterable2;
            } else if (validation instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)validation;
                String m = failure.message();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(47).append("Could build request name for explicitResource: ").append(m).toString());
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else {
                throw new MatchError((Object)validation);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom());
    }

    private Option<ResourceAggregator> resourceAggregator(HttpTx tx, List<HttpRequest> inferredResources) {
        None$ none$;
        List<HttpRequest> list;
        List<HttpRequest> explicitResources = tx.request().requestConfig().explicitResources().nonEmpty() ? this.buildExplicitResources(tx.request().requestConfig().explicitResources(), tx.session()) : Nil$.MODULE$;
        List list2 = explicitResources.$colon$colon$colon(list = inferredResources);
        if (Nil$.MODULE$.equals(list2)) {
            none$ = None$.MODULE$;
        } else {
            List filteredResources;
            Tuple2 tuple2 = (Tuple2)list2.foldLeft((Object)new Tuple2((Object)Predef$.MODULE$.Set().empty(), (Object)List$.MODULE$.empty()), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = new Tuple2(x0$1, x1$1);
                if (tuple22 == null) throw new MatchError((Object)tuple22);
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                HttpRequest request = (HttpRequest)tuple22._2();
                if (tuple23 == null) throw new MatchError((Object)tuple22);
                Set urls = (Set)tuple23._1();
                List requests = (List)tuple23._2();
                String newUrl = request.clientRequest().getUri().toUrl();
                if (urls.contains((Object)newUrl)) {
                    tuple2 = new Tuple2((Object)urls, (Object)requests);
                    return tuple2;
                } else {
                    HttpRequest httpRequest = request;
                    Tuple2 tuple24 = new Tuple2((Object)urls.$plus((Object)newUrl), (Object)requests.$colon$colon((Object)httpRequest));
                    tuple2 = tuple24;
                }
                return tuple2;
            });
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            List list3 = filteredResources = (List)tuple2._2();
            List filteredResources2 = list3;
            none$ = new Some((Object)new DefaultResourceAggregator(tx, (Seq<HttpRequest>)filteredResources2.reverse(), this.httpCaches, this, this.httpTxExecutor, this.coreComponents.clock(), this.coreComponents.configuration()));
        }
        return none$;
    }

    public Option<ResourceAggregator> newResourceAggregatorForCachedPage(HttpTx tx) {
        InferredPageResources inferredPageResources = this.httpCaches.getCachedInferredResources(tx.request().requestConfig().httpProtocol(), tx.request().clientRequest().getUri());
        List<HttpRequest> list = inferredPageResources == null ? Nil$.MODULE$ : inferredPageResources.requests();
        List<HttpRequest> inferredResources = list;
        return this.resourceAggregator(tx, inferredResources);
    }

    public Option<ResourceAggregator> newResourceAggregatorForFetchedPage(Response response, HttpTx tx, Status status) {
        Option<ResourceAggregator> option;
        Status status2 = status;
        KO$ kO$ = KO$.MODULE$;
        if (!(status2 != null ? !status2.equals(kO$) : kO$ != null)) {
            option = None$.MODULE$;
        } else {
            List<HttpRequest> inferredResources = this.httpProtocol.responsePart().inferHtmlResources() && HttpHelper$.MODULE$.isHtml(response.headers()) ? this.inferPageResources(tx.request().clientRequest(), response, tx.session(), tx.request().requestConfig().throttled()) : Nil$.MODULE$;
            option = this.resourceAggregator(tx, inferredResources);
        }
        return option;
    }

    private final List inferredResourcesRequests$1(Uri htmlDocumentUri$1, Response response$1, Request request$1, Session session$2, boolean throttled$2) {
        List<ConcurrentResource> inferred = new HtmlParser().getEmbeddedResources(htmlDocumentUri$1, response$1.body().chars(), UserAgent$.MODULE$.getAgent(request$1));
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$2, this.httpCaches, this.httpProtocol, throttled$2, this.coreComponents.configuration());
    }

    private final List parseCssResources$1(String content$1, Uri uri$1, Session session$3, boolean throttled$3) {
        Function1 & Serializable & scala.Serializable computer = (Function1 & Serializable & scala.Serializable)x$2 -> CssParser$.MODULE$.extractResources((Uri)x$2, content$1);
        List<ConcurrentResource> inferred = this.httpCaches.computeCssResourcesIfAbsent(uri$1, (Function1<Uri, List<ConcurrentResource>>)computer);
        List<ConcurrentResource> filtered = ResourceFetcher$.MODULE$.applyResourceFilters(inferred, this.httpProtocol.responsePart().htmlResourcesInferringFilters());
        return ResourceFetcher$.MODULE$.resourcesToRequests(filtered, session$3, this.httpCaches, this.httpProtocol, throttled$3, this.coreComponents.configuration());
    }

    public ResourceFetcher(CoreComponents coreComponents, HttpCaches httpCaches, HttpProtocol httpProtocol, HttpTxExecutor httpTxExecutor) {
        this.coreComponents = coreComponents;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.httpTxExecutor = httpTxExecutor;
        StrictLogging.$init$((StrictLogging)this);
    }
}

