/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import io.gatling.core.config.HttpConfiguration;
import io.gatling.http.util.SslContexts;
import io.gatling.http.util.SslContextsFactory$;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.io.Serializable;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mr!B\u0001\u0003\u0011\u0003Y\u0011AE*tY\u000e{g\u000e^3yiN4\u0015m\u0019;pefT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000b\u0019\tA\u0001\u001b;ua*\u0011q\u0001C\u0001\bO\u0006$H.\u001b8h\u0015\u0005I\u0011AA5p\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011!cU:m\u0007>tG/\u001a=ug\u001a\u000b7\r^8ssN\u0011Q\u0002\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]iA\u0011\u0001\r\u0002\rqJg.\u001b;?)\u0005Y\u0001b\u0002\u000e\u000e\u0005\u0004%IaG\u0001\u0017\t\u00164\u0017-\u001e7u'Nd7+Z2ve\u0016\u0014\u0016M\u001c3p[V\tA\u0004\u0005\u0002\u001eE5\taD\u0003\u0002 A\u0005A1/Z2ve&$\u0018PC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001D*fGV\u0014XMU1oI>l\u0007BB\u0013\u000eA\u0003%A$A\fEK\u001a\fW\u000f\u001c;Tg2\u001cVmY;sKJ\u000bg\u000eZ8nA!9q%\u0004b\u0001\n\u0013A\u0013\u0001\u0006#fM\u0006,H\u000e\u001e+skN$X*\u00198bO\u0016\u00148/F\u0001*!\r\t\"\u0006L\u0005\u0003WI\u0011Q!\u0011:sCf\u0004\"!\f\u001b\u000e\u00039R!a\f\u0019\u0002\u0007M\u001cHN\u0003\u00022e\u0005\u0019a.\u001a;\u000b\u0003M\nQA[1wCbL!!\u000e\u0018\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:\t\r]j\u0001\u0015!\u0003*\u0003U!UMZ1vYR$&/^:u\u001b\u0006t\u0017mZ3sg\u0002Bq!O\u0007C\u0002\u0013%!(A\u0002Ba:,\u0012a\u000f\t\u0003y\tk\u0011!\u0010\u0006\u0003_yR!a\u0010!\u0002\u000f!\fg\u000e\u001a7fe*\u0011\u0011\tC\u0001\u0006]\u0016$H/_\u0005\u0003\u0007v\u0012\u0011$\u00119qY&\u001c\u0017\r^5p]B\u0013x\u000e^8d_2\u001cuN\u001c4jO\"1Q)\u0004Q\u0001\nm\nA!\u00119oA!9q)\u0004b\u0001\n\u0013A\u0015\u0001E*vaB|'\u000f^3e\u0007&\u0004\b.\u001a:t+\u0005I\u0005cA\t+\u0015B\u00111J\u0015\b\u0003\u0019B\u0003\"!\u0014\n\u000e\u00039S!a\u0014\u0006\u0002\rq\u0012xn\u001c;?\u0013\t\t&#\u0001\u0004Qe\u0016$WMZ\u0005\u0003'R\u0013aa\u0015;sS:<'BA)\u0013\u0011\u00191V\u0002)A\u0005\u0013\u0006\t2+\u001e9q_J$X\rZ\"ja\",'o\u001d\u0011\u0007\t9\u0011\u0001\u0001W\n\u0003/BA\u0001BW,\u0003\u0002\u0003\u0006IaW\u0001\u000bQR$\boQ8oM&<\u0007C\u0001/b\u001b\u0005i&B\u00010`\u0003\u0019\u0019wN\u001c4jO*\u0011\u0001MB\u0001\u0005G>\u0014X-\u0003\u0002c;\n\t\u0002\n\u001e;q\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000b]9F\u0011\u00013\u0015\u0005\u00154\u0007C\u0001\u0007X\u0011\u0015Q6\r1\u0001\\\u0011\u001dAwK1A\u0005\n%\f\u0001d]:m'\u0016\u001c8/[8o)&lWm\\;u'\u0016\u001cwN\u001c3t+\u0005Q\u0007CA\tl\u0013\ta'C\u0001\u0003M_:<\u0007B\u00028XA\u0003%!.A\rtg2\u001cVm]:j_:$\u0016.\\3pkR\u001cVmY8oIN\u0004\u0003b\u00029X\u0005\u0004%I\u0001S\u0001\u0011K:\f'\r\\3e!J|Go\\2pYNDaA],!\u0002\u0013I\u0015!E3oC\ndW\r\u001a)s_R|7m\u001c7tA!9Ao\u0016b\u0001\n\u0013)\u0018aE3oC\ndW\rZ\"ja\",'oU;ji\u0016\u001cX#\u0001<\u0011\u0007]L(*D\u0001y\u0015\t\u0019\u0001%\u0003\u0002{q\n!A*[:u\u0011\u0019ax\u000b)A\u0005m\u0006!RM\\1cY\u0016$7)\u001b9iKJ\u001cV/\u001b;fg\u0002BqA`,C\u0002\u0013%\u0001*\u0001\rf]\u0006\u0014G.\u001a3DSBDWM]*vSR,7/\u0011:sCfDq!!\u0001XA\u0003%\u0011*A\rf]\u0006\u0014G.\u001a3DSBDWM]*vSR,7/\u0011:sCf\u0004\u0003bBA\u0003/\u0012\u0005\u0011qA\u0001\u000f]\u0016<8k\u001d7D_:$X\r\u001f;t)\u0011\tI!a\u0004\u0011\u00071\tY!C\u0002\u0002\u000e\t\u00111bU:m\u0007>tG/\u001a=ug\"A\u0011\u0011CA\u0002\u0001\u0004\t\u0019\"\u0001\u0007iiR\u0004('\u00128bE2,G\rE\u0002\u0012\u0003+I1!a\u0006\u0013\u0005\u001d\u0011un\u001c7fC:Dq!a\u0007X\t\u0013\ti\"A\u0007oK^\u001c6\u000f\\\"p]R,\u0007\u0010\u001e\u000b\u0007\u0003?\t)#a\f\u0011\u0007q\n\t#C\u0002\u0002$u\u0012!bU:m\u0007>tG/\u001a=u\u0011!\t9#!\u0007A\u0002\u0005%\u0012!\u00046eWN\u001bHnQ8oi\u0016DH\u000fE\u0002.\u0003WI1!!\f/\u0005)\u00196\u000bT\"p]R,\u0007\u0010\u001e\u0005\b\u0003c\tI\u00021\u0001<\u0003\r\t\u0007O\u001c")
public class SslContextsFactory {
    private final HttpConfiguration httpConfig;
    private final long sslSessionTimeoutSeconds;
    private final String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    private final List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    private final String[] enabledCipherSuitesArray;

    private long sslSessionTimeoutSeconds() {
        return this.sslSessionTimeoutSeconds;
    }

    public String[] io$gatling$http$util$SslContextsFactory$$enabledProtocols() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledProtocols;
    }

    public List<String> io$gatling$http$util$SslContextsFactory$$enabledCipherSuites() {
        return this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites;
    }

    private String[] enabledCipherSuitesArray() {
        return this.enabledCipherSuitesArray;
    }

    public SslContexts newSslContexts(boolean http2Enabled) {
        SslContexts sslContexts;
        if (this.httpConfig.advanced().useOpenSsl()) {
            BoxedUnit boxedUnit;
            SslContextBuilder sslContextBuilder = SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL);
            Object object = this.httpConfig.advanced().sslSessionCacheSize() > 0 ? sslContextBuilder.sessionCacheSize((long)this.httpConfig.advanced().sslSessionCacheSize()) : BoxedUnit.UNIT;
            Object object2 = this.httpConfig.advanced().sslSessionTimeout().$greater((Object)Duration$.MODULE$.Zero()) ? sslContextBuilder.sessionTimeout(this.sslSessionTimeoutSeconds()) : BoxedUnit.UNIT;
            Object object3 = this.io$gatling$http$util$SslContextsFactory$$enabledProtocols().length > 0 ? sslContextBuilder.protocols(this.io$gatling$http$util$SslContextsFactory$$enabledProtocols()) : BoxedUnit.UNIT;
            SslContextBuilder sslContextBuilder2 = this.httpConfig.advanced().sslEnabledCipherSuites().nonEmpty() ? sslContextBuilder.ciphers(this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites()) : sslContextBuilder.ciphers(null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS);
            this.httpConfig.ssl().keyManagerFactory().foreach((Function1 & Serializable & scala.Serializable)x$1 -> sslContextBuilder.keyManager(x$1));
            Option option = this.httpConfig.ssl().trustManagerFactory();
            if (option instanceof Some) {
                Some some = (Some)option;
                TrustManagerFactory tmf = (TrustManagerFactory)some.value();
                boxedUnit = sslContextBuilder.trustManager(tmf);
            } else {
                boxedUnit = this.httpConfig.advanced().useInsecureTrustManager() ? sslContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE) : BoxedUnit.UNIT;
            }
            SslContext sslContext = sslContextBuilder.build();
            if (http2Enabled) {
                SslContext alpnSslContext = sslContextBuilder.applicationProtocolConfig(SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn()).build();
                sslContexts = new SslContexts(sslContext, (Option<SslContext>)new Some((Object)alpnSslContext));
            } else {
                sslContexts = new SslContexts(sslContext, (Option<SslContext>)None$.MODULE$);
            }
        } else {
            SSLContext jdkSslContext = SSLContext.getInstance("TLS");
            jdkSslContext.init((KeyManager[])this.httpConfig.ssl().keyManagerFactory().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getKeyManagers()).orNull(Predef$.MODULE$.$conforms()), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultTrustManagers(), SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$DefaultSslSecureRandom());
            SslContext sslContext = this.newSslContext(jdkSslContext, null);
            None$ alpnSslContext = http2Enabled ? new Some((Object)this.newSslContext(jdkSslContext, SslContextsFactory$.MODULE$.io$gatling$http$util$SslContextsFactory$$Apn())) : None$.MODULE$;
            sslContexts = new SslContexts(sslContext, (Option<SslContext>)alpnSslContext);
        }
        return sslContexts;
    }

    private SslContext newSslContext(SSLContext jdkSslContext, ApplicationProtocolConfig apn) {
        return new DelegatingSslContext(this, jdkSslContext, apn){
            private final /* synthetic */ SslContextsFactory $outer;

            public void initEngine(SSLEngine engine) {
                block0: {
                    if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols())).nonEmpty()) break block0;
                    engine.setEnabledProtocols(this.$outer.io$gatling$http$util$SslContextsFactory$$enabledProtocols());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                super((SslContext)new JdkSslContext(jdkSslContext$1, true, $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites().isEmpty() ? null : $outer.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites(), (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE_DEFAULTING_TO_SUPPORTED_CIPHERS, apn$1, ClientAuth.NONE));
            }
        };
    }

    public SslContextsFactory(HttpConfiguration httpConfig) {
        this.httpConfig = httpConfig;
        this.sslSessionTimeoutSeconds = httpConfig.advanced().sslSessionTimeout().toSeconds();
        this.io$gatling$http$util$SslContextsFactory$$enabledProtocols = (String[])httpConfig.advanced().sslEnabledProtocols().toArray(ClassTag$.MODULE$.apply(String.class));
        this.io$gatling$http$util$SslContextsFactory$$enabledCipherSuites = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)httpConfig.advanced().sslEnabledCipherSuites()).asJava();
        this.enabledCipherSuitesArray = (String[])httpConfig.advanced().sslEnabledCipherSuites().toArray(ClassTag$.MODULE$.apply(String.class));
    }
}

