/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Failure;
import io.gatling.core.session.Session;
import io.gatling.http.cache.HttpCaches;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.cookie.CookieSupport$;
import io.gatling.http.engine.response.CheckProcessor$;
import io.gatling.http.protocol.HttpProtocol;
import io.gatling.http.response.Response;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Md!B\u0001\u0003\u0003Ci!\u0001E*fgNLwN\u001c)s_\u000e,7o]8s\u0015\t\u0019A!\u0001\u0005sKN\u0004xN\\:f\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\tA\u0001\u001b;ua*\u0011\u0011BC\u0001\bO\u0006$H.\u001b8h\u0015\u0005Y\u0011AA5p\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012!\u00038piNKG.\u001a8u!\tyq#\u0003\u0002\u0019!\t9!i\\8mK\u0006t\u0007\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002\u000fI,\u0017/^3tiB\u0011AdH\u0007\u0002;)\u0011aDB\u0001\u0007G2LWM\u001c;\n\u0005\u0001j\"a\u0002*fcV,7\u000f\u001e\u0005\tE\u0001\u0011\t\u0011)A\u0005G\u000511\r[3dWN\u00042\u0001\n\u00170\u001d\t)#F\u0004\u0002'S5\tqE\u0003\u0002)\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003WA\tq\u0001]1dW\u0006<W-\u0003\u0002.]\t!A*[:u\u0015\tY\u0003\u0003\u0005\u00021g5\t\u0011G\u0003\u00023\r\u0005)1\r[3dW&\u0011A'\r\u0002\n\u0011R$\bo\u00115fG.D\u0001B\u000e\u0001\u0003\u0002\u0003\u0006IaN\u0001\u000bQR$\boQ1dQ\u0016\u001c\bC\u0001\u001d<\u001b\u0005I$B\u0001\u001e\u0007\u0003\u0015\u0019\u0017m\u00195f\u0013\ta\u0014H\u0001\u0006IiR\u00048)Y2iKND\u0001B\u0010\u0001\u0003\u0002\u0003\u0006IaP\u0001\rQR$\b\u000f\u0015:pi>\u001cw\u000e\u001c\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0003\u0005\u001a\t\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003\t\u0006\u0013A\u0002\u0013;uaB\u0013x\u000e^8d_2D\u0001B\u0012\u0001\u0003\u0002\u0003\u0006IaR\u0001\u0006G2|7m\u001b\t\u0003\u00116k\u0011!\u0013\u0006\u0003\u0015.\u000bA!\u001e;jY*\u0011A\nC\u0001\bG>lWn\u001c8t\u0013\tq\u0015JA\u0003DY>\u001c7\u000eC\u0003Q\u0001\u0011\u0005\u0011+\u0001\u0004=S:LGO\u0010\u000b\b%R+fk\u0016-Z!\t\u0019\u0006!D\u0001\u0003\u0011\u0015)r\n1\u0001\u0017\u0011\u0015Qr\n1\u0001\u001c\u0011\u0015\u0011s\n1\u0001$\u0011\u00151t\n1\u00018\u0011\u0015qt\n1\u0001@\u0011\u00151u\n1\u0001H\u0011\u0015Y\u0006\u0001\"\u0001]\u0003Q)\b\u000fZ1uKN+7o]5p]\u000e\u0013\u0018m\u001d5fIR!Q,\u001a4l!\tq6-D\u0001`\u0015\t\u0001\u0017-A\u0004tKN\u001c\u0018n\u001c8\u000b\u0005\tD\u0011\u0001B2pe\u0016L!\u0001Z0\u0003\u000fM+7o]5p]\")\u0001M\u0017a\u0001;\")qM\u0017a\u0001Q\u0006q1\u000f^1siRKW.Z:uC6\u0004\bCA\bj\u0013\tQ\u0007C\u0001\u0003M_:<\u0007\"\u00027[\u0001\u0004A\u0017\u0001D3oIRKW.Z:uC6\u0004\b\"\u00028\u0001\t\u0013y\u0017AE;qI\u0006$XmU3tg&|gn\u0015;biN$R!\u00189reNDQ\u0001Y7A\u0002uCQaZ7A\u0002!DQ\u0001\\7A\u0002!DQ\u0001^7A\u0002U\faa\u001d;biV\u001c\bC\u0001<z\u001b\u00059(B\u0001=L\u0003\u0015\u0019H/\u0019;t\u0013\tQxO\u0001\u0004Ti\u0006$Xo\u001d\u0005\u0006y\u0002!\t!`\u0001\u000fkB$\u0017\r^3e'\u0016\u001c8/[8o)\u0015q\u0018\u0011DA\u000e!\u0015yq0XA\u0002\u0013\r\t\t\u0001\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b=\t)!!\u0003\n\u0007\u0005\u001d\u0001C\u0001\u0004PaRLwN\u001c\t\u0005\u0003\u0017\t\u0019B\u0004\u0003\u0002\u000e\u0005=\u0001C\u0001\u0014\u0011\u0013\r\t\t\u0002E\u0001\u0007!J,G-\u001a4\n\t\u0005U\u0011q\u0003\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005E\u0001\u0003C\u0003aw\u0002\u0007Q\f\u0003\u0004\u0004w\u0002\u0007\u0011Q\u0004\t\u0005\u0003?\t\u0019#\u0004\u0002\u0002\")\u00111AB\u0005\u0005\u0003K\t\tC\u0001\u0005SKN\u0004xN\\:f\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\ta#\u001e9eCR,GMU3eSJ,7\r^*fgNLwN\u001c\u000b\b;\u00065\u0012qFA\u0019\u0011\u0019\u0001\u0017q\u0005a\u0001;\"91!a\nA\u0002\u0005u\u0001\u0002CA\u001a\u0003O\u0001\r!!\u000e\u0002\u0017I,G-\u001b:fGR,&/\u001b\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\r)(/\u001b\u0006\u0004\u0003\u007fi\u0012aA1iG&!\u00111IA\u001d\u0005\r)&/\u001b\u0005\b\u0003\u000f\u0002A\u0011BA%\u00035\u0019\u0017m\u00195f%\u0016$\u0017N]3diR9Q,a\u0013\u0002N\u0005=\u0003B\u00021\u0002F\u0001\u0007Q\fC\u0004\u0004\u0003\u000b\u0002\r!!\b\t\u0011\u0005M\u0012Q\ta\u0001\u0003kAq!a\u0015\u0001\r#\t)&A\u0007va\u0012\fG/\u001a*fM\u0016\u0014XM\u001d\u000b\u0006;\u0006]\u0013\u0011\f\u0005\u0007A\u0006E\u0003\u0019A/\t\u000f\r\t\t\u00061\u0001\u0002\u001e!9\u0011Q\f\u0001\u0007\u0012\u0005}\u0013\u0001E;qI\u0006$Xm\u0012:pkB\u001cF/\u0019;t)%i\u0016\u0011MA2\u0003K\n9\u0007\u0003\u0004a\u00037\u0002\r!\u0018\u0005\u0007O\u0006m\u0003\u0019\u00015\t\r1\fY\u00061\u0001i\u0011\u0019!\u00181\fa\u0001k&*\u0001!a\u001b\u0002p%\u0019\u0011Q\u000e\u0002\u00031I+7o\\;sG\u0016\u001cVm]:j_:\u0004&o\\2fgN|'/C\u0002\u0002r\t\u0011ACU8piN+7o]5p]B\u0013xnY3tg>\u0014\b")
public abstract class SessionProcessor {
    private final boolean notSilent;
    private final Request request;
    private final List<HttpCheck> checks;
    private final HttpCaches httpCaches;
    private final HttpProtocol httpProtocol;
    private final Clock clock;

    public Session updateSessionCrashed(Session session, long startTimestamp, long endTimestamp) {
        return this.updateSessionStats(session, startTimestamp, endTimestamp, (Status)KO$.MODULE$);
    }

    private Session updateSessionStats(Session session, long startTimestamp, long endTimestamp, Status status) {
        Session session2;
        if (this.notSilent) {
            Status status2 = status;
            KO$ kO$ = KO$.MODULE$;
            Session sessionWithUpdatedStatus = !(status2 != null ? !status2.equals(kO$) : kO$ != null) ? session.markAsFailed() : session;
            session2 = this.updateGroupStats(sessionWithUpdatedStatus, startTimestamp, endTimestamp, status);
        } else {
            session2 = session;
        }
        return session2;
    }

    public Tuple2<Session, Option<String>> updatedSession(Session session, Response response) {
        Tuple2<Session, Option<Failure>> tuple2 = CheckProcessor$.MODULE$.check(session, response, this.checks);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Session sessionWithCheckSavedValues = (Session)tuple2._1();
        Option checkError = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)sessionWithCheckSavedValues, (Object)checkError);
        Tuple2 tuple23 = tuple22;
        Session sessionWithCheckSavedValues2 = (Session)tuple23._1();
        Option checkError2 = (Option)tuple23._2();
        Session sessionWithHttp2PriorKnowledge = this.httpProtocol.enginePart().enableHttp2() ? this.httpCaches.updateSessionHttp2PriorKnowledge(sessionWithCheckSavedValues2, response) : sessionWithCheckSavedValues2;
        KO$ newStatus = checkError2.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
        Session newSession = this.updateSessionAfterChecks$1(sessionWithHttp2PriorKnowledge, (Status)newStatus, response);
        return new Tuple2((Object)newSession, (Object)checkError2.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.message()));
    }

    public Session updatedRedirectSession(Session session, Response response, Uri redirectUri) {
        Session sessionWithCookieStoreUpdate = CookieSupport$.MODULE$.storeCookies(session, this.request.getUri(), response.cookies(), this.clock.nowMillis());
        Session sessionWithGroupUpdate = this.updateSessionStats(sessionWithCookieStoreUpdate, response.startTimestamp(), response.endTimestamp(), (Status)OK$.MODULE$);
        return this.cacheRedirect(sessionWithGroupUpdate, response, redirectUri);
    }

    private Session cacheRedirect(Session session, Response response, Uri redirectUri) {
        return this.httpProtocol.requestPart().cache() && HttpHelper$.MODULE$.isPermanentRedirect(response.status()) ? this.httpCaches.addRedirect(session, this.request, redirectUri) : session;
    }

    public abstract Session updateReferer(Session var1, Response var2);

    public abstract Session updateGroupStats(Session var1, long var2, long var4, Status var6);

    private final Session updateSessionAfterChecks$1(Session s1, Status status, Response response$1) {
        Session s2 = CookieSupport$.MODULE$.storeCookies(s1, this.request.getUri(), response$1.cookies(), this.clock.nowMillis());
        Session s3 = this.updateReferer(s2, response$1);
        Session s4 = this.httpCaches.cacheContent(s3, this.httpProtocol, this.request, response$1);
        return this.updateSessionStats(s4, response$1.startTimestamp(), response$1.endTimestamp(), status);
    }

    public SessionProcessor(boolean notSilent, Request request, List<HttpCheck> checks, HttpCaches httpCaches, HttpProtocol httpProtocol, Clock clock) {
        this.notSilent = notSilent;
        this.request = request;
        this.checks = checks;
        this.httpCaches = httpCaches;
        this.httpProtocol = httpProtocol;
        this.clock = clock;
    }
}

