/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.engine.response;

import com.softwaremill.quicklens.package;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.commons.util.Throwables;
import io.gatling.commons.util.Throwables$;
import io.gatling.commons.validation.Failure;
import io.gatling.commons.validation.Success;
import io.gatling.commons.validation.Validation;
import io.gatling.commons.validation.package;
import io.gatling.commons.validation.package$;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.core.util.NameGen;
import io.gatling.http.HeaderNames$;
import io.gatling.http.client.Request;
import io.gatling.http.client.ahc.uri.Uri;
import io.gatling.http.engine.response.Crash;
import io.gatling.http.engine.response.NextExecutor;
import io.gatling.http.engine.response.Proceed;
import io.gatling.http.engine.response.ProcessorResult;
import io.gatling.http.engine.response.Redirect;
import io.gatling.http.engine.response.RedirectProcessor$;
import io.gatling.http.engine.response.ResponseProcessor;
import io.gatling.http.engine.response.SessionProcessor;
import io.gatling.http.engine.response.StatsProcessor;
import io.gatling.http.engine.tx.HttpTx;
import io.gatling.http.engine.tx.ResourceTx;
import io.gatling.http.request.HttpRequest;
import io.gatling.http.request.HttpRequestConfig;
import io.gatling.http.response.HttpFailure;
import io.gatling.http.response.HttpResult;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBuilder;
import io.gatling.http.util.HttpHelper$;
import java.io.Serializable;
import java.nio.charset.Charset;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011\u0001\u0004R3gCVdGOU3ta>t7/\u001a)s_\u000e,7o]8s\u0015\t\u0019A!\u0001\u0005sKN\u0004xN\\:f\u0015\t)a!\u0001\u0004f]\u001eLg.\u001a\u0006\u0003\u000f!\tA\u0001\u001b;ua*\u0011\u0011BC\u0001\bO\u0006$H.\u001b8h\u0015\u0005Y\u0011AA5p\u0007\u0001\u0019R\u0001\u0001\b\u00151\t\u0002\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0017\u001b\u0005\u0011\u0011BA\f\u0003\u0005E\u0011Vm\u001d9p]N,\u0007K]8dKN\u001cxN\u001d\t\u00033\u0001j\u0011A\u0007\u0006\u00037q\tAb]2bY\u0006dwnZ4j]\u001eT!!\b\u0010\u0002\u0011QL\b/Z:bM\u0016T\u0011aH\u0001\u0004G>l\u0017BA\u0011\u001b\u00055\u0019FO]5di2{wmZ5oOB\u00111\u0005K\u0007\u0002I)\u0011QEJ\u0001\u0005kRLGN\u0003\u0002(\u0011\u0005!1m\u001c:f\u0013\tICEA\u0004OC6,w)\u001a8\t\u0011-\u0002!\u0011!Q\u0001\n1\n!\u0001\u001e=\u0011\u00055zS\"\u0001\u0018\u000b\u0005-\"\u0011B\u0001\u0019/\u0005\u0019AE\u000f\u001e9Uq\"A!\u0007\u0001B\u0001B\u0003%1'\u0001\ttKN\u001c\u0018n\u001c8Qe>\u001cWm]:peB\u0011Q\u0003N\u0005\u0003k\t\u0011\u0001cU3tg&|g\u000e\u0015:pG\u0016\u001c8o\u001c:\t\u0011]\u0002!\u0011!Q\u0001\na\nab\u001d;biN\u0004&o\\2fgN|'\u000f\u0005\u0002\u0016s%\u0011!H\u0001\u0002\u000f'R\fGo\u001d)s_\u000e,7o]8s\u0011!a\u0004A!A!\u0002\u0013i\u0014\u0001\u00048fqR,\u00050Z2vi>\u0014\bCA\u000b?\u0013\ty$A\u0001\u0007OKb$X\t_3dkR|'\u000f\u0003\u0005B\u0001\t\u0005\t\u0015!\u0003C\u00039!WMZ1vYR\u001c\u0005.\u0019:tKR\u0004\"a\u0011&\u000e\u0003\u0011S!!\u0012$\u0002\u000f\rD\u0017M]:fi*\u0011q\tS\u0001\u0004]&|'\"A%\u0002\t)\fg/Y\u0005\u0003\u0017\u0012\u0013qa\u00115beN,G\u000fC\u0003N\u0001\u0011\u0005a*\u0001\u0004=S:LGO\u0010\u000b\u0007\u001fB\u000b&k\u0015+\u0011\u0005U\u0001\u0001\"B\u0016M\u0001\u0004a\u0003\"\u0002\u001aM\u0001\u0004\u0019\u0004\"B\u001cM\u0001\u0004A\u0004\"\u0002\u001fM\u0001\u0004i\u0004\"B!M\u0001\u0004\u0011\u0005\"\u0002,\u0001\t\u00039\u0016AC8o\u0007>l\u0007\u000f\\3uKR\u0011\u0001l\u0017\t\u0003\u001feK!A\u0017\t\u0003\tUs\u0017\u000e\u001e\u0005\u00069V\u0003\r!X\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0005y\u0003W\"A0\u000b\u0005\r1\u0011BA1`\u0005)AE\u000f\u001e9SKN,H\u000e\u001e\u0005\u0006G\u0002!I\u0001Z\u0001\u000eQ\u0006tG\r\\3GC&dWO]3\u0015\u0005a+\u0007\"\u00024c\u0001\u00049\u0017a\u00024bS2,(/\u001a\t\u0003=\"L!![0\u0003\u0017!#H\u000f\u001d$bS2,(/\u001a\u0005\u0006W\u0002!I\u0001\\\u0001\u000fQ\u0006tG\r\\3SKN\u0004xN\\:f)\tAV\u000eC\u0003\u0004U\u0002\u0007a\u000e\u0005\u0002__&\u0011\u0001o\u0018\u0002\t%\u0016\u001c\bo\u001c8tK\")!\u000f\u0001C\u0005g\u0006I\u0002.\u00198eY\u0016\u0014Vm\u001d9p]N,GK]1og\u001a|'/\\3s)\t!H\u0010E\u0002vu:l\u0011A\u001e\u0006\u0003ob\f!B^1mS\u0012\fG/[8o\u0015\tI\b\"A\u0004d_6lwN\\:\n\u0005m4(A\u0003,bY&$\u0017\r^5p]\")Q0\u001da\u0001]\u0006Y!/Y<SKN\u0004xN\\:f\u0011\u0019y\b\u0001\"\u0003\u0002\u0002\u0005y\u0001.\u00198eY\u0016\u0014Vm\u001d9p]N,\u0007\u0007\u0006\u0003\u0002\u0004\u0005%\u0001cA\u000b\u0002\u0006%\u0019\u0011q\u0001\u0002\u0003\u001fA\u0013xnY3tg>\u0014(+Z:vYRDQ! @A\u00029\u0004")
public class DefaultResponseProcessor
implements ResponseProcessor,
StrictLogging,
NameGen {
    private final HttpTx tx;
    private final SessionProcessor sessionProcessor;
    private final StatsProcessor statsProcessor;
    private final NextExecutor nextExecutor;
    private final Charset defaultCharset;
    private final Logger logger;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    @Override
    public void onComplete(HttpResult result) {
        HttpResult httpResult = result;
        if (httpResult instanceof Response) {
            Response response = (Response)httpResult;
            this.handleResponse(response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (httpResult instanceof HttpFailure) {
            HttpFailure httpFailure = (HttpFailure)httpResult;
            this.handleFailure(httpFailure);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)httpResult);
        }
    }

    private void handleFailure(HttpFailure failure) {
        block8: {
            Session sessionWithUpdatedStats = this.sessionProcessor.updateSessionCrashed(this.tx.session(), failure.startTimestamp(), failure.endTimestamp());
            try {
                try {
                    this.statsProcessor.reportStats(this.tx.fullRequestName(), this.tx.request().clientRequest(), sessionWithUpdatedStats, (Status)KO$.MODULE$, failure, (Option<String>)new Some((Object)failure.errorMessage()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        BoxedUnit boxedUnit;
                        Throwable t = (Throwable)option.get();
                        if (this.logger().underlying().isErrorEnabled()) {
                            this.logger().underlying().error(new StringBuilder(84).append("ResponseProcessor crashed while handling failure ").append(failure).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block8;
                    }
                    throw throwable;
                }
            }
            finally {
                this.nextExecutor.executeNextOnCrash(sessionWithUpdatedStats, failure.endTimestamp());
            }
        }
    }

    private void handleResponse(Response response) {
        Request clientRequest = this.tx.request().clientRequest();
        ProcessorResult processorResult = this.handleResponse0(response);
        if (processorResult instanceof Proceed) {
            Proceed proceed = (Proceed)processorResult;
            Session newSession = proceed.newSession();
            Option<String> errorMessage = proceed.error();
            KO$ status = errorMessage.isDefined() ? KO$.MODULE$ : OK$.MODULE$;
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)status, response, errorMessage);
            this.nextExecutor.executeNext(newSession, (Status)status, response);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Redirect) {
            Redirect redirect = (Redirect)processorResult;
            HttpTx redirectTx = redirect.redirectTx();
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, redirectTx.session(), (Status)OK$.MODULE$, response, (Option<String>)None$.MODULE$);
            this.nextExecutor.executeRedirect(redirectTx);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (processorResult instanceof Crash) {
            Crash crash = (Crash)processorResult;
            String errorMessage = crash.error();
            Session newSession = this.sessionProcessor.updateSessionCrashed(this.tx.session(), response.startTimestamp(), response.endTimestamp());
            this.statsProcessor.reportStats(this.tx.fullRequestName(), clientRequest, newSession, (Status)KO$.MODULE$, response, (Option<String>)new Some((Object)errorMessage));
            this.nextExecutor.executeNextOnCrash(newSession, response.endTimestamp());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)processorResult);
        }
    }

    private Validation<Response> handleResponseTransformer(Response rawResponse) {
        Validation validation;
        Option<Function2<Session, Response, Validation<Response>>> option = this.tx.request().requestConfig().responseTransformer();
        if (option instanceof Some) {
            Some some = (Some)option;
            Function2 transformer = (Function2)some.value();
            validation = package$.MODULE$.safely((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(30).append("Response transformer crashed: ").append((String)x$1).toString(), (Function0 & Serializable & scala.Serializable)() -> (Validation)transformer.apply((Object)$this.tx.session(), (Object)rawResponse));
        } else {
            validation = package.SuccessWrapper$.MODULE$.success$extension(package$.MODULE$.SuccessWrapper((Object)rawResponse));
        }
        return validation;
    }

    private ProcessorResult handleResponse0(Response rawResponse) {
        Crash crash;
        try {
            Crash crash2;
            Validation<Response> validation = this.handleResponseTransformer(rawResponse);
            if (validation instanceof Failure) {
                Failure failure = (Failure)validation;
                String errorMessage = failure.message();
                crash2 = new Crash(errorMessage);
            } else if (validation instanceof Success) {
                ProcessorResult processorResult;
                Success success = (Success)validation;
                Response response = (Response)success.value();
                if (HttpHelper$.MODULE$.isRedirect(response.status()) && this.tx.request().requestConfig().followRedirect()) {
                    if (this.tx.redirectCount() >= this.tx.request().requestConfig().maxRedirects()) {
                        processorResult = new Crash(new StringBuilder(27).append("Too many redirects, max is ").append(this.tx.request().requestConfig().maxRedirects()).toString());
                    } else {
                        Crash crash3;
                        Option<String> option = response.header(HeaderNames$.MODULE$.Location());
                        if (option instanceof Some) {
                            ProcessorResult processorResult2;
                            Some some = (Some)option;
                            String location = (String)some.value();
                            Uri redirectUri = HttpHelper$.MODULE$.resolveFromUri(this.tx.request().clientRequest().getUri(), location);
                            Session newSession = this.sessionProcessor.updatedRedirectSession(this.tx.session(), response, redirectUri);
                            Validation<Request> validation2 = RedirectProcessor$.MODULE$.redirectRequest(this.tx.request().clientRequest(), newSession, response.status(), this.tx.request().requestConfig().httpProtocol(), redirectUri, this.defaultCharset);
                            if (validation2 instanceof Success) {
                                Success success2 = (Success)validation2;
                                Request redirectRequest = (Request)success2.value();
                                HttpTx fresh$macro$45 = this.tx;
                                HttpTx fresh$macro$48 = (HttpTx)new package.PathModify((Object)fresh$macro$45, (Function2 & Serializable & scala.Serializable)(fresh$macro$43, fresh$macro$44) -> fresh$macro$43.copy((Session)fresh$macro$44.apply((Object)fresh$macro$43.session()), fresh$macro$43.copy$default$2(), fresh$macro$43.copy$default$3(), fresh$macro$43.copy$default$4(), fresh$macro$43.copy$default$5(), fresh$macro$43.copy$default$6())).setTo((Object)newSession);
                                HttpTx fresh$macro$51 = (HttpTx)new package.PathModify((Object)fresh$macro$48, (Function2 & Serializable & scala.Serializable)(fresh$macro$46, fresh$macro$47) -> {
                                    Request x$7 = (Request)fresh$macro$47.apply((Object)fresh$macro$46.request().clientRequest());
                                    String x$8 = fresh$macro$46.request().copy$default$1();
                                    HttpRequestConfig x$9 = fresh$macro$46.request().copy$default$3();
                                    HttpRequest x$10 = fresh$macro$46.request().copy(x$8, x$7, x$9);
                                    Session x$11 = fresh$macro$46.copy$default$1();
                                    Function1<Request, ResponseBuilder> x$12 = fresh$macro$46.copy$default$3();
                                    Action x$13 = fresh$macro$46.copy$default$4();
                                    Option<ResourceTx> x$14 = fresh$macro$46.copy$default$5();
                                    int x$15 = fresh$macro$46.copy$default$6();
                                    return fresh$macro$46.copy(x$11, x$10, x$12, x$13, x$14, x$15);
                                }).setTo((Object)redirectRequest);
                                processorResult2 = new Redirect((HttpTx)new package.PathModify((Object)fresh$macro$51, (Function2 & Serializable & scala.Serializable)(fresh$macro$49, fresh$macro$50) -> {
                                    int x$16 = fresh$macro$50.apply$mcII$sp(fresh$macro$49.redirectCount());
                                    Session x$17 = fresh$macro$49.copy$default$1();
                                    HttpRequest x$18 = fresh$macro$49.copy$default$2();
                                    Function1<Request, ResponseBuilder> x$19 = fresh$macro$49.copy$default$3();
                                    Action x$20 = fresh$macro$49.copy$default$4();
                                    Option<ResourceTx> x$21 = fresh$macro$49.copy$default$5();
                                    return fresh$macro$49.copy(x$17, x$18, x$19, x$20, x$21, x$16);
                                }).using((Function1)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$5 -> x$5 + 1));
                            } else if (validation2 instanceof Failure) {
                                Failure failure = (Failure)validation2;
                                String message = failure.message();
                                processorResult2 = new Crash(message);
                            } else {
                                throw new MatchError(validation2);
                            }
                            crash3 = processorResult2;
                        } else {
                            crash3 = new Crash("Redirect status, yet no Location header");
                        }
                        processorResult = crash3;
                    }
                } else {
                    Tuple2<Session, Option<String>> tuple2 = this.sessionProcessor.updatedSession(this.tx.session(), response);
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    Session newSession = (Session)tuple2._1();
                    Option errorMessage = (Option)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)newSession, (Object)errorMessage);
                    Tuple2 tuple23 = tuple22;
                    Session newSession2 = (Session)tuple23._1();
                    Option errorMessage2 = (Option)tuple23._2();
                    processorResult = new Proceed(newSession2, (Option<String>)errorMessage2);
                }
                crash2 = processorResult;
            } else {
                throw new MatchError(validation);
            }
            crash = crash2;
        }
        catch (Throwable throwable) {
            Throwable t;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                t = (Throwable)option.get();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(85).append("ResponseProcessor crashed while handling response ").append(rawResponse.status()).append(" on session=").append(this.tx.session()).append(" request=").append(this.tx.request().requestName()).append(": ").append(this.tx.request().clientRequest()).append(", forwarding").toString(), t);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            Crash crash4 = new Crash(Throwables.PimpedException$.MODULE$.detailedMessage$extension(Throwables$.MODULE$.PimpedException(t)));
            crash = crash4;
        }
        return crash;
    }

    public DefaultResponseProcessor(HttpTx tx, SessionProcessor sessionProcessor, StatsProcessor statsProcessor, NextExecutor nextExecutor, Charset defaultCharset) {
        this.tx = tx;
        this.sessionProcessor = sessionProcessor;
        this.statsProcessor = statsProcessor;
        this.nextExecutor = nextExecutor;
        this.defaultCharset = defaultCharset;
        StrictLogging.$init$((StrictLogging)this);
        NameGen.$init$((NameGen)this);
    }
}

