/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.action.sse.fsm;

import akka.actor.FSM;
import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.action.Action;
import io.gatling.core.session.Session;
import io.gatling.http.action.sse.fsm.Closing$;
import io.gatling.http.action.sse.fsm.ClosingData;
import io.gatling.http.action.sse.fsm.SseActor;
import io.gatling.http.action.sse.fsm.SseActorData;
import io.gatling.http.action.sse.fsm.SseActorState;
import io.gatling.http.action.sse.fsm.SseReceived;
import io.gatling.http.action.sse.fsm.SseStreamClosed;
import io.gatling.http.action.sse.fsm.SseStreamCrashed;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Serializable;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00012\u0001\"\u0001\u0002\u0011\u0002\u0007\u0005q\u0002\b\u0002\f/\",gn\u00117pg&twM\u0003\u0002\u0004\t\u0005\u0019am]7\u000b\u0005\u00151\u0011aA:tK*\u0011q\u0001C\u0001\u0007C\u000e$\u0018n\u001c8\u000b\u0005%Q\u0011\u0001\u00025uiBT!a\u0003\u0007\u0002\u000f\u001d\fG\u000f\\5oO*\tQ\"\u0001\u0002j_\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q\u0003\u0001C\u00011\u00051A%\u001b8ji\u0012\"\u0012!\u0007\t\u0003#iI!a\u0007\n\u0003\tUs\u0017\u000e\u001e\t\u0003;yi\u0011AA\u0005\u0003?\t\u0011\u0001bU:f\u0003\u000e$xN\u001d")
public interface WhenClosing {
    public static void $init$(WhenClosing $this) {
        ((FSM)$this).when((Object)Closing$.MODULE$, ((FSM)$this).when$default$2(), (PartialFunction)new Serializable((SseActor)$this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SseActor $outer;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends FSM.Event<SseActorData>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                FSM.State<SseActorState, SseActorData> state;
                A1 A1 = x1;
                if (A1 != null) {
                    SseActorData sseActorData = (SseActorData)A1.stateData();
                    if (A1.event() instanceof SseReceived && sseActorData instanceof ClosingData) {
                        ClosingData closingData = (ClosingData)sseActorData;
                        Session session = closingData.session();
                        this.$outer.logUnmatchedServerMessage(session);
                        state = this.$outer.stay();
                        return (B1)state;
                    }
                }
                if (A1 != null) {
                    Object object = A1.event();
                    SseActorData sseActorData = (SseActorData)A1.stateData();
                    if (object instanceof SseStreamClosed) {
                        SseStreamClosed sseStreamClosed = (SseStreamClosed)object;
                        long timestamp = sseStreamClosed.timestamp();
                        if (sseActorData instanceof ClosingData) {
                            BoxedUnit boxedUnit;
                            ClosingData closingData = (ClosingData)sseActorData;
                            String actionName = closingData.actionName();
                            Session session = closingData.session();
                            Action next = closingData.next();
                            long closeStart = closingData.timestamp();
                            if (this.$outer.logger().underlying().isInfoEnabled()) {
                                this.$outer.logger().underlying().info("Socket closed");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Session newSession = this.$outer.logResponse(session, actionName, closeStart, timestamp, (Status)OK$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$);
                            next.$bang(newSession.remove(this.$outer.wsName()));
                            state = this.$outer.stop();
                            return (B1)state;
                        }
                    }
                }
                if (A1 != null) {
                    Object object = A1.event();
                    SseActorData sseActorData = (SseActorData)A1.stateData();
                    if (object instanceof SseStreamCrashed) {
                        SseStreamCrashed sseStreamCrashed = (SseStreamCrashed)object;
                        Throwable t = sseStreamCrashed.t();
                        long timestamp = sseStreamCrashed.timestamp();
                        if (sseActorData instanceof ClosingData) {
                            BoxedUnit boxedUnit;
                            ClosingData closingData = (ClosingData)sseActorData;
                            String actionName = closingData.actionName();
                            Session session = closingData.session();
                            Action next = closingData.next();
                            long closeStart = closingData.timestamp();
                            if (this.$outer.logger().underlying().isInfoEnabled()) {
                                this.$outer.logger().underlying().info("SSE stream crashed while waiting for socket close");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                            Session newSession = this.$outer.logResponse(session, actionName, closeStart, timestamp, (Status)KO$.MODULE$, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)t.getMessage()));
                            next.$bang(newSession.markAsFailed().remove(this.$outer.wsName()));
                            state = this.$outer.stop();
                            return (B1)state;
                        }
                    }
                }
                state = function1.apply(x1);
                return (B1)state;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(FSM.Event<SseActorData> x1) {
                FSM.Event<SseActorData> event = x1;
                if (event != null) {
                    SseActorData sseActorData = (SseActorData)event.stateData();
                    if (event.event() instanceof SseReceived && sseActorData instanceof ClosingData) {
                        return true;
                    }
                }
                if (event != null) {
                    Object object = event.event();
                    SseActorData sseActorData = (SseActorData)event.stateData();
                    if (object instanceof SseStreamClosed && sseActorData instanceof ClosingData) {
                        return true;
                    }
                }
                if (event == null) return false;
                Object object = event.event();
                SseActorData sseActorData = (SseActorData)event.stateData();
                if (!(object instanceof SseStreamCrashed)) return false;
                if (!(sseActorData instanceof ClosingData)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

