/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.response;

import com.typesafe.scalalogging.Logger;
import io.gatling.commons.util.ClockSingleton$;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.commons.util.StringHelper$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.ResponseTimings;
import io.gatling.http.HeaderNames$;
import io.gatling.http.check.HttpCheck;
import io.gatling.http.check.checksum.ChecksumCheck;
import io.gatling.http.response.ByteArrayResponseBody$;
import io.gatling.http.response.ByteArrayResponseBodyUsage$;
import io.gatling.http.response.HttpResponse;
import io.gatling.http.response.InputStreamResponseBody$;
import io.gatling.http.response.InputStreamResponseBodyUsage$;
import io.gatling.http.response.NoResponseBody$;
import io.gatling.http.response.Response;
import io.gatling.http.response.ResponseBodyUsageStrategy;
import io.gatling.http.response.ResponseBuilder$;
import io.gatling.http.response.StringResponseBody$;
import io.gatling.http.util.HttpHelper$;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.LazyResponseBodyPart;
import org.asynchttpclient.netty.request.NettyRequest;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t5w!B\u0001\u0003\u0011\u0003Y\u0011a\u0004*fgB|gn]3Ck&dG-\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fgB|gn]3\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011\"\u0001\u0002j_\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!a\u0004*fgB|gn]3Ck&dG-\u001a:\u0014\u00075\u0001b\u0003\u0005\u0002\u0012)5\t!CC\u0001\u0014\u0003\u0015\u00198-\u00197b\u0013\t)\"C\u0001\u0004B]f\u0014VM\u001a\t\u0003/yi\u0011\u0001\u0007\u0006\u00033i\tAb]2bY\u0006dwnZ4j]\u001eT!a\u0007\u000f\u0002\u0011QL\b/Z:bM\u0016T\u0011!H\u0001\u0004G>l\u0017BA\u0010\u0019\u00055\u0019FO]5di2{wmZ5oO\")\u0011%\u0004C\u0001E\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\bI5\u0011\r\u0011\"\u0001&\u00031)U\u000e\u001d;z\u0011\u0016\fG-\u001a:t+\u00051\u0003CA\u00140\u001b\u0005A#BA\u0003*\u0015\tQ3&A\u0003d_\u0012,7M\u0003\u0002-[\u00059\u0001.\u00198eY\u0016\u0014(B\u0001\u0018\t\u0003\u0015qW\r\u001e;z\u0013\t\u0001\u0004F\u0001\nEK\u001a\fW\u000f\u001c;IiR\u0004\b*Z1eKJ\u001c\bB\u0002\u001a\u000eA\u0003%a%A\u0007F[B$\u0018\u0010S3bI\u0016\u00148\u000f\t\u0005\bi5\u0011\r\u0011\"\u00016\u0003!IE-\u001a8uSRLX#\u0001\u001c\u0011\tE9\u0014(O\u0005\u0003qI\u0011\u0011BR;oGRLwN\\\u0019\u0011\u00051Q\u0014BA\u001e\u0003\u0005!\u0011Vm\u001d9p]N,\u0007BB\u001f\u000eA\u0003%a'A\u0005JI\u0016tG/\u001b;zA!9q(\u0004b\u0001\n\u0013\u0001\u0015AD%t\t\u0016\u0014WoZ#oC\ndW\rZ\u000b\u0002\u0003B\u0011\u0011CQ\u0005\u0003\u0007J\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004F\u001b\u0001\u0006I!Q\u0001\u0010\u0013N$UMY;h\u000b:\f'\r\\3eA!)q)\u0004C\u0001\u0011\u0006Ib.Z<SKN\u0004xN\\:f\u0005VLG\u000eZ3s\r\u0006\u001cGo\u001c:z)\u0019I\u0005kY6n_B\u0011!*\u0014\b\u0003\u0019-K!\u0001\u0014\u0002\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\u0017%\u0016\u001c\bo\u001c8tK\n+\u0018\u000e\u001c3fe\u001a\u000b7\r^8ss*\u0011AJ\u0001\u0005\u0006#\u001a\u0003\rAU\u0001\u0007G\",7m[:\u0011\u0007MSVL\u0004\u0002U3:\u0011Q\u000bW\u0007\u0002-*\u0011qKC\u0001\u0007yI|w\u000e\u001e \n\u0003MI!\u0001\u0014\n\n\u0005mc&\u0001\u0002'jgRT!\u0001\u0014\n\u0011\u0005y\u000bW\"A0\u000b\u0005\u0001$\u0011!B2iK\u000e\\\u0017B\u00012`\u0005%AE\u000f\u001e9DQ\u0016\u001c7\u000eC\u0003e\r\u0002\u0007Q-A\nsKN\u0004xN\\:f)J\fgn\u001d4pe6,'\u000fE\u0002\u0012M\"L!a\u001a\n\u0003\r=\u0003H/[8o!\u0011\t\u0012.O\u001d\n\u0005)\u0014\"a\u0004)beRL\u0017\r\u001c$v]\u000e$\u0018n\u001c8\t\u000b14\u0005\u0019A!\u0002+\u0011L7oY1sIJ+7\u000f]8og\u0016\u001c\u0005.\u001e8lg\")aN\u0012a\u0001\u0003\u0006\u0011\u0012N\u001c4fe\"#X\u000e\u001c*fg>,(oY3t\u0011\u0015\u0001h\t1\u0001r\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011!o^\u0007\u0002g*\u0011A/^\u0001\u0007G>tg-[4\u000b\u0005Y4\u0011\u0001B2pe\u0016L!\u0001_:\u0003)\u001d\u000bG\u000f\\5oO\u000e{gNZ5hkJ\fG/[8o\r\u0011q!\u0001\u0001>\u0014\u0005e\u0004\u0002\u0002\u0003?z\u0005\u0003\u0005\u000b\u0011B?\u0002\u000fI,\u0017/^3tiB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005y\u0011m]=oG\"$H\u000f]2mS\u0016tGO\u0003\u0002\u0002\u0006\u0005\u0019qN]4\n\u0007\u0005%qPA\u0004SKF,Xm\u001d;\t\u0015\u00055\u0011P!A!\u0002\u0013\ty!\u0001\bdQ\u0016\u001c7n];n\u0007\",7m[:\u0011\tMS\u0016\u0011\u0003\t\u0005\u0003'\tI\"\u0004\u0002\u0002\u0016)\u0019\u0011qC0\u0002\u0011\rDWmY6tk6LA!a\u0007\u0002\u0016\ti1\t[3dWN,Xn\u00115fG.D!\"a\bz\u0005\u0003\u0005\u000b\u0011BA\u0011\u0003M\u0011w\u000eZ=Vg\u0006<Wm\u0015;sCR,w-[3t!\u0019\t\u0019#a\u000b\u000229!\u0011QEA\u0014!\t)&#C\u0002\u0002*I\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0017\u0003_\u00111aU3u\u0015\r\tIC\u0005\t\u0004\u0019\u0005M\u0012bAA\u001b\u0005\tI\"+Z:q_:\u001cXMQ8esV\u001b\u0018mZ3TiJ\fG/Z4z\u0011!!\u0017P!A!\u0002\u0013)\u0007\"CA\u001es\n\u0005\t\u0015!\u0003B\u00039\u0019Ho\u001c:f\u0005>$\u0017\u0010U1siND\u0001B\\=\u0003\u0002\u0003\u0006I!\u0011\u0005\u000b\u0003\u0003J(\u0011!Q\u0001\n\u0005\r\u0013A\u00043fM\u0006,H\u000e^\"iCJ\u001cX\r\u001e\t\u0005\u0003\u000b\n\u0019&\u0004\u0002\u0002H)!\u0011\u0011JA&\u0003\u001d\u0019\u0007.\u0019:tKRTA!!\u0014\u0002P\u0005\u0019a.[8\u000b\u0005\u0005E\u0013\u0001\u00026bm\u0006LA!!\u0016\u0002H\t91\t[1sg\u0016$\bBB\u0011z\t\u0003\tI\u0006\u0006\t\u0002\\\u0005u\u0013qLA1\u0003G\n)'a\u001a\u0002jA\u0011A\"\u001f\u0005\u0007y\u0006]\u0003\u0019A?\t\u0011\u00055\u0011q\u000ba\u0001\u0003\u001fA\u0001\"a\b\u0002X\u0001\u0007\u0011\u0011\u0005\u0005\u0007I\u0006]\u0003\u0019A3\t\u000f\u0005m\u0012q\u000ba\u0001\u0003\"1a.a\u0016A\u0002\u0005C\u0001\"!\u0011\u0002X\u0001\u0007\u00111\t\u0005\t\u0003[J(\u0019!C\u0001\u0001\u0006\u00012m\\7qkR,7\t[3dWN,Xn\u001d\u0005\b\u0003cJ\b\u0015!\u0003B\u0003E\u0019w.\u001c9vi\u0016\u001c\u0005.Z2lgVl7\u000f\t\u0005\u000b\u0003kJ\b\u0019!a\u0001\n\u0003\u0001\u0015AD:u_J,\u0007\n^7m\u001fJ\u001c5o\u001d\u0005\f\u0003sJ\b\u0019!a\u0001\n\u0003\tY(\u0001\nti>\u0014X\r\u0013;nY>\u00138i]:`I\u0015\fH\u0003BA?\u0003\u0007\u00032!EA@\u0013\r\t\tI\u0005\u0002\u0005+:LG\u000fC\u0005\u0002\u0006\u0006]\u0014\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005%\u0015\u0010)Q\u0005\u0003\u0006y1\u000f^8sK\"#X\u000e\\(s\u0007N\u001c\b\u0005\u000b\u0003\u0002\b\u00065\u0005cA\t\u0002\u0010&\u0019\u0011\u0011\u0013\n\u0003\u0011Y|G.\u0019;jY\u0016D1\"!&z\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\u0006q1\u000f^1siRKW.Z:uC6\u0004XCAAM!\r\t\u00121T\u0005\u0004\u0003;\u0013\"\u0001\u0002'p]\u001eD1\"!)z\u0001\u0004\u0005\r\u0011\"\u0001\u0002$\u0006\u00112\u000f^1siRKW.Z:uC6\u0004x\fJ3r)\u0011\ti(!*\t\u0015\u0005\u0015\u0015qTA\u0001\u0002\u0004\tI\n\u0003\u0005\u0002*f\u0004\u000b\u0015BAM\u0003=\u0019H/\u0019:u)&lWm\u001d;b[B\u0004\u0003\u0006BAT\u0003\u001bC1\"a,z\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u0018\u0006aQM\u001c3US6,7\u000f^1na\"Y\u00111W=A\u0002\u0003\u0007I\u0011AA[\u0003A)g\u000e\u001a+j[\u0016\u001cH/Y7q?\u0012*\u0017\u000f\u0006\u0003\u0002~\u0005]\u0006BCAC\u0003c\u000b\t\u00111\u0001\u0002\u001a\"A\u00111X=!B\u0013\tI*A\u0007f]\u0012$\u0016.\\3ti\u0006l\u0007\u000f\t\u0015\u0005\u0003s\u000bi\t\u0003\u0006\u0002Bf\u0004\r\u00111A\u0005\n\u0001\u000baa\u0018:fg\u0016$\bbCAcs\u0002\u0007\t\u0019!C\u0005\u0003\u000f\f!b\u0018:fg\u0016$x\fJ3r)\u0011\ti(!3\t\u0013\u0005\u0015\u00151YA\u0001\u0002\u0004\t\u0005bBAgs\u0002\u0006K!Q\u0001\b?J,7/\u001a;!Q\u0011\tY-!$\t\u0013\u0005M\u0017\u00101A\u0005\n\u0005U\u0017AB:uCR,8/\u0006\u0002\u0002XB!\u0011CZAm!\rq\u00181\\\u0005\u0004\u0003;|(A\u0005%uiB\u0014Vm\u001d9p]N,7\u000b^1ukND\u0011\"!9z\u0001\u0004%I!a9\u0002\u0015M$\u0018\r^;t?\u0012*\u0017\u000f\u0006\u0003\u0002~\u0005\u0015\bBCAC\u0003?\f\t\u00111\u0001\u0002X\"A\u0011\u0011^=!B\u0013\t9.A\u0004ti\u0006$Xo\u001d\u0011)\t\u0005\u001d\u0018Q\u0012\u0005\n\u0003_L\b\u0019!C\u0005\u0003c\fq\u0001[3bI\u0016\u00148/\u0006\u0002\u0002tB\u0019q%!>\n\u0007\u0005]\bFA\u0006IiR\u0004\b*Z1eKJ\u001c\b\"CA~s\u0002\u0007I\u0011BA\u007f\u0003-AW-\u00193feN|F%Z9\u0015\t\u0005u\u0014q \u0005\u000b\u0003\u000b\u000bI0!AA\u0002\u0005M\b\u0002\u0003B\u0002s\u0002\u0006K!a=\u0002\u0011!,\u0017\rZ3sg\u0002BCA!\u0001\u0002\u000e\"I!\u0011B=A\u0002\u0013%!1B\u0001\u0007G\",hn[:\u0016\u0005\t5\u0001\u0003B*[\u0005\u001f\u0001BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+i\u0013A\u00022vM\u001a,'/\u0003\u0003\u0003\u001a\tM!a\u0002\"zi\u0016\u0014UO\u001a\u0005\n\u0005;I\b\u0019!C\u0005\u0005?\t!b\u00195v].\u001cx\fJ3r)\u0011\tiH!\t\t\u0015\u0005\u0015%1DA\u0001\u0002\u0004\u0011i\u0001\u0003\u0005\u0003&e\u0004\u000b\u0015\u0002B\u0007\u0003\u001d\u0019\u0007.\u001e8lg\u0002BCAa\t\u0002\u000e\"I!1F=A\u0002\u0013%!QF\u0001\bI&<Wm\u001d;t+\t\u0011y\u0003\u0005\u0005\u0002$\tE\"Q\u0007B\u001e\u0013\u0011\u0011\u0019$a\f\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002$\t]\u0012\u0002\u0002B\u001d\u0003_\u0011aa\u0015;sS:<\u0007\u0003\u0002B\u001f\u0005\u0007j!Aa\u0010\u000b\t\t\u0005\u0013qJ\u0001\tg\u0016\u001cWO]5us&!!Q\tB \u00055iUm]:bO\u0016$\u0015nZ3ti\"I!\u0011J=A\u0002\u0013%!1J\u0001\fI&<Wm\u001d;t?\u0012*\u0017\u000f\u0006\u0003\u0002~\t5\u0003BCAC\u0005\u000f\n\t\u00111\u0001\u00030!A!\u0011K=!B\u0013\u0011y#\u0001\u0005eS\u001e,7\u000f^:!Q\u0011\u0011y%!$\t\u0013\t]\u0013\u00101A\u0005\n\te\u0013\u0001\u00048fiRL(+Z9vKN$XC\u0001B.!\u0011\tbM!\u0018\u0011\t\t}#QM\u0007\u0003\u0005CR1\u0001 B2\u0015\tqs0\u0003\u0003\u0003h\t\u0005$\u0001\u0004(fiRL(+Z9vKN$\b\"\u0003B6s\u0002\u0007I\u0011\u0002B7\u0003AqW\r\u001e;z%\u0016\fX/Z:u?\u0012*\u0017\u000f\u0006\u0003\u0002~\t=\u0004BCAC\u0005S\n\t\u00111\u0001\u0003\\!A!1O=!B\u0013\u0011Y&A\u0007oKR$\u0018PU3rk\u0016\u001cH\u000f\t\u0015\u0005\u0005c\ni\tC\u0004\u0003ze$\tAa\u001f\u0002\u0017%t\u0017\u000e\u001e#jO\u0016\u001cHo\u001d\u000b\u0003\u0005_AqAa z\t\u0003\u0011\t)\u0001\u000bva\u0012\fG/Z*uCJ$H+[7fgR\fW\u000e\u001d\u000b\u0003\u0003{BqA!\"z\t\u0003\u0011\t)\u0001\nva\u0012\fG/Z#oIRKW.Z:uC6\u0004\bb\u0002BEs\u0012\u0005!1R\u0001\u0010g\u0016$h*\u001a;usJ+\u0017/^3tiR!\u0011Q\u0010BG\u0011!\u00119Fa\"A\u0002\tu\u0003b\u0002BIs\u0012\u0005!\u0011Q\u0001\n[\u0006\u00148NU3tKRDqA!&z\t\u0003\u0011\t)A\u0004e_J+7/\u001a;\t\u000f\te\u0015\u0010\"\u0003\u0003\u0002\u0006Y!/Z:fi\u000eCWO\\6t\u0011\u001d\u0011i*\u001fC\u0001\u0005?\u000b!\"Y2dk6,H.\u0019;f)\u0011\tiH!)\t\u0011\u0005M'1\u0014a\u0001\u00033DqA!(z\t\u0003\u0011)\u000b\u0006\u0003\u0002~\t\u001d\u0006\u0002CAx\u0005G\u0003\rA!+\u0011\u0007y\u0014Y+C\u0002\u0003.~\u00141\u0003\u0013;uaJ+7\u000f]8og\u0016DU-\u00193feNDqA!(z\t\u0003\u0011\t\f\u0006\u0003\u0002~\tM\u0006\u0002\u0003B[\u0005_\u0003\rAa.\u0002\u0011\t|G-\u001f)beR\u00042A B]\u0013\r\u0011Yl \u0002\u0015\u0011R$\bOU3ta>t7/\u001a\"pIf\u0004\u0016M\u001d;\t\u000f\t}\u0016\u0010\"\u0001\u0003B\u0006y!/Z:pYZ,Gm\u00115beN,G/\u0006\u0002\u0002D!9!QY=\u0005\u0002\t\u001d\u0017!\u00022vS2$W#A\u001d\t\u000f\t-\u0017\u0010\"\u0001\u0003H\u0006\t\"-^5mIN\u000bg-\u001a*fgB|gn]3")
public class ResponseBuilder {
    private final Request request;
    private final List<ChecksumCheck> checksumChecks;
    private final Set<ResponseBodyUsageStrategy> bodyUsageStrategies;
    private final Option<PartialFunction<Response, Response>> responseTransformer;
    private final boolean storeBodyParts;
    private final boolean inferHtmlResources;
    private final Charset defaultCharset;
    private final boolean computeChecksums;
    private volatile boolean storeHtmlOrCss;
    private volatile long startTimestamp;
    private volatile long endTimestamp;
    private volatile boolean _reset;
    private volatile Option<HttpResponseStatus> status;
    private volatile HttpHeaders headers;
    private volatile List<ByteBuf> chunks;
    private volatile Map<String, MessageDigest> digests;
    private volatile Option<NettyRequest> nettyRequest;

    public static Function1<Request, ResponseBuilder> newResponseBuilderFactory(List<HttpCheck> list, Option<PartialFunction<Response, Response>> option, boolean bl, boolean bl2, GatlingConfiguration gatlingConfiguration) {
        return ResponseBuilder$.MODULE$.newResponseBuilderFactory(list, option, bl, bl2, gatlingConfiguration);
    }

    public static Function1<Response, Response> Identity() {
        return ResponseBuilder$.MODULE$.Identity();
    }

    public static DefaultHttpHeaders EmptyHeaders() {
        return ResponseBuilder$.MODULE$.EmptyHeaders();
    }

    public static Logger logger() {
        return ResponseBuilder$.MODULE$.logger();
    }

    public boolean computeChecksums() {
        return this.computeChecksums;
    }

    public boolean storeHtmlOrCss() {
        return this.storeHtmlOrCss;
    }

    public void storeHtmlOrCss_$eq(boolean x$1) {
        this.storeHtmlOrCss = x$1;
    }

    public long startTimestamp() {
        return this.startTimestamp;
    }

    public void startTimestamp_$eq(long x$1) {
        this.startTimestamp = x$1;
    }

    public long endTimestamp() {
        return this.endTimestamp;
    }

    public void endTimestamp_$eq(long x$1) {
        this.endTimestamp = x$1;
    }

    private boolean _reset() {
        return this._reset;
    }

    private void _reset_$eq(boolean x$1) {
        this._reset = x$1;
    }

    private Option<HttpResponseStatus> status() {
        return this.status;
    }

    private void status_$eq(Option<HttpResponseStatus> x$1) {
        this.status = x$1;
    }

    private HttpHeaders headers() {
        return this.headers;
    }

    private void headers_$eq(HttpHeaders x$1) {
        this.headers = x$1;
    }

    private List<ByteBuf> chunks() {
        return this.chunks;
    }

    private void chunks_$eq(List<ByteBuf> x$1) {
        this.chunks = x$1;
    }

    private Map<String, MessageDigest> digests() {
        return this.digests;
    }

    private void digests_$eq(Map<String, MessageDigest> x$1) {
        this.digests = x$1;
    }

    private Option<NettyRequest> nettyRequest() {
        return this.nettyRequest;
    }

    private void nettyRequest_$eq(Option<NettyRequest> x$1) {
        this.nettyRequest = x$1;
    }

    public Map<String, MessageDigest> initDigests() {
        return this.computeChecksums() ? (Map)this.checksumChecks.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(map, check) -> map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)check.algorithm()), (Object)MessageDigest.getInstance(check.algorithm())))) : Predef$.MODULE$.Map().empty();
    }

    public void updateStartTimestamp() {
        this.startTimestamp_$eq(ClockSingleton$.MODULE$.nowMillis());
    }

    public void updateEndTimestamp() {
        this.endTimestamp_$eq(ClockSingleton$.MODULE$.nowMillis());
    }

    public void setNettyRequest(NettyRequest nettyRequest) {
        this.nettyRequest_$eq((Option<NettyRequest>)new Some((Object)nettyRequest));
    }

    public void markReset() {
        this._reset_$eq(true);
    }

    public void doReset() {
        block0: {
            if (!this._reset()) break block0;
            this._reset_$eq(false);
            this.endTimestamp_$eq(0L);
            this.status_$eq((Option<HttpResponseStatus>)None$.MODULE$);
            this.headers_$eq((HttpHeaders)ResponseBuilder$.MODULE$.EmptyHeaders());
            this.resetChunks();
            this.digests_$eq(this.initDigests());
        }
    }

    private void resetChunks() {
        this.chunks().foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.release()));
        this.chunks_$eq((List<ByteBuf>)Nil$.MODULE$);
    }

    public void accumulate(HttpResponseStatus status) {
        this.status_$eq((Option<HttpResponseStatus>)new Some((Object)status));
        this.updateEndTimestamp();
    }

    public void accumulate(HttpResponseHeaders headers) {
        HttpHeaders newHeaders = headers.getHeaders();
        if (this.headers() == ResponseBuilder$.MODULE$.EmptyHeaders()) {
            this.headers_$eq(newHeaders);
            this.storeHtmlOrCss_$eq(this.inferHtmlResources && (HttpHelper$.MODULE$.isHtml(newHeaders) || HttpHelper$.MODULE$.isCss(newHeaders)));
        } else {
            this.headers().add(newHeaders);
        }
    }

    public void accumulate(HttpResponseBodyPart bodyPart) {
        block2: {
            this.updateEndTimestamp();
            ByteBuf byteBuf = ((LazyResponseBodyPart)bodyPart).getBuf();
            if (byteBuf.readableBytes() <= 0) break block2;
            if (this.storeBodyParts || this.storeHtmlOrCss()) {
                ByteBuf byteBuf2 = byteBuf.retain();
                this.chunks_$eq((List<ByteBuf>)this.chunks().$colon$colon((Object)byteBuf2));
            }
            if (this.computeChecksums()) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])byteBuf.nioBuffers())).foreach((Function1 & Serializable & scala.Serializable)nioBuffer -> {
                    ResponseBuilder.$anonfun$accumulate$1(this, nioBuffer);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public Charset resolvedCharset() {
        return (Charset)Option$.MODULE$.apply((Object)this.headers().get(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)contentType -> HttpHelper$.MODULE$.extractCharsetFromContentType((String)contentType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
    }

    public Response build() {
        Response response;
        this.endTimestamp_$eq(package$.MODULE$.max(this.endTimestamp(), this.startTimestamp()));
        Map checksums = (Map)this.digests().foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(map, entry) -> {
            Tuple2 tuple2 = entry;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String algo = (String)tuple2._1();
            MessageDigest md = (MessageDigest)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)algo, (Object)md);
            Tuple2 tuple23 = tuple22;
            String algo2 = (String)tuple23._1();
            MessageDigest md2 = (MessageDigest)tuple23._2();
            return map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)algo2), (Object)StringHelper$.MODULE$.bytes2Hex(md2.digest())));
        });
        int bodyLength = BoxesRunTime.unboxToInt((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce(this.chunks()), (Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.readableBytes()), (Numeric)Numeric.IntIsIntegral$.MODULE$));
        Set bodyUsages = (Set)this.bodyUsageStrategies.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.bodyUsage(bodyLength), Set$.MODULE$.canBuildFrom());
        Charset resolvedCharset = (Charset)Option$.MODULE$.apply((Object)this.headers().get(HeaderNames$.MODULE$.ContentType())).flatMap((Function1 & Serializable & scala.Serializable)contentType -> HttpHelper$.MODULE$.extractCharsetFromContentType((String)contentType)).getOrElse((Function0 & Serializable & scala.Serializable)() -> $this.defaultCharset);
        List properlyOrderedChunks = this.chunks().reverse();
        NoResponseBody$ body = properlyOrderedChunks.isEmpty() ? NoResponseBody$.MODULE$ : (bodyUsages.contains((Object)ByteArrayResponseBodyUsage$.MODULE$) ? ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (bodyUsages.contains((Object)InputStreamResponseBodyUsage$.MODULE$) || bodyUsages.isEmpty() ? InputStreamResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : (HttpHelper$.MODULE$.isTxt(this.headers()) ? StringResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset) : ByteArrayResponseBody$.MODULE$.apply((Seq<ByteBuf>)properlyOrderedChunks, resolvedCharset))));
        this.resetChunks();
        HttpResponse rawResponse = new HttpResponse(this.request, this.nettyRequest(), this.status(), this.headers(), body, (Map<String, String>)checksums, bodyLength, resolvedCharset, new ResponseTimings(this.startTimestamp(), this.endTimestamp()));
        Option<PartialFunction<Response, Response>> option = this.responseTransformer;
        if (None$.MODULE$.equals(option)) {
            response = rawResponse;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            PartialFunction transformer = (PartialFunction)some.value();
            response = (Response)transformer.applyOrElse((Object)rawResponse, ResponseBuilder$.MODULE$.Identity());
        } else {
            throw new MatchError(option);
        }
        return response;
    }

    public Response buildSafeResponse() {
        return new HttpResponse(this.request, this.nettyRequest(), this.status(), this.headers(), NoResponseBody$.MODULE$, (Map<String, String>)Predef$.MODULE$.Map().empty(), 0, this.resolvedCharset(), new ResponseTimings(this.startTimestamp(), this.endTimestamp()));
    }

    public static final /* synthetic */ void $anonfun$accumulate$1(ResponseBuilder $this, ByteBuffer nioBuffer) {
        $this.digests().values().foreach((Function1 & Serializable & scala.Serializable)digest -> {
            digest.update(nioBuffer.duplicate());
            return BoxedUnit.UNIT;
        });
    }

    public ResponseBuilder(Request request, List<ChecksumCheck> checksumChecks, Set<ResponseBodyUsageStrategy> bodyUsageStrategies, Option<PartialFunction<Response, Response>> responseTransformer, boolean storeBodyParts, boolean inferHtmlResources, Charset defaultCharset) {
        this.request = request;
        this.checksumChecks = checksumChecks;
        this.bodyUsageStrategies = bodyUsageStrategies;
        this.responseTransformer = responseTransformer;
        this.storeBodyParts = storeBodyParts;
        this.inferHtmlResources = inferHtmlResources;
        this.defaultCharset = defaultCharset;
        this.computeChecksums = checksumChecks.nonEmpty();
        this.status = None$.MODULE$;
        this.headers = ResponseBuilder$.MODULE$.EmptyHeaders();
        this.chunks = Nil$.MODULE$;
        this.digests = this.initDigests();
        this.nettyRequest = None$.MODULE$;
    }
}

