/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.resolver;

import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.util.Collections;
import java.util.List;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\tA\u0012\t\\5bg\u0016\u001c\u0018i^1sK:\u000bW.\u001a*fg>dg/\u001a:\u000b\u0005\r!\u0011\u0001\u0003:fg>dg/\u001a:\u000b\u0005\u00151\u0011\u0001\u00025uiBT!a\u0002\u0005\u0002\u000f\u001d\fG\u000f\\5oO*\t\u0011\"\u0001\u0002j_\u000e\u00011c\u0001\u0001\r)A\u0011QBE\u0007\u0002\u001d)\u0011q\u0002E\u0001\u0005Y\u0006twMC\u0001\u0012\u0003\u0011Q\u0017M^1\n\u0005Mq!AB(cU\u0016\u001cG\u000fE\u0002\u00163mi\u0011A\u0006\u0006\u0003\u0007]Q!\u0001\u0007\u0005\u0002\u000b9,G\u000f^=\n\u0005i1\"\u0001\u0004(b[\u0016\u0014Vm]8mm\u0016\u0014\bC\u0001\u000f \u001b\u0005i\"B\u0001\u0010\u0011\u0003\rqW\r^\u0005\u0003Au\u00111\"\u00138fi\u0006#GM]3tg\"A!\u0005\u0001B\u0001B\u0003%1%A\u0004bY&\f7/Z:\u0011\t\u0011j\u0003g\u0007\b\u0003K-\u0002\"AJ\u0015\u000e\u0003\u001dR!\u0001\u000b\u0006\u0002\rq\u0012xn\u001c;?\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0003\u0019\u0001&/\u001a3fM&\u0011af\f\u0002\u0004\u001b\u0006\u0004(B\u0001\u0017*!\t!\u0013'\u0003\u00023_\t11\u000b\u001e:j]\u001eD\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\boJ\f\u0007\u000f]3e\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001HO\u001e\u0011\u0005e\u0002Q\"\u0001\u0002\t\u000b\t*\u0004\u0019A\u0012\t\u000bQ*\u0004\u0019\u0001\u000b\t\u000bu\u0002A\u0011\t \u0002\u000fI,7o\u001c7wKR\u0011qh\u0012\t\u0004\u0001\u0016[R\"A!\u000b\u0005\t\u001b\u0015AC2p]\u000e,(O]3oi*\u0011AiF\u0001\u0005kRLG.\u0003\u0002G\u0003\n1a)\u001e;ve\u0016DQ\u0001\u0013\u001fA\u0002A\n\u0011a\u001d\u0005\u0006{\u0001!\tE\u0013\u000b\u0004\u007f-c\u0005\"\u0002%J\u0001\u0004\u0001\u0004\"B'J\u0001\u0004q\u0015a\u00029s_6L7/\u001a\t\u0004\u0001>[\u0012B\u0001)B\u0005\u001d\u0001&o\\7jg\u0016DQA\u0015\u0001\u0005BM\u000b!B]3t_24X-\u00117m)\t!&\fE\u0002A\u000bV\u00032A\u0016-\u001c\u001b\u00059&B\u0001#\u0011\u0013\tIvK\u0001\u0003MSN$\b\"\u0002%R\u0001\u0004\u0001\u0004\"\u0002*\u0001\t\u0003bFc\u0001+^=\")\u0001j\u0017a\u0001a!)Qj\u0017a\u0001?B\u0019\u0001iT+\t\u000b\u0005\u0004A\u0011\t2\u0002\u000b\rdwn]3\u0015\u0003\r\u0004\"\u0001Z3\u000e\u0003%J!AZ\u0015\u0003\tUs\u0017\u000e\u001e")
public class AliasesAwareNameResolver
implements NameResolver<InetAddress> {
    private final Map<String, InetAddress> aliases;
    private final NameResolver<InetAddress> wrapped;

    public Future<InetAddress> resolve(String s) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = ImmediateEventExecutor.INSTANCE.newPromise().setSuccess((Object)address);
        } else {
            future = this.wrapped.resolve(s);
        }
        return future;
    }

    public Future<InetAddress> resolve(String s, Promise<InetAddress> promise) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = promise.setSuccess((Object)address);
        } else {
            future = this.wrapped.resolve(s, promise);
        }
        return future;
    }

    public Future<List<InetAddress>> resolveAll(String s) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = ImmediateEventExecutor.INSTANCE.newPromise().setSuccess(Collections.singletonList(address));
        } else {
            future = this.wrapped.resolveAll(s);
        }
        return future;
    }

    public Future<List<InetAddress>> resolveAll(String s, Promise<List<InetAddress>> promise) {
        Future future;
        Option option = this.aliases.get((Object)s);
        if (option instanceof Some) {
            Some some = (Some)option;
            InetAddress address = (InetAddress)some.value();
            future = promise.setSuccess(Collections.singletonList(address));
        } else {
            future = this.wrapped.resolveAll(s, promise);
        }
        return future;
    }

    public void close() {
        this.wrapped.close();
    }

    public AliasesAwareNameResolver(Map<String, InetAddress> aliases, NameResolver<InetAddress> wrapped) {
        this.aliases = aliases;
        this.wrapped = wrapped;
    }
}

