/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.asynchttpclient.Realm;
import org.asynchttpclient.uri.Uri;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.io.Codec$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

public final class HttpHelper$
implements StrictLogging {
    public static HttpHelper$ MODULE$;
    private final String HttpScheme;
    private final String WsScheme;
    private final Vector<Object> OkCodes;
    private final Vector<Object> RedirectStatusCodes;
    private final Logger logger;

    static {
        new HttpHelper$();
    }

    public Logger logger() {
        return this.logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public String HttpScheme() {
        return this.HttpScheme;
    }

    public String WsScheme() {
        return this.WsScheme;
    }

    public Vector<Object> OkCodes() {
        return this.OkCodes;
    }

    public Vector<Object> RedirectStatusCodes() {
        return this.RedirectStatusCodes;
    }

    public List<Tuple2<String, String>> parseFormBody(String body) {
        return (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])body.split("&"))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.split("=", 2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))).map((Function1 & Serializable & scala.Serializable)pair -> {
            String paramName = HttpHelper$.utf8Decode$1(pair[0]);
            String paramValue = ((String[])pair).length > 1 ? HttpHelper$.utf8Decode$1(pair[1]) : "";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)paramName), (Object)paramValue);
        }, scala.collection.package$.MODULE$.breakOut(List$.MODULE$.canBuildFrom()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.BASIC, true, (Option<Function1<Session, Validation<String>>>)None$.MODULE$, (Option<Function1<Session, Validation<String>>>)None$.MODULE$);
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return this.buildRealm(username, password, Realm.AuthScheme.DIGEST, false, (Option<Function1<Session, Validation<String>>>)None$.MODULE$, (Option<Function1<Session, Validation<String>>>)None$.MODULE$);
    }

    public Function1<Session, Validation<Realm>> buildNTLMAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password, Function1<Session, Validation<String>> ntlmDomain, Function1<Session, Validation<String>> ntlmHost) {
        return this.buildRealm(username, password, Realm.AuthScheme.NTLM, false, (Option<Function1<Session, Validation<String>>>)new Some(ntlmDomain), (Option<Function1<Session, Validation<String>>>)new Some(ntlmHost));
    }

    public Function1<Session, Validation<Realm>> buildRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password, Realm.AuthScheme authScheme, boolean preemptive, Option<Function1<Session, Validation<String>>> ntlmDomain, Option<Function1<Session, Validation<String>>> ntlmHost) {
        return (Function1 & Serializable & scala.Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable & scala.Serializable)usernameValue -> ((Validation)password.apply(session)).flatMap((Function1 & Serializable & scala.Serializable)passwordValue -> io.gatling.core.session.package$.MODULE$.resolveOptionalExpression(ntlmDomain, session).flatMap((Function1 & Serializable & scala.Serializable)ntlmDomainValue -> io.gatling.core.session.package$.MODULE$.resolveOptionalExpression(ntlmHost, session).map((Function1 & Serializable & scala.Serializable)ntlmHostValue -> new Realm.Builder(usernameValue, passwordValue).setScheme(authScheme).setUsePreemptiveAuth(preemptive).setNtlmDomain((String)ntlmDomainValue.orNull(Predef$.MODULE$.$conforms())).setNtlmHost((String)ntlmHostValue.orNull(Predef$.MODULE$.$conforms())).build()))));
    }

    private boolean headerExists(HttpHeaders headers, String headerName, Function1<String, Object> f) {
        return Option$.MODULE$.apply((Object)headers.get(headerName)).exists(f);
    }

    public boolean isCss(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(HeaderValues$.MODULE$.TextCss())));
    }

    public boolean isHtml(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)ct -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isHtml$1(ct)));
    }

    public boolean isAjax(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.XRequestedWith(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.contains(HeaderValues$.MODULE$.XmlHttpRequest())));
    }

    public boolean isTxt(HttpHeaders headers) {
        return this.headerExists(headers, HeaderNames$.MODULE$.ContentType(), (Function1<String, Object>)(Function1 & Serializable & scala.Serializable)ct -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isTxt$1(ct)));
    }

    public Uri resolveFromUri(Uri rootURI, String relative) {
        return relative.startsWith("//") ? Uri.create((String)(rootURI.getScheme() + ":" + relative)) : Uri.create((Uri)rootURI, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI, relative));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                BoxedUnit boxedUnit;
                Throwable e = (Throwable)option.get();
                if (this.logger().underlying().isInfoEnabled()) {
                    this.logger().underlying().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to resolve URI rootURI='", "', relative='", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rootURI, relative})), e);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                throw throwable;
            }
            None$ none$ = None$.MODULE$;
            some = none$;
        }
        return some;
    }

    public boolean isRedirect(int statusCode) {
        return this.RedirectStatusCodes().contains((Object)BoxesRunTime.boxToInteger((int)statusCode));
    }

    public boolean isPermanentRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 308;
    }

    public boolean isNotModified(int statusCode) {
        return statusCode == 304;
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType) {
        None$ none$;
        int n = contentType.indexOf("charset=");
        switch (n) {
            case -1: {
                none$ = None$.MODULE$;
                break;
            }
            default: {
                int n2;
                IntRef start = IntRef.create((int)(n + "charset=".length()));
                if (contentType.regionMatches(true, start.elem, "UTF-8", 0, 5)) {
                    none$ = new Some((Object)StandardCharsets.UTF_8);
                    break;
                }
                int n3 = contentType.indexOf(59, start.elem);
                switch (n3) {
                    case -1: {
                        n2 = contentType.length();
                        break;
                    }
                    default: {
                        n2 = n3;
                        break;
                    }
                }
                IntRef end = IntRef.create((int)n2);
                none$ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    while (contentType.charAt(start$1.elem) == ' ' && start$1.elem < end$1.elem) {
                        ++start$1.elem;
                    }
                    while (contentType.charAt(end$1.elem - 1) == ' ' && end$1.elem > start$1.elem) {
                        --end$1.elem;
                    }
                    if (contentType.charAt(start$1.elem) == '\"' && start$1.elem < end$1.elem) {
                        ++start$1.elem;
                    }
                    if (contentType.charAt(end$1.elem - 1) == '\"' && end$1.elem > start$1.elem) {
                        --end$1.elem;
                    }
                    String charsetString = contentType.substring(start$1.elem, end$1.elem);
                    return Charset.forName(charsetString);
                }).toOption();
                break;
            }
        }
        return none$;
    }

    private static final String utf8Decode$1(String s) {
        return URLDecoder.decode(s, Codec$.MODULE$.UTF8().name());
    }

    public static final /* synthetic */ boolean $anonfun$isHtml$1(String ct) {
        return ct.contains(HeaderValues$.MODULE$.TextHtml()) || ct.contains(HeaderValues$.MODULE$.ApplicationXhtml());
    }

    public static final /* synthetic */ boolean $anonfun$isTxt$1(String ct) {
        return ct.contains("text") || ct.contains("json") || ct.contains("javascript") || ct.contains("xml");
    }

    private HttpHelper$() {
        MODULE$ = this;
        StrictLogging.$init$((StrictLogging)this);
        this.HttpScheme = "http";
        this.WsScheme = "ws";
        this.OkCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{200, 304, 201, 202, 203, 204, 205, 206, 207, 208, 209}));
        this.RedirectStatusCodes = (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{301, 302, 303, 307, 308}));
    }
}

