/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.cache;

import io.gatling.commons.util.NumberHelper$;
import io.gatling.commons.util.TimeHelper$;
import io.gatling.http.HeaderNames$;
import io.gatling.http.HeaderValues$;
import io.gatling.http.cache.ExpiresSupport;
import io.gatling.http.response.Response;
import java.io.Serializable;
import java.util.Map;
import org.asynchttpclient.cookie.DateParser;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.compat.java8.JFunction0;
import scala.compat.java8.JFunction1;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar$;

public abstract class ExpiresSupport$class {
    private static /* synthetic */ Map $deserializeLambdaCache$;

    public static Option extractMaxAgeValue(ExpiresSupport $this, String s) {
        None$ none$;
        int index = s.indexOf($this.MaxAgePrefix());
        int start = $this.MaxAgePrefix().length() + index;
        if (index >= 0 && start <= s.length()) {
            char c = s.charAt(start);
            switch (c) {
                case '-': {
                    none$ = new Some((Object)BoxesRunTime.boxToLong((long)-1L));
                    break;
                }
                default: {
                    if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(c))) {
                        none$ = new Some((Object)BoxesRunTime.boxToLong((long)NumberHelper$.MODULE$.extractLongValue(s, start)));
                        break;
                    }
                    none$ = None$.MODULE$;
                    break;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public static Option extractExpiresValue(ExpiresSupport $this, String timestring) {
        String trimmedTimeString = ExpiresSupport$class.removeQuote$1($this, timestring.trim());
        return Option$.MODULE$.apply((Object)DateParser.parse((String)trimmedTimeString)).map((Function1)(JFunction1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.getTime()));
    }

    public static Option getResponseExpires(ExpiresSupport $this, Response response) {
        return ExpiresSupport$class.pragmaNoCache$1($this, response) || ExpiresSupport$class.cacheControlNoCache$1($this, response) ? None$.MODULE$ : ExpiresSupport$class.maxAgeAsExpiresValue$1($this, response).orElse((Function0)(JFunction0 & Serializable & scala.Serializable)() -> ExpiresSupport$class.expiresValue$1($this, response)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$4 -> x$4 > 0L);
    }

    private static final String removeQuote$1(ExpiresSupport $this, String s) {
        String string;
        if (!s.isEmpty()) {
            int start = 0;
            int end = s.length();
            if (s.charAt(0) == '\"') {
                ++start;
            }
            if (s.charAt(s.length() - 1) == '\"') {
                --end;
            }
            string = s.substring(start, end);
        } else {
            string = s;
        }
        return string;
    }

    private static final boolean pragmaNoCache$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Pragma()).exists((Function1)(JFunction1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains(HeaderValues$.MODULE$.NoCache())));
    }

    public static final /* synthetic */ boolean io$gatling$http$cache$ExpiresSupport$class$$$anonfun$3(ExpiresSupport $this, String h) {
        return h.contains(HeaderValues$.MODULE$.NoCache()) || h.contains(HeaderValues$.MODULE$.NoStore()) || h.contains($this.MaxAgeZero());
    }

    private static final boolean cacheControlNoCache$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).exists((Function1)(JFunction1 & Serializable & scala.Serializable)h -> BoxesRunTime.boxToBoolean((boolean)ExpiresSupport$class.io$gatling$http$cache$ExpiresSupport$class$$$anonfun$3($this, h)));
    }

    private static final Option maxAgeAsExpiresValue$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.CacheControl()).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)s -> $this.extractMaxAgeValue((String)s)).map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)maxAge -> maxAge < 0L ? maxAge : maxAge * 1000L + TimeHelper$.MODULE$.nowMillis());
    }

    private static final Option expiresValue$1(ExpiresSupport $this, Response response$1) {
        return response$1.header(HeaderNames$.MODULE$.Expires()).flatMap((Function1)(JFunction1 & Serializable & scala.Serializable)timestring -> $this.extractExpiresValue((String)timestring)).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> x$3 > TimeHelper$.MODULE$.nowMillis());
    }

    public static void $init$(ExpiresSupport $this) {
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$MaxAgePrefix_$eq("max-age=");
        $this.io$gatling$http$cache$ExpiresSupport$_setter_$MaxAgeZero_$eq(new StringBuilder().append((Object)$this.MaxAgePrefix()).append((Object)"0").toString());
    }
}

