/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.javaapi.http;

import edu.umd.cs.findbugs.annotations.NonNull;
import io.gatling.core.Predef;
import io.gatling.core.action.builder.ActionBuilder;
import io.gatling.core.body.Body;
import io.gatling.http.request.builder.HttpRequestBuilder;
import io.gatling.http.response.Response;
import io.gatling.javaapi.core.CheckBuilder;
import io.gatling.javaapi.core.Session;
import io.gatling.javaapi.core.internal.Bodies;
import io.gatling.javaapi.core.internal.Converters;
import io.gatling.javaapi.core.internal.Expressions;
import io.gatling.javaapi.http.BodyPart;
import io.gatling.javaapi.http.RequestActionBuilder;
import io.gatling.javaapi.http.internal.HttpChecks;
import io.gatling.javaapi.http.internal.ScalaHttpRequestActionBuilderConditions;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class HttpRequestActionBuilder
extends RequestActionBuilder<HttpRequestActionBuilder, HttpRequestBuilder> {
    public HttpRequestActionBuilder(HttpRequestBuilder httpRequestBuilder) {
        super(httpRequestBuilder);
    }

    @Override
    protected HttpRequestActionBuilder make(Function<HttpRequestBuilder, HttpRequestBuilder> function) {
        return new HttpRequestActionBuilder(function.apply((HttpRequestBuilder)this.wrapped));
    }

    public ActionBuilder asScala() {
        return (ActionBuilder)this.wrapped;
    }

    @NonNull
    public HttpRequestActionBuilder check(CheckBuilder ... checkBuilderArray) {
        return this.check(Arrays.asList(checkBuilderArray));
    }

    @NonNull
    public HttpRequestActionBuilder check(@NonNull List<CheckBuilder> list) {
        return new HttpRequestActionBuilder(((HttpRequestBuilder)this.wrapped).check(HttpChecks.toScalaChecks(list)));
    }

    @NonNull
    public UntypedCondition checkIf(@NonNull String string) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, string));
    }

    @NonNull
    public UntypedCondition checkIf(@NonNull Function<Session, Boolean> function) {
        return new UntypedCondition(ScalaHttpRequestActionBuilderConditions.untyped((HttpRequestBuilder)this.wrapped, function));
    }

    public TypedCondition checkIf(BiFunction<Response, Session, Boolean> biFunction) {
        return new TypedCondition(ScalaHttpRequestActionBuilderConditions.typed((HttpRequestBuilder)this.wrapped, biFunction));
    }

    @NonNull
    public HttpRequestActionBuilder ignoreProtocolChecks() {
        return this.make(HttpRequestBuilder::ignoreProtocolChecks);
    }

    @NonNull
    public HttpRequestActionBuilder silent() {
        return this.make(HttpRequestBuilder::silent);
    }

    @NonNull
    public HttpRequestActionBuilder notSilent() {
        return this.make(HttpRequestBuilder::notSilent);
    }

    @NonNull
    public HttpRequestActionBuilder disableFollowRedirect() {
        return this.make(HttpRequestBuilder::disableFollowRedirect);
    }

    @NonNull
    public HttpRequestActionBuilder transformResponse(@NonNull BiFunction<Response, Session, Response> biFunction) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.transformResponse(Expressions.javaBiFunctionToExpression((BiFunction)biFunction)));
    }

    @NonNull
    public HttpRequestActionBuilder body(io.gatling.javaapi.core.Body body) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.body(body.asScala()));
    }

    @NonNull
    public HttpRequestActionBuilder processRequestBody(@NonNull Function<io.gatling.javaapi.core.Body, ? extends io.gatling.javaapi.core.Body> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.processRequestBody(body -> ((io.gatling.javaapi.core.Body)function.apply(Bodies.toJavaBody((Body)body))).asScala()));
    }

    @NonNull
    public HttpRequestActionBuilder bodyPart(@NonNull BodyPart bodyPart) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyPart(bodyPart.asScala()));
    }

    @NonNull
    public HttpRequestActionBuilder bodyParts(BodyPart ... bodyPartArray) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyParts(Converters.toScalaSeq(Arrays.stream(bodyPartArray).map(BodyPart::asScala).collect(Collectors.toList()))));
    }

    @NonNull
    public HttpRequestActionBuilder bodyParts(@NonNull List<BodyPart> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.bodyParts(Converters.toScalaSeq(list.stream().map(BodyPart::asScala).collect(Collectors.toList()))));
    }

    @NonNull
    public HttpRequestActionBuilder resources(HttpRequestActionBuilder ... httpRequestActionBuilderArray) {
        return this.resources(Arrays.asList(httpRequestActionBuilderArray));
    }

    @NonNull
    public HttpRequestActionBuilder resources(@NonNull List<HttpRequestActionBuilder> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.resources(Converters.toScalaSeq(list.stream().map(httpRequestActionBuilder -> (HttpRequestBuilder)httpRequestActionBuilder.wrapped).collect(Collectors.toList()))));
    }

    @NonNull
    public HttpRequestActionBuilder asMultipartForm() {
        return this.make(HttpRequestBuilder::asMultipartForm);
    }

    @NonNull
    public HttpRequestActionBuilder asFormUrlEncoded() {
        return this.make(HttpRequestBuilder::asFormUrlEncoded);
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull String string, @NonNull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toAnyExpression((String)string2)));
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull Function<Session, String> function, @NonNull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toAnyExpression((String)string)));
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull String string, @NonNull Object object) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)object)));
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull Function<Session, String> function, @NonNull Object object) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)object)));
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull String string, @NonNull Function<Session, Object> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function)));
    }

    @NonNull
    public HttpRequestActionBuilder formParam(@NonNull Function<Session, String> function, @NonNull Function<Session, Object> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2)));
    }

    @NonNull
    public HttpRequestActionBuilder multivaluedFormParam(@NonNull String string, @NonNull List<Object> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list))));
    }

    @NonNull
    public HttpRequestActionBuilder multivaluedFormParam(@NonNull String string, @NonNull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.toSeqExpression((String)string2)));
    }

    @NonNull
    public HttpRequestActionBuilder multivaluedFormParam(@NonNull Function<Session, String> function, @NonNull List<Object> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.toStaticValueExpression((Object)Converters.toScalaSeq((List)list))));
    }

    @NonNull
    public HttpRequestActionBuilder multivaluedFormParam(@NonNull String string, @NonNull Function<Session, List<Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.toStringExpression((String)string), Expressions.javaListFunctionToExpression((Function)function)));
    }

    @NonNull
    public HttpRequestActionBuilder multivaluedFormParam(@NonNull Function<Session, String> function, @NonNull Function<Session, List<Object>> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.multivaluedFormParam(Expressions.javaFunctionToExpression((Function)function), Expressions.javaListFunctionToExpression((Function)function2)));
    }

    @NonNull
    public HttpRequestActionBuilder formParamSeq(@NonNull List<Map.Entry<String, Object>> list) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamSeq(Converters.toScalaTuple2Seq((List)list)));
    }

    @NonNull
    public HttpRequestActionBuilder formParamSeq(@NonNull Function<Session, List<Map.Entry<String, Object>>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamSeq(Expressions.javaPairListFunctionToTuple2SeqExpression((Function)function)));
    }

    @NonNull
    public HttpRequestActionBuilder formParamMap(@NonNull Map<String, Object> map) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Converters.toScalaMap((Map)map)));
    }

    @NonNull
    public HttpRequestActionBuilder formParamMap(@NonNull Function<Session, Map<String, Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Expressions.javaMapFunctionToExpression((Function)function)));
    }

    @NonNull
    public HttpRequestActionBuilder form(@NonNull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formParamMap(Expressions.toMapExpression((String)string)));
    }

    @NonNull
    public HttpRequestActionBuilder form(@NonNull Function<Session, Map<String, Object>> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.form(Expressions.javaMapFunctionToExpression((Function)function)));
    }

    @NonNull
    public HttpRequestActionBuilder formUpload(@NonNull String string, @NonNull String string2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.toStringExpression((String)string2), Predef.rawFileBodies()));
    }

    @NonNull
    public HttpRequestActionBuilder formUpload(@NonNull Function<Session, String> function, @NonNull String string) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.toStringExpression((String)string), Predef.rawFileBodies()));
    }

    @NonNull
    public HttpRequestActionBuilder formUpload(@NonNull String string, Function<Session, String> function) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.toStringExpression((String)string), Expressions.javaFunctionToExpression((Function)function), Predef.rawFileBodies()));
    }

    @NonNull
    public HttpRequestActionBuilder formUpload(@NonNull Function<Session, String> function, @NonNull Function<Session, String> function2) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.formUpload(Expressions.javaFunctionToExpression((Function)function), Expressions.javaFunctionToExpression((Function)function2), Predef.rawFileBodies()));
    }

    @NonNull
    public HttpRequestActionBuilder requestTimeout(int n) {
        return this.requestTimeout(Duration.ofSeconds(n));
    }

    @NonNull
    public HttpRequestActionBuilder requestTimeout(@NonNull Duration duration) {
        return this.make(httpRequestBuilder -> httpRequestBuilder.requestTimeout(Converters.toScalaDuration((Duration)duration)));
    }

    public static final class UntypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Untyped wrapped;

        public UntypedCondition(ScalaHttpRequestActionBuilderConditions.Untyped untyped) {
            this.wrapped = untyped;
        }

        @NonNull
        public HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        @NonNull
        public HttpRequestActionBuilder then(@NonNull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }

    public static final class TypedCondition {
        private final ScalaHttpRequestActionBuilderConditions.Typed wrapped;

        public TypedCondition(ScalaHttpRequestActionBuilderConditions.Typed typed) {
            this.wrapped = typed;
        }

        @NonNull
        public HttpRequestActionBuilder then(CheckBuilder ... checkBuilderArray) {
            return this.then(Arrays.asList(checkBuilderArray));
        }

        @NonNull
        public HttpRequestActionBuilder then(@NonNull List<CheckBuilder> list) {
            return this.wrapped.then_(list);
        }
    }
}

