/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.util;

import io.gatling.netty.util.StringBuilderPool;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;

public final class StringUtils {
    private StringUtils() {
    }

    public static ByteBuffer charSequence2ByteBuffer(CharSequence charSequence, Charset charset) {
        return charset.encode(CharBuffer.wrap(charSequence));
    }

    public static byte[] byteBuffer2ByteArray(ByteBuffer byteBuffer) {
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return byArray;
    }

    public static byte[] charSequence2Bytes(CharSequence charSequence, Charset charset) {
        ByteBuffer byteBuffer = StringUtils.charSequence2ByteBuffer(charSequence, charset);
        return StringUtils.byteBuffer2ByteArray(byteBuffer);
    }

    public static String toHexString(byte[] byArray) {
        StringBuilder stringBuilder = StringBuilderPool.DEFAULT.get();
        for (byte by : byArray) {
            stringBuilder.append(Integer.toHexString((by & 0xF0) >>> 4));
            stringBuilder.append(Integer.toHexString(by & 0xF));
        }
        return stringBuilder.toString();
    }

    public static void appendBase16(StringBuilder stringBuilder, byte[] byArray) {
        int n = 16;
        for (byte by : byArray) {
            int n2 = 0xFF & by;
            int n3 = 48 + n2 / n % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
            n3 = 48 + n2 % n;
            if (n3 > 57) {
                n3 = 97 + (n3 - 48 - 10);
            }
            stringBuilder.append((char)n3);
        }
    }
}

