/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.sign;

import io.gatling.http.client.Request;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBody;
import io.gatling.http.client.oauth.ConsumerKey;
import io.gatling.http.client.oauth.OAuthSignatureCalculatorInstance;
import io.gatling.http.client.oauth.RequestToken;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.List;

public class OAuthSignatureCalculator
implements SignatureCalculator {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = ThreadLocal.withInitial(() -> {
        try {
            return new OAuthSignatureCalculatorInstance();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new ExceptionInInitializerError(noSuchAlgorithmException);
        }
    });
    private final ConsumerKey consumerAuth;
    private final RequestToken requestToken;

    public OAuthSignatureCalculator(ConsumerKey consumerKey, RequestToken requestToken) {
        this.consumerAuth = consumerKey;
        this.requestToken = requestToken;
    }

    @Override
    public void sign(Request request) throws Exception {
        RequestBody requestBody = request.getBody();
        List list = requestBody instanceof FormUrlEncodedRequestBody ? (List)((FormUrlEncodedRequestBody)requestBody).getContent() : Collections.emptyList();
        String string = INSTANCES.get().computeAuthorizationHeader(this.consumerAuth, this.requestToken, request.getMethod(), request.getUri(), list);
        request.getHeaders().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)string);
    }
}

