/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.bytearray;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.bytearray.ByteArrayRequestBodyBuilder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.Charset;
import java.util.Base64;

public final class ByteArrayRequestBody
extends RequestBody<byte[]> {
    private final String fileName;
    private final Charset charset;

    public ByteArrayRequestBody(byte[] byArray, String string, String string2, Charset charset) {
        super(byArray, string);
        this.fileName = string2;
        this.charset = charset;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        return new WritableContent(Unpooled.wrappedBuffer((byte[])((byte[])this.content)), ((byte[])this.content).length);
    }

    @Override
    public RequestBodyBuilder<byte[]> newBuilder() {
        return new ByteArrayRequestBodyBuilder((byte[])this.content, this.fileName);
    }

    @Override
    public byte[] getBytes() {
        return (byte[])this.content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public String toString() {
        return "ByteArrayRequestBody{contentType='" + this.contentType + '\'' + ", content (Base64)=" + Base64.getEncoder().encodeToString((byte[])this.content) + '}';
    }
}

