/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.uri;

import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Assertions;
import io.gatling.http.client.util.MiscUtils;

final class UriParser {
    public String scheme;
    public String host;
    public int port = -1;
    public String query;
    public String fragment;
    private String authority;
    public String path;
    public String userInfo;
    private String originalUrl;
    private int start;
    private int end;
    private int currentIndex = 0;

    UriParser() {
    }

    private void trimLeft() {
        while (this.start < this.end && this.originalUrl.charAt(this.start) <= ' ') {
            ++this.start;
        }
        if (this.originalUrl.regionMatches(true, this.start, "url:", 0, 4)) {
            this.start += 4;
        }
    }

    private void trimRight() {
        this.end = this.originalUrl.length();
        while (this.end > 0 && this.originalUrl.charAt(this.end - 1) <= ' ') {
            --this.end;
        }
    }

    private boolean isFragmentOnly() {
        return this.start < this.originalUrl.length() && this.originalUrl.charAt(this.start) == '#';
    }

    private boolean isValidProtocolChar(char c) {
        return Character.isLetterOrDigit(c) && c != '.' && c != '+' && c != '-';
    }

    private boolean isValidProtocolChars(String string) {
        for (int i = 1; i < string.length(); ++i) {
            if (this.isValidProtocolChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean isValidProtocol(String string) {
        return string.length() > 0 && Character.isLetter(string.charAt(0)) && this.isValidProtocolChars(string);
    }

    private void computeInitialScheme() {
        for (int i = this.currentIndex; i < this.end; ++i) {
            char c = this.originalUrl.charAt(i);
            if (c == ':') {
                String string = this.originalUrl.substring(this.currentIndex, i);
                if (!this.isValidProtocol(string)) break;
                this.scheme = string.toLowerCase();
                this.currentIndex = i + 1;
                break;
            }
            if (c == '/') break;
        }
    }

    private boolean overrideWithContext(Uri uri) {
        boolean bl = false;
        if (uri != null && (this.scheme == null || this.scheme.equalsIgnoreCase(uri.getScheme()))) {
            String string = uri.getPath();
            if (MiscUtils.isNonEmpty(string) && string.charAt(0) == '/') {
                this.scheme = null;
            }
            if (this.scheme == null) {
                this.scheme = uri.getScheme();
                this.userInfo = uri.getUserInfo();
                this.host = uri.getHost();
                this.port = uri.getPort();
                this.path = string;
                bl = true;
            }
        }
        return bl;
    }

    private int findWithinCurrentRange(char c) {
        int n = this.originalUrl.indexOf(c, this.currentIndex);
        return n > this.end ? -1 : n;
    }

    private void trimFragment() {
        int n = this.findWithinCurrentRange('#');
        if (n >= 0) {
            this.end = n;
            if (n + 1 < this.originalUrl.length()) {
                this.fragment = this.originalUrl.substring(n + 1);
            }
        }
    }

    private void inheritContextQuery(Uri uri, boolean bl) {
        if (bl && this.currentIndex == this.end) {
            this.query = uri.getQuery();
            this.fragment = uri.getFragment();
        }
    }

    private boolean computeQuery() {
        int n;
        if (this.currentIndex < this.end && (n = this.findWithinCurrentRange('?')) != -1) {
            this.query = this.originalUrl.substring(n + 1, this.end);
            if (this.end > n) {
                this.end = n;
            }
            return n == this.currentIndex;
        }
        return false;
    }

    private boolean currentPositionStartsWith4Slashes() {
        return this.originalUrl.regionMatches(this.currentIndex, "////", 0, 4);
    }

    private boolean currentPositionStartsWith2Slashes() {
        return this.originalUrl.regionMatches(this.currentIndex, "//", 0, 2);
    }

    private void computeAuthority() {
        int n = this.findWithinCurrentRange('/');
        if (n == -1 && (n = this.findWithinCurrentRange('?')) == -1) {
            n = this.end;
        }
        this.host = this.authority = this.originalUrl.substring(this.currentIndex, n);
        this.currentIndex = n;
    }

    private void computeUserInfo() {
        int n = this.authority.indexOf(64);
        if (n != -1) {
            this.userInfo = this.authority.substring(0, n);
            this.host = this.authority.substring(n + 1);
        } else {
            this.userInfo = null;
        }
    }

    private boolean isMaybeIPV6() {
        return this.host.length() > 0 && this.host.charAt(0) == '[';
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void computeIPV6() {
        int n = this.host.indexOf(93) + 1;
        if (n <= 1) throw new IllegalArgumentException("Invalid authority field: " + this.authority);
        this.port = -1;
        if (this.host.length() > n) {
            if (this.host.charAt(n) != ':') throw new IllegalArgumentException("Invalid authority field: " + this.authority);
            int n2 = n + 1;
            if (this.host.length() > n2) {
                this.port = Integer.parseInt(this.host.substring(n2));
            }
        }
        this.host = this.host.substring(0, n);
    }

    private void computeRegularHostPort() {
        int n = this.host.indexOf(58);
        this.port = -1;
        if (n >= 0) {
            int n2 = n + 1;
            if (this.host.length() > n2) {
                this.port = Integer.parseInt(this.host.substring(n2));
            }
            this.host = this.host.substring(0, n);
        }
    }

    private void removeEmbeddedDot() {
        this.path = this.path.replace("/./", "/");
    }

    private void removeEmbedded2Dots() {
        int n = 0;
        while ((n = this.path.indexOf("/../", n)) >= 0) {
            if (n > 0) {
                this.end = this.path.lastIndexOf(47, n - 1);
                if (this.end >= 0 && this.path.indexOf("/../", this.end) != 0) {
                    this.path = this.path.substring(0, this.end) + this.path.substring(n + 3);
                    n = 0;
                    continue;
                }
                if (this.end != 0) continue;
                break;
            }
            n += 3;
        }
    }

    private void removeTailing2Dots() {
        while (this.path.endsWith("/..")) {
            this.end = this.path.lastIndexOf(47, this.path.length() - 4);
            if (this.end < 0) break;
            this.path = this.path.substring(0, this.end + 1);
        }
    }

    private void removeStartingDot() {
        if (this.path.startsWith("./") && this.path.length() > 2) {
            this.path = this.path.substring(2);
        }
    }

    private void removeTrailingDot() {
        if (this.path.endsWith("/.")) {
            this.path = this.path.substring(0, this.path.length() - 1);
        }
    }

    private void handleRelativePath() {
        int n = this.path.lastIndexOf(47);
        String string = this.originalUrl.substring(this.currentIndex, this.end);
        this.path = n == -1 ? (this.authority != null ? "/" + string : string) : this.path.substring(0, n + 1) + string;
    }

    private void handleConsecutiveSlashes() {
        StringBuilder stringBuilder = null;
        boolean bl = false;
        for (int i = 0; i < this.path.length(); ++i) {
            char c = this.path.charAt(i);
            if (c == '/') {
                if (bl) {
                    if (stringBuilder == null) {
                        stringBuilder = new StringBuilder(this.path.length() - 1);
                        stringBuilder.append(this.path, 0, i);
                    }
                } else if (stringBuilder != null) {
                    stringBuilder.append(c);
                }
                bl = true;
                continue;
            }
            bl = false;
            if (stringBuilder == null) continue;
            stringBuilder.append(c);
        }
        this.path = stringBuilder != null ? stringBuilder.toString() : this.path;
    }

    private void handlePathDots() {
        if (this.path.indexOf(46) != -1) {
            this.removeEmbeddedDot();
            this.removeEmbedded2Dots();
            this.removeTailing2Dots();
            this.removeStartingDot();
            this.removeTrailingDot();
        }
    }

    private void parseAuthority() {
        if (!this.currentPositionStartsWith4Slashes() && this.currentPositionStartsWith2Slashes()) {
            this.currentIndex += 2;
            this.computeAuthority();
            this.computeUserInfo();
            if (this.host != null) {
                if (this.isMaybeIPV6()) {
                    this.computeIPV6();
                } else {
                    this.computeRegularHostPort();
                }
            }
            if (this.port < -1) {
                throw new IllegalArgumentException("Invalid port number :" + this.port);
            }
            if (MiscUtils.isNonEmpty(this.authority)) {
                this.path = "";
            }
        }
    }

    private void computeRegularPath() {
        if (this.originalUrl.charAt(this.currentIndex) == '/') {
            this.path = this.originalUrl.substring(this.currentIndex, this.end);
        } else if (MiscUtils.isNonEmpty(this.path)) {
            this.handleRelativePath();
        } else {
            String string = this.originalUrl.substring(this.currentIndex, this.end);
            this.path = MiscUtils.isNonEmpty(string) && string.charAt(0) != '/' ? "/" + string : string;
        }
        this.handlePathDots();
        this.handleConsecutiveSlashes();
    }

    private void computeQueryOnlyPath() {
        int n = this.path.lastIndexOf(47);
        this.path = n < 0 ? "/" : this.path.substring(0, n) + "/";
    }

    private void computePath(boolean bl) {
        if (this.currentIndex < this.end) {
            this.computeRegularPath();
        } else if (bl && this.path != null) {
            this.computeQueryOnlyPath();
        } else if (this.path == null) {
            this.path = "";
        }
    }

    public void parse(Uri uri, String string) {
        Assertions.assertNotNull(string, "originalUrl");
        this.originalUrl = string;
        this.end = string.length();
        this.trimLeft();
        this.trimRight();
        this.currentIndex = this.start;
        if (!this.isFragmentOnly()) {
            this.computeInitialScheme();
        }
        boolean bl = this.overrideWithContext(uri);
        this.trimFragment();
        this.inheritContextQuery(uri, bl);
        boolean bl2 = this.computeQuery();
        this.parseAuthority();
        this.computePath(bl2);
    }
}

