/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.string;

import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.RequestBodyBuilder;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.body.string.StringRequestBodyBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public final class StringRequestBody
extends RequestBody<String> {
    private final Charset charset;

    public StringRequestBody(String string, String string2, Charset charset) {
        super(string, string2);
        this.charset = charset;
    }

    @Override
    public WritableContent build(ByteBufAllocator byteBufAllocator) {
        ByteBuf byteBuf = this.charset.equals(StandardCharsets.UTF_8) ? ByteBufUtil.writeUtf8((ByteBufAllocator)byteBufAllocator, (CharSequence)((CharSequence)this.content)) : ByteBufUtil.encodeString((ByteBufAllocator)byteBufAllocator, (CharBuffer)CharBuffer.wrap((CharSequence)this.content), (Charset)this.charset);
        return new WritableContent(byteBuf, byteBuf.readableBytes());
    }

    @Override
    public RequestBodyBuilder<String> newBuilder() {
        return new StringRequestBodyBuilder((String)this.content);
    }

    @Override
    public byte[] getBytes() {
        return ((String)this.content).getBytes(this.charset);
    }

    public String toString() {
        return "StringRequestBody{content=" + (String)this.content + ", contentType=" + this.contentType + ", charset=" + this.charset + '}';
    }
}

