/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.proxy;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.InternetProtocolFamily;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ProxyProtocolHandler
extends ChannelDuplexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProxyProtocolHandler.class);
    private final String sourceIpV4Address;
    private final String sourceIpV6Address;

    public ProxyProtocolHandler(String string, String string2) {
        this.sourceIpV4Address = string;
        this.sourceIpV6Address = string2;
    }

    private String version1Header(InternetProtocolFamily internetProtocolFamily, int n, InetSocketAddress inetSocketAddress) {
        StringBuilder stringBuilder = new StringBuilder("PROXY TCP");
        if (internetProtocolFamily == InternetProtocolFamily.IPv4) {
            if (this.sourceIpV4Address == null) {
                return null;
            }
            stringBuilder.append("4 ").append(this.sourceIpV4Address);
        } else {
            if (this.sourceIpV6Address == null) {
                return null;
            }
            stringBuilder.append("6 ").append(this.sourceIpV6Address);
        }
        return stringBuilder.append(" ").append(inetSocketAddress.getAddress().getHostAddress()).append(" ").append(n).append(" ").append(inetSocketAddress.getPort()).append("\r\n").toString();
    }

    public void channelActive(ChannelHandlerContext channelHandlerContext) throws Exception {
        int n;
        InetSocketAddress inetSocketAddress = (InetSocketAddress)channelHandlerContext.channel().localAddress();
        InetSocketAddress inetSocketAddress2 = (InetSocketAddress)channelHandlerContext.channel().remoteAddress();
        InternetProtocolFamily internetProtocolFamily = InternetProtocolFamily.of((InetAddress)inetSocketAddress.getAddress());
        String string = this.version1Header(internetProtocolFamily, n = ThreadLocalRandom.current().nextInt(1001, 65536), inetSocketAddress2);
        if (string == null) {
            LOGGER.debug("Skipping Proxy Protocol header generation because no fake source address was provided for protocol {}", (Object)internetProtocolFamily);
        } else {
            LOGGER.debug("Sending Proxy Protocol header {} for protocol {}", (Object)string, (Object)internetProtocolFamily);
            channelHandlerContext.write((Object)Unpooled.wrappedBuffer((byte[])string.getBytes(StandardCharsets.US_ASCII)));
        }
        channelHandlerContext.pipeline().remove((ChannelHandler)this);
        super.channelActive(channelHandlerContext);
    }
}

