/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl;

import io.gatling.http.client.Http2PriorKnowledge;
import io.gatling.http.client.HttpClient;
import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.HttpListener;
import io.gatling.http.client.LocalAddresses;
import io.gatling.http.client.Request;
import io.gatling.http.client.SslContextsHolder;
import io.gatling.http.client.body.is.InputStreamRequestBody;
import io.gatling.http.client.impl.AllowClientNoContextWebSocketClientCompressionHandler;
import io.gatling.http.client.impl.Http2AppHandler;
import io.gatling.http.client.impl.HttpAppHandler;
import io.gatling.http.client.impl.HttpTx;
import io.gatling.http.client.impl.NoopHandler;
import io.gatling.http.client.impl.NotAggregatingInboundHttp2ToHttpAdapter;
import io.gatling.http.client.impl.RequestTimeout;
import io.gatling.http.client.impl.SslHandlers;
import io.gatling.http.client.impl.WebSocketHandler;
import io.gatling.http.client.impl.chunk.ForkedChunkedWriteHandler;
import io.gatling.http.client.impl.compression.CustomDelegatingDecompressorFrameListener;
import io.gatling.http.client.impl.compression.CustomHttpContentDecompressor;
import io.gatling.http.client.pool.ChannelPool;
import io.gatling.http.client.pool.ChannelPoolKey;
import io.gatling.http.client.pool.RemoteKey;
import io.gatling.http.client.proxy.HttpProxyServer;
import io.gatling.http.client.proxy.ProxyProtocolHandler;
import io.gatling.http.client.proxy.ProxyServer;
import io.gatling.http.client.ssl.Tls;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.util.Pair;
import io.gatling.netty.util.Transports;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpDecoderConfig;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.DefaultEventExecutor;
import io.netty.util.concurrent.DefaultPromise;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultHttpClient
implements HttpClient {
    private static final Http2Settings DEFAULT_HTTP2_SETTINGS = Http2Settings.defaultSettings();
    private static final Logger LOGGER;
    private static final String PINNED_HANDLER = "pinned";
    private static final String PROXY_SSL_HANDLER = "ssl-proxy";
    private static final String PROXY_HANDLER = "proxy";
    private static final String PROXY_PROTOCOL_HANDLER = "proxy-protocol";
    private static final String SSL_HANDLER = "ssl";
    public static final String HTTP_CLIENT_CODEC = "http";
    private static final String HTTP2_HANDLER = "http2";
    private static final String INFLATER_HANDLER = "inflater";
    private static final String CHUNKED_WRITER_HANDLER = "chunked-writer";
    private static final String WS_OBJECT_AGGREGATOR = "ws-object-aggregator";
    private static final String WS_COMPRESSION = "ws-compression";
    private static final String WS_FRAME_AGGREGATOR = "ws-frame-aggregator";
    private static final String APP_WS_HANDLER = "app-ws";
    private static final String ALPN_HANDLER = "alpn";
    static final String APP_HTTP2_HANDLER = "app-http2";
    public static final String APP_HTTP_HANDLER = "app-http";
    private static final HttpDecoderConfig HTTP_DECODER_CONFIG;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HttpClientConfig config;
    private final EventExecutor channelGroupEventExecutor;
    private final ChannelGroup channelGroup;
    private final FastThreadLocal<EventLoopResources> eventLoopResources = new FastThreadLocal();
    private final long idleTimeoutNanos;
    private static final Exception IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT;

    private ChannelHandler newHttpClientCodec() {
        return new HttpClientCodec(HTTP_DECODER_CONFIG, false, false);
    }

    public DefaultHttpClient(HttpClientConfig httpClientConfig) {
        this.config = httpClientConfig;
        this.channelGroupEventExecutor = new DefaultEventExecutor();
        this.channelGroup = new DefaultChannelGroup(this.channelGroupEventExecutor);
        this.idleTimeoutNanos = httpClientConfig.getChannelPoolIdleTimeout() * 1000000L;
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.channelGroup.close().awaitUninterruptibly();
            this.channelGroupEventExecutor.shutdownGracefully(0L, 1L, TimeUnit.SECONDS);
            SslContextsHolder sslContextsHolder = this.config.getDefaultSslContextsHolder();
            if (sslContextsHolder != null) {
                ReferenceCountUtil.release((Object)sslContextsHolder.getSslContext());
                ReferenceCountUtil.release((Object)sslContextsHolder.getAlpnSslContext());
            }
        }
    }

    @Override
    public void sendRequest(Request request, long l, EventLoop eventLoop, HttpListener httpListener, SslContextsHolder sslContextsHolder) {
        if (this.isClosed()) {
            return;
        }
        if (sslContextsHolder == null) {
            sslContextsHolder = this.config.getDefaultSslContextsHolder();
        }
        HttpTx httpTx = this.buildTx(request, l, httpListener, sslContextsHolder);
        if (eventLoop.inEventLoop()) {
            this.sendTx(httpTx, eventLoop);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.sendTx(httpTx, eventLoop));
        }
    }

    @Override
    public void sendHttp2Requests(Pair<Request, HttpListener>[] pairArray, long l, EventLoop eventLoop, SslContextsHolder sslContextsHolder) {
        if (this.isClosed()) {
            return;
        }
        for (Pair<Request, HttpListener> pair : pairArray) {
            pair.getRight().onSend();
        }
        Request request = pairArray[0].getLeft();
        if (request.getUri().isSecured() && request.isHttp2Enabled() && !this.config.isEnableSni()) {
            for (Pair<Request, HttpListener> pair : pairArray) {
                HttpListener httpListener = pair.getRight();
                httpListener.onThrowable(new UnsupportedOperationException("HTTP/2 can't work if SNI is disabled."));
            }
            return;
        }
        if (sslContextsHolder == null) {
            sslContextsHolder = this.config.getDefaultSslContextsHolder();
        }
        ArrayList<HttpTx> arrayList = new ArrayList<HttpTx>(pairArray.length);
        for (Pair<Request, HttpListener> pair : pairArray) {
            Request request2 = pair.getLeft();
            HttpListener httpListener = pair.getRight();
            arrayList.add(this.buildTx(request2, l, httpListener, sslContextsHolder));
        }
        if (eventLoop.inEventLoop()) {
            this.sendHttp2Txs(arrayList, eventLoop);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.sendHttp2Txs(arrayList, eventLoop));
        }
    }

    private EventLoopResources eventLoopResources(EventLoop eventLoop) {
        EventLoopResources eventLoopResources = (EventLoopResources)this.eventLoopResources.get();
        if (eventLoopResources == null) {
            eventLoopResources = new EventLoopResources(eventLoop);
            this.eventLoopResources.set((Object)eventLoopResources);
        }
        return eventLoopResources;
    }

    private HttpTx buildTx(Request request, long l, HttpListener httpListener, SslContextsHolder sslContextsHolder) {
        RequestTimeout requestTimeout = RequestTimeout.requestTimeout(request.getRequestTimeout(), httpListener);
        ChannelPoolKey channelPoolKey = new ChannelPoolKey(l, RemoteKey.newKey(request.getUri(), request.getProxyServer()));
        return new HttpTx(request, httpListener, requestTimeout, channelPoolKey, sslContextsHolder);
    }

    boolean canRetry(HttpTx httpTx) {
        return httpTx.channelState == HttpTx.ChannelState.POOLED && (!(httpTx.request.getBody() instanceof InputStreamRequestBody) || !((InputStreamRequestBody)httpTx.request.getBody()).isConsumed());
    }

    void retry(HttpTx httpTx, EventLoop eventLoop) {
        if (this.isClosed()) {
            return;
        }
        httpTx.channelState = HttpTx.ChannelState.RETRY;
        LOGGER.debug("Retrying with new HTTP/1.1 connection");
        this.sendTx(httpTx, eventLoop);
    }

    void retryHttp2(List<HttpTx> list, EventLoop eventLoop) {
        if (this.isClosed()) {
            return;
        }
        for (HttpTx httpTx : list) {
            httpTx.channelState = HttpTx.ChannelState.RETRY;
        }
        LOGGER.debug("Retrying with new HTTP/2 connection");
        this.sendHttp2Txs(list, eventLoop);
    }

    private void sendTx(HttpTx httpTx, EventLoop eventLoop) {
        EventLoopResources eventLoopResources = this.eventLoopResources(eventLoop);
        Request request = httpTx.request;
        HttpListener httpListener = httpTx.listener;
        RequestTimeout requestTimeout = httpTx.requestTimeout;
        Uri uri = request.getUri();
        boolean bl = request.isHttp2Enabled() && uri.isSecured() && !uri.isWebSocket();
        Channel channel = uri.isWebSocket() ? null : eventLoopResources.channelPool.poll(httpTx.key);
        httpListener.onSend();
        httpTx.requestTimeout.start(eventLoop);
        if (channel != null && httpTx.channelState != HttpTx.ChannelState.RETRY) {
            this.sendTxWithChannel(httpTx, channel);
        } else {
            InetSocketAddress inetSocketAddress = this.proxyHandlerUnresolvedRemoteAddress(request.getProxyServer(), uri);
            boolean bl2 = inetSocketAddress != null;
            this.resolveChannelRemoteAddresses(request, eventLoop, inetSocketAddress, httpListener, requestTimeout).addListener(future -> {
                if (requestTimeout.isDone()) {
                    return;
                }
                if (future.isSuccess()) {
                    List list = (List)future.getNow();
                    if (bl && httpTx.channelState != HttpTx.ChannelState.RETRY) {
                        String string = uri.getHost();
                        Channel channel = eventLoopResources.channelPool.pollCoalescedChannel(httpTx.key.clientId, string, list);
                        if (channel != null) {
                            httpTx.listener.onProtocolAwareness(true);
                            this.sendTxWithChannel(httpTx, channel);
                        } else {
                            this.sendTxWithNewChannel(httpTx, eventLoopResources, eventLoop, list, bl2);
                        }
                    } else {
                        this.sendTxWithNewChannel(httpTx, eventLoopResources, eventLoop, list, bl2);
                    }
                }
            });
        }
    }

    private void sendHttp2Txs(List<HttpTx> list, EventLoop eventLoop) {
        HttpTx httpTx = list.get(0);
        EventLoopResources eventLoopResources = this.eventLoopResources(eventLoop);
        Request request = httpTx.request;
        HttpListener httpListener = httpTx.listener;
        RequestTimeout requestTimeout = httpTx.requestTimeout;
        Uri uri = request.getUri();
        for (HttpTx object2 : list) {
            object2.requestTimeout.start(eventLoop);
        }
        ProxyServer proxyServer = request.getProxyServer();
        InetSocketAddress inetSocketAddress = this.proxyHandlerUnresolvedRemoteAddress(proxyServer, uri);
        boolean bl = inetSocketAddress != null;
        this.resolveChannelRemoteAddresses(request, eventLoop, inetSocketAddress, httpListener, requestTimeout).addListener(future -> {
            if (requestTimeout.isDone()) {
                return;
            }
            if (future.isSuccess()) {
                List list2 = (List)future.getNow();
                String string = uri.getHost();
                Channel channel = eventLoopResources.channelPool.poll(httpTx.key);
                if (channel == null) {
                    channel = eventLoopResources.channelPool.pollCoalescedChannel(httpTx.key.clientId, string, list2);
                }
                if (channel != null) {
                    this.sendHttp2TxsWithChannel(list, channel);
                } else {
                    this.sendHttp2TxsWithNewChannel(list, eventLoopResources, eventLoop, list2, bl);
                }
            }
        });
    }

    private void sendTxWithChannel(HttpTx httpTx, Channel channel) {
        if (this.isClosed()) {
            return;
        }
        if (ChannelPool.isHttp2(channel)) {
            httpTx.listener.onProtocolAwareness(true);
        }
        httpTx.requestTimeout.setChannel(channel);
        channel.write((Object)httpTx);
    }

    private void sendHttp2TxsWithChannel(List<HttpTx> list, Channel channel) {
        if (this.isClosed()) {
            return;
        }
        for (HttpTx httpTx : list) {
            httpTx.requestTimeout.setChannel(channel);
            httpTx.listener.onProtocolAwareness(true);
            channel.write((Object)httpTx);
        }
    }

    private static boolean proxyHandlerSupportsUri(ProxyServer proxyServer, Uri uri) {
        return !(proxyServer instanceof HttpProxyServer) || uri.isSecured();
    }

    private InetSocketAddress proxyHandlerUnresolvedRemoteAddress(ProxyServer proxyServer, Uri uri) {
        return proxyServer != null && DefaultHttpClient.proxyHandlerSupportsUri(proxyServer, uri) ? InetSocketAddress.createUnresolved(uri.getHost(), uri.getExplicitPort()) : null;
    }

    private Future<List<InetSocketAddress>> resolveChannelRemoteAddresses(Request request, EventLoop eventLoop, InetSocketAddress inetSocketAddress, HttpListener httpListener, RequestTimeout requestTimeout) {
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer != null) {
            InetSocketAddress inetSocketAddress2 = inetSocketAddress != null ? inetSocketAddress : proxyServer.getAddress();
            return ImmediateEventExecutor.INSTANCE.newSucceededFuture(List.of(inetSocketAddress2));
        }
        Promise promise = eventLoop.newPromise();
        request.getNameResolver().resolveAll(request.getUri().getHost(), (Promise<List<InetAddress>>)eventLoop.newPromise(), httpListener).addListener(future -> {
            if (future.isSuccess()) {
                List list = ((List)future.getNow()).stream().map(inetAddress -> new InetSocketAddress((InetAddress)inetAddress, request.getUri().getExplicitPort())).collect(Collectors.toList());
                promise.setSuccess(list);
            } else {
                if (!requestTimeout.isDone()) {
                    httpListener.onThrowable(future.cause());
                }
                promise.setFailure(future.cause());
                requestTimeout.cancel();
            }
        });
        return promise;
    }

    private void sendTxWithNewChannel(HttpTx httpTx, EventLoopResources eventLoopResources, EventLoop eventLoop, List<InetSocketAddress> list, boolean bl) {
        httpTx.channelState = HttpTx.ChannelState.NEW;
        this.openNewChannel(httpTx, httpTx.request, bl, eventLoop, eventLoopResources, list, httpTx.listener, httpTx.requestTimeout).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                if (httpTx.requestTimeout.isDone()) {
                    channel.close();
                    return;
                }
                this.channelGroup.add((Object)channel);
                ChannelPool.registerPoolKey(channel, httpTx.key);
                Uri uri = httpTx.request.getUri();
                if (uri.isSecured()) {
                    this.installSslHandler(httpTx, channel, uri.getHost(), uri.getExplicitPort(), SSL_HANDLER).addListener(future2 -> {
                        if (httpTx.requestTimeout.isDone() || !future2.isSuccess()) {
                            channel.close();
                            return;
                        }
                        if (!httpTx.request.isHttp2Enabled() || httpTx.request.getHttp2PriorKnowledge() == Http2PriorKnowledge.HTTP1_ONLY) {
                            this.sendTxWithChannel(httpTx, channel);
                        } else {
                            LOGGER.debug("Installing Http2Handler for {}", (Object)uri);
                            this.installHttp2Handler(httpTx, channel, eventLoopResources.channelPool).addListener(future -> {
                                if (httpTx.requestTimeout.isDone() || !future.isSuccess()) {
                                    channel.close();
                                    return;
                                }
                                this.sendTxWithChannel(httpTx, channel);
                            });
                        }
                    });
                } else {
                    this.sendTxWithChannel(httpTx, channel);
                }
            }
        });
    }

    private void sendHttp2TxsWithNewChannel(List<HttpTx> list, EventLoopResources eventLoopResources, EventLoop eventLoop, List<InetSocketAddress> list2, boolean bl) {
        HttpTx httpTx = list.get(0);
        this.openNewChannel(httpTx, httpTx.request, bl, eventLoop, eventLoopResources, list2, httpTx.listener, httpTx.requestTimeout).addListener(future -> {
            if (future.isSuccess()) {
                Channel channel = (Channel)future.getNow();
                if (httpTx.requestTimeout.isDone()) {
                    channel.close();
                    return;
                }
                this.channelGroup.add((Object)channel);
                ChannelPool.registerPoolKey(channel, httpTx.key);
                Uri uri = httpTx.request.getUri();
                LOGGER.debug("Installing SslHandler for {}", (Object)uri);
                this.installSslHandler(httpTx, channel, uri.getHost(), uri.getExplicitPort(), SSL_HANDLER).addListener(future2 -> {
                    if (httpTx.requestTimeout.isDone() || !future2.isSuccess()) {
                        channel.close();
                        return;
                    }
                    LOGGER.debug("Installing Http2Handler for {}", (Object)uri);
                    this.installHttp2Handler(httpTx, channel, eventLoopResources.channelPool).addListener(future -> {
                        if (httpTx.requestTimeout.isDone() || !future.isSuccess()) {
                            channel.close();
                            return;
                        }
                        this.sendHttp2TxsWithChannel(list, channel);
                    });
                });
            }
        });
    }

    private Bootstrap bootstrap(HttpTx httpTx, Request request, EventLoopResources eventLoopResources) {
        Uri uri = request.getUri();
        ProxyServer proxyServer = request.getProxyServer();
        if (proxyServer != null) {
            if (uri.isWebSocket()) {
                return eventLoopResources.getWsBootstrapWithProxy(httpTx, proxyServer);
            }
            return eventLoopResources.getHttp1BootstrapWithProxy(httpTx, proxyServer);
        }
        if (uri.isWebSocket()) {
            return eventLoopResources.wsBootstrap;
        }
        if (uri.isSecured() && request.isHttp2Enabled() && request.getHttp2PriorKnowledge() != Http2PriorKnowledge.HTTP1_ONLY) {
            return eventLoopResources.http2Bootstrap;
        }
        return eventLoopResources.http1Bootstrap;
    }

    private Future<Channel> openNewChannel(HttpTx httpTx, Request request, boolean bl, EventLoop eventLoop, EventLoopResources eventLoopResources, List<InetSocketAddress> list, HttpListener httpListener, RequestTimeout requestTimeout) {
        LOGGER.debug("Opening new channel to remote={} from local={}", list, (Object)request.getLocalAddresses());
        Bootstrap bootstrap = this.bootstrap(httpTx, request, eventLoopResources);
        Promise promise = eventLoop.newPromise();
        InetSocketAddress inetSocketAddress = bl ? request.getProxyServer().getAddress() : null;
        this.openNewChannelRec(list, inetSocketAddress, request.getLocalAddresses(), 0, (Promise<Channel>)promise, bootstrap, httpListener, requestTimeout);
        return promise;
    }

    private void openNewChannelRec(List<InetSocketAddress> list, InetSocketAddress inetSocketAddress, LocalAddresses localAddresses, int n, Promise<Channel> promise, Bootstrap bootstrap, HttpListener httpListener, RequestTimeout requestTimeout) {
        InetSocketAddress inetSocketAddress2;
        InetSocketAddress inetSocketAddress3;
        if (this.isClosed()) {
            return;
        }
        InetSocketAddress inetSocketAddress4 = list.get(n);
        boolean bl = false;
        if (localAddresses == null) {
            inetSocketAddress3 = null;
        } else {
            inetSocketAddress2 = localAddresses.getLocalAddressForRemote(inetSocketAddress4.getAddress());
            if (inetSocketAddress2 == null) {
                inetSocketAddress3 = null;
                bl = true;
            } else {
                inetSocketAddress3 = inetSocketAddress2;
            }
        }
        if (bl) {
            int n2 = n + 1;
            if (n2 < list.size()) {
                this.openNewChannelRec(list, inetSocketAddress, localAddresses, n2, promise, bootstrap, httpListener, requestTimeout);
            } else {
                requestTimeout.cancel();
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException("Can't connect to remote " + String.valueOf(list) + " + from local " + String.valueOf(localAddresses));
                httpListener.onThrowable(unsupportedOperationException);
                promise.setFailure((Throwable)unsupportedOperationException);
            }
        } else {
            inetSocketAddress2 = bootstrap.connect((SocketAddress)inetSocketAddress4, inetSocketAddress3);
            inetSocketAddress2.addListener(arg_0 -> this.lambda$openNewChannelRec$12(inetSocketAddress4, (ChannelFuture)inetSocketAddress2, promise, inetSocketAddress3, requestTimeout, n, list, inetSocketAddress, localAddresses, bootstrap, httpListener, arg_0));
        }
    }

    private Future<Channel> installSslHandler(HttpTx httpTx, Channel channel, String string, int n, String string2) {
        LOGGER.debug("Installing SslHandler for {}:{}", (Object)string, (Object)n);
        try {
            SslHandler sslHandler = SslHandlers.newSslHandler(httpTx.sslContext(), channel.alloc(), string, n, this.config);
            ChannelPipeline channelPipeline = channel.pipeline();
            String string3 = channelPipeline.get(PROXY_HANDLER) != null ? PROXY_HANDLER : PINNED_HANDLER;
            channelPipeline.addAfter(string3, string2, (ChannelHandler)sslHandler);
            return sslHandler.handshakeFuture().addListener(future -> {
                if (httpTx.requestTimeout.isDone()) {
                    return;
                }
                if (future.isSuccess()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("TLS handshake successful: peerHost={} peerPort={} protocol={} cipher suite={}", new Object[]{sslHandler.engine().getSession().getPeerHost(), sslHandler.engine().getSession().getPeerPort(), sslHandler.engine().getSession().getProtocol(), sslHandler.engine().getSession().getCipherSuite()});
                    }
                } else {
                    httpTx.requestTimeout.cancel();
                    httpTx.listener.onThrowable(future.cause());
                }
            });
        }
        catch (RuntimeException runtimeException) {
            httpTx.requestTimeout.cancel();
            httpTx.listener.onThrowable(runtimeException);
            return new DefaultPromise((EventExecutor)ImmediateEventExecutor.INSTANCE).setFailure((Throwable)runtimeException);
        }
    }

    private Future<Void> installHttp2Handler(final HttpTx httpTx, final Channel channel, final ChannelPool channelPool) {
        final Promise promise = channel.eventLoop().newPromise();
        channel.pipeline().addAfter(SSL_HANDLER, ALPN_HANDLER, (ChannelHandler)new ApplicationProtocolNegotiationHandler("http/1.1"){

            protected void configurePipeline(ChannelHandlerContext channelHandlerContext, String string) throws Exception {
                switch (string) {
                    case "h2": {
                        LOGGER.debug("ALPN led to HTTP/2 with remote {}", (Object)httpTx.request.getUri().getHost());
                        httpTx.listener.onProtocolAwareness(true);
                        DefaultHttp2Connection defaultHttp2Connection = new DefaultHttp2Connection(false);
                        ChannelPool.registerHttp2Connection(channel, (Http2Connection)defaultHttp2Connection);
                        HttpToHttp2ConnectionHandler httpToHttp2ConnectionHandler = new HttpToHttp2ConnectionHandlerBuilder().initialSettings(DEFAULT_HTTP2_SETTINGS).connection((Http2Connection)defaultHttp2Connection).frameListener((Http2FrameListener)new CustomDelegatingDecompressorFrameListener((Http2Connection)defaultHttp2Connection, (Http2FrameListener)new NotAggregatingInboundHttp2ToHttpAdapter((Http2Connection)defaultHttp2Connection, (Promise<Void>)promise))).build();
                        channelHandlerContext.pipeline().addLast(DefaultHttpClient.HTTP2_HANDLER, (ChannelHandler)httpToHttp2ConnectionHandler).addLast(DefaultHttpClient.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ForkedChunkedWriteHandler()).addLast(DefaultHttpClient.APP_HTTP2_HANDLER, (ChannelHandler)new Http2AppHandler(DefaultHttpClient.this, (Http2ConnectionHandler)httpToHttp2ConnectionHandler, channelPool));
                        channelPool.offer(channel);
                        SslHandler sslHandler = (SslHandler)channelHandlerContext.pipeline().get(DefaultHttpClient.SSL_HANDLER);
                        Set<String> set = Tls.extractSubjectAlternativeNames(sslHandler.engine());
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("TLS handshake successful: protocol={} cipher suite={}", (Object)sslHandler.engine().getSession().getProtocol(), (Object)sslHandler.engine().getSession().getCipherSuite());
                        }
                        if (set.size() <= 1) break;
                        channelPool.offerCoalescedChannel(set, (InetSocketAddress)channel.remoteAddress(), channel, httpTx.key);
                        break;
                    }
                    case "http/1.1": {
                        LOGGER.debug("ALPN led to HTTP/1 with remote {}", (Object)httpTx.request.getUri().getHost());
                        if (httpTx.request.getHttp2PriorKnowledge() == Http2PriorKnowledge.HTTP2_SUPPORTED) {
                            IllegalStateException illegalStateException = new IllegalStateException("HTTP/2 Prior knowledge was set on host " + httpTx.request.getUri().getHost() + " but it only supports HTTP/1");
                            promise.setFailure((Throwable)illegalStateException);
                            throw illegalStateException;
                        }
                        httpTx.listener.onProtocolAwareness(false);
                        channelHandlerContext.pipeline().addLast(DefaultHttpClient.HTTP_CLIENT_CODEC, DefaultHttpClient.this.newHttpClientCodec()).addLast(DefaultHttpClient.INFLATER_HANDLER, (ChannelHandler)new CustomHttpContentDecompressor()).addLast(DefaultHttpClient.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ForkedChunkedWriteHandler()).addLast(DefaultHttpClient.APP_HTTP_HANDLER, (ChannelHandler)new HttpAppHandler(DefaultHttpClient.this, channelPool));
                        promise.setSuccess(null);
                        break;
                    }
                    default: {
                        IllegalStateException illegalStateException = new IllegalStateException("Unknown protocol: " + string);
                        promise.setFailure((Throwable)illegalStateException);
                        channelHandlerContext.close();
                        throw illegalStateException;
                    }
                }
            }
        });
        promise.addListener(future -> {
            if (!future.isSuccess()) {
                httpTx.listener.onThrowable(future.cause());
            }
        });
        return promise;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void flushClientIdChannels(long l, EventLoop eventLoop) {
        if (eventLoop.inEventLoop()) {
            this.eventLoopResources((EventLoop)eventLoop).channelPool.flushClientIdChannelPoolPartitions(l);
        } else if (!eventLoop.isShutdown()) {
            eventLoop.execute(() -> this.eventLoopResources((EventLoop)eventLoop).channelPool.flushClientIdChannelPoolPartitions(l));
        }
    }

    private /* synthetic */ void lambda$openNewChannelRec$12(InetSocketAddress inetSocketAddress, ChannelFuture channelFuture, Promise promise, InetSocketAddress inetSocketAddress2, RequestTimeout requestTimeout, int n, List list, InetSocketAddress inetSocketAddress3, LocalAddresses localAddresses, Bootstrap bootstrap, HttpListener httpListener, Future future) throws Exception {
        if (future.isSuccess()) {
            LOGGER.debug("Connected to remoteAddress={} from localAddress={}", (Object)inetSocketAddress, (Object)channelFuture.channel().localAddress());
            promise.setSuccess((Object)channelFuture.channel());
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Failed to connect to remoteAddress=" + String.valueOf(inetSocketAddress) + " from localAddress=" + String.valueOf(inetSocketAddress2), future.cause());
            }
            if (requestTimeout.isDone()) {
                promise.setFailure((Throwable)IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT);
                return;
            }
            int n2 = n + 1;
            if (n2 < list.size()) {
                this.openNewChannelRec(list, inetSocketAddress3, localAddresses, n2, (Promise<Channel>)promise, bootstrap, httpListener, requestTimeout);
            } else {
                requestTimeout.cancel();
                httpListener.onThrowable(future.cause());
                promise.setFailure(future.cause());
            }
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        LOGGER = LoggerFactory.getLogger(DefaultHttpClient.class);
        HTTP_DECODER_CONFIG = new HttpDecoderConfig().setMaxHeaderSize(Integer.MAX_VALUE).setValidateHeaders(false);
        IGNORE_REQUEST_TIMEOUT_REACHED_WHILE_TRYING_TO_CONNECT = new TimeoutException("Request timeout reached while trying to connect, should be ignored"){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    private final class EventLoopResources {
        private static final int POOL_CLEANER_PERIOD_MS = 1000;
        private final Bootstrap http1Bootstrap;
        private final Bootstrap http2Bootstrap;
        private final Bootstrap wsBootstrap;
        private final ChannelPool channelPool = new ChannelPool();

        private void addHttpHandlers(Channel channel) {
            channel.pipeline().addLast(DefaultHttpClient.HTTP_CLIENT_CODEC, DefaultHttpClient.this.newHttpClientCodec()).addLast(DefaultHttpClient.INFLATER_HANDLER, (ChannelHandler)new CustomHttpContentDecompressor()).addLast(DefaultHttpClient.CHUNKED_WRITER_HANDLER, (ChannelHandler)new ChunkedWriteHandler()).addLast(DefaultHttpClient.APP_HTTP_HANDLER, (ChannelHandler)new HttpAppHandler(DefaultHttpClient.this, this.channelPool));
        }

        private void addWsHandlers(Channel channel) {
            channel.pipeline().addLast(DefaultHttpClient.HTTP_CLIENT_CODEC, DefaultHttpClient.this.newHttpClientCodec()).addLast(DefaultHttpClient.WS_OBJECT_AGGREGATOR, (ChannelHandler)new HttpObjectAggregator(Integer.MAX_VALUE)).addLast(DefaultHttpClient.WS_COMPRESSION, (ChannelHandler)AllowClientNoContextWebSocketClientCompressionHandler.INSTANCE).addLast(DefaultHttpClient.WS_FRAME_AGGREGATOR, (ChannelHandler)new WebSocketFrameAggregator(Integer.MAX_VALUE)).addLast(DefaultHttpClient.APP_WS_HANDLER, (ChannelHandler)new WebSocketHandler());
        }

        private void addProxyHandlers(Channel channel, HttpTx httpTx, ProxyServer proxyServer) {
            ChannelPipeline channelPipeline = channel.pipeline();
            channelPipeline.addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
            if (proxyServer instanceof HttpProxyServer) {
                if (((HttpProxyServer)proxyServer).isSecured()) {
                    DefaultHttpClient.this.installSslHandler(httpTx, channel, proxyServer.getHost(), proxyServer.getPort(), DefaultHttpClient.PROXY_SSL_HANDLER).addListener(future -> {
                        if (httpTx.requestTimeout.isDone() || !future.isSuccess()) {
                            channel.close();
                        }
                    });
                }
                if (httpTx.request.getProxyProtocolSourceIpV4Address() != null || httpTx.request.getProxyProtocolSourceIpV6Address() != null) {
                    channelPipeline.addLast(DefaultHttpClient.PROXY_PROTOCOL_HANDLER, (ChannelHandler)new ProxyProtocolHandler(httpTx.request.getProxyProtocolSourceIpV4Address(), httpTx.request.getProxyProtocolSourceIpV6Address()));
                }
            }
            if (DefaultHttpClient.proxyHandlerSupportsUri(proxyServer, httpTx.request.getUri())) {
                channelPipeline.addLast(DefaultHttpClient.PROXY_HANDLER, (ChannelHandler)proxyServer.newProxyHandler());
            }
        }

        private EventLoopResources(EventLoop eventLoop) {
            eventLoop.scheduleWithFixedDelay(() -> this.channelPool.closeIdleChannels(DefaultHttpClient.this.idleTimeoutNanos), 1000L, 1000L, TimeUnit.MILLISECONDS);
            this.http1Bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channelFactory(Transports.newSocketChannelFactory((boolean)DefaultHttpClient.this.config.isUseNativeTransport(), (boolean)DefaultHttpClient.this.config.isUseIoUring()))).group((EventLoopGroup)eventLoop)).resolver((AddressResolverGroup)NoopAddressResolverGroup.INSTANCE).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
                    EventLoopResources.this.addHttpHandlers(channel);
                }
            });
            Transports.configureOptions((Bootstrap)this.http1Bootstrap, (int)((int)DefaultHttpClient.this.config.getConnectTimeout()), (boolean)DefaultHttpClient.this.config.isTcpNoDelay(), (boolean)DefaultHttpClient.this.config.isSoKeepAlive(), (DefaultHttpClient.this.config.isUseNativeTransport() && !DefaultHttpClient.this.config.isUseIoUring() && Epoll.isAvailable() ? 1 : 0) != 0);
            this.http2Bootstrap = (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
                }
            });
            this.wsBootstrap = (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    channel.pipeline().addLast(DefaultHttpClient.PINNED_HANDLER, (ChannelHandler)NoopHandler.INSTANCE);
                    EventLoopResources.this.addWsHandlers(channel);
                }
            });
        }

        private Bootstrap getHttp1BootstrapWithProxy(final HttpTx httpTx, final ProxyServer proxyServer) {
            return (Bootstrap)this.http1Bootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    EventLoopResources.this.addProxyHandlers(channel, httpTx, proxyServer);
                    EventLoopResources.this.addHttpHandlers(channel);
                }
            });
        }

        private Bootstrap getWsBootstrapWithProxy(final HttpTx httpTx, final ProxyServer proxyServer) {
            return (Bootstrap)this.wsBootstrap.clone().handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) {
                    EventLoopResources.this.addProxyHandlers(channel, httpTx, proxyServer);
                    EventLoopResources.this.addWsHandlers(channel);
                }
            });
        }
    }
}

