/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.body.multipart.FilePart;
import io.gatling.http.client.body.multipart.impl.FileLikePartImpl;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.gatling.http.client.util.MiscUtils;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ScatteringByteChannel;

public final class FilePartImpl
extends FileLikePartImpl<FilePart> {
    private final File file;
    private FileChannel channel;
    private long position = 0L;

    public FilePartImpl(FilePart filePart, byte[] byArray) {
        super(filePart, byArray);
        this.file = (File)filePart.getContent();
    }

    private FileChannel getChannel() throws IOException {
        if (this.channel == null) {
            this.channel = new RandomAccessFile(this.file, "r").getChannel();
        }
        return this.channel;
    }

    @Override
    protected long getContentLength() {
        return this.file.length();
    }

    @Override
    protected void copyContentInto(ByteBuf byteBuf) throws IOException {
        int n = byteBuf.writeBytes((ScatteringByteChannel)this.getChannel(), byteBuf.writableBytes());
        if (n > 0) {
            this.position += (long)n;
        }
        if (this.position == this.file.length() || n < 0) {
            this.state = PartImplState.POST_CONTENT;
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
    }

    @Override
    public void close() {
        super.close();
        MiscUtils.closeSilently(this.channel);
    }
}

