/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.oauth;

import io.gatling.http.client.Param;
import io.gatling.http.client.Request;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.form.FormUrlEncodedRequestBody;
import io.gatling.http.client.oauth.ConsumerKey;
import io.gatling.http.client.oauth.OAuthSignatureCalculatorInstance;
import io.gatling.http.client.oauth.RequestToken;
import io.gatling.http.client.uri.Uri;
import io.gatling.http.client.uri.UriEncoder;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;

public class OAuthSignatureCalculator
implements Function<Request, Request> {
    private static final ThreadLocal<OAuthSignatureCalculatorInstance> INSTANCES = ThreadLocal.withInitial(OAuthSignatureCalculatorInstance::new);
    private final ConsumerKey consumerAuth;
    private final RequestToken requestToken;
    private final boolean useAuthorizationHeader;

    OAuthSignatureCalculatorInstance getOAuthSignatureCalculatorInstance() {
        return INSTANCES.get();
    }

    public OAuthSignatureCalculator(ConsumerKey consumerKey, RequestToken requestToken, boolean bl) {
        this.consumerAuth = consumerKey;
        this.requestToken = requestToken;
        this.useAuthorizationHeader = bl;
    }

    @Override
    public Request apply(Request request) {
        RequestBody requestBody = request.getBody();
        List list = requestBody instanceof FormUrlEncodedRequestBody ? (List)((FormUrlEncodedRequestBody)requestBody).getContent() : Collections.emptyList();
        OAuthSignatureCalculatorInstance.Signature signature = this.getOAuthSignatureCalculatorInstance().computeSignature(this.consumerAuth, this.requestToken, request.getMethod(), request.getUri(), list);
        if (this.useAuthorizationHeader) {
            return OAuthSignatureCalculator.signWithAuthorizationHeader(request, signature);
        }
        if (requestBody instanceof FormUrlEncodedRequestBody) {
            return OAuthSignatureCalculator.signWithFormParams(request, signature);
        }
        return OAuthSignatureCalculator.signWithQueryParams(request, signature);
    }

    private static Request signWithAuthorizationHeader(Request request, OAuthSignatureCalculatorInstance.Signature signature) {
        request.getHeaders().set((CharSequence)HttpHeaderNames.AUTHORIZATION, (Object)signature.computeAuthorizationHeader());
        return request;
    }

    private static Request signWithFormParams(Request request, OAuthSignatureCalculatorInstance.Signature signature) {
        FormUrlEncodedRequestBody formUrlEncodedRequestBody = (FormUrlEncodedRequestBody)request.getBody();
        ArrayList<Param> arrayList = new ArrayList<Param>((Collection)formUrlEncodedRequestBody.getContent());
        arrayList.addAll(signature.computeParams());
        FormUrlEncodedRequestBody formUrlEncodedRequestBody2 = new FormUrlEncodedRequestBody(arrayList, formUrlEncodedRequestBody.getPatchedContentType(), formUrlEncodedRequestBody.getCharset());
        return request.copyWithNewBody(formUrlEncodedRequestBody2);
    }

    private static Request signWithQueryParams(Request request, OAuthSignatureCalculatorInstance.Signature signature) {
        Uri uri = UriEncoder.RAW.encode(request.getUri(), signature.computeParams());
        return request.copyWithNewUri(uri);
    }
}

