/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.impl.request;

import io.gatling.http.client.HttpClientConfig;
import io.gatling.http.client.Request;
import io.gatling.http.client.RequestBuilder;
import io.gatling.http.client.SignatureCalculator;
import io.gatling.http.client.body.RequestBody;
import io.gatling.http.client.body.WritableContent;
import io.gatling.http.client.impl.request.WritableRequest;
import io.gatling.http.client.proxy.HttpProxyServer;
import io.gatling.http.client.uri.Uri;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import java.io.IOException;

public class WritableRequestBuilder {
    private static WritableRequest buildRequestWithoutBody(String string, HttpMethod httpMethod, HttpHeaders httpHeaders) {
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && (HttpMethod.POST.equals((Object)httpMethod) || HttpMethod.PUT.equals((Object)httpMethod) || HttpMethod.PATCH.equals((Object)httpMethod))) {
            httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        }
        DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, Unpooled.buffer((int)0), httpHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        return new WritableRequest((HttpRequest)defaultFullHttpRequest, null);
    }

    private static WritableRequest buildRequestWithBody(String string, Uri uri, HttpMethod httpMethod, HttpHeaders httpHeaders, RequestBody<?> requestBody, ByteBufAllocator byteBufAllocator, HttpClientConfig httpClientConfig) throws IOException {
        boolean bl = !uri.isSecured() && httpClientConfig.isEnableZeroCopy();
        WritableContent writableContent = requestBody.build(bl, byteBufAllocator);
        Object object = writableContent.getContent();
        if (object instanceof ByteBuf && !httpHeaders.contains((CharSequence)HttpHeaderNames.EXPECT, (CharSequence)HttpHeaderValues.CONTINUE, true)) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH)) {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)byteBuf.readableBytes());
            }
            DefaultFullHttpRequest defaultFullHttpRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, byteBuf, httpHeaders, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
            return new WritableRequest((HttpRequest)defaultFullHttpRequest, null);
        }
        if (!httpHeaders.contains((CharSequence)HttpHeaderNames.CONTENT_LENGTH) && !httpHeaders.contains((CharSequence)HttpHeaderNames.TRANSFER_ENCODING)) {
            if (writableContent.getContentLength() >= 0L) {
                httpHeaders.set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)writableContent.getContentLength());
            } else {
                httpHeaders.set((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
            }
        }
        DefaultHttpRequest defaultHttpRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, httpMethod, string, httpHeaders);
        return new WritableRequest((HttpRequest)defaultHttpRequest, object);
    }

    public static WritableRequest buildRequest(Request request, ByteBufAllocator byteBufAllocator, HttpClientConfig httpClientConfig, boolean bl) throws Exception {
        Uri uri = request.getUri();
        HttpHeaders httpHeaders = request.getHeaders();
        RequestBody<?> requestBody = request.getBody();
        String string = bl || !uri.isSecured() && request.getProxyServer() instanceof HttpProxyServer ? uri.toUrl() : uri.toRelativeUrl();
        WritableRequest writableRequest = requestBody == null ? WritableRequestBuilder.buildRequestWithoutBody(string, request.getMethod(), httpHeaders) : WritableRequestBuilder.buildRequestWithBody(string, uri, request.getMethod(), httpHeaders, requestBody, byteBufAllocator, httpClientConfig);
        SignatureCalculator signatureCalculator = request.getSignatureCalculator();
        if (signatureCalculator != null) {
            Request request2 = new RequestBuilder(request, request.getUri()).setHeaders(writableRequest.getRequest().headers()).setFixUrlEncoding(false).setDefaultCharset(httpClientConfig.getDefaultCharset()).build();
            signatureCalculator.sign(request2);
        }
        return writableRequest;
    }
}

