/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.client.body.multipart.impl;

import io.gatling.http.client.body.multipart.impl.PartImpl;
import io.gatling.http.client.body.multipart.impl.PartImplState;
import io.gatling.http.client.util.MiscUtils;
import io.netty.channel.FileRegion;
import io.netty.util.AbstractReferenceCounted;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.List;

public class MultipartFileRegion
extends AbstractReferenceCounted
implements FileRegion {
    private final List<PartImpl> parts;
    private final long contentLength;
    private boolean done = false;
    private int currentPartIndex;
    private long transferred;

    public MultipartFileRegion(List<PartImpl> list, long l) {
        this.parts = list;
        this.contentLength = l;
    }

    public long position() {
        return 0L;
    }

    public long count() {
        return this.contentLength;
    }

    public long transfered() {
        return this.transferred();
    }

    public long transferred() {
        return this.transferred;
    }

    public FileRegion retain() {
        super.retain();
        return this;
    }

    public FileRegion retain(int n) {
        super.retain(n);
        return this;
    }

    public FileRegion touch() {
        return this;
    }

    public FileRegion touch(Object object) {
        return this;
    }

    public long transferTo(WritableByteChannel writableByteChannel, long l) throws IOException {
        long l2 = this.transferTo(writableByteChannel);
        if (l2 > 0L) {
            this.transferred += l2;
        }
        return l2;
    }

    private long transferTo(WritableByteChannel writableByteChannel) throws IOException {
        long l;
        PartImpl partImpl;
        if (this.done) {
            return -1L;
        }
        boolean bl = false;
        for (l = 0L; l < 8192L && !this.done && !bl; l += partImpl.transferTo(writableByteChannel)) {
            partImpl = this.parts.get(this.currentPartIndex);
            bl = partImpl.isTargetSlow();
            if (partImpl.getState() != PartImplState.DONE) continue;
            ++this.currentPartIndex;
            if (this.currentPartIndex != this.parts.size()) continue;
            this.done = true;
        }
        return l;
    }

    protected void deallocate() {
        for (PartImpl partImpl : this.parts) {
            MiscUtils.closeSilently(partImpl);
        }
    }
}

