/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.graphite;

import akka.actor.ActorRef;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.ResponseTimings$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.stats.writer.UserEndMessage;
import io.gatling.core.stats.writer.UserStartMessage;
import io.gatling.core.util.NameGen;
import io.gatling.graphite.GraphiteData;
import io.gatling.graphite.GraphitePath;
import io.gatling.graphite.GraphitePathPattern;
import io.gatling.graphite.OldGraphitePathPattern;
import io.gatling.graphite.message.GraphiteMetrics$;
import io.gatling.graphite.sender.MetricsSender$;
import io.gatling.graphite.types.HistogramRequestMetricsBuffer;
import io.gatling.graphite.types.MetricByStatus;
import io.gatling.graphite.types.RequestMetricsBuffer;
import io.gatling.graphite.types.UserBreakdown;
import io.gatling.graphite.types.UserBreakdownBuffer;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapFactory;
import scala.collection.MapFactory$;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Mc!B\b\u0011\u0001I1\u0002\u0002C\u0016\u0001\u0005\u0003\u0005\u000b\u0011B\u0017\t\u0011Q\u0002!\u0011!Q\u0001\nUBQa\u000f\u0001\u0005\u0002qBQ\u0001\u0011\u0001\u0005\u0002\u0005Cq\u0001\u0013\u0001C\u0002\u0013%\u0011\n\u0003\u0004S\u0001\u0001\u0006IA\u0013\u0005\u0006'\u0002!\t\u0001\u0016\u0005\u00065\u0002!\ta\u0017\u0005\u0006I\u0002!I!\u001a\u0005\u0006q\u0002!I!\u001f\u0005\b\u0003\u0003\u0001A\u0011IA\u0002\u0011\u001d\t\t\u0002\u0001C!\u0003'Aq!a\u0007\u0001\t\u0003\ti\u0002C\u0004\u0002\"\u0001!I!a\t\u0003%\u001d\u0013\u0018\r\u001d5ji\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003#I\t\u0001b\u001a:ba\"LG/\u001a\u0006\u0003'Q\tqaZ1uY&twMC\u0001\u0016\u0003\tIwnE\u0002\u0001/\u0015\u00022\u0001G\u0010\"\u001b\u0005I\"B\u0001\u000e\u001c\u0003\u00199(/\u001b;fe*\u0011A$H\u0001\u0006gR\fGo\u001d\u0006\u0003=I\tAaY8sK&\u0011\u0001%\u0007\u0002\u000b\t\u0006$\u0018m\u0016:ji\u0016\u0014\bC\u0001\u0012$\u001b\u0005\u0001\u0012B\u0001\u0013\u0011\u000519%/\u00199iSR,G)\u0019;b!\t1\u0013&D\u0001(\u0015\tAS$\u0001\u0003vi&d\u0017B\u0001\u0016(\u0005\u001dq\u0015-\\3HK:\fQa\u00197pG.\u001c\u0001\u0001\u0005\u0002/e5\tqF\u0003\u0002)a)\u0011\u0011GE\u0001\bG>lWn\u001c8t\u0013\t\u0019tFA\u0003DY>\u001c7.A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003mej\u0011a\u000e\u0006\u0003qu\taaY8oM&<\u0017B\u0001\u001e8\u0005Q9\u0015\r\u001e7j]\u001e\u001cuN\u001c4jOV\u0014\u0018\r^5p]\u00061A(\u001b8jiz\"2!\u0010 @!\t\u0011\u0003\u0001C\u0003,\u0007\u0001\u0007Q\u0006C\u00035\u0007\u0001\u0007Q'\u0001\roK^\u0014Vm\u001d9p]N,W*\u001a;sS\u000e\u001c()\u001e4gKJ,\u0012A\u0011\t\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bB\tQ\u0001^=qKNL!a\u0012#\u0003)I+\u0017/^3ti6+GO]5dg\n+hMZ3s\u000391G.^:i)&lWM\u001d(b[\u0016,\u0012A\u0013\t\u0003\u0017Bk\u0011\u0001\u0014\u0006\u0003\u001b:\u000bA\u0001\\1oO*\tq*\u0001\u0003kCZ\f\u0017BA)M\u0005\u0019\u0019FO]5oO\u0006ya\r\\;tQRKW.\u001a:OC6,\u0007%\u0001\u0004p]&s\u0017\u000e\u001e\u000b\u0003CUCQAV\u0004A\u0002]\u000bA!\u001b8jiB\u0011\u0001\u0004W\u0005\u00033f\u0011A!\u00138ji\u00069qN\u001c$mkNDGC\u0001/c!\ti\u0006-D\u0001_\u0015\u0005y\u0016!B:dC2\f\u0017BA1_\u0005\u0011)f.\u001b;\t\u000b\rD\u0001\u0019A\u0011\u0002\t\u0011\fG/Y\u0001\u000e_:,6/\u001a:NKN\u001c\u0018mZ3\u0015\tq3'o\u001e\u0005\u0006O&\u0001\r\u0001[\u0001\tg\u000e,g.\u0019:j_B\u0011\u0011\u000e\u001d\b\u0003U:\u0004\"a\u001b0\u000e\u00031T!!\u001c\u0017\u0002\rq\u0012xn\u001c;?\u0013\tyg,\u0001\u0004Qe\u0016$WMZ\u0005\u0003#FT!a\u001c0\t\u000bML\u0001\u0019\u0001;\u0002\u000f%\u001c8\u000b^1siB\u0011Q,^\u0005\u0003mz\u0013qAQ8pY\u0016\fg\u000eC\u0003d\u0013\u0001\u0007\u0011%A\tp]J+7\u000f]8og\u0016lUm]:bO\u0016$2\u0001\u0018>\u0000\u0011\u0015Y(\u00021\u0001}\u0003!\u0011Xm\u001d9p]N,\u0007C\u0001\r~\u0013\tq\u0018DA\bSKN\u0004xN\\:f\u001b\u0016\u001c8/Y4f\u0011\u0015\u0019'\u00021\u0001\"\u0003%yg.T3tg\u0006<W\rF\u0003]\u0003\u000b\ty\u0001C\u0004\u0002\b-\u0001\r!!\u0003\u0002\u000f5,7o]1hKB\u0019\u0001$a\u0003\n\u0007\u00055\u0011D\u0001\tM_\u0006$WI^3oi6+7o]1hK\")1m\u0003a\u0001C\u00059qN\\\"sCNDG#\u0002/\u0002\u0016\u0005e\u0001BBA\f\u0019\u0001\u0007\u0001.A\u0003dCV\u001cX\rC\u0003d\u0019\u0001\u0007\u0011%\u0001\u0004p]N#x\u000e\u001d\u000b\u00049\u0006}\u0001\"B2\u000e\u0001\u0004\t\u0013!F:f]\u0012lU\r\u001e:jGN$vn\u0012:ba\"LG/\u001a\u000b\n9\u0006\u0015\u0012qEA\u0019\u0003\u000fBQa\u0019\bA\u0002\u0005Bq!!\u000b\u000f\u0001\u0004\tY#A\u0003fa>\u001c\u0007\u000eE\u0002^\u0003[I1!a\f_\u0005\u0011auN\\4\t\u000f\u0005Mb\u00021\u0001\u00026\u0005y!/Z9vKN$8/T3ue&\u001c7\u000fE\u0004j\u0003o\tY$!\u0011\n\u0007\u0005e\u0012OA\u0002NCB\u00042AIA\u001f\u0013\r\ty\u0004\u0005\u0002\r\u000fJ\f\u0007\u000f[5uKB\u000bG\u000f\u001b\t\u0004\u0007\u0006\r\u0013bAA#\t\nqQ*\u001a;sS\u000e\u0014\u0015p\u0015;biV\u001c\bbBA%\u001d\u0001\u0007\u00111J\u0001\u000fkN,'O\u0011:fC.$wn\u001e8t!\u001dI\u0017qGA\u001e\u0003\u001b\u00022aQA(\u0013\r\t\t\u0006\u0012\u0002\u000e+N,'O\u0011:fC.$wn\u001e8")
public class GraphiteDataWriter
extends DataWriter<GraphiteData>
implements NameGen {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public RequestMetricsBuffer newResponseMetricsBuffer() {
        return new HistogramRequestMetricsBuffer(this.configuration);
    }

    private String flushTimerName() {
        return this.flushTimerName;
    }

    public GraphiteData onInit(Init init) {
        ActorRef metricsSender = this.context().actorOf(MetricsSender$.MODULE$.props(this.clock, this.configuration), this.genName("metricsSender"));
        Map requestsByPath = (Map)Map$.MODULE$.empty();
        Map usersByScenario = (Map)Map$.MODULE$.empty();
        OldGraphitePathPattern pattern = new OldGraphitePathPattern(init.runMessage(), this.configuration);
        usersByScenario.update((Object)((GraphitePathPattern)pattern).allUsersPath(), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)Collections.PimpedIterable$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedIterable((Iterable)init.scenarios()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)GraphiteDataWriter.$anonfun$onInit$1(x$1)), (Numeric)Numeric.LongIsIntegral$.MODULE$))));
        init.scenarios().foreach((Function1 & Serializable)scenario -> (Map)usersByScenario.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pattern.usersPath(scenario.name())), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)scenario.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L))))));
        this.startTimerAtFixedRate(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().graphite().writePeriod());
        return new GraphiteData(metricsSender, (Map<GraphitePath, RequestMetricsBuffer>)requestsByPath, (Map<GraphitePath, UserBreakdownBuffer>)usersByScenario, pattern);
    }

    public void onFlush(GraphiteData data) {
        scala.collection.immutable.Map requestsMetrics = (scala.collection.immutable.Map)data.requestsByPath().view().mapValues((Function1 & Serializable)x$2 -> x$2.metricsByStatus()).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
        scala.collection.immutable.Map usersBreakdowns = (scala.collection.immutable.Map)data.usersByScenario().view().mapValues((Function1 & Serializable)x$3 -> x$3.breakDown()).to(MapFactory$.MODULE$.toFactory((MapFactory)Predef$.MODULE$.Map()));
        data.requestsByPath().foreach((Function1 & Serializable)x0$1 -> {
            GraphiteDataWriter.$anonfun$onFlush$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.sendMetricsToGraphite(data, this.clock.nowSeconds(), (scala.collection.immutable.Map<GraphitePath, MetricByStatus>)requestsMetrics, (scala.collection.immutable.Map<GraphitePath, UserBreakdown>)usersBreakdowns);
    }

    private void onUserMessage(String scenario, boolean isStart, GraphiteData data) {
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().usersPath(scenario))).record(isStart);
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().allUsersPath())).record(isStart);
    }

    private void onResponseMessage(ResponseMessage response, GraphiteData data) {
        int responseTime = ResponseTimings$.MODULE$.responseTime(response.startTimestamp(), response.endTimestamp());
        if (!this.configuration.data().graphite().light()) {
            ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().responsePath(response.name(), (List<String>)response.groupHierarchy()), (Function0 & Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
        }
        ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().allResponsesPath(), (Function0 & Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
    }

    public void onMessage(LoadEventMessage message, GraphiteData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserStartMessage) {
            UserStartMessage userStartMessage = (UserStartMessage)loadEventMessage;
            String scenario = userStartMessage.scenario();
            this.onUserMessage(scenario, true, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof UserEndMessage) {
            UserEndMessage userEndMessage = (UserEndMessage)loadEventMessage;
            String scenario = userEndMessage.scenario();
            this.onUserMessage(scenario, false, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onCrash(String cause, GraphiteData data) {
    }

    public void onStop(GraphiteData data) {
        this.cancelTimer(this.flushTimerName());
        this.onFlush(data);
    }

    private void sendMetricsToGraphite(GraphiteData data, long epoch, scala.collection.immutable.Map<GraphitePath, MetricByStatus> requestsMetrics, scala.collection.immutable.Map<GraphitePath, UserBreakdown> userBreakdowns) {
        data.metricsSender().$bang((Object)GraphiteMetrics$.MODULE$.apply(data.format().metrics(userBreakdowns, requestsMetrics), epoch), this.self());
    }

    public static final /* synthetic */ long $anonfun$onInit$1(ShortScenarioDescription x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$onFlush$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RequestMetricsBuffer buff = (RequestMetricsBuffer)tuple2._2();
        buff.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GraphiteDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        NameGen.$init$((NameGen)this);
        this.flushTimerName = "flushTimer";
    }
}

