/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.graphite.types;

import io.gatling.commons.stats.KO$;
import io.gatling.commons.stats.OK$;
import io.gatling.commons.stats.Status;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.graphite.types.MetricByStatus;
import io.gatling.graphite.types.Metrics;
import io.gatling.graphite.types.RequestMetricsBuffer;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.IntCountsHistogram;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichLong$;

@ScalaSignature(bytes="\u0006\u0001]4A!\u0006\f\u0001?!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00034\u0001\u0011\u0005A\u0007C\u00048\u0001\t\u0007I\u0011\u0002\u001d\t\rq\u0002\u0001\u0015!\u0003:\u0011\u001di\u0004A1A\u0005\naBaA\u0010\u0001!\u0002\u0013I\u0004bB \u0001\u0005\u0004%I\u0001\u000f\u0005\u0007\u0001\u0002\u0001\u000b\u0011B\u001d\t\u000f\u0005\u0003!\u0019!C\u0005q!1!\t\u0001Q\u0001\neBqa\u0011\u0001C\u0002\u0013%A\t\u0003\u0004N\u0001\u0001\u0006I!\u0012\u0005\b\u001d\u0002\u0011\r\u0011\"\u0003E\u0011\u0019y\u0005\u0001)A\u0005\u000b\"9\u0001\u000b\u0001b\u0001\n\u0013!\u0005BB)\u0001A\u0003%Q\tC\u0003S\u0001\u0011\u00053\u000bC\u0003g\u0001\u0011\u0005s\rC\u0003i\u0001\u0011\u0005\u0013\u000eC\u0003n\u0001\u0011%aNA\u000fISN$xn\u001a:b[J+\u0017/^3ti6+GO]5dg\n+hMZ3s\u0015\t9\u0002$A\u0003usB,7O\u0003\u0002\u001a5\u0005AqM]1qQ&$XM\u0003\u0002\u001c9\u00059q-\u0019;mS:<'\"A\u000f\u0002\u0005%|7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\ta#\u0003\u0002*-\t!\"+Z9vKN$X*\u001a;sS\u000e\u001c()\u001e4gKJ\fQbY8oM&<WO]1uS>t\u0007C\u0001\u00172\u001b\u0005i#B\u0001\u00180\u0003\u0019\u0019wN\u001c4jO*\u0011\u0001GG\u0001\u0005G>\u0014X-\u0003\u00023[\t!r)\u0019;mS:<7i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDCA\u001b7!\t9\u0003\u0001C\u0003+\u0005\u0001\u00071&A\u0006qKJ\u001cWM\u001c;jY\u0016\fT#A\u001d\u0011\u0005\u0005R\u0014BA\u001e#\u0005\u0019!u.\u001e2mK\u0006a\u0001/\u001a:dK:$\u0018\u000e\\32A\u0005Y\u0001/\u001a:dK:$\u0018\u000e\\33\u00031\u0001XM]2f]RLG.\u001a\u001a!\u0003-\u0001XM]2f]RLG.Z\u001a\u0002\u0019A,'oY3oi&dWm\r\u0011\u0002\u0017A,'oY3oi&dW\rN\u0001\ra\u0016\u00148-\u001a8uS2,G\u0007I\u0001\f_.D\u0015n\u001d;pOJ\fW.F\u0001F!\t15*D\u0001H\u0015\tA\u0015*\u0001\u0007IIJD\u0015n\u001d;pOJ\fWNC\u0001K\u0003\ry'oZ\u0005\u0003\u0019\u001e\u0013\u0011#\u00112tiJ\f7\r\u001e%jgR|wM]1n\u00031y7\u000eS5ti><'/Y7!\u0003-Yw\u000eS5ti><'/Y7\u0002\u0019-|\u0007*[:u_\u001e\u0014\u0018-\u001c\u0011\u0002\u0019\u0005dG\u000eS5ti><'/Y7\u0002\u001b\u0005dG\u000eS5ti><'/Y7!\u0003\r\tG\r\u001a\u000b\u0004)^\u000b\u0007CA\u0011V\u0013\t1&E\u0001\u0003V]&$\b\"\u0002-\u0012\u0001\u0004I\u0016AB:uCR,8\u000f\u0005\u0002[?6\t1L\u0003\u0002];\u0006)1\u000f^1ug*\u0011aLG\u0001\bG>lWn\u001c8t\u0013\t\u00017L\u0001\u0004Ti\u0006$Xo\u001d\u0005\u0006EF\u0001\raY\u0001\u0005i&lW\r\u0005\u0002\"I&\u0011QM\t\u0002\u0005\u0019>tw-A\u0003dY\u0016\f'\u000fF\u0001U\u0003=iW\r\u001e:jGN\u0014\u0015p\u0015;biV\u001cX#\u00016\u0011\u0005\u001dZ\u0017B\u00017\u0017\u00059iU\r\u001e:jG\nK8\u000b^1ukN\f!#\\3ue&\u001c7o\u00144ISN$xn\u001a:b[R\u0011q.\u001e\t\u0004CA\u0014\u0018BA9#\u0005\u0019y\u0005\u000f^5p]B\u0011qe]\u0005\u0003iZ\u0011q!T3ue&\u001c7\u000fC\u0003w)\u0001\u0007Q)A\u0005iSN$xn\u001a:b[\u0002")
public class HistogramRequestMetricsBuffer
implements RequestMetricsBuffer {
    private final double percentile1;
    private final double percentile2;
    private final double percentile3;
    private final double percentile4;
    private final AbstractHistogram okHistogram;
    private final AbstractHistogram koHistogram;
    private final AbstractHistogram allHistogram;

    private double percentile1() {
        return this.percentile1;
    }

    private double percentile2() {
        return this.percentile2;
    }

    private double percentile3() {
        return this.percentile3;
    }

    private double percentile4() {
        return this.percentile4;
    }

    private AbstractHistogram okHistogram() {
        return this.okHistogram;
    }

    private AbstractHistogram koHistogram() {
        return this.koHistogram;
    }

    private AbstractHistogram allHistogram() {
        return this.allHistogram;
    }

    @Override
    public void add(Status status, long time) {
        long recordableTime = RichLong$.MODULE$.max$extension(Predef$.MODULE$.longWrapper(time), 1L);
        this.allHistogram().recordValue(recordableTime);
        Status status2 = status;
        if (OK$.MODULE$.equals(status2)) {
            this.okHistogram().recordValue(recordableTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (KO$.MODULE$.equals(status2)) {
            this.koHistogram().recordValue(recordableTime);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)status2);
        }
    }

    @Override
    public void clear() {
        this.okHistogram().reset();
        this.koHistogram().reset();
        this.allHistogram().reset();
    }

    @Override
    public MetricByStatus metricsByStatus() {
        return new MetricByStatus(this.metricsOfHistogram(this.okHistogram()), this.metricsOfHistogram(this.koHistogram()), this.metricsOfHistogram(this.allHistogram()));
    }

    private Option<Metrics> metricsOfHistogram(AbstractHistogram histogram) {
        long count = histogram.getTotalCount();
        return count > 0L ? new Some((Object)new Metrics(count, (int)histogram.getMinValue(), (int)histogram.getMaxValue(), (int)histogram.getMean(), (int)histogram.getStdDeviation(), (int)histogram.getValueAtPercentile(this.percentile1()), (int)histogram.getValueAtPercentile(this.percentile2()), (int)histogram.getValueAtPercentile(this.percentile3()), (int)histogram.getValueAtPercentile(this.percentile4()))) : None$.MODULE$;
    }

    public HistogramRequestMetricsBuffer(GatlingConfiguration configuration) {
        this.percentile1 = configuration.charting().indicators().percentile1();
        this.percentile2 = configuration.charting().indicators().percentile2();
        this.percentile3 = configuration.charting().indicators().percentile3();
        this.percentile4 = configuration.charting().indicators().percentile4();
        this.okHistogram = new IntCountsHistogram(2);
        this.koHistogram = new IntCountsHistogram(2);
        this.allHistogram = new IntCountsHistogram(2);
    }
}

