/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.graphite;

import akka.actor.ActorRef;
import akka.actor.package$;
import io.gatling.commons.util.Clock;
import io.gatling.commons.util.Collections;
import io.gatling.commons.util.Collections$;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.stats.message.ResponseTimings$;
import io.gatling.core.stats.writer.DataWriter;
import io.gatling.core.stats.writer.Flush$;
import io.gatling.core.stats.writer.Init;
import io.gatling.core.stats.writer.LoadEventMessage;
import io.gatling.core.stats.writer.ResponseMessage;
import io.gatling.core.stats.writer.ShortScenarioDescription;
import io.gatling.core.stats.writer.UserMessage;
import io.gatling.core.util.NameGen;
import io.gatling.graphite.GraphiteData;
import io.gatling.graphite.GraphitePath;
import io.gatling.graphite.GraphitePathPattern;
import io.gatling.graphite.OldGraphitePathPattern;
import io.gatling.graphite.message.GraphiteMetrics$;
import io.gatling.graphite.sender.MetricsSender$;
import io.gatling.graphite.types.HistogramRequestMetricsBuffer;
import io.gatling.graphite.types.MetricByStatus;
import io.gatling.graphite.types.RequestMetricsBuffer;
import io.gatling.graphite.types.UserBreakdown;
import io.gatling.graphite.types.UserBreakdownBuffer;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005=c!B\u0001\u0003\u0001\u0011A!AE$sCBD\u0017\u000e^3ECR\fwK]5uKJT!a\u0001\u0003\u0002\u0011\u001d\u0014\u0018\r\u001d5ji\u0016T!!\u0002\u0004\u0002\u000f\u001d\fG\u000f\\5oO*\tq!\u0001\u0002j_N\u0019\u0001!C\f\u0011\u0007)\t2#D\u0001\f\u0015\taQ\"\u0001\u0004xe&$XM\u001d\u0006\u0003\u001d=\tQa\u001d;biNT!\u0001\u0005\u0003\u0002\t\r|'/Z\u0005\u0003%-\u0011!\u0002R1uC^\u0013\u0018\u000e^3s!\t!R#D\u0001\u0003\u0013\t1\"A\u0001\u0007He\u0006\u0004\b.\u001b;f\t\u0006$\u0018\r\u0005\u0002\u001975\t\u0011D\u0003\u0002\u001b\u001f\u0005!Q\u000f^5m\u0013\ta\u0012DA\u0004OC6,w)\u001a8\t\u0011y\u0001!\u0011!Q\u0001\n\u0001\nQa\u00197pG.\u001c\u0001\u0001\u0005\u0002\"K5\t!E\u0003\u0002\u001bG)\u0011A\u0005B\u0001\bG>lWn\u001c8t\u0013\t1#EA\u0003DY>\u001c7\u000e\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]B\u0011!&L\u0007\u0002W)\u0011AfD\u0001\u0007G>tg-[4\n\u00059Z#\u0001F$bi2LgnZ\"p]\u001aLw-\u001e:bi&|g\u000eC\u00031\u0001\u0011\u0005\u0011'\u0001\u0004=S:LGO\u0010\u000b\u0004eM\"\u0004C\u0001\u000b\u0001\u0011\u0015qr\u00061\u0001!\u0011\u0015As\u00061\u0001*\u0011\u00151\u0004\u0001\"\u00018\u0003aqWm\u001e*fgB|gn]3NKR\u0014\u0018nY:Ck\u001a4WM]\u000b\u0002qA\u0011\u0011\bP\u0007\u0002u)\u00111HA\u0001\u0006if\u0004Xm]\u0005\u0003{i\u0012ACU3rk\u0016\u001cH/T3ue&\u001c7OQ;gM\u0016\u0014\bbB \u0001\u0005\u0004%I\u0001Q\u0001\u000fM2,8\u000f\u001b+j[\u0016\u0014h*Y7f+\u0005\t\u0005C\u0001\"H\u001b\u0005\u0019%B\u0001#F\u0003\u0011a\u0017M\\4\u000b\u0003\u0019\u000bAA[1wC&\u0011\u0001j\u0011\u0002\u0007'R\u0014\u0018N\\4\t\r)\u0003\u0001\u0015!\u0003B\u0003=1G.^:i)&lWM\u001d(b[\u0016\u0004\u0003\"\u0002'\u0001\t\u0003i\u0015AB8o\u0013:LG\u000f\u0006\u0002\u0014\u001d\")qj\u0013a\u0001!\u0006!\u0011N\\5u!\tQ\u0011+\u0003\u0002S\u0017\t!\u0011J\\5u\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u001dygN\u00127vg\"$\"A\u0016/\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\tUs\u0017\u000e\u001e\u0005\u0006;N\u0003\raE\u0001\u0005I\u0006$\u0018\rC\u0003`\u0001\u0011%\u0001-A\u0007p]V\u001bXM]'fgN\fw-\u001a\u000b\u0004-\u00064\u0007\"\u00022_\u0001\u0004\u0019\u0017aC;tKJlUm]:bO\u0016\u0004\"A\u00033\n\u0005\u0015\\!aC+tKJlUm]:bO\u0016DQ!\u00180A\u0002MAQ\u0001\u001b\u0001\u0005\n%\f\u0011c\u001c8SKN\u0004xN\\:f\u001b\u0016\u001c8/Y4f)\r1&n\u001c\u0005\u0006W\u001e\u0004\r\u0001\\\u0001\te\u0016\u001c\bo\u001c8tKB\u0011!\"\\\u0005\u0003].\u0011qBU3ta>t7/Z'fgN\fw-\u001a\u0005\u0006;\u001e\u0004\ra\u0005\u0005\u0006c\u0002!\tE]\u0001\n_:lUm]:bO\u0016$2AV:y\u0011\u0015!\b\u000f1\u0001v\u0003\u001diWm]:bO\u0016\u0004\"A\u0003<\n\u0005]\\!\u0001\u0005'pC\u0012,e/\u001a8u\u001b\u0016\u001c8/Y4f\u0011\u0015i\u0006\u000f1\u0001\u0014\u0011\u0015Q\b\u0001\"\u0011|\u0003\u001dygn\u0011:bg\"$BA\u0016?\u0002\u0012!)Q0\u001fa\u0001}\u0006)1-Y;tKB\u0019q0!\u0004\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007AVBAA\u0003\u0015\r\t9aH\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-\u0001,\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u0011\u0006=!bAA\u00061\")Q,\u001fa\u0001'!9\u0011Q\u0003\u0001\u0005\u0002\u0005]\u0011AB8o'R|\u0007\u000fF\u0002W\u00033Aa!XA\n\u0001\u0004\u0019\u0002bBA\u000f\u0001\u0011%\u0011qD\u0001\u0016g\u0016tG-T3ue&\u001c7\u000fV8He\u0006\u0004\b.\u001b;f)%1\u0016\u0011EA\u0012\u0003[\t\u0019\u0005\u0003\u0004^\u00037\u0001\ra\u0005\u0005\t\u0003K\tY\u00021\u0001\u0002(\u0005)Q\r]8dQB\u0019q+!\u000b\n\u0007\u0005-\u0002L\u0001\u0003M_:<\u0007\u0002CA\u0018\u00037\u0001\r!!\r\u0002\u001fI,\u0017/^3tiNlU\r\u001e:jGN\u0004ra`A\u001a\u0003o\ti$\u0003\u0003\u00026\u0005=!aA'baB\u0019A#!\u000f\n\u0007\u0005m\"A\u0001\u0007He\u0006\u0004\b.\u001b;f!\u0006$\b\u000eE\u0002:\u0003\u007fI1!!\u0011;\u00059iU\r\u001e:jG\nK8\u000b^1ukND\u0001\"!\u0012\u0002\u001c\u0001\u0007\u0011qI\u0001\u000fkN,'O\u0011:fC.$wn\u001e8t!\u001dy\u00181GA\u001c\u0003\u0013\u00022!OA&\u0013\r\tiE\u000f\u0002\u000e+N,'O\u0011:fC.$wn\u001e8")
public class GraphiteDataWriter
extends DataWriter<GraphiteData>
implements NameGen {
    private final Clock clock;
    private final GatlingConfiguration configuration;
    private final String flushTimerName;

    public String genName(String base) {
        return NameGen.genName$((NameGen)this, (String)base);
    }

    public RequestMetricsBuffer newResponseMetricsBuffer() {
        return new HistogramRequestMetricsBuffer(this.configuration);
    }

    private String flushTimerName() {
        return this.flushTimerName;
    }

    public GraphiteData onInit(Init init) {
        ActorRef metricsSender = this.context().actorOf(MetricsSender$.MODULE$.props(this.clock, this.configuration), this.genName("metricsSender"));
        Map requestsByPath = Map$.MODULE$.empty();
        Map usersByScenario = Map$.MODULE$.empty();
        OldGraphitePathPattern pattern = new OldGraphitePathPattern(init.runMessage(), this.configuration);
        usersByScenario.update((Object)((GraphitePathPattern)pattern).allUsersPath(), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)Collections.PimpedTraversableOnce$.MODULE$.sumBy$extension(Collections$.MODULE$.PimpedTraversableOnce((TraversableOnce)init.scenarios()), (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToLong((long)GraphiteDataWriter.$anonfun$onInit$1(x$1)), (Numeric)Numeric.LongIsIntegral$.MODULE$))));
        init.scenarios().foreach((Function1 & Serializable & scala.Serializable)scenario -> (Map)usersByScenario.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)pattern.usersPath(scenario.name())), (Object)new UserBreakdownBuffer(BoxesRunTime.unboxToLong((Object)scenario.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L))))));
        this.setTimer(this.flushTimerName(), Flush$.MODULE$, this.configuration.data().graphite().writePeriod(), true);
        return new GraphiteData(metricsSender, (Map<GraphitePath, RequestMetricsBuffer>)requestsByPath, (Map<GraphitePath, UserBreakdownBuffer>)usersByScenario, pattern);
    }

    public void onFlush(GraphiteData data) {
        scala.collection.immutable.Map requestsMetrics = data.requestsByPath().mapValues((Function1 & Serializable & scala.Serializable)x$2 -> x$2.metricsByStatus()).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map usersBreakdowns = data.usersByScenario().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> x$3.breakDown()).toMap(Predef$.MODULE$.$conforms());
        data.requestsByPath().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GraphiteDataWriter.$anonfun$onFlush$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.sendMetricsToGraphite(data, this.clock.nowSeconds(), (scala.collection.immutable.Map<GraphitePath, MetricByStatus>)requestsMetrics, (scala.collection.immutable.Map<GraphitePath, UserBreakdown>)usersBreakdowns);
    }

    private void onUserMessage(UserMessage userMessage, GraphiteData data) {
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().usersPath(userMessage.session().scenario()))).add(userMessage);
        ((UserBreakdownBuffer)data.usersByScenario().apply((Object)data.format().allUsersPath())).add(userMessage);
    }

    private void onResponseMessage(ResponseMessage response, GraphiteData data) {
        int responseTime = ResponseTimings$.MODULE$.responseTime(response.startTimestamp(), response.endTimestamp());
        if (!this.configuration.data().graphite().light()) {
            ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().responsePath(response.name(), (List<String>)response.groupHierarchy()), (Function0 & Serializable & scala.Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
        }
        ((RequestMetricsBuffer)data.requestsByPath().getOrElseUpdate((Object)data.format().allResponsesPath(), (Function0 & Serializable & scala.Serializable)() -> this.newResponseMetricsBuffer())).add(response.status(), responseTime);
    }

    public void onMessage(LoadEventMessage message, GraphiteData data) {
        LoadEventMessage loadEventMessage = message;
        if (loadEventMessage instanceof UserMessage) {
            UserMessage userMessage = (UserMessage)loadEventMessage;
            this.onUserMessage(userMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (loadEventMessage instanceof ResponseMessage) {
            ResponseMessage responseMessage = (ResponseMessage)loadEventMessage;
            this.onResponseMessage(responseMessage, data);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onCrash(String cause, GraphiteData data) {
    }

    public void onStop(GraphiteData data) {
        this.cancelTimer(this.flushTimerName());
    }

    private void sendMetricsToGraphite(GraphiteData data, long epoch, scala.collection.immutable.Map<GraphitePath, MetricByStatus> requestsMetrics, scala.collection.immutable.Map<GraphitePath, UserBreakdown> userBreakdowns) {
        package$.MODULE$.actorRef2Scala(data.metricsSender()).$bang((Object)GraphiteMetrics$.MODULE$.apply(data.format().metrics(userBreakdowns, requestsMetrics), epoch), this.self());
    }

    public static final /* synthetic */ long $anonfun$onInit$1(ShortScenarioDescription x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.totalUserCount().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
    }

    public static final /* synthetic */ void $anonfun$onFlush$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RequestMetricsBuffer buff = (RequestMetricsBuffer)tuple2._2();
        buff.clear();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public GraphiteDataWriter(Clock clock, GatlingConfiguration configuration) {
        this.clock = clock;
        this.configuration = configuration;
        NameGen.$init$((NameGen)this);
        this.flushTimerName = "flushTimer";
    }
}

