/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.pkg;

import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

enum ManifestEntry {
    ManifestVersion("Manifest-Version"),
    ImplementationTitle("Implementation-Title"),
    ImplementationVersion("Implementation-Version"),
    ImplementationVendor("Implementation-Vendor"),
    SpecificationVendor("Specification-Vendor"),
    GatlingVersion("Gatling-Version"),
    GatlingPackager("Gatling-Packager"),
    GatlingPackagerVersion("Gatling-Packager-Version"),
    GatlingSimulations("Gatling-Simulations"),
    GatlingExtraProtocols("Gatling-Extra-Protocols"),
    JavaVersion("Java-Version");

    private static final String SIMULATIONS_MANIFEST_ENTRY_DELIMITER = ",";
    private final String name;

    private ManifestEntry(String string2) {
        this.name = string2;
    }

    void write(FileWriter fileWriter, String string) throws IOException {
        fileWriter.write(this.header() + string + "\n");
    }

    void write(FileWriter fileWriter, Collection<String> collection) throws IOException {
        if (!collection.isEmpty()) {
            fileWriter.write(this.header() + String.join((CharSequence)SIMULATIONS_MANIFEST_ENTRY_DELIMITER, collection) + "\n");
        }
    }

    public static List<String> readList(String string) {
        return Arrays.asList(string.split(SIMULATIONS_MANIFEST_ENTRY_DELIMITER));
    }

    String header() {
        return this.name + ": ";
    }
}

