/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.plugin.pkg;

import io.gatling.internal.asm.ClassReader;
import io.gatling.internal.asm.ClassVisitor;
import io.gatling.internal.asm.ClassWriter;
import io.gatling.internal.asm.tree.AbstractInsnNode;
import io.gatling.internal.asm.tree.ClassNode;
import io.gatling.internal.asm.tree.InsnNode;
import io.gatling.plugin.io.PluginLogger;
import io.gatling.plugin.pkg.Dependency;
import io.gatling.plugin.pkg.ManifestEntry;
import io.gatling.plugin.util.IOUtil;
import io.gatling.plugin.util.ZipUtil;
import io.gatling.scanner.SimulationScanResult;
import io.gatling.scanner.SimulationScanner;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public final class EnterprisePackager {
    private final PluginLogger logger;
    private static final Set<String> POPULAR_FRAMEWORK_GROUPID_PREFIXES = Set.of("ch.qos.logback", "com.amazonaws", "com.azure", "com.github.javafaker", "com.google", "com.opencsv", "com.vladmihalcea", "groovy", "io.micrometer", "io.vavr", "joda-time", "junit", "kotlin", "lombok", "mysql", "net.datafaker", "org.apache", "org.assertj", "org.aspectj", "com.fasterxml", "org.flywaydb", "org.hibernate", "org.jsoup", "org.mockito", "org.postgresql", "org.scala-lang", "org.seleniumhq", "org.slf4j", "org.springframework", "org.reflections", "org.testcontainers", "software.amazon");
    private static final Set<String> gatlingExtraProtocolsArtifactIds = Set.of("gatling-grpc", "gatling-mqtt");

    public EnterprisePackager(PluginLogger pluginLogger) {
        this.logger = pluginLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEnterprisePackage(List<File> list, Set<Dependency> set, Set<Dependency> set2, String string, String string2, String string3, String string4, String string5, File file) throws IOException {
        String string6 = EnterprisePackager.gatlingVersion(set);
        Set<String> set3 = EnterprisePackager.gatlingExtraProtocols(set);
        File file2 = Files.createTempDirectory("gatling-" + string4, new FileAttribute[0]).toFile();
        Set<Dependency> set4 = EnterprisePackager.shippedDependencies(set2);
        SimulationScanResult simulationScanResult = SimulationScanner.scan(EnterprisePackager.scannedDependencies(set4), list);
        if (simulationScanResult.getSimulationClasses().isEmpty()) {
            throw EnterprisePackager.newStacklessIllegalArgumentException("Your project doesn't contain any Simulation");
        }
        try {
            for (Dependency object2 : set4) {
                ZipUtil.unpack(object2.file, file2, EnterprisePackager::excludeJarEntry, EnterprisePackager::resolveServicesConflicts);
            }
            EnterprisePackager.disableBcFipsCheck(file2);
            for (File file3 : list) {
                if (!file3.exists() || !file3.isDirectory()) continue;
                IOUtil.copyDirectory(file3, file2);
            }
            File file3 = new File(file2, "META-INF");
            file3.mkdirs();
            try (FileWriter fileWriter = new FileWriter(new File(file3, "MANIFEST.MF"));){
                ManifestEntry.ManifestVersion.write(fileWriter, "1.0");
                ManifestEntry.ImplementationTitle.write(fileWriter, string2);
                ManifestEntry.ImplementationVersion.write(fileWriter, string3);
                ManifestEntry.ImplementationVendor.write(fileWriter, "GatlingCorp");
                ManifestEntry.SpecificationVendor.write(fileWriter, "GatlingCorp");
                ManifestEntry.GatlingVersion.write(fileWriter, string6);
                ManifestEntry.GatlingPackager.write(fileWriter, string4);
                ManifestEntry.GatlingPackagerVersion.write(fileWriter, string5);
                ManifestEntry.GatlingSimulations.write(fileWriter, simulationScanResult.getSimulationClasses());
                ManifestEntry.GatlingExtraProtocols.write(fileWriter, set3);
                ManifestEntry.JavaVersion.write(fileWriter, String.valueOf(simulationScanResult.getHighestJavaVersionClass().javaVersion));
            }
            File file4 = new File(new File(new File(file3, "maven"), string), string2);
            file4.mkdirs();
            try (FileWriter fileWriter = new FileWriter(new File(file4, "pom.properties"));){
                fileWriter.write("groupId=" + string + "\n");
                fileWriter.write("artifactId=" + string2 + "\n");
                fileWriter.write("version=" + string3 + "\n");
            }
            fileWriter = new FileWriter(new File(file4, "pom.xml"));
            try {
                fileWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
                fileWriter.write("<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
                fileWriter.write("    xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd\">\n");
                fileWriter.write("    <modelVersion>4.0.0</modelVersion>\n");
                fileWriter.write("    <groupId>" + string + "</groupId>\n");
                fileWriter.write("    <artifactId>" + string2 + "</artifactId>\n");
                fileWriter.write("    <version>" + string3 + "</version>\n");
                fileWriter.write("</project>");
            }
            finally {
                fileWriter.close();
            }
            this.logger.info("Generating Gatling Enterprise package " + String.valueOf(file));
            ZipUtil.pack(file2, file);
        }
        finally {
            IOUtil.deleteDirectory(file2);
        }
    }

    private static Set<Dependency> shippedDependencies(Set<Dependency> set) {
        return set.stream().filter(dependency -> !dependency.artifactId.equals("netty-all") && !dependency.groupId.equals("ch.qos.logback") && !dependency.artifactId.equals("slf4j-simple") && !dependency.artifactId.equals("log4j-slf4j-impl") && !dependency.artifactId.equals("log4j-slf4j2-impl")).collect(Collectors.toSet());
    }

    private static boolean excludeJarEntry(String string) {
        String string2 = string.toUpperCase(Locale.ROOT);
        return string2.endsWith("MODULE-INFO.CLASS") || string2.startsWith("LICENSE") || string2.startsWith("META-INF/LICENSE") || string2.startsWith("META-INF/NOTICE") || string2.startsWith("META-INF/DEPENDENCIES") || string2.equals("META-INF/MANIFEST.MF") || string2.equals("META-INF/INDEX.LIST") || string2.startsWith("META-INF/MAVEN/") || string2.endsWith(".SF") || string2.endsWith(".DSA") || string2.endsWith(".RSA") || string2.endsWith(".EXE") || string2.startsWith("IO/GATLING/") || string2.startsWith("IO/NETTY/");
    }

    private static boolean resolveServicesConflicts(String string, File file, InputStream inputStream) {
        if (file.length() > 0L && string.startsWith("META-INF/services/")) {
            try {
                List<String> list = Files.readAllLines(file.toPath(), StandardCharsets.UTF_8);
                List list2 = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8)).lines().collect(Collectors.toList());
                HashSet<String> hashSet = new HashSet<String>(list);
                hashSet.addAll(list2);
                ArrayList<String> arrayList = new ArrayList<String>(hashSet);
                Collections.sort(arrayList);
                try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file, StandardCharsets.UTF_8, false));){
                    for (String string2 : arrayList) {
                        bufferedWriter.write(string2);
                        bufferedWriter.newLine();
                    }
                }
                return true;
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        return false;
    }

    private static void disableBcFipsCheck(File file) throws IOException {
        File file2 = new File(file, "org/bouncycastle/crypto/fips/FipsStatus.class".replace('/', File.separatorChar));
        if (file2.exists()) {
            Object object2;
            Path path = file2.toPath();
            byte[] byArray = Files.readAllBytes(path);
            ClassReader classReader = new ClassReader(byArray);
            ClassNode classNode = new ClassNode();
            classReader.accept((ClassVisitor)classNode, 589824);
            for (Object object2 : classNode.methods) {
                if (!object2.name.equals("checksumValidate")) continue;
                object2.instructions.clear();
                object2.instructions.add((AbstractInsnNode)new InsnNode(177));
                object2.tryCatchBlocks.clear();
            }
            ClassWriter classWriter = new ClassWriter(589824);
            classNode.accept((ClassVisitor)classWriter);
            object2 = classWriter.toByteArray();
            Files.write(path, (byte[])object2, new OpenOption[0]);
        }
    }

    private static List<File> scannedDependencies(Set<Dependency> set) {
        return set.stream().filter(dependency -> POPULAR_FRAMEWORK_GROUPID_PREFIXES.stream().filter(dependency.groupId::startsWith).findFirst().isEmpty()).map(dependency -> dependency.file).collect(Collectors.toList());
    }

    public static List<String> getSimulationClasses(File file) throws IOException {
        return EnterprisePackager.readManifestEntry(file, ManifestEntry.GatlingSimulations, ManifestEntry::readList);
    }

    public static int getJavaVersion(File file) throws IOException {
        return EnterprisePackager.readManifestEntry(file, ManifestEntry.JavaVersion, Integer::parseInt);
    }

    private static <T> T readManifestEntry(File file, ManifestEntry manifestEntry, Function<String, T> function) throws IOException {
        try (JarFile jarFile = new JarFile(file);){
            Object object;
            block11: {
                InputStream inputStream = jarFile.getInputStream(jarFile.getEntry("META-INF/MANIFEST.MF"));
                try {
                    String string2 = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    object = string2.lines().filter(string -> string.startsWith(manifestEntry.header())).map(string -> function.apply(string.substring(manifestEntry.header().length()))).findFirst().orElseThrow();
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return (T)object;
        }
    }

    private static String gatlingVersion(Set<Dependency> set) {
        return set.stream().filter((Predicate<Dependency>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$gatlingVersion$5(io.gatling.plugin.pkg.Dependency ), (Lio/gatling/plugin/pkg/Dependency;)Z)()).findFirst().orElseThrow((Supplier<IllegalArgumentException>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$gatlingVersion$6(), ()Ljava/lang/IllegalArgumentException;)()).version;
    }

    private static Set<String> gatlingExtraProtocols(Set<Dependency> set) {
        return set.stream().filter(dependency -> dependency.groupId.equals("io.gatling") && gatlingExtraProtocolsArtifactIds.contains(dependency.artifactId)).map(dependency -> dependency.artifactId.substring("gatling-".length())).collect(Collectors.toSet());
    }

    private static IllegalArgumentException newStacklessIllegalArgumentException(String string) {
        return new IllegalArgumentException(string){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        };
    }

    private static /* synthetic */ IllegalArgumentException lambda$gatlingVersion$6() {
        return EnterprisePackager.newStacklessIllegalArgumentException("Can't find Gatling libraries in dependencies");
    }

    private static /* synthetic */ boolean lambda$gatlingVersion$5(Dependency dependency) {
        return dependency.groupId.equals("io.gatling") && dependency.artifactId.equals("gatling-app");
    }
}

